/*
 * This file has been modified as part of the FreeMiNT project. See
 * the file Changes.MH for details and dates.
 */

# ifndef _dosfile_h
# define _dosfile_h

# ifdef __TURBOC__
# include "include\mint.h"
# else
# include "include/mint.h"
# endif


FILEPTR * do_open (const char *name, int mode, int attr, XATTR *x);
long do_pclose (PROC *p, FILEPTR *f);
long do_close (FILEPTR *f);
long get_opens (fcookie *object, struct listopens *l);
long ARGS_ON_STACK f_open (const char *name, int mode);
long ARGS_ON_STACK f_create (const char *name, int attrib);
long ARGS_ON_STACK f_close (int fh);
long ARGS_ON_STACK f_read (int fh, long count, char *buf);
long ARGS_ON_STACK f_write (int fh, long count, const char *buf);
long ARGS_ON_STACK f_seek (long place, int fh, int how);
long ARGS_ON_STACK f_dup (int fh);
long ARGS_ON_STACK f_force (int newh, int oldh);
long ARGS_ON_STACK f_datime (ushort *timeptr, int fh, int rwflag);
long ARGS_ON_STACK f_lock (int fh, int mode, long start, long length);
long ARGS_ON_STACK f_pipe (short *usrh);
long ARGS_ON_STACK f_cntl (int fh, long arg, int cmd);
long ARGS_ON_STACK f_select (unsigned timeout, long *rfdp, long *wfdp, long *xfdp);
long ARGS_ON_STACK f_midipipe (int pid, int in, int out);

# endif /* _dosfile_h */
