#include <mintbind.h>
#include <osbind.h>
#include <stdio.h>
#include <ctype.h>
#include <statfs.h>
#include <errno.h>
#include <stdlib.h>
#include <mint\dcntl.h>

#define UNLIMITED		0x7fffffffL

#define SHOW_NORM		1
#define SHOW_DFREE	2
#define SHOW_STATFS	4
#define SHOW_FSINFO	8
#define SHOW_ALL		(SHOW_NORM|SHOW_DFREE|SHOW_STATFS|SHOW_FSINFO)

void usage(void)
{
	fprintf(stdout, "fsinfo, Version 1.2, %s\n", __DATE__);
	fprintf(stdout, "Aufruf: fsinfo [Option] Laufwerkbuchstabe [..]\n");
	fprintf(stdout, "	      -a      alle Daten anzeigen\n");
	fprintf(stdout, "	      -d      nur Daten von Dfree() anzeigen\n");
	fprintf(stdout, "	      -s      nur Daten von statfs() anzeigen\n");
	fprintf(stdout, "	      -f      nur Daten von FS_INFO anzeigen\n");
	exit(0);
}

int main(int argc, char *argv[])
{
	if (argc >= 2)
	{
		long				l, max_dpc;
		int				i, start = 1;
		char				drive[] = "X:\\.";
		struct statfs	st;
		_DISKINFO		buf;
		int				flags = SHOW_NORM;
		char				xfs_name[10];
		
		if (argv[1][0] == '-')
		{
			switch (argv[1][1])
			{
				case 'a' :
					flags = SHOW_ALL;
					start++;
					break;
				case 'd' :
					flags = SHOW_DFREE;
					start++;
					break;
				case 's' :
					flags = SHOW_STATFS;
					start++;
					break;
				case 'f' :
					flags = SHOW_FSINFO;
					start++;
					break;
				default:
					usage();
			}
		}
		
		for (i = start; i < argc; i++)
		{
			drive[0] = argv[i][0];

			drive[0] = toupper(drive[0]);
			fprintf(stdout, "Laufwerk %c:\n", drive[0]);

			if (flags & SHOW_NORM)
			{
				fprintf(stdout, "  Dpathconf():\n");
				max_dpc = Dpathconf(drive, -1);
				if (max_dpc >= 0)
				{

					if (max_dpc >= 0)
					{
						l = Dpathconf(drive, 0);
						fprintf(stdout, "    Max. Anzahl geffneter Dateien: ");
						if (l == UNLIMITED)
							fprintf(stdout, "unbegrenzt\n");
						else
							fprintf(stdout, "%ld\n", l);
					}
					
					if (max_dpc >= 1)
					{
						l = Dpathconf(drive, 1);
						fprintf(stdout, "    Max. Anzahl Links einer Datei: ");
						if (l == UNLIMITED)
							fprintf(stdout, "unbegrenzt\n");
						else
							fprintf(stdout, "%ld\n", l);
					}
						
					if (max_dpc >= 2)
					{
						l = Dpathconf(drive, 2);
						fprintf(stdout, "    Max. Lnge des vollen Pfades: ");
						if (l == UNLIMITED)
							fprintf(stdout, "unbegrenzt\n");
						else
							fprintf(stdout, "%ld\n", l);
					}
							
					if (max_dpc >= 3)
					{
						l = Dpathconf(drive, 3);
						fprintf(stdout, "    Max. Lnge des Dateinames: ");
						if (l == UNLIMITED)
							fprintf(stdout, "unbegrenzt\n");
						else
							fprintf(stdout, "%ld\n", l);
					}
								
					if (max_dpc >= 4)
					{
						l = Dpathconf(drive, 4);
						fprintf(stdout, "    Anzahl der schreibbaren Byte: ");
						if (l == 0x7fffffffL)
							fprintf(stdout, "unbegrenzt\n");
						else
							fprintf(stdout, "%ld\n", l);
					}

					if (max_dpc >= 5)
					{
						l = Dpathconf(drive, 5);
						fprintf(stdout, "    Dateinamen werden ");
						switch ((int)l)
						{
							case 0 : fprintf(stdout, "nicht gekrzt\n"); break;
							case 1 : fprintf(stdout, "auf max. Lnge gekrzt\n"); break;
							case 2 : fprintf(stdout, "auf 8+3 gekrzt\n"); break;
							default: fprintf(stdout, "[unbekannt: %ld]\n", l);
						}
					}

					if (max_dpc >= 6)
					{
						l = Dpathconf(drive, 6);
						fprintf(stdout, "    Gro/klein wird ");
						switch ((int)l)
						{
							case 0 : fprintf(stdout, "echt unterschieden (Minix)\n"); break;
							case 1 : fprintf(stdout, "nicht unterschieden (TOS)\n"); break;
							case 2 : fprintf(stdout, "halb unterschieden (VFAT/Mac)\n"); break;
							default: fprintf(stdout, "[unbekannt: %ld]\n", l);
						}
					}
					
					if (max_dpc >= 7)
					{
						l = Dpathconf(drive, 7);
						fprintf(stdout, "    Modus-Bits: ");
						fprintf(stdout, "  bit0..5: 0x%lX,", l&0x0000003FL);
						fprintf(stdout, "  bit8..19: 0x%lX,", l&0x000FFF00L);
						fprintf(stdout, "  bit20..27: 0x%lX\n", l&0x3FF00000L);
					}
						
					if (max_dpc >= 8)
					{
						l = Dpathconf(drive, 8);
						fprintf(stdout, "    Erweiterte Attribute: 0x%lX\n", l);
					}

					if (Dcntl(MX_KER_XFSNAME, drive, (long)xfs_name) == 0)
						fprintf(stdout, "    Dateisystem (MX_KER_XFSNAME): %s\n", xfs_name);
				}
				else
					fprintf(stdout, "    Fehler %ld!\n", max_dpc);
			}
			
			if (flags & SHOW_DFREE)
			{
				fprintf(stdout, "  Dfree():\n");
				l = Dfree(&buf, drive[0] - 'A' + 1);
				if (l == 0)
				{
					fprintf(stdout, "    b_free=   %6ld   b_total=  %6ld\n", buf.b_free, buf.b_total);
					fprintf(stdout, "    bsecsiz=  %6ld   b_clsiz=  %6ld\n", buf.b_secsiz, buf.b_clsiz);
				}
				else
					fprintf(stderr, "    Fehler %ld!\n", l);
			}
			
			if (flags & SHOW_STATFS)
			{	
				fprintf(stdout, "  statfs():\n");
				l = statfs(drive, &st);
				if (l != -1)
				{
					fprintf(stdout, "    f_type=   %5ld   f_bsize=  %5ld\n", st.f_type, st.f_bsize);
					fprintf(stdout, "    f_blocks= %5ld   f_bfree=  %5ld   f_bavail= %5ld\n", st.f_blocks, st.f_bfree, st.f_bavail);
					fprintf(stdout, "    f_files=  %5ld   f_ffree=  %5ld\n", st.f_files, st.f_ffree);
				}
				else
					fprintf(stderr, "    Fehler %d!\n", -errno);
			}

			if (flags & SHOW_FSINFO)
			{
				struct fs_info	info;
				
				fprintf(stdout, "  Dcntl(FS_INFO):\n");
				l = Dcntl(FS_INFO, drive, (long)&info);
				if (l == 0)
				{
					fprintf(stdout, "    name= %s   version= %ld.%ld\n", info.name, ((info.version & 0xffff0000L)>>16), (info.version & 0x0000ffffL));
					fprintf(stdout, "    type= (%ld,%ld)      type_asc= %s\n", ((info.type & 0xffff0000L)>>16), (info.type & 0x0000ffffL), info.type_asc);
				}
				else
					fprintf(stderr, "    Fehler %ld!\n", l);
			}
		}
	}
	else
		usage();
	return 0;
}
