/*
 * This file has been modified as part of the FreeMiNT project. See
 * the file Changes.MH for details and dates.
 */

# ifndef _proc_h
# define _proc_h

# ifdef __TURBOC__
# include "include\mint.h"
# else
# include "include/mint.h"
# endif


PROC *	new_proc	(void);
void	dispose_proc	(PROC *p);

PROC *	fork_proc	(void);
void	init_proc	(void);

void	reset_priorities(void);
void	run_next	(PROC *p, int slices);
void	fresh_slices	(int slices);

void	add_q	(int que, PROC *proc);
void	rm_q	(int que, PROC *proc);

void ARGS_ON_STACK preempt	(void);
int  ARGS_ON_STACK sleep	(int que, long cond);
void ARGS_ON_STACK wake		(int que, long cond);
void ARGS_ON_STACK iwake	(int que, long cond, short pid);
void ARGS_ON_STACK wakeselect	(PROC *p);

void	DUMPPROC (void);
void	calc_load_average (void);

# endif /* _proc_h */
