/*
 * This file has been modified as part of the FreeMiNT project. See
 * the file Changes.MH for details and dates.
 */

# ifndef _biosfs_h
# define _biosfs_h

# ifdef __TURBOC__
# include "include\mint.h"
# else
# include "include/mint.h"
# endif


long rsvf_ioctl (int f, void *arg, int mode);
void biosfs_init (void);
long iwrite	(int bdev, const char *buf, long bytes, int ndelay, struct bios_file *b);
long iread	(int bdev, char *buf, long bytes, int ndelay, struct bios_file *b);
long iocsbrk	(int bdev, int mode, struct bios_tty *t);
void ARGS_ON_STACK mouse_handler (const char *buf);
long ARGS_ON_STACK nocreat (fcookie *dir, const char *name, unsigned mode, int attrib, fcookie *fc);
long ARGS_ON_STACK nomkdir	(fcookie *dir, const char *name, unsigned mode);
long ARGS_ON_STACK nowritelabel (fcookie *dir, const char *name);
long ARGS_ON_STACK noreadlabel (fcookie *dir, char *name, int namelen);
long ARGS_ON_STACK nosymlink (fcookie *dir, const char *name, const char *to);
long ARGS_ON_STACK noreadlink (fcookie *dir, char *buf, int buflen);
long ARGS_ON_STACK nohardlink (fcookie *, const char *, fcookie *, const char *);
long ARGS_ON_STACK nofscntl (fcookie *dir, const char *name, int cmd, long arg);
long ARGS_ON_STACK nodskchng (int drv, int mode);
int set_auxhandle (PROC *, int);

long	ARGS_ON_STACK null_open	(FILEPTR *f);
long	ARGS_ON_STACK null_write	(FILEPTR *f, const char *buf, long bytes);
long	ARGS_ON_STACK null_read	(FILEPTR *f, char *buf, long bytes);
long	ARGS_ON_STACK null_lseek	(FILEPTR *f, long where, int whence);
long	ARGS_ON_STACK null_ioctl	(FILEPTR *f, int mode, void *buf);
long	ARGS_ON_STACK null_datime	(FILEPTR *f, ushort *time, int rwflag);
long	ARGS_ON_STACK null_close	(FILEPTR *f, int pid);
long	ARGS_ON_STACK null_select	(FILEPTR *f, long p, int mode);
void	ARGS_ON_STACK null_unselect	(FILEPTR *f, long p, int mode);

# endif /* _biosfs_h */
