/* Definitions of target machine for GNU compiler.  atariST/TT version.
   Copyright (C) 1987, 1988, 1993 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "m68k/m68k.h"

/* See m68k.h.  7 means 68020 with 68881, or 68030.  */

#ifndef TARGET_DEFAULT
#ifdef TARGET_CPU_DEFAULT
#define TARGET_DEFAULT TARGET_CPU_DEFAULT
#else
#define TARGET_DEFAULT 7
#endif
#endif

/* Pass the architecture flags to the assembler. */
#define COMMON_ASM_SPEC \
  "%{m68000} %{mc68000} %{m68020} %{mc68020} %{m68020-40:-m68020} %{m68030} " \
  "%{m68040} %{m68881} %{msoft-float:-mno-68881} %{m68851} %{mno-68851} " \
  "%{m68302} %{mno-68302} %{m68332} %{mno-68332}"

#if (TARGET_DEFAULT & 01000)
/* note atleast gas-1.38 Patchlevel 2 required for mc68040 specific
   support in the assembler.  */
#define ASM_SPEC "%{!m680*:%{!mc680*:-m68040}} " COMMON_ASM_SPEC
#else
/* falcon/TT */
#if (TARGET_DEFAULT & 5) /* note this is true for TARGET_DEFAULT == 0407 too */
/* for the TT etc (020/030) also appropriate for m68040 (falcon) ie:
   -m68020-40 (and not -m68040). Note that the assembler does not need
   any special indication of the 040 when -m68020-40, only needs
   -mc68020. the only time the assembler needs -mc68040 is when
   -m68040 */
#define ASM_SPEC COMMON_ASM_SPEC
#else
/* for a regular 68k ST */
#if (TARGET_DEFAULT & 2)
#define ASM_SPEC \
 "%{!m680*:%{!mc680*:-m68000 %{!msoft-float:-m68881}}} "\
 COMMON_ASM_SPEC
#else
#define ASM_SPEC "%{!m680*:%{!mc680*:-m68000}} " COMMON_ASM_SPEC
#endif
#endif /* TT /falcon */
#endif /* m68040-only */

/* Register to use for base-relative addressing. The BASE_ADDR_* macros
   are for using GNU cpp's stringification feature. */

#define BASE_ADDR_REG	4		/* a4 */
#undef PIC_OFFSET_TABLE_REGNUM
#define PIC_OFFSET_TABLE_REGNUM	(BASE_ADDR_REG+8)	/* GCC register num */
#define BASE_ADDR_STRING(X)	"a" #X
#define BASE_ADDR_NAME(X)	BASE_ADDR_STRING(X)

#undef SUBTARGET_SWITCHES
#define SUBTARGET_SWITCHES			\
    { "pcrel", 02000},				\
    { "nopcrel", -02000},			\
    { "baserel", 04000},			\
    { "nobaserel", -04000},

#undef SUBTARGET_OVERRIDE_OPTIONS
#define SUBTARGET_OVERRIDE_OPTIONS \
  if (TARGET_BASE_REL) flag_pic = 3;

#define COMMON_CPP_SPEC \
"%{mshort:-D__MSHORT__} "\
"%{mbaserel:-D__MBASE__=" BASE_ADDR_NAME (BASE_ADDR_REG)\
  " -D__MBASESTR__=\"" BASE_ADDR_NAME (BASE_ADDR_REG) "\"}"

#if (TARGET_DEFAULT & 5)
#if (TARGET_DEFAULT & 2)
#define CPP_SPEC \
 "%{m68881:%{m68000:-D__M68881__} %{mc68000:-D__M68881__}} "\
 "%{!m68000:%{!mc68000:"\
   "%{!msoft-float:-D__M68881__} "\
   "-D__M68020__ -D__mc68020__ %{!ansi:-Dmc68020}}} "\
 COMMON_CPP_SPEC
#define CC1_SPEC \
 "%{!m68881:%{m68000:-msoft-float} %{mc68000:-msoft-float}}"
#else
#define CPP_SPEC \
 "%{m68881:-D__M68881__} "\
 "%{!m68000:%{!mc68000:-D__M68020__ -D__mc68020__ %{!ansi:-Dmc68020}}} "\
 COMMON_CPP_SPEC
#endif
#else
#if (TARGET_DEFAULT & 2)
#define CPP_SPEC \
 "%{!msoft-float:-D__M68881__} "\
 "%{m68020*:-D__M68020__ -D__mc68020__ %{!ansi:-Dmc68020}} "\
 "%{mc68020:-D__M68020__ -D__mc68020__ %{!ansi:-Dmc68020}} "\
 "%{m68030:-D__M68020__ -D__mc68020__ %{!ansi:-Dmc68020}} "\
 "%{m68040:-D__M68020__ -D__mc68020__ %{!ansi:-Dmc68020}} "\
 COMMON_CPP_SPEC
#else
#define CPP_SPEC \
 "%{m68881:-D__M68881__} "\
 "%{m68020*:-D__M68020__ -D__mc68020__ %{!ansi:-Dmc68020}} "\
 "%{mc68020:-D__M68020__ -D__mc68020__ %{!ansi:-Dmc68020}} "\
 "%{m68030:-D__M68020__ -D__mc68020__ %{!ansi:-Dmc68020}} "\
 "%{m68040:-D__M68020__ -D__mc68020__ %{!ansi:-Dmc68020}} "\
 COMMON_CPP_SPEC
#endif
#endif

/* Names to predefine in the preprocessor for this target machine.  */

#define CPP_PREDEFINES "-Dmc68000 -Datarist -Dgem -Asystem(tos) -Asystem(gem) -Acpu(m68k) -Amachine(m68k)"

/* specs for start file and link specs */
#define STARTFILE_SPEC "%{pg:g}%{!pg:%{p:m}}crt0.o%s"

/* NOTE: for ataris we dont need to do anything special for -a or
   -tcov as bb_* routines will automatically be pulled in from the
   libraries as required when they are referenced by the generated
   code.  */

#define LIB_SPEC "-lc"

/* Tell linker to make sharable text executable */

#define LINK_SPEC "%{mbaserel:-n}"

#define PTRDIFF_TYPE "long int"
#define SIZE_TYPE "long unsigned int"

/* We must override m68k.h.  */
#undef WCHAR_TYPE
#undef WCHAR_TYPE_SIZE
#define WCHAR_TYPE "short unsigned int"
#define WCHAR_TYPE_SIZE 16
#define WCHAR_UNSIGNED 1

#if 0
/* Don't try using XFmode.  */
#undef LONG_DOUBLE_TYPE_SIZE
#define LONG_DOUBLE_TYPE_SIZE 64
#endif

/* Every structure or union's size must be a multiple of 2 bytes.  */

#define STRUCTURE_SIZE_BOUNDARY 16

#define DBX_DEBUGGING_INFO

/* Allow folding division by zero.  */
#define REAL_INFINITY

/* Generate calls to memcpy, memcmp and memset.  */
#define TARGET_MEM_FUNCTIONS

/* The value of `EDOM' on the target machine.  */
#define TARGET_EDOM 89

/* This is how to create a rtl expression that refers to the global
   "variable" `errno'.  */
#define GEN_ERRNO_RTX \
  gen_rtx (MEM, TARGET_SHORT ? HImode : SImode, \
	   gen_rtx (SYMBOL_REF, Pmode, "errno"))

#define FUNCTION_VALUEX(MODE)					\
  gen_rtx (REG, (MODE), (TARGET_68881 && FLOAT_MODE_P (MODE) ? 16 : 0))

#undef FUNCTION_VALUE
#define FUNCTION_VALUE(VALTYPE,FUNC) FUNCTION_VALUEX (TYPE_MODE (VALTYPE))
#undef LIBCALL_VALUE
#define LIBCALL_VALUE(MODE) FUNCTION_VALUEX (MODE)

/* 1 if N is a possible register number for a function value.  */

#undef FUNCTION_VALUE_REGNO_P
#define FUNCTION_VALUE_REGNO_P(N) ((N) == 0 || (TARGET_68881 && (N) == 16))

/* Define this to be true when FUNCTION_VALUE_REGNO_P is true for
   more than one register.  */

#undef NEEDS_UNTYPED_CALL
#define NEEDS_UNTYPED_CALL (TARGET_68881)

/* This is how to output an assembler line defining a `double' constant.  */

#undef ASM_OUTPUT_DOUBLE
#define ASM_OUTPUT_DOUBLE(FILE,VALUE)				\
  {								\
    if (REAL_VALUE_ISINF (VALUE))				\
      {								\
	if (REAL_VALUE_NEGATIVE (VALUE))			\
	  fprintf (FILE, "\t.double 0r-Inf\n");			\
	else							\
	  fprintf (FILE, "\t.double 0rInf\n");			\
      }								\
    else if (REAL_VALUE_ISNAN (VALUE))				\
      { long l[2];						\
	REAL_VALUE_TO_TARGET_DOUBLE (VALUE, l);			\
	fprintf (FILE, "\t.long 0x%lx\n\t.long 0x%lx\n", l[0], l[1]); \
      }								\
    else if (REAL_VALUE_MINUS_ZERO (VALUE))			\
      {								\
	fprintf (FILE, "\t.double 0r-0.0\n");			\
      }								\
    else							\
      { char dstr[30];						\
	REAL_VALUE_TO_DECIMAL (VALUE, "%.17g", dstr);		\
	fprintf (FILE, "\t.double 0r%s\n", dstr);		\
      }								\
    }

/* This is how to output an assembler line defining a `float' constant.  */

#undef ASM_OUTPUT_FLOAT
#define ASM_OUTPUT_FLOAT(FILE,VALUE)				\
  {								\
    if (REAL_VALUE_ISINF (VALUE))				\
      {								\
	if (REAL_VALUE_NEGATIVE (VALUE))			\
	  fprintf (FILE, "\t.single 0r-Inf\n");			\
	else							\
	  fprintf (FILE, "\t.single 0rInf\n");			\
      }								\
    else if (REAL_VALUE_ISNAN (VALUE))				\
      { long l;							\
	REAL_VALUE_TO_TARGET_SINGLE (VALUE, l);			\
	fprintf (FILE, "\t.long 0x%lx\n", l);			\
      }								\
    else if (REAL_VALUE_MINUS_ZERO (VALUE))			\
      {								\
	fprintf (FILE, "\t.single 0r-0.0\n");			\
      }								\
    else							\
      { char dstr[30];						\
	REAL_VALUE_TO_DECIMAL (VALUE, "%.9g", dstr);		\
	fprintf (FILE, "\t.single 0r%s\n", dstr);		\
      }								\
    }

/* This is how to output an assembler lines defining floating operands.  */
  
#undef ASM_OUTPUT_FLOAT_OPERAND
#define ASM_OUTPUT_FLOAT_OPERAND(CODE,FILE,VALUE)		\
 do {								\
      if (CODE != 'f' || REAL_VALUE_ISNAN (VALUE))		\
	{							\
	  long l;						\
	  REAL_VALUE_TO_TARGET_SINGLE (VALUE, l);		\
	  asm_fprintf (FILE, "%I");				\
	  fprintf (FILE, "0x%lx", l);				\
	}							\
      else if (REAL_VALUE_ISINF (VALUE))			\
	{							\
	  if (REAL_VALUE_NEGATIVE (VALUE))			\
	    asm_fprintf (FILE, "%I0r-Inf");			\
	  else							\
	    asm_fprintf (FILE, "%I0rInf");			\
	}							\
      else if (REAL_VALUE_MINUS_ZERO (VALUE))			\
	{							\
	  asm_fprintf (FILE, "%I0r-0.0");			\
	}							\
      else							\
	{ char dstr[30];					\
	  REAL_VALUE_TO_DECIMAL (VALUE, "%.9g", dstr);		\
	  asm_fprintf (FILE, "%I0r%s", dstr);			\
	}							\
    } while (0)

#undef ASM_OUTPUT_DOUBLE_OPERAND
#define ASM_OUTPUT_DOUBLE_OPERAND(FILE,VALUE)				\
 do { if (REAL_VALUE_ISINF (VALUE))					\
	{								\
	  if (REAL_VALUE_NEGATIVE (VALUE))				\
	    asm_fprintf (FILE, "%I0r-Inf");				\
	  else								\
	    asm_fprintf (FILE, "%I0rInf");				\
	}								\
      else if (REAL_VALUE_ISNAN (VALUE))				\
	{								\
	  long l[2];							\
	  REAL_VALUE_TO_TARGET_DOUBLE (VALUE, l);			\
	  asm_fprintf (FILE, "%I");					\
	  fprintf (FILE, "0x%lx%08lx", l[0], l[1]);			\
	}								\
      else if (REAL_VALUE_MINUS_ZERO (VALUE))				\
	{								\
	  asm_fprintf (FILE, "%I0r-0.0");				\
	}								\
      else								\
	{ char dstr[30];						\
	  REAL_VALUE_TO_DECIMAL (VALUE, "%.17g", dstr);			\
	  asm_fprintf (FILE, "%I0r%s", dstr);				\
	}								\
    } while (0)

/* given that symbolic_operand(X), return TRUE if no special
   base relative relocation is necessary */

#define LEGITIMATE_BASEREL_OPERAND_P(X) \
  (flag_pic == 3 && read_only_operand (X))

#undef LEGITIMATE_PIC_OPERAND_P
#define LEGITIMATE_PIC_OPERAND_P(X) \
  (! symbolic_operand (X, VOIDmode) || LEGITIMATE_BASEREL_OPERAND_P (X))


/* Define this macro if references to a symbol must be treated
   differently depending on something about the variable or function
   named by the symbol (such as what section it is in).

   The macro definition, if any, is executed immediately after the
   rtl for DECL has been created and stored in `DECL_RTL (DECL)'.
   The value of the rtl will be a `mem' whose address is a
   `symbol_ref'.

   The usual thing for this macro to do is to record a flag in the
   `symbol_ref' (such as `SYMBOL_REF_FLAG') or to store a modified
   name string in the `symbol_ref' (if one bit is not enough
   information).

   On the Atari we use this to indicate if a symbol is in text or
   data space, as well as to distinguish functions from data. */

#define ENCODE_SECTION_INFO(DECL)\
do									\
  {									\
    if (TREE_CODE (DECL) == FUNCTION_DECL)				\
      {									\
        SYMBOL_REF_FLAG (XEXP (DECL_RTL (DECL), 0)) = 1;		\
	SYMBOL_REF_USED (XEXP (DECL_RTL (DECL), 0)) = 1;		\
      }									\
    else								\
      {									\
	rtx rtl = (TREE_CODE_CLASS (TREE_CODE (DECL)) != 'd'		\
		   ? TREE_CST_RTL (DECL) : DECL_RTL (DECL));		\
	if (RTX_UNCHANGING_P (rtl) && !MEM_VOLATILE_P (rtl))		\
	  SYMBOL_REF_FLAG (XEXP (rtl, 0)) = 1;				\
      }									\
  }									\
while (0)

#if 0
#undef SELECT_RTX_SECTION
#define SELECT_RTX_SECTION(MODE, X)					\
{									\
  if (!flag_pic || LEGITIMATE_BASEREL_OPERAND_P (X))			\
    readonly_data_section();						\
  else if (LEGITIMATE_PIC_OPERAND_P (X))				\
    readonly_data_section();						\
  else									\
    data_section();							\
}
#else
#undef SELECT_RTX_SECTION
#define SELECT_RTX_SECTION(MODE, X) readonly_data_section ();
#endif

/* according to varasm.c, RELOC referrs *only* to whether constants (!)
   are addressed by address. This doesn't matter in baserelative
   code, so we allow (inspite of flag_pic) readonly_data_section() in
   that case */

#undef SELECT_SECTION
#define SELECT_SECTION(DECL, RELOC)					\
{									\
  if (TREE_CODE (DECL) == STRING_CST)					\
    {									\
      if (flag_writable_strings)					\
	data_section ();						\
      else								\
	readonly_data_section ();					\
    }									\
  else if (TREE_CODE (DECL) == VAR_DECL)				\
    {									\
      if (TREE_READONLY (DECL)						\
	  && ! TREE_THIS_VOLATILE (DECL)				\
	  && DECL_INITIAL (DECL)					\
	  && (DECL_INITIAL (DECL) == error_mark_node			\
	      || TREE_CONSTANT (DECL_INITIAL (DECL)))			\
	  && !(flag_pic && flag_pic != 3 && RELOC))			\
	readonly_data_section ();					\
      else								\
	data_section ();						\
    }									\
  else									\
    readonly_data_section ();						\
}

#define ASM_OUTPUT_EXTERNAL_LIBCALL(asm_out_file,fun)

/* Don't default to pcc-struct-return, because gcc is the only compiler, and
   we want to retain compatibility with older gcc versions.  */
#undef PCC_STATIC_STRUCT_RETURN
#define DEFAULT_PCC_STRUCT_RETURN 0

/* Define this macro if the system header files support C++ as well
   as C.  This macro inhibits the usual method of using system header
   files in C++, which is to pretend that the file's contents are
   enclosed in `extern "C" {...}'.  */
#define NO_IMPLICIT_EXTERN_C
