/*
 * Copyright 1993, 1994 by Ulrich Khn. All rights reserved.
 *
 * THIS PROGRAM COMES WITH ABSOLUTELY NO WARRANTY, NOT
 * EVEN THE IMPLIED WARRANTIES OF MERCHANTIBILITY OR
 * FITNESS FOR A PARTICULAR PURPOSE. USE AT YOUR OWN
 * RISK.
 */

/*
 * File : auth.h
 *        client authorization
 */

#ifndef AUTH_H
#define AUTH_H

#include <sys/socket.h>
#include <netinet/in.h>
#include <types.h>
#include "svc.h"
#include "mount.h"
#include "fh.h"


#ifndef ROOT_UID
#define ROOT_UID 0
#endif
#ifndef NOBODY_UID
#define NOBODY_UID  ((uid_t) -2)
#endif
#ifndef NOBODY_GID
#define NOBODY_GID  ((gid_t) -2)
#endif




typedef struct client_info
{
	struct client_info *next;
	char *name;
	struct in_addr addr;
} client_info;

typedef struct accesslist
{
	struct accesslist *next;
	char *mountpoint;

	exportlist *ex;

	short dev;   /* these two are filled in when the file handle system */
	long inode;  /* is set up */

	/* if the following client lists are empty, grant access to everyone */
	client_info *access;
	client_info *rw_access;

	/* grant root access to these clients, use anon_uid for everyone else */
	client_info *root_access;
	int read_only;
	uid_t anon_uid;
	gid_t anon_gid;   /* extension, not used for now */

	/* more to come */
} accesslist;



extern exportlist *exports;
extern accesslist *authlist;


#define AUTH_NO      0x0
#define AUTH_NORMAL  0x1
#define AUTH_ROOT    0x2
#define AUTH_RW      0x4

int auth_init();

/* This is for the mountd only */
accesslist *auth_mnt(char *dirname, SVCXPRT *xprt);

/* This is for the nfsd only */
accesslist *auth_nfs(svc_fh *fh, SVCXPRT *xprt, int *auth_kind);

#endif
