/*
 * File : exportent.h
 *
 */

#ifndef EXPORTENT_H
#define EXPORTENT_H


#include <stdio.h>


#define TABFILE  "\\etc\\xtab"


/* option keywords */
#define ACCESS_OPT  "access"   /* machines that can mount fs */
#define ROOT_OPT    "root"     /* machines with root access */
#define RO_OPT      "ro"       /* export read-only */
#define RW_OPT      "rw"       /* export read-mostly */
#define ANON_OPT    "anon"     /* uid for anonymous requests */
#define SECURE_OPT  "secure"   /* use secure NFS for access */
#define WINDOW_OPT  "window"   /* expiration window for credential */


struct exportent
{
	char *xent_dirname;   /* directory or file to export */
	char *xent_options;   /* options, as above */
};

FILE *setexportent();
struct exportent *getexportent(FILE *fp);
int addexportent(FILE *fp, char *dirname, char *options);
int remexportent(FILE *fp, char *dirname);
char *getexportopt(struct exportent *xent, char *opt);
void endexportent(FILE *fp);


#endif
