
# ifndef _minixfs_h
# define _minixfs_h

# include "minix.h"
# include "global.h"


extern FILESYS minix_filesys;


void sync_bitmaps (register super_info *psblk);

# define WB_CHECK(super) (BIO_WB_CHECK (super->di))

FASTFN void
sync (ushort dev)
{
	register super_info *psblk = super_ptr[dev];
	
	if (!WB_CHECK (psblk))
	{
		/* must sync :-( */
		sync_bitmaps (psblk);
		bio.sync_drv (psblk->di);
	}
}

# endif /* _minixfs_h */
