/*
 *	/dev/audio for Atari Ste, MegaSte, TT, Falcon running Mint.
 *	(Ste DMA stuff).
 *
 *	Based on audiodev 0.1 by Charles Briscoe-Smith, which is in
 *	turn based on lpdev 0.6 by Thierry Bousch.
 *
 *	10/28/95, Kay Roemer.
 *
 *	9705, John Blakeley - got the it to work on the Falcon.
 */

#include <string.h>
#include <osbind.h>
#include "falcon.h"
#include "kerbind.h"
#include "file.h"
#include "atarierr.h"
#include "dmasnd.h"
#include "audios.h"
#include "device.h"
#include "mfp.h"
#include "cookie.h"

static void		fal_reset (void);
static void		fal_timer (void);
static long		fal_copyin (char *buf, long len);
static long		fal_ioctl (short mode, void *arg);
static long		fal_wspace (void);

static long		fal_mix_ioctl (short cmd, void *arg);

#define FalInt	(*(volatile unsigned char *)0xffff8900)

static short stereo = 0;

/*
 * install things
 */
long
fal_init (struct device *dev)
{
	long snd_cookie;

	if (get_cookie (COOKIE__SND, &snd_cookie) ||
	    !(snd_cookie & ( SND_16BIT | SND_DSP | SND_MATRIX) ) ) {
		/*
		 * _SND cookie not set or no Falcon
		 * compatible sound hardware.
		 */
		return 1;
	}
	if (MFP_IERA & MFP_IMRA & 0x20) {
		c_conws ("timer A in use!\r\n");
		return 1;
	}

	dev->channels = 2;
	dev->reset = fal_reset;
	dev->copyin = fal_copyin;
	dev->ioctl = fal_ioctl;
	dev->wspace = fal_wspace;
	
	Devconnect( DMAPLAY, DAC, CLK25M, CLKOLD, 1 );
	Soundcmd( SETPRESCALE, PRE160 );
	Buffoper( 0 );
	Setmode( MONO8 );
	FalInt = 0;

	timer_func = fal_timer;

	Jdisint (13);
	/*Mfpint ( 15, new_gpi7_vector );*/
	Xbtimer(0, 8, 1, new_timera_vector);
	Jenabint (13);
	return 0;
}

static long
fal_wspace (void)
{
	short sr = spl7 ();
	long avail;

	avail = BUFSIZE - dmab[bufidx].used;
	if (!playing)
		avail += BUFSIZE;
	spl (sr);
	return avail;
}

static void
fal_reset (void)
{
	short sr = spl7 ();

	playing = 0;
	Buffoper( 0 );
	dmab[0].used = 0;
	dmab[1].used = 0;
	spl (sr);
	if (audio_rsel)
		wakeselect (audio_rsel);
}

/*
 * timer A (frame done) interrupt
 */
static void
fal_timer (void)
{
	short i, sr;

	sr = spl7 ();
	i = bufidx ^ 1;
	if (playing) {
		if (--playing == 0) {
			dmab[i].used = 0;
			Buffoper( 0 );
			/*Setinterrupt( SI_TIMERA, SI_NONE );*/
			FalInt |= 0x04;
		} else {
			dmab[i].used = 0;
			Buffoper( SB_PLA_ENA );
			bufidx = i;
		}
		spl (sr);
		if (audio_rsel)
			wakeselect (audio_rsel);
	} else
		spl (sr);
}

/*
 * copy (and convert) samples from user space
 */
static long
fal_copyin (char *buf, long len)
{
	long cando;
	short i;

	timera_cli ();
	i = bufidx;
	cando = BUFSIZE - dmab[i].used;
	if (len < cando)
		cando = len;
	if (cando <= 0) {
		timera_sti ();
		return 0;
	}
	(*copyfn) (dmab[i].buf + dmab[i].used, buf, cando);
	dmab[i].used += cando;
	/*
	 * DMA wants event number of samples. If odd, then play the
	 * last sample twice..
	 */
	if (!stereo && (cando & 1)) {
		dmab[i].buf[dmab[i].used] = dmab[i].buf[dmab[i].used - 1];
		++dmab[i].used;
	}
	if (playing == 0) {
		playing = 1;
		bufidx ^= 1;
		Setbuffer( SR_PLAY, ( void * )dmab[i].buf, ( void * )( dmab[i].buf + dmab[i].used ) );
		Buffoper( SB_PLA_ENA );
	} else {
		playing = 2;
		/*Setinterrupt( SI_TIMERA, SI_PLAY );*/
		if (FalInt&0x04)
			;
		else
			FalInt |= 0x04;
		Setbuffer( SR_PLAY, ( void * )dmab[i].buf, ( void * )( dmab[i].buf + dmab[i].used ) );
		Buffoper( SB_PLA_ENA|SB_PLA_RPT );
	}
	timera_sti ();
	return cando;
}

static long
fal_ioctl (mode, buf)
	short mode;
	void *buf;
{
	long arg = (long)buf;
	short i;

	switch (mode) {
	case AIOCGSPEED:
		i = DMAsmc;
		switch (i & 0x3) {
		case DMA_6KHZ:
			*(long *)arg = 6258;
			break;

		case DMA_12KHZ:
			*(long *)arg = 12517;
			break;

		case DMA_25KHZ:
			*(long *)arg = 25033;
			break;

		case DMA_50KHZ:
			*(long *)arg = 50066;
			break;
		}
		break;

	case AIOCSSPEED:
		if (arg < (6258L+12517L)/2)
			Soundcmd( SETPRESCALE, PREMUTE );
		else if (arg < (12517L+25033L)/2)
			Soundcmd( SETPRESCALE, PRE640 );
		else if (arg < (25033L+50066L)/2)
			Soundcmd( SETPRESCALE, PRE320 );
		else
			Soundcmd( SETPRESCALE, PRE160 );
		break;

	case AIOCSSTEREO:
		if (arg) {
			stereo = 1;
			Setmode( STEREO8 );
		} else {
			stereo = 0;
			Setmode( MONO8 );
		}
		break;

	default:
		return EINVFN;
	}
	return 0;
}

#define FAL_SCALE(v)	(((v)*15/100) << 4)
#define FAL_CHECK(v)	((v) >= 0 && (v) <= 100)

long
fal_mix_init (struct device *dev)
{
	long snd_cookie;

	if (get_cookie (COOKIE__SND, &snd_cookie) ||
	    !(snd_cookie & (SND_16BIT|SND_DSP|SND_MATRIX))) {
		/*
		 * _SND cookie not set or no Falcon compatible
		 * sound hardware
		 */
		return 1;
	}
	Soundcmd(LTATTEN,FAL_SCALE(0));
	Soundcmd(RTATTEN,FAL_SCALE(0));

	dev->mix_ioctl = fal_mix_ioctl;
	return 0;
}

static long
fal_mix_ioctl (mode, buf)
	short mode;
	void *buf;
{
	long arg = (long)buf;

	switch (mode) {
	case AIOCSVOLUME:
		if (!FAL_CHECK (arg))
			return EINVAL;
		arg = 100 - arg;
		Soundcmd(LTATTEN, FAL_SCALE(arg));
		Soundcmd(RTATTEN, FAL_SCALE(arg));
		break;

	case AIOCSLVOLUME:
		if (!FAL_CHECK (arg))
			return EINVAL;
		arg = 100 - arg;
		Soundcmd(LTATTEN, FAL_SCALE(arg));
		break;

	case AIOCSRVOLUME:
		if (!FAL_CHECK (arg))
			return EINVAL;
		arg = 100 - arg;
		Soundcmd(RTATTEN, FAL_SCALE(arg));
		break;

	default:
		return EINVFN;
	}
	return 0;
}
