/*
 * interface to sound hardware drivers for /dev/audio.
 *
 * 11/03/95, Kay Roemer.
 */

#ifndef _DEVICE_H
#define _DEVICE_H

/*
 * sound hardware descriptor
 */
struct device {
	short	channels;
	void	(*reset) (void);
	long	(*copyin) (char *buf, long len);
	long	(*ioctl) (short mode, void *arg);
	long	(*wspace) (void);
	long	(*mix_ioctl) (short cmd, void *arg);
};

/*
 * play buffer
 */
#define BUFSIZE (0x8000L - sizeof (long))

struct dmabuf {
	unsigned char buf[BUFSIZE];
	long used;
};

extern struct dmabuf dmab[2];

/*
 * 0 (not currently playing), >=1 (playing)
 */
extern volatile short playing;

/*
 * index into dmab. points to buffer currenly beeing filled
 * by write().
 */
extern volatile short bufidx;

/*
 * sample format converter
 */
extern void *(*copyfn) (void *dst, const void *src, size_t len);

/*
 * write selector.
 */
extern long audio_rsel;

/*
 * asm stuff
 */
extern void  new_timera_vector (void);
extern void  new_gpi7_vector (void);
extern void  psg_player (void);
extern void  (*timer_func) (void);

#endif
