#ifndef	__SHEL__
#define	__SHEL__

#include	"types.h"

/****************************************************************************
 * Shel_do_find                                                             *
 *  Implementation of shel_find()                                           *
 ****************************************************************************/
WORD              /* 0 if the file was not found or 1.                      */
Shel_do_find(     /*                                                        */
BYTE *buf);       /* Buffer where the filename is given and full path       */
                  /* returned.                                              */
/****************************************************************************/

/****************************************************************************
 * Shel_do_write                                                            *
 *  Implementation of shel_write().                                         *
 ****************************************************************************/
WORD             /*                                                         */
Shel_do_write(   /*                                                         */
WORD apid,       /* Application id.                                         */
WORD mode,       /* Mode.                                                   */
WORD wisgr,      /*                                                         */
WORD wiscr,      /*                                                         */
BYTE *cmd,       /* Command line.                                           */
BYTE *tail);     /* Command tail.                                           */
/****************************************************************************/

void Shel_read(AES_PB *apb);	/*0x0078*/
void Shel_write(AES_PB *apb); /*0x0079*/

/****************************************************************************
 * Shel_find                                                                *
 *  0x007c shel_find().                                                     *
 ****************************************************************************/
void              /*                                                        */
Shel_find(        /*                                                        */
AES_PB *apb);     /* AES parameter block.                                   */
/****************************************************************************/

/****************************************************************************
 * Shel_envrn                                                               *
 *  0x007d shel_envrn().                                                    *
 ****************************************************************************/
void              /*                                                        */
Shel_envrn(       /*                                                        */
AES_PB *apb);     /* AES parameter block.                                   */
/****************************************************************************/

#endif
