#ifndef __VDI__
#define __VDI__

#include "types.h"

/****************************************************************************
 * Vdi_v_bar                                                                *
 *  Output filled rectangle.                                                *
 ****************************************************************************/
void              /*                                                        */
Vdi_v_bar(        /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD *pxy);       /* Coordinate list.                                       */
/****************************************************************************/


/****************************************************************************
 * Vdi_v_clrwk                                                              *
 *  Clear workstation.                                                      *
 ****************************************************************************/
void              /*                                                        */
Vdi_v_clrwk(      /*                                                        */
WORD handle);     /* Workstation handle.                                    */
/****************************************************************************/

/****************************************************************************
 * Vdi_v_clsvwk                                                             *
 *  Close virtual workstation.                                              *
 ****************************************************************************/
void              /*                                                        */
Vdi_v_clsvwk(     /*                                                        */
WORD handle);     /* Workstation handle.                                    */
/****************************************************************************/

/****************************************************************************
 * Vdi_v_clswk                                                              *
 *  Close workstation.                                                      *
 ****************************************************************************/
void              /*                                                        */
Vdi_v_clswk(      /*                                                        */
WORD handle);     /* Workstation handle.                                    */
/****************************************************************************/

/****************************************************************************
 * Vdi_v_gtext                                                              *
 *  Output graphic text.                                                    *
 ****************************************************************************/
void              /*                                                        */
Vdi_v_gtext(      /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD x,           /* X position.                                            */
WORD y,           /* Y position.                                            */
BYTE *str);       /* Text to be output.                                     */
/****************************************************************************/

/****************************************************************************
 * Vdi_v_hide_c                                                             *
 *  Hide mouse cursor.                                                      *
 ****************************************************************************/
void              /*                                                        */
Vdi_v_hide_c(     /*                                                        */
WORD handle);     /* Workstation handle.                                    */
/****************************************************************************/

/****************************************************************************
 * Vdi_v_opnvwk                                                             *
 *  Open virtual workstation.                                               *
 ****************************************************************************/
void              /*                                                        */
Vdi_v_opnvwk(     /*                                                        */
WORD *work_in,    /* In parameters.                                         */
WORD *handle,     /* Workstation handle.                                    */
WORD *work_out);  /* Out parameters.                                        */
/****************************************************************************/

/****************************************************************************
 * Vdi_v_opnwk                                                              *
 *  Open workstation.                                                       *
 ****************************************************************************/
void              /*                                                        */
Vdi_v_opnwk(      /*                                                        */
WORD *work_in,    /* In parameters.                                         */
WORD *handle,     /* Workstation handle.                                    */
WORD *work_out);  /* Out parameters.                                        */
/****************************************************************************/

/****************************************************************************
 * Vdi_v_pline                                                              *
 *  Output polyline.                                                        *
 ****************************************************************************/
void              /*                                                        */
Vdi_v_pline(      /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD count,       /* Number of points.                                      */
WORD *pxy);       /* Array of points.                                       */
/****************************************************************************/

/****************************************************************************
 * Vdi_v_show_c                                                             *
 *  Show mouse cursor.                                                      *
 ****************************************************************************/
void              /*                                                        */
Vdi_v_show_c(     /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD reset);      /* If 0 the cursor will always be shown.                  */
/****************************************************************************/

/****************************************************************************
 * Vdi_vex_butv                                                             *
 *  Set mouse button interrupt handler.                                     *
 ****************************************************************************/
void                             /*                                         */
Vdi_vex_butv(                    /*                                         */
WORD handle,                     /* Workstation handle.                     */
void *butv,                      /* New handler.                            */
void **old_butv);                /* Old handler.                            */
/****************************************************************************/

/****************************************************************************
 * Vdi_vex_motv                                                             *
 *  Set mouse movement interrupt handler.                                   *
 ****************************************************************************/
void                             /*                                         */
Vdi_vex_motv(                    /*                                         */
WORD handle,                     /* Workstation handle.                     */
void *motv,                      /* New handler.                            */
void **old_motv);                /* Old handler.                            */
/****************************************************************************/

/****************************************************************************
 * Vdi_vex_timv                                                             *
 *  Set timer tick interrupt handler.                                       *
 ****************************************************************************/
void                             /*                                         */
Vdi_vex_timv(                    /*                                         */
WORD handle,                     /* Workstation handle.                     */
void *timv,                      /* New handler.                            */
void **old_timv,                 /* Old handler.                            */
WORD *mpt);                      /* Time in milliseconds between ticks.     */
/****************************************************************************/

/****************************************************************************
 * Vdi_vq_extnd                                                             *
 *  Request extra information.                                              *
 ****************************************************************************/
void              /*                                                        */
Vdi_vq_extnd(     /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD mode,        /* Request mode.                                          */
WORD *work_out);  /* Output parameters.                                     */
/****************************************************************************/

/****************************************************************************
 * Vdi_vq_key_s                                                             *
 *  Request current shift key status.                                       *
 ****************************************************************************/
void              /*                                                        */
Vdi_vq_key_s(     /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD *status);    /* Shift key status.                                      */
/****************************************************************************/

/****************************************************************************
 * Vdi_vq_mouse                                                             *
 *  Request current state of mouse.                                         *
 ****************************************************************************/
void              /*                                                        */
Vdi_vq_mouse(     /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD *mb,         /* Button state.                                          */
WORD *mx,         /* X coordinate of mouse cursor.                          */
WORD *my);        /* Y coordinate of mouse cursor.                          */
/****************************************************************************/

/****************************************************************************
 * Vdi_vqt_attributes                                                       *
 *  Get information about text settings.                                    *
 ****************************************************************************/
void                 /*                                                     */
Vdi_vqt_attributes(  /*                                                     */
WORD handle,         /* Workstation handle.                                 */
WORD *attr);         /* Array of attributes.                                */
/****************************************************************************/

/****************************************************************************
 * Vdi_vr_recfl                                                             *
 *  Output filled rectangle.                                                *
 ****************************************************************************/
void              /*                                                        */
Vdi_vr_recfl(     /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD *pxy);       /* Rectangle coordinates.                                 */
/****************************************************************************/

/****************************************************************************
 * Vdi_vr_trnfm                                                             *
 *  Transform memory block.                                                 *
 ****************************************************************************/
void              /*                                                        */
Vdi_vr_trnfm(     /*                                                        */
WORD handle,      /* Workstation handle.                                    */
MFDB *src,        /* Source block.                                          */
MFDB *dst);       /* Destination block.                                     */
/****************************************************************************/

/****************************************************************************
 * Vdi_vro_cpyfm                                                            *
 *  Blit memory block.                                                      *
 ****************************************************************************/
void              /*                                                        */
Vdi_vro_cpyfm(    /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD mode,        /* Mode.                                                  */
WORD *pxy,        /* Bounding rectangles.                                   */
MFDB *src,        /* Source block.                                          */
MFDB *dst);       /* Destination block.                                     */
/****************************************************************************/

/****************************************************************************
 * Vdi_vrt_cpyfm                                                            *
 *  Blit memory block.                                                      *
 ****************************************************************************/
void              /*                                                        */
Vdi_vrt_cpyfm(    /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD mode,        /* Mode.                                                  */
WORD *pxy,        /* Bounding rectangles.                                   */
MFDB *src,        /* Source block.                                          */
MFDB *dst,        /* Destination block.                                     */
WORD *colors);    /* Color of fg and bg.                                    */
/****************************************************************************/

/****************************************************************************
 * Vdi_vs_clip                                                              *
 *  Set clipping rectangle.                                                 *
 ****************************************************************************/
void              /*                                                        */
Vdi_vs_clip(      /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD flag,        /* On/off flag.                                           */
WORD *pxy);       /* Rectangle coordinates.                                 */
/****************************************************************************/

/****************************************************************************
 * Vdi_vsc_form                                                             *
 *  Set mouse form.                                                         *
 ****************************************************************************/
void              /*                                                        */
Vdi_vsc_form(     /*                                                        */
WORD handle,      /* Workstation handle.                                    */
MFORM *newform);  /* New mouse form.                                        */
/****************************************************************************/

/****************************************************************************
 * Vdi_vsf_color                                                            *
 *  Set fill color.                                                         *
 ****************************************************************************/
WORD              /*                                                        */
Vdi_vsf_color(    /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD color);      /* Color number.                                          */
/****************************************************************************/

/****************************************************************************
 * Vdi_vsf_interior                                                         *
 *  Set interior fill type.                                                 *
 ****************************************************************************/
WORD              /*                                                        */
Vdi_vsf_interior( /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD interior);   /* Interior type.                                         */
/****************************************************************************/

/****************************************************************************
 * Vdi_vsf_style                                                            *
 *  Set style of fill pattern.                                              *
 ****************************************************************************/
WORD              /*                                                        */
Vdi_vsf_style(    /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD style);      /* Line type.                                             */
/****************************************************************************/

/****************************************************************************
 * Vdi_vsl_color                                                            *
 *  Set line color.                                                         *
 ****************************************************************************/
WORD              /*                                                        */
Vdi_vsl_color(    /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD color);      /* Color number.                                          */
/****************************************************************************/

/****************************************************************************
 * Vdi_vsl_type                                                             *
 *  Set line type.                                                          *
 ****************************************************************************/
WORD              /*                                                        */
Vdi_vsl_type(     /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD type);       /* Line type.                                             */
/****************************************************************************/

/****************************************************************************
 * Vdi_vst_alignment                                                        *
 *  Set text alignment.                                                     *
 ****************************************************************************/
void              /*                                                        */
Vdi_vst_alignment(/*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD halign,      /* Horzontal alignment.                                   */
WORD valign,      /* Vertical alignment.                                    */
WORD *hout,       /* Actual horizontal alignment.                           */
WORD *vout);      /* Actual vertical alignment.                             */
/****************************************************************************/

/****************************************************************************
 * Vdi_vst_color                                                            *
 *  Set text color.                                                         *
 ****************************************************************************/
WORD              /*                                                        */
Vdi_vst_color(    /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD color);      /* Color number.                                          */
/****************************************************************************/

/****************************************************************************
 * Vdi_vst_effects                                                          *
 *  Set text effects.                                                       *
 ****************************************************************************/
WORD              /*                                                        */
Vdi_vst_effects(  /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD effects);    /* Text effects.                                          */
/****************************************************************************/

/****************************************************************************
 * Vdi_vst_font                                                             *
 *  Set font id.                                                            *
 ****************************************************************************/
WORD              /*                                                        */
Vdi_vst_font(     /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD fntid);      /* Text fontid.                                           */
/****************************************************************************/

/****************************************************************************
 * Vdi_vst_height                                                           *
 *  Set text height.                                                        *
 ****************************************************************************/
WORD              /*                                                        */
Vdi_vst_height(   /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD height,      /* Height in pixels.                                      */
WORD *wchar,      /* Width of character.                                    */
WORD *hchar,      /* Height of character.                                   */
WORD *wcell,      /* Width of character cell.                               */
WORD *hcell);     /* Height of character cell.                              */
/****************************************************************************/

/****************************************************************************
 * Vdi_vst_point                                                            *
 *  Set text height.                                                        *
 ****************************************************************************/
WORD              /*                                                        */
Vdi_vst_point(    /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD point,       /* Height in points.                                      */
WORD *wchar,      /* Width of character.                                    */
WORD *hchar,      /* Height of character.                                   */
WORD *wcell,      /* Width of character cell.                               */
WORD *hcell);     /* Height of character cell.                              */
/****************************************************************************/

/****************************************************************************
 * Vdi_vswr_mode                                                            *
 *  Set write mode.                                                         *
 ****************************************************************************/
WORD              /*                                                        */
Vdi_vswr_mode(    /*                                                        */
WORD handle,      /* Workstation handle.                                    */
WORD mode);       /* Write mode.                                            */
/****************************************************************************/
#endif
