#include <aesbind.h>
#include <mintbind.h>
#include <osbind.h>
#include <process.h>
#include <signal.h>
#include <stdio.h>
#include <unistd.h>

#include "appl.h"
#include "debug.h"
#include "evnt.h"
#include "evnthndl.h"
#include "form.h"
#include "graf.h"
#include "lxgemdos.h"
#include "menu.h"
#include "misc.h"
#include "mousedev.h"
#include "objc.h"
#include "rdwrs.h"
#include "resource.h"
#include "wind.h"

#include	<sysvars.h>

void init_aes(WORD physical) {
	init_global(physical);

	Rdwrs_init_module();
	
	Supexec(link_in);

	Appl_init_module();
	
	init_objc();

	Graf_init_module();

	Wind_init_module();

	Menu_init_module();

	Moudev_init_module();

	Evhd_init_module();
}

void	exit_aes(void) {
	Moudev_exit_module();
	
	Evhd_exit_module();
	
	Menu_exit_module();
	
	Wind_exit_module();
	
	Appl_exit_module();

	Supexec(link_remove);

	exit_objc();

	Rdwrs_exit_module();

	exit_global();
}


int main(int argc,char **argv) {
	WORD physical = 0;
	WORD i;

	
/*	remove(DEBUGPATH);*/

	for(i = 1; i < argc; i++) {
		if(!strcmp("-physical",argv[i])) {
			physical = 1;
		}
		else {
			fprintf(stderr,"Unknown option %s\r\n",argv[i]);
		};
	};

	init_aes(physical);

	graf_mouse(ARROW,0L);

	Menu_handler();
	
	exit_aes();

	return 0;
};


