/* WINTYPE.C - Windows class for X

  Rhett D. Jacobs   <rhett@jaemol.cbr.fidonet.org>

  Version 1.0

  Last Modified: 1/1/95
*/

#include"wintype.h"
#include"bitmaps/xtron.h"	/* icon */


void win_setup(void)
{
  /* set the display name from  the environment variable DISPLAY */
  display = XOpenDisplay (NULL);
  if (display == NULL) {
    fprintf (stderr,"Unable to open display %s\n",
	     XDisplayName (NULL));
    exit (1);
  }
  screen = DefaultScreen (display);
  foreground = BlackPixel(display, screen);
  background = WhitePixel(display, screen);
}


void win_shutdown(void)
{
  XFreeGC(display, gc);
  XCloseDisplay (display);
  exit (0);
}


Window win_open(int x, int y, int width, int height, int border_width,
		Window parent, int istoplevel, int argc, char *argv[],
		char *win_name)
{
  Window new_window;
  XSizeHints size_hints;
  Pixmap icon_map;

  /* create window */
  new_window = XCreateSimpleWindow(display, parent, x, y, width, height,
				   border_width, foreground, background);

  /* set size hints for window manager */
   if (istoplevel) {
     size_hints.flags = PMinSize | PMaxSize | PSize | PResizeInc;
     size_hints.min_width  = width;
     size_hints.max_width  = width;
     size_hints.min_height = height;
     size_hints.max_height = height;
     size_hints.width_inc  = 1;
     size_hints.height_inc = 1;

     icon_map = XCreateBitmapFromData(display, new_window, xtron_bits,
				      xtron_width, xtron_height);
     XSelectInput(display, new_window,
		  ButtonPressMask | KeyPressMask | ExposureMask |
		  VisibilityChangeMask | FocusChangeMask);

     /* state which hints are included */
     XSetStandardProperties (display, new_window, win_name,
			     "XTron", icon_map,
			     argv, argc, &size_hints);
   }
  /* return the window ID */
  return (new_window);
}


GC win_getGC(void)
{
  XGCValues gcValues;

  gc = XCreateGC (display, main_window,
		  (unsigned long) 0, &gcValues);

  XSetBackground (display, gc, background);
  XSetForeground (display, gc, foreground);

  return (gc);
}
