/* MAIN.H - XTron main file header

   Rhett D. Jacobs   <rhett@jaemol.cbr.fidonet.org>

   Version 1.0

   Last Modified: 1/1/95
 */

#ifndef MAIN_H
#define MAIN_H

#include <string.h>
#include <sys/types.h>
#include <sys/time.h>

#include "resource.h"
#include "wintype.h"
#include "xtron.h"

/* interface windows */
#include "bitmaps/computer.h"
#include "bitmaps/human.h"
#include "bitmaps/humanr.h"
#include "bitmaps/comprr.h"
#include "bitmaps/again.h"
#include "bitmaps/pause.h"
#include "bitmaps/quit.h"

/* player pieces and background */
#include "bitmaps/p1.h"
#include "bitmaps/p2.h"
#include "bitmaps/p3.h"
/* #include "bitmaps/back.h" */
static char back_bits[GAME_X * GAME_Y / 8];
static int  back_width = GAME_X, back_height = GAME_Y;

extern struct Player p[2];
extern struct Board b;

void ButtonEvent(XButtonEvent *pEvent);
void KeyEvent(XKeyEvent *pEvent);
void ExposeEvent(XExposeEvent *pEvent);
Window set_window(int x, int y, int width, int height);
void mapwindows(void);
Pixmap set_icon(char *bits, unsigned int width, unsigned int height);
int check_valid(int p_num, int x_inc, int y_inc);
void think(int p_num);
int game_update(void);
void delay(int len);
void restart_game(void);
void open_windows(int argc, char **argv);
void assign_bitmaps(void);

#endif
