
/*  Codes in the map data bytestream:

	      Byte 1	Arguments	   Meaning
	    ==========	=========	============
	    00 mv1 mv2		    - Two short draw commands
	    01 dxx dyy		    - One longer draw command
	    10 mv1 000		    - One short draw command
	    11 000 000		    - Long move command
			ax ax ay ay
	    11 000 001		    - Long draw command
			ax ax ay ay
	    11 000 010		    - Medium draw command
			dx dy
	    11 000 011		    - Medium move command
			dx dy
*/

static unsigned char mapdata[] = {
    192,4,222,2,28,136,106,144,106,10,10,9,17,33,20,20,33,17,18,17,160,106,
    115,114,10,20,10,160,115,10,136,116,106,123,34,17,34,122,106,144,122,
    10,98,33,18,10,18,136,106,144,106,144,105,10,17,12,10,106,9,136,106,12,
    9,9,12,9,27,25,27,51,84,43,29,27,85,27,27,27,43,46,84,84,27,84,30,27,
    43,27,0,24,11,11,9,11,152,195,129,128,9,12,11,9,11,83,8,25,24,25,152,
    82,24,83,0,1,46,82,8,98,1,9,8,136,98,90,24,24,11,3,136,90,98,8,97,9,9,
    33,24,8,9,84,11,0,1,90,10,8,1,25,25,128,98,1,9,11,8,82,9,25,1,0,8,25,
    1,98,9,195,115,121,27,27,29,27,27,27,11,67,84,11,152,76,25,27,84,3,25,
    27,83,152,83,27,9,84,27,11,27,27,27,41,43,30,30,30,53,176,194,127,132,
    51,29,27,27,25,27,3,25,24,27,152,76,27,11,1,1,0,76,11,3,27,152,84,84,
    27,25,152,75,24,11,51,128,83,25,9,36,12,33,33,10,97,3,25,9,144,114,25,
    27,51,25,11,25,27,43,43,29,27,27,11,84,11,53,3,84,27,43,27,27,25,27,152,
    84,29,29,27,27,152,68,152,85,30,30,27,30,29,27,43,43,43,51,27,27,29,128,
    84,24,84,27,25,24,24,27,46,51,53,46,30,51,53,152,85,29,29,30,27,51,54,
    46,30,30,30,46,102,176,102,54,45,53,45,51,30,27,51,46,152,84,85,27,51,
    43,53,54,45,29,51,102,51,53,46,94,176,85,30,94,54,53,30,30,45,168,102,
    102,54,50,62,152,195,129,128,44,52,54,54,152,195,129,128,54,52,54,110,
    62,54,102,46,176,94,194,127,132,54,51,45,45,54,20,39,55,54,30,54,54,60,
    54,38,60,62,20,59,52,52,44,38,52,52,160,110,39,55,184,194,129,132,63,
    55,54,52,38,36,55,39,160,110,39,39,118,39,63,39,38,160,126,36,34,36,20,
    36,20,34,160,116,194,133,128,36,160,116,36,36,116,52,38,33,33,36,12,144,
    123,36,36,12,144,124,12,36,144,124,36,36,33,36,194,132,128,36,52,62,116,
    39,52,195,127,128,51,102,60,55,36,36,124,36,36,36,38,34,52,52,55,36,54,
    62,54,54,46,54,30,46,46,38,54,47,46,102,54,36,43,54,55,102,38,62,176,
    118,63,39,195,127,128,55,60,63,52,55,54,62,54,36,57,160,116,37,27,51,
    27,54,38,39,54,52,55,54,62,54,30,46,38,52,54,62,55,54,54,46,53,51,46,
    30,46,30,54,46,53,54,102,30,94,111,51,54,54,54,55,176,102,39,55,38,62,
    110,38,52,54,38,54,110,39,55,102,176,111,55,176,102,102,55,54,184,110,
    103,54,62,176,110,38,52,110,63,63,63,110,54,38,176,110,62,52,176,110,
    38,38,54,54,30,3,52,55,176,102,54,60,23,38,36,60,36,12,36,36,36,34,36,
    12,36,36,176,116,33,36,36,38,36,34,36,36,10,36,36,34,33,34,33,34,36,12,
    12,12,12,18,33,34,10,17,33,12,10,12,10,10,12,12,36,9,33,10,9,144,105,
    9,98,9,12,10,36,12,33,36,33,36,33,20,12,9,160,195,127,128,11,98,17,9,
    9,9,25,1,136,90,8,9,9,18,160,115,12,18,115,12,9,33,115,136,116,20,20,
    116,114,34,34,33,18,136,115,106,9,10,25,9,8,98,9,98,98,9,136,98,10,9,
    11,24,11,24,90,136,98,136,89,136,97,9,12,9,12,9,33,3,11,25,98,136,195,
    128,126,33,195,128,127,106,195,132,120,160,195,128,127,144,195,128,127,
    116,195,131,125,33,195,128,127,160,195,136,186,51,55,33,32,195,161,131,
    53,46,53,51,46,27,44,51,54,54,30,24,53,51,29,45,27,30,27,27,51,51,46,
    30,51,53,54,176,102,52,54,62,54,54,176,94,94,51,54,30,168,102,30,54,55,
    54,102,55,54,55,63,118,52,116,52,33,116,12,36,12,116,33,33,17,12,9,17,
    17,106,136,106,12,4,136,106,9,106,26,9,33,9,12,9,12,9,17,9,97,9,33,12,
    9,9,9,12,60,10,9,8,9,9,9,8,9,24,84,9,195,106,130,30,52,136,195,183,175,
    38,38,34,9,25,27,51,152,195,129,128,168,192,5,136,3,21,38,39,39,36,33,
    38,37,27,46,25,27,27,152,195,129,128,9,27,12,1,195,129,128,136,195,157,
    154,83,27,195,129,128,52,192,4,212,3,10,30,160,195,130,126,52,136,192,
    4,24,3,54,44,33,192,3,223,2,90,136,195,128,129,31,33,195,78,85,52,136,
    192,4,50,2,5,33,11,27,62,184,195,115,121,33,6,30,195,141,110,33,11,136,
    195,128,129,30,195,129,129,184,195,5,104,11,195,57,71,46,36,9,195,140,
    137,33,27,176,195,125,133,160,90,11,54,160,195,119,118,51,52,33,195,193,
    59,33,33,11,51,176,195,125,133,33,33,33,27,46,30,195,121,128,51,54,38,
    195,128,127,33,9,195,124,126,27,30,52,33,160,195,119,131,176,195,128,
    127,43,184,195,130,122,152,195,129,128,12,3,176,195,131,106,38,60,12,
    11,25,152,195,133,125,51,58,136,195,74,102,11,5,47,36,195,118,122,33,
    29,195,119,130,33,11,46,195,135,127,11,30,160,195,128,130,128,195,128,
    127,168,195,129,128,160,192,4,185,1,120,51,46,54,27,51,168,85,53,51,46,
    36,12,10,17,33,34,36,12,17,25,144,195,21,192,90,11,1,12,15,60,60,116,
    53,27,54,152,195,250,171,30,55,102,54,55,54,38,38,36,50,195,127,128,9,
    25,1,88,9,9,13,195,102,142,51,30,29,46,46,195,128,127,116,160,115,12,
    17,136,195,121,139,43,45,168,116,20,12,195,127,127,160,195,122,139,30,
    102,51,52,195,128,127,33,10,152,195,150,110,136,98,152,84,25,136,195,
    128,130,51,195,129,128,55,33,195,128,129,160,195,129,128,160,195,137,
    136,27,27,25,24,176,195,128,127,40,27,3,27,51,54,168,194,128,132,54,51,
    54,54,62,38,33,12,62,36,98,38,36,33,11,8,33,20,9,33,98,12,34,36,195,97,
    146,30,94,54,22,176,102,176,102,54,102,54,62,184,110,160,110,63,176,119,
    60,9,1,136,90,1,8,9,1,25,24,144,90,98,9,9,136,90,9,128,195,125,157,46,
    46,110,33,12,136,98,136,195,131,140,52,54,54,160,195,127,128,60,38,16,
    9,1,25,152,195,127,128,194,143,156,136,195,127,128,30,152,84,11,27,43,
    52,39,36,12,36,160,195,109,132,84,29,53,53,176,195,129,126,33,114,160,
    195,106,136,11,30,29,152,84,52,54,34,136,195,128,129,20,144,195,129,127,
    160,195,84,130,27,84,29,46,52,20,33,36,12,192,5,51,1,89,25,27,8,27,30,
    60,60,160,195,129,128,176,195,78,82,10,9,11,30,30,52,176,195,118,120,
    152,85,27,43,195,129,128,55,36,17,195,128,127,160,192,4,102,2,15,17,19,
    9,16,5,176,111,176,195,129,129,152,195,25,76,136,98,9,136,98,136,97,43,
    24,25,25,30,29,52,194,132,129,62,160,102,38,53,27,84,30,39,136,195,128,
    129,160,116,184,192,4,52,1,62,27,84,27,85,43,195,129,128,60,52,20,11,
    12,195,128,129,36,33,195,128,129,144,195,120,127,11,27,176,116,195,121,
    126,54,55,17,8,195,126,129,27,54,39,136,195,127,128,12,195,120,121,136,
    76,29,36,116,195,94,138,11,84,30,36,160,195,129,128,160,192,2,167,3,173,
    11,17,160,90,116,11,4,12,160,82,17,25,75,136,116,17,33,27,75,9,25,152,
    195,129,128,136,97,1,11,3,152,81,11,27,9,25,33,33,11,69,68,84,4,195,127,
    128,20,10,20,36,9,1,24,27,25,36,33,36,20,9,160,195,127,128,19,10,33,36,
    34,33,20,36,144,116,39,20,12,144,116,33,12,12,34,116,115,20,33,33,152,
    194,122,129,85,84,78,77,27,27,30,29,152,76,29,29,30,85,30,27,152,84,46,
    29,51,53,86,43,53,6,84,43,46,51,94,30,118,168,77,168,85,168,103,63,39,
    176,117,52,110,184,103,31,29,70,85,77,85,84,77,29,27,84,76,194,118,128,
    194,119,128,194,123,128,76,152,84,194,123,127,76,76,84,84,76,75,84,84,
    24,152,84,76,27,128,84,27,84,84,152,76,84,194,120,128,84,152,84,67,194,
    115,127,194,121,127,76,136,84,68,3,27,76,75,27,75,84,76,84,75,76,27,176,
    125,116,176,194,132,130,117,54,36,63,54,77,25,128,84,11,25,25,27,176,
    85,24,25,24,84,152,85,85,176,116,60,43,168,116,117,117,195,127,128,84,
    67,27,52,117,125,36,62,194,123,128,83,67,68,168,194,123,129,152,194,123,
    128,194,123,129,27,19,152,84,3,27,84,27,168,85,75,194,122,126,24,0,10,
    9,27,30,27,84,76,29,117,63,51,61,85,84,43,152,76,76,77,84,84,27,136,75,
    3,2,12,144,123,34,24,85,83,84,84,152,84,76,67,27,76,194,123,128,83,27,
    5,27,29,29,152,85,43,43,78,84,168,85,30,84,194,126,132,43,51,195,129,
    128,168,84,194,122,127,67,76,82,83,152,84,75,83,68,194,123,128,84,84,
    84,194,121,128,69,27,176,85,152,84,76,84,84,152,76,194,123,129,27,168,
    85,75,152,84,85,84,194,121,129,194,122,128,30,27,29,60,160,117,84,152,
    84,25,27,76,27,176,69,68,85,194,122,128,152,84,152,194,123,127,152,84,
    194,123,127,76,152,194,122,128,152,84,76,152,68,84,27,27,54,160,116,168,
    116,36,160,116,160,116,117,116,36,59,68,152,76,152,84,176,194,123,128,
    69,31,152,195,129,128,52,36,184,116,36,160,116,160,116,194,132,129,36,
    52,116,125,116,59,195,129,128,38,36,160,125,52,117,38,160,124,160,194,
    132,128,124,194,133,129,194,134,128,160,116,116,160,116,116,160,195,125,
    128,168,84,152,76,194,120,129,194,109,128,77,152,84,76,152,77,27,85,195,
    129,128,85,84,85,29,84,168,86,47,194,128,132,39,110,194,134,130,116,116,
    195,127,128,194,136,130,116,194,132,128,194,133,128,117,36,116,194,134,
    129,36,195,127,128,176,84,195,129,128,194,120,128,194,119,128,195,19,
    127,68,76,68,136,194,118,128,76,152,83,194,118,127,194,123,128,192,7,
    251,3,222,194,132,128,192,0,0,3,222,125,192,7,251,3,222,194,117,128,194,
    113,127,24,68,84,75,194,122,128,75,68,27,76,194,122,128,84,168,117,160,
    69,85,27,195,129,128,52,176,85,124,60,36,38,194,132,128,195,105,128,194,
    123,127,27,67,124,116,123,144,84,115,194,134,128,160,90,124,116,12,33,
    115,24,84,84,3,152,67,128,84,194,123,127,83,152,75,83,84,152,75,194,116,
    128,194,122,128,152,195,129,128,19,195,129,128,116,160,116,3,1,17,152,
    195,129,128,128,115,3,27,11,25,19,4,136,124,34,36,36,32,36,123,160,116,
    124,194,137,128,124,116,194,133,128,160,194,139,128,124,115,27,67,27,
    152,84,67,195,129,128,3,76,152,195,129,128,84,27,152,68,11,83,0,9,98,
    25,116,20,11,11,20,36,195,127,128,20,11,9,20,115,116,115,34,116,33,116,
    160,115,34,34,34,194,133,127,124,116,116,136,116,8,34,36,9,34,152,195,
    129,128,12,11,3,27,27,83,27,27,195,129,128,83,24,27,0,168,75,152,68,84,
    27,67,152,74,84,152,75,27,76,27,118,51,62,43,1,25,9,25,152,75,152,84,
    24,160,195,127,128,24,25,84,152,83,75,152,84,27,84,30,63,54,160,195,127,
    128,27,27,27,152,84,27,9,10,152,195,129,128,1,160,83,152,85,84,76,152,
    67,27,25,152,84,27,27,84,3,27,27,27,27,46,29,27,84,27,25,33,36,106,33,
    25,27,24,84,136,84,27,27,144,67,84,128,84,84,29,24,24,84,76,27,27,27,
    152,68,83,27,75,27,152,84,83,152,84,83,27,152,75,84,194,123,128,84,152,
    84,27,194,119,129,152,84,27,84,84,45,29,11,152,83,83,152,84,84,77,27,
    43,43,29,68,27,27,68,27,152,84,27,24,84,27,84,27,3,76,83,68,66,27,83,
    152,67,152,76,128,194,123,128,27,27,76,27,77,30,29,29,29,29,152,85,27,
    3,3,195,129,128,11,3,152,84,152,84,152,76,84,27,27,27,84,84,27,27,84,
    27,85,27,43,68,76,85,43,168,75,84,128,83,3,27,25,27,84,84,27,84,27,152,
    68,84,152,84,194,123,129,27,51,27,27,43,76,84,27,76,67,194,122,129,152,
    77,76,152,69,27,29,85,152,84,27,152,77,29,27,168,84,27,51,27,152,84,51,
    152,85,152,102,168,84,29,194,123,130,27,168,76,194,122,128,152,85,85,
    51,77,27,3,11,8,136,83,83,0,24,83,168,195,129,127,27,27,12,33,8,27,168,
    84,68,75,84,84,152,84,84,83,76,152,67,152,84,27,27,68,84,84,84,194,123,
    127,194,122,127,84,26,128,83,84,152,84,83,152,84,84,84,69,76,84,152,85,
    29,27,85,27,94,46,54,30,84,30,84,11,85,27,76,27,27,76,27,27,152,194,123,
    129,152,85,27,75,27,152,76,84,84,27,152,76,29,76,43,84,77,43,85,176,85,
    53,29,27,3,84,75,84,68,152,83,84,75,25,24,27,25,84,29,152,77,176,85,152,
    84,84,27,86,11,76,43,51,85,152,85,27,76,27,84,152,84,85,194,122,128,27,
    152,83,84,53,152,76,27,27,77,76,76,27,128,194,122,127,76,83,24,84,152,
    68,24,83,27,29,152,77,76,84,51,85,152,84,194,121,128,152,85,76,27,84,
    77,194,123,128,152,84,27,194,123,129,84,43,27,152,77,68,194,123,129,84,
    77,84,84,84,27,27,67,3,9,9,144,84,3,152,84,84,76,30,27,30,55,116,38,160,
    85,84,76,84,27,76,25,84,84,194,123,129,84,51,29,37,43,85,75,27,83,27,
    3,25,195,128,129,54,31,54,29,29,84,51,84,84,76,152,76,27,69,84,152,77,
    152,85,194,123,128,76,27,27,76,76,76,168,76,84,29,78,39,84,168,84,27,
    51,84,168,69,84,54,152,77,77,84,43,51,152,85,27,43,194,108,132,168,84,
    77,27,43,77,84,152,77,68,69,194,122,129,168,84,69,84,76,194,122,128,76,
    152,194,120,129,76,84,68,194,123,128,84,68,194,120,128,27,27,84,194,123,
    127,76,75,76,84,84,128,76,84,194,117,125,75,194,123,127,152,76,128,84,
    194,123,127,76,84,75,27,68,194,122,128,194,123,128,27,84,68,194,123,128,
    194,123,127,152,68,83,116,36,123,116,12,160,123,144,98,136,83,11,24,20,
    116,116,160,125,116,160,117,36,160,116,52,36,195,223,46,25,30,85,11,12,
    160,195,121,129,24,27,128,116,39,160,195,77,130,27,13,152,84,195,109,
    132,29,36,36,11,195,62,167,39,36,53,110,194,134,133,52,176,94,176,102,
    168,85,53,43,43,76,152,84,128,76,84,84,84,194,119,126,76,128,83,1,1,36,
    160,116,184,124,160,124,116,160,116,20,36,12,38,115,34,160,90,24,12,9,
    27,27,195,129,128,19,0,9,160,124,12,36,116,195,95,134,168,76,52,124,117,
    36,116,36,36,17,24,27,27,84,84,195,47,118,27,30,192,0,153,3,200,3,76,
    84,152,85,76,76,85,30,160,194,133,128,194,132,128,124,33,116,36,136,195,
    83,120,27,25,152,76,27,51,152,195,129,128,184,116,36,116,36,195,131,130,
    84,195,129,128,84,152,84,3,85,84,195,129,128,51,60,36,36,160,124,124,
    16,192,7,250,3,127,36,11,152,195,128,127,33,25,30,152,192,2,161,3,137,
    30,27,52,117,38,116,12,20,3,84,152,195,25,150,36,160,116,116,116,36,160,
    124,116,160,124,116,20,195,127,128,152,83,76,194,121,127,152,84,84,27,
    27,52,116,168,84,152,192,4,185,1,83,63,55,52,54,38,63,118,52,144,98,17,
    12,9,10,54,54,102,46,36,176,195,128,127,62,38,62,39,110,63,54,63,110,
    118,51,52,63,52,110,38,38,160,102,62,38,54,59,110,54,54,62,63,52,36,63,
    62,63,102,184,110,52,52,63,55,62,54,102,54,54,54,62,52,54,54,38,62,55,
    54,36,34,116,12,60,33,33,34,160,123,36,144,116,20,12,115,36,20,12,160,
    115,34,36,12,36,12,116,20,36,17,106,10,20,116,136,116,160,115,36,20,34,
    10,12,36,34,160,106,12,115,33,36,136,98,9,33,9,36,33,18,10,17,33,20,9,
    8,11,11,11,11,1,24,27,27,27,11,152,90,0,9,9,9,33,9,11,51,54,30,29,30,
    29,53,85,51,51,168,84,84,27,27,41,43,25,27,25,12,11,9,17,9,8,11,51,54,
    53,30,0,11,9,9,11,9,25,25,25,25,27,1,25,25,25,25,9,9,25,33,12,34,52,17,
    36,50,58,52,36,52,54,62,54,38,63,62,60,39,38,36,63,160,117,60,36,36,60,
    34,33,34,34,116,38,62,62,54,38,52,36,36,117,36,36,36,36,38,36,36,52,38,
    33,36,36,36,20,36,116,36,36,36,36,36,160,115,60,12,52,36,54,102,60,62,
    38,38,60,36,36,54,38,38,39,36,36,20,34,20,116,39,51,27,27,43,51,51,43,
    30,27,25,152,195,129,129,52,55,39,38,60,52,62,33,36,20,12,10,136,106,
    10,52,37,54,184,102,184,102,54,54,54,30,54,38,54,55,54,55,54,54,62,54,
    54,38,110,52,54,38,39,52,176,102,54,176,110,52,55,52,55,54,38,62,55,38,
    110,62,24,195,129,129,55,55,52,52,60,52,33,34,9,34,33,34,12,12,17,18,
    9,9,98,9,9,106,12,9,97,9,98,136,98,9,9,33,34,10,36,12,33,36,10,18,33,
    33,34,12,34,10,20,12,20,20,9,20,15,50,20,20,17,34,11,98,9,20,12,115,38,
    52,20,38,36,12,36,36,34,17,17,36,36,52,12,54,52,54,38,54,55,39,52,102,
    38,60,12,62,52,55,110,52,54,62,55,110,54,54,30,53,54,195,128,127,38,34,
    60,15,106,20,114,12,10,62,33,62,38,62,54,52,54,176,102,54,62,176,102,
    195,128,127,38,38,55,54,62,54,61,62,30,30,54,54,102,54,176,94,160,94,
    47,36,38,55,160,110,38,126,111,62,54,194,128,132,55,176,110,54,62,63,
    52,52,52,52,62,36,63,60,52,36,195,127,127,33,34,17,8,11,9,136,88,98,9,
    9,1,11,8,1,25,25,24,27,8,24,54,27,1,25,11,8,9,9,30,1,4,9,6,27,1,9,9,10,
    9,33,98,33,17,9,9,9,9,136,124,52,54,55,38,39,33,36,63,36,52,52,52,54,
    52,52,38,44,176,195,128,127,36,160,116,54,38,36,102,46,54,54,30,36,10,
    12,17,33,36,9,0,0,1,9,38,54,36,52,38,62,52,33,9,33,160,116,34,18,36,12,
    20,10,9,9,9,136,98,136,98,9,11,9,9,24,1,25,25,3,11,11,1,27,11,9,8,9,27,
    90,1,1,9,34,12,12,114,10,12,18,17,33,195,128,129,116,12,36,38,39,36,12,
    55,46,54,62,34,9,1,33,12,12,52,160,116,36,36,33,36,20,12,12,1,12,36,12,
    54,36,176,195,128,127,34,36,36,36,36,18,17,34,12,58,115,10,9,36,34,10,
    10,17,33,26,17,10,18,33,33,34,17,33,36,9,17,12,11,4,20,11,11,19,195,129,
    128,9,26,9,25,12,98,1,25,3,25,24,9,25,9,1,25,27,1,25,4,12,12,12,12,17,
    12,116,12,9,36,33,60,12,36,20,12,11,152,84,6,3,27,27,11,43,30,29,30,84,
    27,25,33,25,3,195,129,127,27,11,1,98,12,36,34,34,9,33,36,20,12,34,33,
    36,10,33,57,60,36,62,54,29,51,47,38,30,152,85,30,36,36,114,36,12,115,
    160,115,36,4,36,38,33,36,60,62,46,54,38,85,30,47,116,195,127,128,116,
    36,36,33,38,38,53,54,48,51,54,33,195,128,127,62,55,54,51,53,54,54,36,
    33,60,12,20,50,36,38,33,11,12,195,128,129,33,36,10,136,98,33,27,9,9,98,
    1,25,27,8,1,33,27,11,24,25,12,33,9,36,12,36,10,144,115,36,19,9,17,12,
    10,160,115,12,12,20,12,36,60,36,36,184,194,132,127,20,18,36,12,17,36,
    10,33,194,132,126,115,12,20,12,12,17,36,10,10,12,10,33,20,17,33,33,9,
    9,34,9,9,144,98,98,17,106,10,33,11,25,33,9,33,27,25,152,195,129,128,116,
    160,195,127,128,11,84,0,11,25,25,30,27,25,27,62,53,51,48,10,136,195,128,
    129,29,29,27,27,12,34,19,152,195,129,128,12,195,127,128,27,54,29,1,12,
    4,11,13,27,84,27,11,25,33,36,20,34,36,17,160,115,34,12,12,18,12,34,36,
    115,12,33,36,12,12,12,20,34,17,33,36,12,36,116,36,20,36,160,116,116,38,
    34,52,160,116,36,36,36,36,36,52,36,36,11,152,84,195,127,128,20,36,36,
    11,152,195,129,128,12,39,20,52,36,52,33,36,52,44,52,36,43,27,44,36,36,
    36,115,36,33,36,36,52,160,115,36,116,116,36,33,25,27,27,43,11,195,129,
    128,12,12,33,34,36,36,36,12,33,17,36,12,12,33,36,33,36,36,116,33,36,36,
    51,51,51,51,44,62,36,33,36,33,34,33,160,116,33,83,12,10,36,33,36,38,36,
    43,30,160,195,127,128,51,54,30,37,51,54,27,51,85,29,168,85,85,27,85,168,
    85,30,30,45,29,27,85,84,51,86,43,30,53,46,46,53,54,54,38,54,195,128,127,
    22,54,54,54,54,62,36,195,127,128,47,176,110,54,54,36,50,33,36,12,33,12,
    33,33,33,11,195,129,128,9,36,34,36,36,1,25,195,129,128,12,12,12,20,20,
    36,38,36,12,10,9,9,25,12,10,33,39,58,106,24,27,51,25,9,33,33,36,11,11,
    27,10,136,98,19,195,129,128,33,12,116,12,18,20,36,36,33,12,34,33,36,54,
    43,51,195,129,128,36,115,20,34,36,12,33,36,52,36,60,38,36,36,44,36,12,
    136,115,20,136,195,128,129,20,36,3,195,129,128,36,195,126,128,136,116,
    36,33,12,39,36,12,36,34,33,36,12,36,36,20,36,36,36,20,36,38,36,60,160,
    195,129,128,11,25,36,33,160,195,127,128,11,195,129,128,12,195,127,128,
    27,11,11,8,8,11,24,27,11,27,27,3,27,195,130,128,116,36,33,36,52,60,34,
    36,39,30,195,129,127,34,33,160,192,0,0,0,141,100,36,34,33,33,27,11,12,
    17,34,52,36,38,51,51,195,129,128,52,52,36,36,34,36,36,38,36,38,38,152,
    195,129,128,52,36,36,60,36,52,36,36,176,116,33,24,12,33,36,9,25,27,26,
    36,60,36,116,36,11,195,129,128,36,33,152,195,129,128,12,33,27,24,3,24,
    11,27,27,27,27,27,27,27,27,43,54,60,195,127,128,27,11,4,9,25,25,32,3,
    27,194,134,133,195,113,121,83,27,25,27,83,84,3,192,7,255,0,119,100,192,
    0,0,0,119,184,192,7,255,0,119,27,24,24,27,27,83,27,27,136,84,27,11,27,
    43,11,27,27,152,84,27,27,27,27,27,11,27,27,30,38,160,195,127,128,27,55,
    34,50,52,195,126,128,54,30,60,38,152,195,127,127,27,152,84,168,84,24,
    25,9,27,27,27,25,25,25,27,51,51,11,27,27,84,24,176,84,27,27,27,27,11,
    43,13,3,176,84,11,51,43,30,54,45,195,129,127,0,11,11,27,1,27,25,12,160,
    195,127,128,12,1,24,27,128,84,27,152,76,84,27,84,27,27,27,27,27,27,27,
    152,85,5,27,27,24,27,27,83,24,24,27,11,27,25,36,36,32,25,84,152,84,152,
    83,27,27,27,30,152,85,29,27,51,29,24,27,12,36,160,195,127,128,12,36,12,
    36,176,195,129,128,12,19,27,152,195,126,129,84,27,84,27,152,195,129,128,
    136,195,128,129,194,135,126,38,160,195,131,128,83,152,195,125,128,27,
    27,27,152,83,27,84,152,84,152,84,27,27,24,31,195,129,128,184,194,121,
    130,59,30,117,38,27,27,27,27,11,30,38,27,51,27,11,24,27,24,27,27,27,27,
    27,43,27,27,27,25,25,27,51,45,30,30,30,27,25,27,24,30,194,133,129,195,
    123,126,24,27,3,27,84,12,33,195,126,129,11,25,27,11,27,27,52,52,51,25,
    27,24,27,25,33,36,36,36,36,36,36,60,52,36,34,9,9,3,84,152,84,24,152,84,
    27,24,84,27,27,27,3,27,3,27,27,51,152,84,30,52,36,38,52,160,195,126,128,
    43,27,27,27,25,27,27,29,27,25,27,83,11,27,27,27,27,24,27,152,84,27,27,
    27,11,27,27,152,84,27,27,55,36,38,27,195,129,128,51,27,195,128,129,10,
    3,25,3,12,3,51,152,84,67,152,195,129,128,11,84,27,29,27,60,195,127,128,
    27,27,43,43,43,27,51,27,27,168,84,25,36,160,195,130,128,12,17,11,76,4,
    36,36,60,36,33,36,20,36,20,12,116,33,36,34,36,36,34,36,176,194,123,128,
    195,133,127,123,20,12,4,20,11,27,11,11,3,27,152,84,152,84,27,84,29,152,
    83,152,84,27,76,84,152,84,29,27,43,76,84,152,195,129,128,12,33,36,33,
    33,27,27,195,129,128,20,33,24,27,27,27,11,51,192,5,79,1,138,30,46,33,
    33,195,113,90,136,195,128,129,27,152,195,127,128,176,195,127,128,44,36,
    34,195,97,130,51,31,152,195,129,128,52,136,195,253,211,54,176,195,128,
    127,33,195,122,123,50,195,131,137,54,17,195,169,136,46,176,102,54,54,
    54,176,103,55,52,62,36,20,18,34,9,98,17,89,0,25,82,0,3,195,204,73,54,
    38,57,9,152,195,124,159,30,54,33,136,195,127,131,54,33,136,195,127,131,
    30,53,52,50,9,136,195,127,136,27,55,33,195,129,136,176,195,133,138,54,
    57,9,195,140,154,30,38,38,33,11,136,195,127,128,128,195,136,137,55,36,
    8,152,195,134,139,30,60,11,195,129,126,152,195,129,128,50,195,128,132,
    51,52,54,63,12,11,8,9,195,136,140,54,60,11,136,195,137,141,60,9,152,192,
    5,155,2,41,30,6,60,136,192,6,32,1,222,46,52,110,55,55,60,62,38,39,52,
    62,38,38,38,44,39,38,60,54,52,54,54,60,50,55,55,55,62,38,62,39,52,54,
    54,55,63,176,118,110,60,52,38,52,52,60,60,102,39,60,11,195,129,128,38,
    17,36,33,98,144,98,136,98,9,9,17,24,9,27,5,25,136,84,9,160,90,9,41,9,
    25,27,25,33,25,9,11,85,25,19,3,11,128,90,27,9,27,9,11,27,27,11,9,25,3,
    11,11,1,27,11,152,84,25,17,0,3,3,24,24,25,5,136,195,184,201,38,60,117,
    36,52,60,39,23,20,184,115,60,39,36,38,36,36,36,52,36,38,36,116,33,36,
    38,36,36,60,11,9,8,27,152,84,24,25,8,11,3,3,25,30,3,30,51,51,27,84,168,
    83,27,11,0,11,13,27,27,27,27,25,27,94,51,195,127,126,46,33,195,141,106,
    54,30,36,57,160,98,27,136,195,174,161,46,46,36,33,33,33,27,152,195,132,
    130,15,160,116,36,22,34,52,33,15,9,11,27,51,51,11,30,27,27,176,195,140,
    135,23,160,110,36,52,17,9,27,1,27,27,30,176,195,132,122,36,36,38,36,36,
    36,36,20,33,33,13,43,27,27,29,24,3,27,27,176,195,144,142,36,12,12,20,
    20,34,114,20,18,34,36,33,34,36,33,27,152,84,27,27,43,45,30,29,30,85,46,
    168,195,128,129,152,195,134,115,52,60,33,11,3,176,195,136,128,20,36,33,
    152,84,27,176,195,25,59,38,36,9,11,30,195,132,44,55,36,52,57,33,36,115,
    9,33,18,9,27,13,27,27,51,29,43,53,195,160,109,84,176,116,195,164,131,
    17,136,106,12,9,144,113,98,12,9,9,11,6,27,45,51,53,53,53,176,94,59,62,
    52,62,38,195,121,118,53,54,36,9,136,195,176,110,33,13,30,195,135,119,
    36,34,11,136,195,128,129,30,27,195,129,129,176,195,87,183,29,24,25,27,
    29,46,54,46,55,54,102,51,30,54,52,102,94,55,63,60,36,176,195,128,127,
    116,22,36,118,98,38,39,39,52,38,38,52,10,11,11,1,24,24,24,82,24,3,11,
    136,97,17,106,33,10,9,9,9,136,195,118,156,39,62,38,55,9,33,17,11,24,27,
    27,195,136,138,39,102,53,52,20,54,33,12,9,152,98,11,27,11,152,195,132,
    142,160,117,9,136,98,33,10,11,30,51,53,53,176,195,137,128,18,11,27,54,
    195,129,129,160,195,127,115,11,25,24,136,195,128,129,30,50,176,116,52,
    195,134,138,12,9,24,9,36,36,20,11,24,9,9,152,76,30,38,38,51,43,136,195,
    128,129,54,52,160,195,129,129,54,176,195,116,145,33,33,38,33,20,62,36,
    53,94,54,60,55,36,36,15,52,10,9,11,11,12,98,33,36,102,54,52,17,9,9,98,
    25,9,9,33,136,195,128,129,25,25,24,24,54,62,51,27,128,95,27,27,24,27,
    30,43,53,29,46,44,50,33,12,12,52,195,128,129,152,195,109,105,54,51,54,
    46,30,30,85,51,51,51,51,45,34,160,195,128,127,34,33,36,9,160,115,9,36,
    9,10,8,195,72,180,51,51,54,53,102,102,54,38,55,54,62,54,34,38,176,102,
    152,195,129,128,55,102,55,36,38,36,116,52,52,36,20,36,39,34,60,52,60,
    52,36,52,33,195,128,129,22,36,17,17,33,90,136,90,9,10,10,114,52,106,9,
    25,17,10,10,9,36,38,36,34,25,83,89,8,24,136,90,1,1,12,160,98,9,36,36,
    90,12,12,36,115,11,75,3,136,84,11,9,9,27,41,25,45,94,46,46,30,27,54,38,
    27,27,29,45,27,54,30,30,30,45,51,43,43,11,27,176,94,53,54,54,25,1,27,
    43,25,27,195,190,172,8,9,90,106,98,9,106,10,106,38,62,176,94,63,62,54,
    52,160,115,17,33,25,24,9,9,82,98,25,9,25,160,195,128,129,18,18,18,160,
    116,12,136,195,128,129,84,84,29,84,168,84,45,30,3,11,11,9,25,27,53,53,
    102,176,102,53,51,51,54,54,38,36,54,38,160,102,46,37,54,31,63,33,36,195,
    125,96,33,33,12,12,39,36,12,36,160,116,36,36,117,116,160,115,20,12,17,
    17,3,94,85,30,27,43,27,27,27,27,3,27,3,27,51,51,30,46,94,195,150,135,
    27,27,44,52,36,136,195,140,131,24,43,3,52,52,124,195,132,137,39,36,34,
    8,27,29,195,135,109,54,52,60,9,25,25,195,130,113,51,51,53,54,38,54,184,
    102,54,152,195,129,128,176,110,38,33,11,9,25,17,17,106,12,9,30,30,45,
    51,195,127,126,17,33,11,195,128,146,30,52,36,33,25,24,152,195,131,140,
    30,36,50,34,38,36,36,160,116,116,12,3,27,25,152,84,29,27,27,176,195,137,
    120,52,33,152,195,132,124,60,9,30,195,129,126,27,29,160,116,195,126,124,
    39,36,33,11,27,27,195,156,137,39,36,36,34,68,152,195,128,123,54,36,11,
    136,195,99,132,36,116,38,62,63,116,160,124,136,195,128,129,116,51,27,
    152,195,127,127,53,27,30,60,38,59,52,54,39,33,9,33,195,128,129,60,52,
    160,116,52,52,60,116,38,160,117,36,176,117,39,38,36,52,60,52,52,54,46,
    62,55,54,184,116,12,52,39,52,63,38,36,160,117,36,36,34,17,12,10,34,9,
    36,160,116,116,52,160,116,38,38,62,38,38,55,38,38,60,63,39,33,36,60,125,
    39,33,1,117,33,24,27,8,3,9,13,152,84,11,9,25,0,3,8,8,1,12,117,36,9,9,
    27,11,30,83,83,27,27,9,9,25,3,8,84,1,11,27,27,84,11,27,11,83,3,27,11,
    25,27,24,152,83,24,27,25,27,27,152,90,25,83,160,195,128,129,54,27,51,
    51,43,51,86,45,43,27,11,8,25,25,25,9,9,9,2,11,27,24,84,25,27,30,53,27,
    29,51,195,170,164,39,176,85,43,27,17,160,115,195,174,95,38,160,116,11,
    152,195,149,170,52,33,152,195,115,108,39,36,38,36,57,36,36,20,36,17,36,
    12,10,98,9,3,51,54,38,30,27,30,45,27,27,9,9,30,30,45,84,168,195,149,117,
    55,54,20,8,25,195,125,129,33,11,11,11,11,25,24,25,30,195,129,128,184,
    195,130,129,55,60,52,195,144,139,46,55,52,60,17,8,24,136,195,127,128,
    152,195,138,134,47,39,36,8,27,136,195,133,135,25,30,30,38,36,136,195,
    132,123,54,60,63,36,60,11,11,0,75,136,195,134,138,54,38,160,116,33,152,
    83,25,195,132,124,176,111,176,126,9,25,25,9,128,195,132,138,176,117,52,
    36,11,11,27,195,154,129,30,160,195,199,112,54,33,136,195,127,128,152,
    195,115,98,30,160,195,126,123,30,160,195,124,124,6,195,125,124,11,176,
    195,129,128,160,195,140,162,9,30,195,41,34,5,38,160,195,179,129,27,52,
    160,195,124,126,8,54,195,131,140,30,160,195,119,126,52,136,192,7,56,1,
    176,43,54,54,57,195,128,129,18,9,11,195,128,127,152,195,26,17,27,52,195,
    129,127,160,195,145,140,60,33,12,12,54,160,195,127,128,54,20,136,195,
    127,128,20,17,33,12,9,136,97,11,27,24,11,27,30,43,29,52,54,54,38,33,32,
    17,195,128,129,38,195,127,129,38,45,54,176,195,139,118,36,94,36,50,36,
    9,33,12,160,116,38,20,9,11,11,27,43,51,27,6,30,30,30,152,195,122,125,
    116,12,38,36,17,36,34,36,60,195,130,128,136,195,130,129,12,36,36,54,44,
    195,127,128,62,36,34,20,19,12,17,25,12,15,55,38,36,52,36,18,10,36,116,
    12,12,38,52,33,20,17,33,1,9,17,12,17,24,9,12,33,26,33,36,12,10,9,8,8,
    11,11,8,12,11,6,152,195,129,128,176,195,129,129,43,27,9,30,30,30,51,61,
    54,38,53,54,30,46,46,30,43,53,30,152,85,85,29,9,9,33,152,85,54,53,43,
    51,54,30,27,27,27,11,84,85,27,27,27,30,30,30,43,43,46,29,168,195,180,
    86,176,195,128,127,34,36,36,9,9,20,12,38,36,52,39,38,34,12,12,9,34,22,
    36,123,36,12,195,127,128,3,9,33,136,195,128,129,29,27,27,24,27,136,84,
    11,0,24,0,27,54,55,54,30,51,54,54,27,40,27,62,54,30,53,54,30,195,140,
    103,9,10,10,36,52,39,55,98,9,27,136,90,3,9,10,9,12,12,9,15,36,36,52,52,
    52,52,176,195,128,127,9,11,8,0,8,11,9,90,9,6,25,195,129,128,11,9,17,17,
    9,11,11,11,18,3,27,31,54,43,30,54,46,51,54,54,38,30,39,62,102,102,54,
    53,176,102,152,110,31,54,54,46,62,46,54,54,195,62,216,52,136,195,130,
    129,12,9,168,195,136,110,34,152,195,133,114,30,57,33,195,155,22,85,11,
    29,38,36,195,129,127,160,195,120,128,36,11,27,176,195,208,104,30,160,
    195,161,126,57,195,127,128,152,195,128,129,160,195,182,150,54,36,52,39,
    9,24,27,195,136,130,38,36,195,127,128,136,195,104,107,20,12,36,12,12,
    5,27,51,195,127,130,152,195,184,162,27,27,30,36,115,195,128,131,60,32,
    152,195,162,131,33,152,195,124,131,52,136,195,125,125,52,136,195,126,
    129,51,195,126,127,11,176,195,128,127,29,160,195,120,125,152,192,7,59,
    1,7,34,33,20,33,27,43,51,168,195,136,125,33,33,36,10,52,12,33,36,33,152,
    195,126,129,25,30,152,195,128,129,27,30,30,30,195,144,121,33,36,12,9,
    43,51,168,195,138,123,36,12,11,195,128,129,152,195,141,119,11,176,195,
    133,125,9,30,30,160,195,126,125,57,195,134,127,20,20,9,160,195,127,128,
    43,51,27,52,195,134,125,36,8,51,152,195,124,128,160,195,127,128,152,192,
    0,12,0,140,36,36,34,36,160,195,136,96,11,27,52,160,192,7,249,0,107,160,
    124,36,192,0,0,0,107,100,160,116,36,160,116,36,12,3,27,43,27,84,152,192,
    7,255,0,106,100,27,27,152,195,69,138,36,12,36,33,152,84,27,27,27,152,
    195,129,129,36,176,195,136,126,36,195,77,130,27,152,195,130,129,160,195,
    124,119,51,116,160,195,116,94,59,152,195,123,125,27,51,195,129,128,36,
    195,80,130,116,33,27,195,61,158,36,36,195,140,118,36,20,36,36,160,116,
    36,36,33,27,11,27,27,83,43,30,27,195,129,129,27,195,129,126,11,11,27,
    152,195,129,128,176,117,160,195,97,126,52,52,33,25,152,195,168,122,27,
    30,36,160,195,92,123,30,51,195,129,128,52,12,11,195,144,125,30,27,27,
    51,30,27,52,51,152,195,129,128,52,38,36,52,36,39,36,36,36,36,12,9,27,
    25,36,36,18,27,152,83,27,24,27,152,195,141,127,60,38,36,116,38,38,27,
    52,176,116,36,160,116,34,36,8,27,27,27,128,84,195,123,128,136,195,126,
    128,128,195,151,132,38,27,176,116,36,39,36,36,38,124,36,36,36,36,20,19,
    27,11,84,27,84,27,152,195,129,128,11,43,27,27,27,128,195,20,147,52,19,
    195,114,119,144,194,123,129,195,134,127,36,195,61,124,27,27,27,30,36,
    36,160,195,89,106,36,195,129,128,52,160,116,36,33,27,27,27,195,115,123,
    27,30,27,27,11,11,0,27,30,27,30,27,51,51,152,195,129,128,59,46,30,27,
    51,52,36,33,36,36,36,15,20,36,36,36,36,36,36,20,36,36,33,11,11,27,128,
    192,5,168,1,1,152,195,129,128,0,106,9,12,12,10,52,12,116,58,58,184,116,
    36,116,36,60,33,36,17,27,27,30,27,27,84,25,84,27,84,76,24,30,27,43,46,
    40,54,46,60,63,52,195,140,142,39,36,160,116,20,36,33,26,5,27,27,168,84,
    152,76,195,163,113,39,38,195,127,127,27,195,128,127,136,195,118,121,38,
    39,38,38,39,98,8,27,3,195,146,120,24,27,3,30,39,39,36,160,195,91,89,12,
    33,152,84,43,51,27,52,36,36,36,36,3,195,138,137,51,62,17,195,204,142,
    24,27,27,195,129,128,44,52,57,33,195,188,114,33,4,128,98,152,98,128,98,
    33,9,90,11,17,25,27,27,27,41,195,128,129,53,47,17,39,57,9,115,54,62,54,
    102,54,62,54,38,55,176,195,137,134,43,152,84,27,52,52,36,116,38,36,115,
    34,20,12,10,38,18,34,116,33,115,34,9,4,195,128,129,34,10,10,9,17,9,33,
    11,27,30,46,45,51,176,86,46,29,29,29,30,30,37,43,30,27,46,30,29,192,7,
    11,0,224,3,29,52,20,195,126,132,152,84,30,31,116,20,195,102,155,54,58,
    17,33,25,30,27,192,7,143,0,201,33,27,176,195,110,146,36,12,8,30,44,192,
    6,168,1,70,11,9,11,46,57,195,129,129,176,195,126,129,11,9,168,195,129,
    129,176,195,127,124,11,11,51,51,51,52,20,144,192,7,66,0,116,51,152,195,
    130,128,33,195,148,136,30,36,33,152,192,7,225,0,151,3,27,27,44,39,36,
    144,192,7,77,0,117,27,152,192,6,72,0,122,51,52,195,128,127,160,195,38,
    153,27,51,46,36,12,144,195,205,66,38,52,38,36,36,51,27,84,27,27,84,27,
    3,195,129,128,160,116,36,9,36,195,152,111,3,27,43,27,27,27,51,29,30,27,
    44,43,152,195,130,128,43,84,85,27,27,3,30,152,116,60,184,116,160,116,
    38,160,195,127,128,27,195,129,128,52,38,30,27,152,195,129,128,11,128,
    194,132,128,195,126,130,194,117,124,27,27,27,24,84,195,130,128,51,27,
    11,27,152,68,27,27,84,27,27,27,195,129,128,176,116,36,195,125,128,85,
    27,152,76,84,84,27,168,84,27,85,27,27,29,27,27,27,30,152,84,152,76,51,
    27,152,195,129,128,51,30,30,36,54,59,27,27,152,77,27,84,84,152,84,152,
    84,77,152,84,27,51,52,38,46,60,36,116,184,116,38,36,39,36,36,54,30,30,
    30,62,55,27,9,25,24,27,30,38,30,3,10,20,33,34,33,27,152,84,30,24,27,3,
    25,27,3,27,27,25,27,152,84,51,168,84,11,11,51,51,27,11,11,3,9,12,128,
    195,128,129,27,29,76,27,152,195,134,128,52,60,63,52,61,25,27,27,27,18,
    152,195,129,128,11,11,11,31,184,195,129,129,29,152,84,30,27,27,51,51,
    52,52,117,38,38,30,46,176,77,195,129,128,136,195,129,126,176,195,127,
    130,52,55,52,20,36,36,33,60,116,36,136,116,36,36,38,38,38,38,54,37,160,
    195,127,128,54,54,52,36,60,37,152,195,129,128,160,116,33,36,38,36,160,
    195,129,128,29,27,43,51,54,160,117,36,52,160,117,36,36,63,52,60,160,117,
    195,127,128,27,27,11,27,0,27,3,3,27,27,3,27,25,25,25,27,13,27,30,54,54,
    38,54,30,25,8,11,0,27,11,27,9,12,12,12,20,9,33,11,195,129,128,9,4,20,
    11,40,25,27,27,27,29,27,27,52,60,54,59,27,30,30,43,51,43,29,27,44,52,
    36,51,62,59,27,11,25,84,0,24,27,152,84,27,27,27,25,24,27,12,116,194,132,
    128,36,36,36,36,36,20,12,115,20,20,9,27,144,115,11,27,3,8,9,10,9,33,9,
    25,83,27,11,9,33,33,34,12,12,19,27,3,27,27,27,152,84,27,3,51,30,30,30,
    54,30,30,27,176,76,30,27,54,30,38,54,51,51,54,33,39,38,38,39,36,36,38,
    44,53,46,25,25,27,11,3,3,27,24,152,84,3,27,43,25,26,32,27,24,27,152,84,
    27,27,83,27,27,29,29,38,38,39,51,30,27,27,53,84,27,10,33,27,26,194,123,
    129,43,27,30,27,152,84,152,76,27,51,43,6,29,27,176,84,152,77,29,27,168,
    84,4,12,34,160,116,10,20,33,36,11,195,129,128,12,195,127,128,5,27,29,
    152,195,129,128,53,51,136,195,129,128,11,27,27,27,43,27,43,152,85,84,
    43,30,27,27,54,94,27,84,152,85,84,11,25,27,11,152,83,9,36,160,116,12,
    8,25,27,27,84,152,83,84,152,195,129,128,60,52,46,53,51,60,39,54,30,30,
    51,27,25,27,27,27,11,30,27,51,27,152,85,27,85,85,31,52,60,110,160,117,
    60,36,102,51,9,27,27,11,27,11,27,27,128,84,152,84,11,24,27,152,84,31,
    27,31,38,36,60,20,52,38,51,27,51,27,11,27,84,26,27,25,27,27,24,12,195,
    127,128,16,98,12,9,3,27,25,27,76,195,130,128,11,25,25,24,25,152,195,129,
    128,36,60,60,36,160,117,39,36,36,116,184,116,36,116,36,39,36,160,116,
    116,36,20,116,36,34,33,33,115,33,9,27,11,6,24,24,27,3,3,27,83,83,24,27,
    25,27,152,83,84,84,27,152,76,27,27,195,129,128,43,51,27,51,27,152,195,
    129,128,115,195,129,128,136,116,12,12,195,127,128,27,84,27,25,27,195,
    129,128,116,36,19,25,27,27,30,27,27,24,30,27,27,27,26,27,3,152,195,130,
    128,36,36,36,34,36,116,144,84,84,84,24,84,27,11,27,176,85,25,152,85,12,
    195,129,128,128,116,12,195,127,128,24,84,44,51,29,43,26,26,33,27,51,152,
    86,27,51,51,27,10,34,34,115,27,27,27,5,27,52,160,195,127,128,168,84,29,
    30,52,43,11,84,152,115,27,24,27,43,84,152,195,131,128,117,195,127,128,
    59,3,30,27,27,53,27,12,12,195,127,128,27,30,160,195,127,127,30,152,195,
    129,128,55,36,51,24,24,27,195,129,128,52,84,27,136,195,128,129,51,27,
    51,52,195,127,128,51,27,30,36,160,195,127,128,51,195,127,127,27,52,52,
    195,127,128,51,25,11,11,51,30,36,38,27,27,27,27,52,36,195,131,127,60,
    195,127,128,27,51,27,152,195,129,128,52,36,59,152,84,84,27,29,51,27,52,
    160,195,126,128,30,36,59,27,30,37,30,30,27,52,52,160,195,127,128,51,25,
    43,29,30,195,129,127,36,43,195,127,128,51,27,51,85,30,38,27,84,54,29,
    152,84,152,195,129,128,51,30,24,55,160,195,127,128,27,1,27,51,27,60,38,
    195,128,127,36,59,29,3,27,30,36,39,30,25,27,27,51,136,84,27,54,116,36,
    116,38,27,195,123,127,44,38,152,195,129,128,51,52,160,116,36,36,34,22,
    160,195,127,128,52,160,195,127,128,51,84,76,84,152,84,27,60,195,127,128,
    52,52,33,195,128,129,43,195,129,128,52,34,20,36,38,27,51,11,46,152,195,
    129,128,51,30,27,46,33,36,36,38,160,195,127,128,30,36,43,27,152,195,129,
    128,55,39,52,38,36,36,36,33,36,20,20,12,34,15,12,36,34,36,36,54,63,152,
    195,129,128,54,38,38,55,62,38,55,62,51,176,117,54,52,116,160,116,116,
    33,36,9,17,36,52,12,33,105,18,9,33,33,2,12,34,36,12,136,98,12,20,17,3,
    3,11,3,8,9,1,38,195,128,127,10,4,12,12,9,152,195,129,128,58,33,33,36,
    33,36,34,36,33,195,128,129,34,33,115,17,25,25,160,195,127,128,20,32,12,
    160,115,36,32,12,58,60,36,160,116,36,38,36,36,55,52,51,51,27,27,30,30,
    29,43,30,27,51,43,30,51,27,30,30,27,52,44,54,55,38,51,52,51,54,63,36,
    52,36,33,38,60,195,127,128,52,34,36,52,36,195,127,128,12,33,36,36,20,
    36,36,124,34,36,36,36,38,60,38,36,36,51,27,27,152,84,27,51,51,51,27,27,
    84,27,25,27,51,24,27,51,27,30,27,51,102,52,52,36,52,46,55,51,51,29,27,
    11,0,24,27,51,27,43,51,54,46,176,102,55,54,102,168,84,3,85,52,51,30,29,
    3,27,25,25,27,75,48,51,27,51,84,85,27,30,84,51,51,27,84,25,27,11,3,51,
    27,27,29,27,27,4,12,195,127,128,136,195,128,129,3,3,25,27,12,12,160,124,
    10,3,27,46,27,12,12,12,12,12,136,195,128,129,36,9,27,25,26,11,12,17,12,
    136,195,127,129,27,51,27,84,27,85,53,52,115,36,36,38,27,30,51,27,84,43,
    52,54,52,52,38,38,54,51,54,38,52,39,27,195,127,127,27,54,102,160,195,
    127,128,25,194,121,128,195,129,128,76,84,3,30,29,27,51,51,30,43,51,46,
    55,52,195,127,128,27,29,27,53,27,24,27,51,46,53,51,30,195,128,127,27,
    43,30,39,27,85,27,24,51,25,9,43,27,52,54,52,52,38,152,85,24,29,27,27,
    11,3,43,27,84,27,55,36,195,126,128,52,36,52,38,33,38,36,36,38,38,52,38,
    62,39,39,38,63,176,110,52,176,195,127,127,0,53,54,51,54,30,54,51,27,27,
    27,25,30,27,27,84,76,152,84,24,27,27,136,195,128,129,27,27,27,84,3,51,
    27,31,27,51,85,55,52,52,51,54,52,51,62,102,54,30,53,54,53,54,23,30,36,
    15,195,127,128,54,54,30,38,54,46,176,195,128,127,36,12,60,36,12,36,36,
    36,38,194,129,132,39,116,33,34,20,34,36,36,34,36,36,36,52,10,106,33,36,
    33,10,20,12,34,8,25,25,10,10,12,17,36,9,33,36,33,36,36,12,123,10,9,12,
    195,127,128,9,9,160,122,36,36,39,36,38,36,38,36,34,33,20,34,20,34,36,
    12,36,36,39,39,39,52,54,59,55,22,39,39,38,39,52,52,60,60,39,38,39,38,
    39,39,63,36,55,60,54,52,43,30,54,58,10,17,36,15,19,9,136,84,25,9,115,
    33,39,39,63,17,8,27,11,3,3,11,24,83,26,25,84,83,24,84,11,11,90,25,9,25,
    27,11,3,11,1,17,0,17,160,116,20,12,38,38,54,54,34,17,36,62,38,54,160,
    102,39,63,116,38,36,39,60,38,152,195,129,128,60,60,57,63,39,52,176,102,
    54,37,54,38,59,195,129,128,52,52,52,63,60,54,38,38,160,117,34,36,38,38,
    31,27,11,27,195,126,127,29,62,38,52,52,54,195,128,127,36,62,57,15,57,
    90,1,38,39,160,195,127,128,12,11,11,12,38,36,33,9,11,3,3,11,25,32,12,
    16,33,12,195,127,128,11,11,10,52,38,195,128,127,184,116,60,52,12,3,9,
    160,98,36,33,38,116,39,36,52,54,36,12,17,34,36,117,36,36,9,11,24,25,9,
    25,3,12,12,10,20,10,9,17,10,12,52,17,136,106,12,52,33,33,33,9,20,12,36,
    38,34,39,38,27,52,36,36,36,36,36,12,38,36,33,34,38,195,128,127,36,36,
    22,20,52,20,20,20,160,115,36,36,51,51,43,51,27,25,47,36,38,38,30,51,11,
    29,54,51,25,29,152,195,129,128,160,195,129,128,63,36,184,116,60,176,116,
    60,184,117,184,117,38,39,36,55,39,176,102,53,51,43,51,84,51,27,27,41,
    27,27,152,84,152,84,13,27,11,27,83,24,11,27,27,1,27,27,84,27,40,85,27,
    29,29,29,29,27,152,84,76,27,27,152,195,127,129,39,38,27,27,51,27,25,30,
    27,168,84,195,127,128,45,51,63,22,160,195,127,128,52,51,60,52,52,195,
    127,128,27,3,52,51,152,195,129,128,52,22,38,38,54,38,38,31,144,116,38,
    30,160,116,63,39,36,116,36,34,9,36,60,36,39,39,36,52,36,160,116,115,36,
    33,33,36,36,33,36,54,30,54,54,54,54,54,46,46,27,59,195,129,128,46,54,
    94,46,46,46,30,29,27,27,27,27,152,84,3,27,27,27,27,52,192,6,41,0,54,30,
    84,29,152,84,43,27,44,38,36,52,36,54,52,36,160,116,160,116,12,36,60,12,
    36,83,26,123,36,36,20,8,27,11,27,27,27,152,195,129,128,11,27,27,27,195,
    127,127,24,33,116,19,25,27,27,84,27,84,29,27,84,168,84,51,52,52,63,160,
    117,195,130,128,144,116,195,129,128,144,116,195,129,128,144,192,5,113,
    0,48,27,27,29,30,84,195,129,128,60,36,160,123,36,12,36,11,27,152,195,
    153,141,152,195,86,117,30,27,27,27,27,27,44,52,36,116,36,117,36,12,4,
    116,36,19,27,27,136,195,112,127,160,116,116,36,51,27,152,195,131,128,
    116,36,20,195,127,128,27,84,195,103,128,52,195,127,128,27,84,84,27,195,
    132,128,60,36,160,116,34,36,51,195,129,128,36,160,116,116,11,27,27,84,
    195,127,128,3,27,84,195,138,132,152,195,129,128,51,52,33,36,36,36,195,
    127,128,83,27,152,195,73,131,20,116,123,116,36,33,152,195,129,128,36,
    36,36,36,11,27,152,84,27,27,27,27,27,152,84,76,27,27,152,195,129,128,
    52,36,160,195,126,128,51,152,195,130,128,36,36,195,129,129,152,195,128,
    129,160,195,131,123,27,27,24,27,84,84,152,84,27,30,27,84,27,27,84,43,
    27,152,84,85,195,129,128,160,124,160,116,36,36,36,36,38,36,12,36,11,152,
    195,130,128,116,20,36,116,160,192,4,131,0,52,51,152,195,129,128,51,27,
    27,27,84,84,3,27,5,27,27,30,160,195,127,128,27,27,27,176,116,116,36,195,
    125,128,52,36,60,36,36,116,36,36,195,125,128,44,36,36,160,117,116,36,
    36,36,36,36,160,116,160,116,36,36,33,36,20,36,36,34,36,33,32,152,84,84,
    84,152,76,27,67,27,27,43,11,27,3,195,124,140,3,27,27,27,43,27,52,195,
    127,128,52,116,144,116,36,36,144,195,130,129,30,152,76,27,27,195,125,
    128,52,116,51,51,30,116,33,36,36,160,116,37,30,160,116,144,116,34,36,
    20,36,36,195,126,128,3,27,68,27,195,129,128,12,11,152,192,5,144,0,95,
    36,36,36,11,27,27,152,195,119,108,24,77,27,152,84,152,85,152,85,84,152,
    85,27,27,152,84,24,27,43,76,30,195,128,127,27,30,152,194,122,129,168,
    84,27,43,27,30,27,30,152,85,27,27,41,84,43,195,129,128,36,195,127,128,
    52,38,160,195,127,128,27,27,30,160,195,127,128,27,60,195,127,128,27,52,
    36,160,195,124,128,84,51,152,84,168,116,36,44,51,195,129,128,116,36,36,
    36,39,36,33,36,19,25,36,38,33,33,195,128,129,18,36,195,127,128,20,33,
    36,160,195,127,128,11,152,195,130,128,160,195,127,128,12,39,36,33,27,
    12,160,195,128,129,36,20,36,36,20,36,12,36,12,116,116,36,160,116,116,
    144,116,36,160,194,132,128,115,36,34,160,116,33,36,11,12,8,195,34,151,
    60,36,195,127,128,51,30,30,27,54,30,160,116,36,39,38,36,46,152,195,129,
    128,36,36,60,36,38,36,144,116,52,116,36,36,36,160,195,125,128,136,194,
    132,128,195,127,128,3,24,66,24,25,4,9,33,20,195,127,128,12,32,36,195,
    127,127,152,84,27,27,27,27,27,27,29,27,43,152,195,163,142,38,60,60,36,
    39,160,195,129,128,12,3,24,84,83,27,195,72,132,30,84,43,54,39,36,34,34,
    8,27,195,157,63,36,36,38,36,116,39,36,160,195,127,128,11,152,195,124,
    127,84,192,4,134,0,107,43,43,152,84,24,36,36,33,160,195,129,129,12,195,
    81,138,38,30,36,36,38,20,12,59,51,152,195,126,129,27,11,51,136,195,128,
    127,27,27,20,33,195,109,206,33,36,9,117,195,127,128,176,195,127,128,61,
    59,51,51,25,27,128,98,12,115,195,129,129,152,195,138,135,39,43,24,33,
    195,150,112,51,45,46,30,36,12,12,9,160,195,137,123,29,30,54,52,12,12,
    98,33,195,150,121,27,52,59,46,27,52,195,127,128,52,50,20,33,34,27,152,
    195,128,127,33,33,152,195,62,152,38,38,20,33,38,43,176,195,128,127,152,
    195,126,127,152,195,19,33,27,43,84,85,195,129,128,36,160,195,129,127,
    36,34,195,132,182,52,57,11,195,161,134,27,60,51,195,129,128,54,195,128,
    127,34,11,136,195,96,140,51,27,59,30,160,195,127,128,60,12,52,10,9,195,
    127,133,51,30,39,38,33,160,195,127,128,8,136,195,127,135,52,36,11,152,
    195,135,116,30,38,27,51,59,30,46,38,53,51,195,129,129,36,33,38,160,195,
    127,128,45,102,30,54,33,33,12,11,195,129,128,33,38,51,52,54,43,30,39,
    52,9,60,36,160,116,36,46,63,36,195,127,128,54,53,27,43,27,25,29,38,38,
    27,52,52,62,84,43,27,51,52,36,116,116,51,195,129,128,36,38,160,115,160,
    115,53,30,27,27,27,84,51,195,129,128,53,29,152,85,27,52,38,33,34,36,20,
    184,195,129,128,57,33,33,36,36,60,36,33,36,36,34,176,116,36,36,33,116,
    33,33,11,84,27,20,9,33,116,33,33,9,11,27,27,27,51,11,152,195,129,128,
    12,36,11,11,9,11,176,195,128,127,25,9,27,11,24,83,8,8,3,25,27,152,84,
    27,4,36,18,36,33,33,12,9,33,160,195,127,128,11,27,84,27,84,43,27,51,26,
    25,36,34,152,195,126,129,136,116,20,20,17,11,51,27,27,48,51,83,48,195,
    137,125,60,39,9,27,152,195,11,85,38,36,160,195,126,128,60,36,53,11,195,
    127,127,51,3,11,51,31,38,160,195,127,128,51,3,31,27,27,52,36,116,160,
    116,36,36,33,38,36,43,31,36,160,195,127,128,43,27,27,27,27,27,30,116,
    36,36,160,116,38,36,36,46,115,36,195,127,128,51,195,126,128,43,30,27,
    152,195,129,128,60,36,20,160,117,20,60,36,195,126,128,52,116,160,116,
    36,52,36,36,144,116,10,38,20,50,36,36,33,36,12,34,36,52,20,12,4,36,12,
    195,127,128,136,195,129,129,12,160,195,126,128,11,12,33,27,27,3,25,160,
    195,127,128,25,26,160,195,127,128,27,27,136,116,195,126,128,27,27,31,
    29,27,30,27,152,83,152,195,129,128,176,195,129,128,51,0,27,30,27,51,24,
    27,11,30,52,51,27,51,51,51,8,19,25,195,129,129,12,11,11,11,24,27,27,152,
    195,212,194,52,54,29,59,27,30,25,24,51,27,195,129,128,54,46,52,39,36,
    36,43,94,29,152,195,129,128,53,52,38,52,52,12,58,34,36,36,20,33,36,36,
    36,19,9,17,9,19,8,12,12,20,11,25,152,195,129,128,11,11,24,51,27,84,27,
    25,30,152,192,4,96,0,115,59,195,129,128,51,195,129,128,36,195,129,128,
    12,19,136,84,30,152,195,124,129,27,29,152,195,129,128,36,160,195,141,
    124,51,27,195,129,129,160,195,129,127,34,152,195,100,219,38,160,195,129,
    129,136,195,54,211,46,152,195,129,128,33,195,137,123,30,27,55,36,20,11,
    152,195,133,126,51,195,129,128,36,128,195,127,128,152,195,160,111,54,
    27,29,53,52,52,54,39,33,9,12,9,9,136,195,126,138,29,168,84,31,52,54,47,
    54,55,38,17,36,52,9,136,106,9,152,195,129,128,10,1,25,152,195,145,145,
    38,38,38,116,52,60,50,52,38,39,39,12,9,8,12,9,36,9,27,27,27,43,27,27,
    11,43,6,195,137,89,52,136,195,157,159,38,38,16,195,149,152,39,36,36,52,
    36,116,116,36,11,27,11,152,76,27,27,3,195,152,123,45,60,12,9,136,195,
    109,108,62,36,9,30,195,127,128,136,195,178,93,54,27,176,84,85,30,36,38,
    117,36,53,30,38,36,20,20,34,34,33,36,184,115,12,11,77,27,27,25,25,25,
    3,152,195,122,190,30,27,51,54,36,36,20,36,8,11,152,192,4,94,0,55,51,31,
    27,195,129,128,62,38,36,39,38,27,11,27,195,128,127,27,51,27,12,19,128,
    84,11,27,29,27,40,27,84,27,12,36,36,160,195,124,128,11,195,127,129,27,
    27,27,51,46,36,52,12,33,38,160,195,127,128,51,195,129,128,36,195,127,
    128,51,195,127,127,30,38,38,36,59,195,129,128,36,60,36,36,33,36,33,25,
    152,195,129,128,36,36,52,36,33,36,36,195,127,128,59,29,160,116,38,27,
    27,27,27,27,43,27,27,27,63,34,36,36,36,36,36,37,27,27,27,31,36,160,195,
    126,128,84,152,84,27,195,129,128,44,36,52,39,36,116,195,127,128,44,38,
    36,60,36,12,12,12,12,12,12,33,12,34,33,36,20,34,160,195,130,128,20,195,
    129,128,176,116,195,131,127,11,84,27,3,27,75,27,24,3,27,29,4,195,129,
    128,19,27,3,30,3,83,195,94,135,36,36,52,195,127,128,54,36,52,36,59,27,
    195,127,127,27,3,25,26,152,192,5,103,0,239,27,52,52,33,17,27,195,128,
    129,160,195,121,134,51,45,43,54,30,62,52,52,54,85,45,51,44,54,27,51,27,
    25,27,27,9,30,27,51,10,90,97,98,106,17,20,160,195,127,128,52,33,9,36,
    116,33,24,36,36,12,54,116,17,116,160,195,129,128,136,195,76,170,12,36,
    60,36,195,126,128,85,195,129,128,52,51,30,36,110,110,54,54,52,195,127,
    128,54,51,53,76,27,76,152,84,152,84,83,27,83,11,11,27,27,8,9,1,9,9,12,
    52,106,97,98,160,123,3,3,136,81,90,25,3,1,82,1,11,9,9,25,83,1,160,98,
    105,33,10,160,110,34,34,33,33,34,160,116,115,123,34,36,36,36,39,160,116,
    39,38,54,53,52,195,127,128,54,51,43,3,24,27,43,176,102,55,27,27,27,30,
    52,160,117,176,110,110,36,52,39,36,36,51,53,47,62,38,195,128,127,9,34,
    36,39,63,62,37,51,51,29,3,30,195,128,127,25,46,46,54,195,86,142,33,17,
    9,152,195,127,128,30,102,184,195,111,122,184,195,129,128,36,136,115,13,
    152,195,127,128,27,176,195,141,65,52,20,12,136,120,34,11,136,106,12,160,
    115,36,20,136,85,84,27,85,27,51,54,54,46,51,54,30,30,168,195,153,106,
    9,26,13,25,25,9,33,136,114,136,84,53,54,30,51,55,54,52,38,160,195,65,
    95,52,52,38,38,160,195,127,128,51,27,9,27,4,32,195,138,125,11,24,15,160,
    195,129,129,38,195,118,124,27,84,152,195,129,128,12,36,195,134,127,1,
    36,51,195,128,124,4,195,117,123,51,9,160,195,96,151,36,51,40,152,195,
    113,131,27,24,136,82,8,36,36,54,30,38,39,160,195,163,94,38,39,36,51,152,
    195,128,127,27,25,128,195,127,129,54,27,48,25,36,144,195,132,132,52,39,
    36,184,102,62,39,52,94,168,84,27,195,129,128,9,3,24,24,4,33,25,33,15,
    60,52,160,195,129,128,1,27,195,128,127,27,195,127,127,152,195,129,128,
    128,195,108,146,11,11,8,9,25,27,10,33,36,160,115,39,60,117,60,62,43,45,
    29,30,27,195,110,119,3,12,195,128,129,36,20,36,12,32,152,195,128,129,
    27,3,26,195,129,129,20,176,195,130,128,12,12,33,38,51,47,51,29,85,27,
    52,116,195,127,128,43,27,195,129,128,3,27,25,12,52,160,195,136,121,115,
    195,128,129,116,12,36,11,11,11,84,3,11,51,195,130,128,55,36,184,195,129,
    127,176,195,127,129,25,27,51,195,124,127,36,54,51,27,24,40,3,11,8,9,62,
    195,128,129,160,195,128,129,36,36,52,39,33,195,123,119,176,84,51,11,27,
    12,116,160,116,195,115,135,38,36,51,54,54,53,30,44,37,39,48,30,27,12,
    11,9,17,20,9,9,195,128,127,27,195,129,127,194,112,139,195,130,127,36,
    106,195,129,127,38,46,152,195,127,128,176,76,195,160,81,176,195,128,127,
    168,195,129,128,51,30,27,43,27,11,116,12,36,20,12,195,156,137,52,51,176,
    84,152,84,84,26,195,130,129,20,33,33,195,118,139,8,27,54,36,195,133,134,
    27,11,27,51,27,11,27,52,38,160,116,195,129,127,36,195,131,128,160,195,
    15,165,25,33,10,20,36,15,20,38,46,43,51,27,85,195,137,130,9,33,20,12,
    59,53,51,168,195,146,119,54,84,27,3,152,195,129,128,136,116,39,160,195,
    126,88,39,160,124,52,195,127,128,152,195,129,128,52,52,176,83,24,25,152,
    195,86,144,12,34,36,12,12,36,195,127,128,176,84,54,27,29,152,192,3,9,
    0,169,152,195,129,128,4,3,26,160,195,128,129,33,12,11,136,116,12,33,152,
    195,129,128,19,195,129,128,12,11,11,27,12,32,152,195,129,128,20,116,34,
    27,25,160,195,130,129,11,11,195,129,128,136,195,128,129,36,33,36,160,
    195,126,128,12,33,25,160,195,127,128,11,136,195,129,129,12,116,19,11,
    11,27,25,152,195,129,128,36,36,36,36,8,33,36,36,20,36,36,160,195,127,
    128,136,115,11,195,129,128,33,195,128,129,160,116,195,127,128,51,52,36,
    36,36,36,33,12,136,116,34,33,36,12,33,34,116,12,20,33,36,33,12,36,39,
    36,36,116,33,36,33,60,12,33,36,36,36,115,36,34,38,195,128,127,36,116,
    12,32,25,36,36,36,33,152,195,129,128,36,11,195,129,128,36,12,52,12,36,
    20,195,127,128,152,76,3,27,152,84,25,84,27,168,84,43,24,27,51,27,27,27,
    195,131,128,136,116,160,195,131,128,33,27,152,84,152,85,3,29,27,30,25,
    152,195,129,128,12,36,160,195,129,128,11,116,33,33,195,127,129,25,160,
    195,129,128,33,3,136,195,129,129,36,12,19,27,84,12,36,36,39,36,36,39,
    36,36,57,36,51,52,38,38,60,160,117,36,33,10,52,54,36,36,8,17,33,11,27,
    29,43,9,160,116,17,30,27,27,11,3,67,27,3,43,27,43,8,36,36,36,195,129,
    128,9,136,85,27,43,27,27,25,27,195,130,128,116,36,36,195,129,128,20,33,
    27,27,3,27,27,27,30,24,160,195,131,128,11,152,195,129,128,116,36,160,
    195,130,129,115,36,116,12,38,195,128,127,12,36,36,60,160,116,160,195,
    124,128,76,195,129,128,60,36,36,117,36,116,144,116,116,33,33,195,127,
    129,24,75,30,51,11,25,27,27,84,195,129,128,20,36,20,160,195,127,128,23,
    36,194,132,128,36,39,36,34,25,27,24,27,51,25,32,11,27,195,131,128,3,27,
    11,27,27,152,195,131,128,12,195,130,129,160,195,130,129,36,36,160,117,
    12,33,3,26,25,27,27,27,27,27,27,195,139,128,12,195,127,128,152,84,25,
    30,27,11,11,12,36,195,127,128,3,195,129,128,124,195,124,128,194,133,127,
    160,195,126,128,84,84,27,195,136,128,38,160,116,160,116,36,60,33,12,11,
    27,3,51,25,27,152,84,27,195,129,128,12,195,127,128,12,39,12,39,36,19,
    24,84,27,27,27,25,43,27,83,36,4,33,12,12,20,36,34,116,116,195,127,128,
    11,25,160,195,127,128,11,25,27,136,116,195,126,128,12,36,34,36,39,36,
    124,36,160,116,36,33,36,36,12,195,127,128,152,84,27,27,152,84,27,195,
    129,128,20,36,36,36,36,36,36,36,160,116,36,11,27,20,160,195,128,129,36,
    34,36,36,116,20,116,11,84,3,27,27,76,128,84,152,84,152,84,27,27,29,27,
    152,84,27,27,152,84,27,27,27,27,51,76,176,195,128,127,168,84,85,84,27,
    27,168,84,27,43,27,85,84,27,30,30,27,152,84,27,152,195,131,128,11,195,
    129,128,12,20,36,36,34,36,12,33,36,36,20,36,36,36,123,36,12,3,152,83,
    152,84,43,84,27,30,27,27,76,168,195,129,127,85,84,27,27,27,152,84,25,
    36,116,160,116,36,36,36,11,27,152,84,27,27,128,84,27,30,27,27,27,27,27,
    27,152,84,27,27,51,27,27,168,76,27,27,4,144,116,36,124,160,116,160,195,
    132,128,20,36,36,116,36,160,116,160,194,134,128,116,36,194,132,128,36,
    115,125,123,36,116,124,116,36,160,116,36,12,116,160,116,33,152,84,3,27,
    68,27,27,27,11,27,29,27,27,20,160,195,126,128,11,24,84,168,76,76,84,84,
    84,76,76,68,76,27,20,116,160,116,116,36,160,123,36,36,124,36,195,121,
    128,3,69,27,27,84,27,27,3,27,27,27,27,27,27,27,84,27,152,84,27,152,195,
    129,128,52,195,127,128,27,3,30,3,27,84,27,27,195,129,128,52,117,195,127,
    128,27,27,24,160,195,127,128,27,84,27,27,27,27,60,36,195,125,128,43,3,
    27,27,27,11,27,43,27,84,27,195,129,128,60,116,116,124,36,160,117,36,36,
    52,195,127,128,27,195,125,127,27,152,195,130,128,59,84,3,27,27,152,83,
    27,76,84,84,84,76,76,84,68,27,195,136,128,60,195,127,128,84,27,152,84,
    84,195,128,127,84,30,36,195,127,128,117,36,36,36,36,36,36,36,160,116,
    36,36,36,51,27,84,83,195,123,128,43,27,152,195,126,127,43,152,195,130,
    128,36,195,127,128,176,195,127,128,128,84,27,27,152,84,27,152,195,132,
    128,60,195,127,128,27,27,27,27,27,27,27,27,27,152,195,131,128,52,36,51,
    152,195,130,128,51,48,152,76,27,27,44,195,127,128,52,51,27,11,195,129,
    128,3,195,129,128,3,27,9,27,27,27,27,27,30,27,27,27,27,76,84,152,84,43,
    27,84,27,195,130,128,52,36,52,195,127,128,51,27,24,160,195,127,128,11,
    27,84,84,27,29,38,60,38,160,195,127,128,30,195,128,127,27,27,27,27,27,
    27,27,195,130,128,60,160,195,126,128,27,24,27,27,30,27,30,27,30,152,84,
    152,85,30,152,116,36,36,38,124,116,62,38,38,27,27,30,27,27,30,27,27,3,
    43,27,27,27,29,27,76,27,30,27,27,27,30,27,152,195,129,128,51,30,36,36,
    52,36,116,36,36,36,36,36,195,127,128,44,160,116,195,125,128,176,116,36,
    36,12,60,36,160,115,36,116,36,195,127,128,52,195,127,128,27,195,129,128,
    52,36,160,195,125,128,84,152,84,27,27,152,76,152,195,129,128,52,194,132,
    128,36,36,36,36,36,195,113,128,27,27,27,27,27,27,29,36,116,59,195,129,
    128,36,160,124,116,195,124,128,52,36,124,116,195,125,128,51,27,84,27,
    52,36,36,52,36,39,36,36,36,36,36,12,36,36,36,36,36,36,36,160,194,132,
    128,194,134,128,36,117,116,116,116,36,38,36,36,36,36,39,37,38,38,160,
    195,127,128,52,38,39,39,30,27,27,30,36,160,116,36,52,51,195,129,128,52,
    195,127,128,52,36,62,36,52,51,195,129,128,52,195,127,128,84,27,27,195,
    132,128,51,30,27,195,130,128,50,36,36,43,27,43,27,52,52,36,15,36,36,36,
    12,12,11,9,38,38,36,36,36,38,36,195,127,128,85,84,29,36,36,36,38,22,36,
    38,36,52,38,43,27,27,3,52,195,131,128,59,27,27,3,84,3,152,84,84,83,30,
    29,117,36,160,117,36,36,39,36,36,36,36,39,30,51,195,129,128,51,29,27,
    60,195,127,128,51,195,129,128,38,152,84,27,6,27,30,27,152,195,131,128,
    52,36,36,34,36,36,116,60,195,127,128,27,27,195,129,128,60,36,168,195,
    126,127,27,27,27,84,152,195,125,127,27,59,195,128,127,27,52,195,129,128,
    51,27,51,30,36,20,160,195,128,127,36,34,195,129,128,51,195,129,128,36,
    36,36,36,160,195,127,128,52,39,152,84,152,84,27,24,27,27,152,85,152,195,
    126,128,44,36,36,36,38,36,160,195,125,128,152,84,27,27,152,195,129,128,
    52,36,116,38,27,51,84,195,131,128,38,27,27,29,195,129,127,152,195,128,
    129,36,52,33,36,34,36,20,33,36,36,195,127,128,176,84,195,126,128,51,195,
    126,128,168,195,126,128,168,195,125,128,60,36,160,116,20,38,152,84,195,
    124,128,51,195,129,128,52,39,33,36,51,195,126,128,60,195,127,128,54,36,
    195,127,128,102,54,33,36,12,12,60,20,116,20,39,62,61,30,52,54,54,47,52,
    52,52,38,39,38,52,38,160,117,124,12,36,12,39,195,127,127,176,195,129,
    128,43,195,129,128,176,195,128,127,160,195,128,127,36,160,195,127,128,
    51,52,52,46,38,195,128,127,36,33,195,128,129,43,58,36,12,38,36,195,125,
    128,160,195,131,128,59,27,195,123,128,36,160,116,51,27,195,140,111,59,
    152,195,155,110,38,195,184,98,33,38,195,162,115,152,195,143,120,27,60,
    195,131,126,30,160,195,72,151,124,195,133,128,116,20,116,36,9,24,29,27,
    29,27,195,126,128,51,27,195,131,124,52,195,128,129,36,160,195,130,128,
    12,160,195,129,128,12,36,195,127,128,75,152,84,27,27,176,195,157,124,
    11,27,25,36,33,27,84,3,27,27,27,30,38,116,36,52,36,160,195,130,128,60,
    195,128,124,25,27,3,27,152,84,51,27,195,136,129,36,160,195,124,125,160,
    84,195,125,129,27,75,152,84,152,195,132,127,160,195,129,128,36,38,36,
    195,148,123,152,195,121,127,51,152,195,130,128,160,195,129,129,36,36,
    36,195,128,122,44,195,129,129,36,11,25,195,141,129,33,27,4,11,30,24,30,
    30,52,36,36,160,195,123,122,34,152,195,129,128,3,11,30,38,160,195,125,
    125,36,195,134,121,160,195,127,128,53,136,195,122,125,51,26,195,129,127,
    27,30,160,195,127,124,160,195,127,128,59,25,195,133,130,152,195,129,128,
    160,195,129,127,152,195,132,125,51,27,115,195,118,125,12,36,116,123,195,
    129,128,184,194,132,128,160,195,126,128,51,27,27,27,27,27,152,195,128,
    127,144,116,195,126,128,152,195,133,118,39,27,27,12,192,2,235,0,39,116,
    60,195,127,128,27,24,195,129,129,27,27,27,195,129,128,20,195,118,129,
    36,195,126,128,152,84,195,135,129,160,116,160,195,111,132,3,27,24,36,
    36,160,195,128,129,36,36,160,116,160,195,22,154,27,27,27,60,116,195,117,
    128,36,36,36,3,84,27,195,142,134,25,29,160,195,204,140,27,27,152,195,
    133,128,160,195,130,131,27,152,195,129,129,160,84,51,136,195,135,130,
    84,31,195,133,129,51,30,152,195,129,128,160,195,128,129,43,195,144,130,
    44,36,195,125,128,27,176,116,195,127,130,58,36,195,126,128,152,195,128,
    127,152,195,125,129,38,27,25,160,195,140,128,27,52,160,116,160,195,126,
    128,52,36,160,195,124,128,152,195,135,129,160,195,127,128,68,152,195,
    126,127,27,152,195,133,134,36,38,43,25,152,195,127,128,24,27,25,84,152,
    195,126,127,27,152,195,126,127,43,152,195,129,128,52,195,127,128,30,38,
    152,195,128,127,152,195,129,129,152,195,129,128,116,57,38,36,12,160,85,
    195,125,128,31,36,116,36,36,12,36,36,160,195,125,132,27,27,52,195,137,
    130,152,195,118,144,152,195,129,128,160,195,146,132,152,195,130,129,27,
    52,195,131,129,5,160,195,122,126,30,85,152,195,130,128,36,51,84,27,52,
    160,195,127,128,46,36,12,36,160,116,33,160,195,127,128,152,195,129,128,
    19,11,3,136,195,134,136,25,25,27,27,27,30,116,160,195,126,128,52,36,195,
    126,128,60,36,144,195,125,130,160,195,129,127,38,152,195,128,130,36,195,
    130,129,51,48,25,30,25,195,135,130,152,84,27,52,160,195,129,130,20,36,
    11,27,195,128,129,152,195,129,129,116,36,195,129,128,51,152,195,130,128,
    52,136,195,130,130,136,195,128,129,152,195,137,126,176,195,129,128,136,
    192,1,70,0,234,3,0,11,43,11,195,129,128,33,25,11,51,51,25,25,19,25,11,
    51,27,27,152,195,130,128,10,11,51,41,27,136,84,51,27,11,195,129,128,33,
    3,4,11,152,195,129,128,12,12,20,52,9,25,30,27,136,195,128,129,30,3,25,
    19,8,1,116,39,36,32,27,11,27,25,25,27,51,51,25,25,33,27,25,3,12,36,19,
    152,195,129,128,20,12,11,27,9,13,53,51,25,27,17,11,3,27,152,195,129,128,
    19,25,25,36,11,27,27,11,11,25,25,27,12,33,24,25,4,11,195,128,129,27,27,
    25,27,9,33,24,54,54,59,25,24,24,27,54,30,3,27,11,136,84,11,27,11,27,3,
    25,9,38,36,11,3,43,27,85,24,27,27,3,76,27,27,27,27,27,11,24,27,27,25,
    27,27,19,25,36,160,195,125,128,11,27,27,46,27,114,84,27,54,27,60,195,
    127,128,44,36,51,52,51,27,11,84,30,152,195,129,128,51,195,128,127,30,
    195,129,128,176,195,127,127,27,43,30,85,27,30,24,20,36,12,17,30,27,51,
    11,17,152,195,129,128,12,12,9,34,36,36,36,36,60,12,195,127,128,11,27,
    3,25,84,27,45,27,43,51,43,51,51,30,51,78,30,29,38,36,36,38,29,29,43,51,
    29,43,51,27,168,84,30,29,30,27,27,51,46,27,52,51,27,27,51,30,27,176,195,
    128,127,6,27,43,27,30,27,4,19,152,195,128,129,29,43,27,195,129,128,12,
    18,160,115,36,117,12,36,195,127,128,10,20,36,12,33,36,18,115,18,36,11,
    4,20,9,33,160,195,127,128,18,6,27,43,30,27,24,36,11,152,195,128,129,29,
    59,3,25,27,27,3,84,43,85,27,152,195,129,128,20,9,160,195,127,128,27,1,
    36,33,27,11,25,9,12,195,127,128,84,51,176,102,43,27,27,25,160,195,127,
    128,3,9,116,12,11,27,3,27,11,3,26,27,41,19,12,12,144,115,36,9,10,36,12,
    52,36,36,34,34,33,60,36,20,36,33,9,24,27,25,36,36,33,3,27,27,27,51,51,
    30,25,25,30,27,152,84,84,84,27,84,27,24,25,3,25,36,36,19,27,27,27,13,
    3,11,152,195,130,128,34,36,20,36,22,22,195,128,127,57,36,144,116,34,116,
    36,54,152,195,129,128,60,116,36,36,36,38,33,33,36,52,33,24,27,30,25,11,
    25,27,12,36,52,60,195,130,129,36,116,33,27,27,27,195,126,128,9,25,27,
    84,27,27,25,11,84,16,27,25,27,27,3,27,11,27,25,36,34,12,36,36,36,20,36,
    36,33,34,36,12,12,20,33,20,116,33,152,195,129,128,116,36,12,36,12,33,
    36,36,36,36,36,20,36,20,33,39,160,116,52,52,20,36,36,176,117,36,36,36,
    36,60,38,36,36,36,36,36,36,36,36,36,38,36,36,36,36,36,36,36,38,36,116,
    160,124,36,36,160,116,36,60,36,60,36,36,39,36,36,116,36,160,116,36,52,
    38,36,60,36,39,36,36,60,36,33,36,36,12,36,34,36,33,36,33,36,36,22,195,
    127,128,43,30,152,116,34,36,33,12,123,36,12,36,36,20,38,38,52,36,34,36,
    33,36,12,195,127,128,25,27,3,195,129,128,36,36,52,39,38,39,60,60,39,36,
    33,36,160,195,126,128,12,160,195,127,128,4,195,127,128,136,116,52,52,
    195,127,128,52,36,36,9,36,160,125,36,36,117,36,60,36,39,36,36,39,36,36,
    36,36,60,36,160,195,127,128,11,195,129,128,36,36,38,36,36,52,39,38,27,
    152,84,29,27,41,168,195,129,128,52,36,36,36,36,36,160,116,116,36,36,36,
    20,34,38,36,52,36,60,44,57,33,195,128,129,52,195,127,128,52,52,60,60,
    36,52,38,33,195,127,128,0,27,11,12,11,19,11,10,32,116,36,36,20,34,36,
    33,27,27,30,27,27,30,27,27,152,195,130,129,27,25,27,12,34,36,20,50,36,
    160,124,36,36,116,38,38,37,36,39,36,36,36,36,60,36,60,36,38,34,36,34,
    36,36,36,52,36,33,12,34,4,36,36,36,60,36,51,52,160,195,127,128,46,39,
    38,36,36,51,152,195,127,127,54,36,36,36,11,20,195,127,128,3,11,11,195,
    129,128,33,33,36,34,36,12,36,33,11,27,27,25,20,20,36,11,27,25,27,27,27,
    11,27,195,129,128,4,195,127,128,84,11,27,11,12,33,25,36,34,25,34,36,39,
    12,195,127,128,11,25,36,12,160,116,33,195,128,129,60,38,38,36,60,52,160,
    195,127,128,60,36,195,127,128,54,33,36,54,36,52,195,127,128,27,3,152,
    195,129,128,51,27,195,130,128,51,27,52,195,130,127,36,136,195,129,128,
    176,195,126,128,43,195,129,128,52,39,33,160,192,2,127,0,254,36,60,160,
    115,36,20,36,39,34,39,36,160,195,125,128,41,195,128,129,27,29,27,51,51,
    30,30,30,54,36,52,33,36,10,36,12,176,195,128,127,12,12,36,20,12,36,36,
    36,20,34,160,195,127,128,25,160,115,160,195,127,128,9,12,33,33,9,27,51,
    53,45,54,27,27,84,27,84,11,3,25,27,25,25,25,25,25,12,12,9,27,51,27,152,
    90,152,195,129,128,51,128,84,25,36,36,36,12,52,36,36,18,9,11,24,27,27,
    69,27,43,152,85,27,51,30,27,85,51,29,51,46,43,43,27,18,33,12,33,33,33,
    33,34,18,33,33,36,12,36,34,17,33,36,10,36,52,36,36,36,36,36,36,36,36,
    36,160,124,36,36,36,36,160,116,20,33,34,36,9,33,36,12,39,12,36,22,36,
    12,36,12,18,25,160,84,12,2,25,36,11,25,27,11,27,51,6,25,195,129,128,33,
    160,195,127,128,11,11,25,76,52,160,195,127,128,84,30,29,30,27,43,27,176,
    84,152,195,129,128,12,19,27,5,136,195,129,128,36,36,36,12,36,12,195,127,
    128,12,36,116,12,195,130,129,12,36,32,84,27,12,128,195,128,129,30,27,
    3,25,136,195,128,129,27,13,25,33,27,54,25,27,11,19,9,24,27,25,152,195,
    129,128,83,152,195,129,128,4,195,127,128,12,36,12,4,11,27,27,12,32,27,
    25,36,19,27,152,195,129,128,9,43,12,195,129,128,11,3,43,11,195,129,128,
    160,195,130,128,11,11,11,176,195,128,127,25,152,195,129,128,9,27,25,11,
    51,152,195,131,127,11,152,195,129,128,19,27,43,51,30,30,43,195,129,128,
    54,30,27,51,51,136,195,128,129,29,30,195,128,127,11,51,11,25,24,27,27,
    59,27,12,195,129,128,11,27,24,152,195,129,128,12,12,11,11,25,27,195,130,
    128,36,36,1,11,11,11,24,152,84,27,25,25,36,11,27,51,25,33,160,195,127,
    128,84,3,51,25,33,25,30,25,27,152,76,3,30,152,76,83,152,84,27,24,30,27,
    51,54,54,36,51,51,51,44,195,127,128,52,36,54,152,195,129,128,52,38,54,
    51,30,36,51,27,30,27,30,152,195,129,128,54,60,38,39,52,52,176,110,62,
    54,53,51,54,29,27,51,51,43,29,30,27,62,36,38,54,38,52,54,38,55,62,45,
    54,30,54,195,128,127,25,11,11,46,51,25,27,30,27,41,12,33,33,0,152,83,
    27,9,25,27,11,9,9,9,11,9,10,25,27,24,27,27,24,76,27,152,83,83,27,83,3,
    27,25,160,195,127,128,11,84,11,3,136,84,3,27,25,27,24,29,27,27,27,168,
    84,12,9,8,9,1,11,11,27,27,43,9,25,9,16,106,10,12,9,19,10,36,195,127,128,
    12,36,11,195,129,128,12,36,34,11,195,129,128,36,3,24,27,25,12,52,36,60,
    36,52,33,36,33,32,11,27,11,27,11,27,27,27,27,3,27,152,84,27,3,27,27,27,
    24,25,36,36,36,52,36,39,36,160,195,133,129,36,36,160,195,133,129,36,195,
    129,129,36,160,195,128,129,33,32,33,25,36,52,12,12,52,36,38,36,34,36,
    33,25,12,12,12,11,27,27,27,11,51,25,195,128,129,3,27,25,84,84,27,27,27,
    27,27,84,27,152,195,130,128,12,36,36,36,36,33,27,12,36,38,36,36,52,36,
    39,36,176,195,130,128,160,116,36,36,160,116,12,10,12,11,27,8,25,25,117,
    38,117,36,36,38,36,36,52,32,36,39,33,24,25,11,27,12,195,127,128,27,152,
    195,132,128,12,52,195,128,129,36,52,52,36,52,33,152,195,129,128,20,20,
    33,36,17,160,195,127,128,17,27,0,25,152,195,129,128,11,30,152,195,129,
    127,12,36,36,33,12,160,90,152,84,84,27,19,27,11,195,129,128,36,39,32,
    34,27,27,152,84,30,25,27,27,5,27,11,31,52,38,27,30,36,52,36,195,127,128,
    51,27,51,51,46,27,30,43,55,195,127,127,29,38,195,127,127,30,84,11,11,
    25,25,27,12,9,36,16,152,84,3,13,27,30,51,51,51,25,27,195,129,128,11,9,
    11,27,12,160,195,129,129,33,152,195,126,128,4,36,33,152,195,126,129,3,
    192,1,65,0,236,0,11,11,84,11,24,25,11,11,25,27,84,3,27,6,30,27,52,38,
    36,52,33,38,36,38,27,152,195,130,128,60,38,52,52,36,38,36,60,52,36,136,
    195,105,115,27,84,60,160,195,121,113,31,38,110,33,9,25,152,195,111,128,
    51,30,52,62,39,36,11,152,195,127,128,136,195,127,128,9,36,11,136,195,
    131,135,60,11,195,124,117,27,24,51,27,54,52,38,36,33,17,160,195,135,129,
    60,52,33,152,195,127,128,11,195,129,127,38,160,195,128,129,36,195,122,
    125,30,36,136,195,136,129,44,195,103,119,52,52,32,195,127,128,136,195,
    127,128,136,195,128,123,30,55,60,54,36,55,39,10,27,9,24,11,11,128,195,
    138,132,33,33,25,27,27,51,52,36,160,195,124,127,8,27,11,176,195,129,128,
    52,52,195,123,123,36,160,195,126,128,11,11,24,27,52,55,52,10,195,124,
    127,30,54,30,176,195,128,127,36,9,32,195,123,131,12,195,127,128,16,8,
    11,3,54,39,55,176,195,135,123,11,25,11,4,195,129,129,32,195,126,128,11,
    152,195,128,127,47,38,52,52,46,23,12,195,117,126,36,160,195,128,129,34,
    24,27,12,160,195,128,129,20,195,128,127,27,152,76,47,176,195,133,129,
    36,195,73,113,51,195,129,128,160,195,117,126,11,30,160,195,120,130,36,
    20,12,11,195,128,129,27,51,152,195,128,126,52,136,195,129,126,51,195,
    129,128,33,195,124,128,52,195,103,140,3,52,195,130,129,128,195,126,128,
    51,43,176,116,33,36,195,127,130,27,27,27,30,51,25,29,54,60,12,52,12,36,
    160,195,127,128,12,33,33,36,136,195,116,134,30,52,136,195,132,128,152,
    195,93,137,30,152,195,129,128,160,195,133,123,152,195,127,128,52,195,
    106,132,20,160,195,127,128,11,13,30,176,195,134,127,44,33,195,122,130,
    152,195,128,127,24,84,85,45,36,36,33,36,195,115,133,27,27,11,51,195,129,
    128,51,30,29,152,116,115,36,12,36,195,118,129,27,43,53,53,160,195,128,
    127,34,12,34,195,118,132,11,30,160,195,124,128,27,52,195,126,128,30,195,
    122,128,27,52,195,125,128,152,84,27,195,130,128,184,115,195,121,127,27,
    29,27,30,116,36,116,12,33,195,114,131,3,54,152,195,129,128,36,195,123,
    126,51,60,9,195,122,129,38,33,32,152,195,175,100,27,52,36,136,195,125,
    125,27,51,52,144,195,117,110,160,195,127,128,11,13,52,195,127,126,30,
    195,159,129,52,39,36,38,33,195,128,129,20,33,25,27,6,27,152,84,195,164,
    136,30,34,195,118,101,27,152,195,94,130,27,11,24,27,11,43,27,27,11,6,
    30,52,36,36,36,39,36,38,36,160,195,217,149,152,195,138,121,44,195,203,
    76,136,84,152,195,157,128,30,54,29,152,195,132,128,12,115,33,27,27,195,
    164,121,84,52,195,130,128,136,195,180,135,30,36,136,195,177,138,11,152,
    195,131,128,160,195,154,125,36,33,27,152,195,147,124,52,33,152,195,128,
    127,39,36,3,195,126,128,136,195,133,131,30,50,144,195,129,129,30,160,
    195,129,126,176,195,128,127,160,195,123,120,51,195,129,128,33,195,152,
    134,36,195,131,127,46,34,83,195,125,136,30,152,195,129,128,160,195,128,
    127,160,195,130,135,160,195,120,93,51,195,129,128,36,195,127,128,136,
    195,111,124,116,36,36,36,36,12,195,127,128,27,152,195,134,125,6,30,195,
    130,127,160,195,137,128,36,160,195,127,128,11,152,195,50,169,38,36,11,
    195,128,129,52,195,206,119,27,3,12,195,127,128,27,11,195,128,127,84,27,
    11,25,27,27,51,152,195,129,128,51,27,51,176,84,52,60,36,36,52,36,36,60,
    36,36,36,12,160,195,115,98,152,85,84,27,27,27,27,11,27,27,30,30,52,39,
    36,52,38,29,25,27,27,24,27,27,11,30,30,60,38,38,36,36,36,36,38,38,36,
    38,38,36,52,52,36,20,144,124,20,36,12,36,33,27,12,36,11,11,25,27,27,3,
    51,27,9,160,195,127,128,12,36,36,195,127,128,4,12,33,84,152,195,105,156,
    3,11,152,195,129,128,11,29,27,27,25,27,12,36,52,36,160,195,129,128,11,
    27,136,116,36,34,60,36,38,33,195,127,128,12,11,27,27,27,3,24,152,195,
    129,128,11,30,27,25,27,3,27,25,17,33,25,27,11,25,24,25,24,25,27,27,27,
    51,30,184,85,84,84,9,36,11,27,27,24,27,30,27,27,152,195,129,128,11,24,
    27,27,152,195,129,128,51,54,152,195,129,128,36,51,27,27,27,25,27,12,11,
    12,160,195,127,128,11,11,27,152,84,29,27,27,43,27,76,30,27,195,147,128,
    97,195,112,130,194,123,132,69,30,30,52,20,52,33,116,36,51,27,51,152,195,
    130,128,36,195,129,127,60,34,36,36,160,116,36,176,84,27,27,27,195,132,
    128,51,27,195,127,127,29,27,27,29,160,195,127,128,52,36,52,36,36,124,
    160,194,132,128,160,116,116,36,33,39,160,116,36,116,38,36,36,36,195,127,
    128,43,27,27,117,195,127,128,27,43,27,11,27,27,27,84,152,195,128,129,
    152,83,30,84,24,51,27,27,31,60,38,36,52,36,36,36,36,160,116,38,36,60,
    46,36,36,38,33,36,36,36,36,36,36,36,36,12,33,36,116,144,116,36,34,36,
    34,54,152,195,129,128,36,36,39,12,38,152,195,129,128,36,36,36,36,36,36,
    36,36,36,160,192,1,51,0,102,36,36,36,39,36,36,52,38,36,62,36,36,20,36,
    12,36,36,38,34,152,195,129,128,20,32,36,9,152,195,129,128,33,160,195,
    127,128,9,36,36,20,33,36,36,144,116,36,136,116,36,36,11,27,3,27,3,27,
    3,25,27,152,195,129,128,43,27,11,27,27,27,27,27,3,27,25,29,27,27,27,51,
    27,27,27,27,52,55,160,116,52,43,52,60,195,127,128,27,43,53,30,27,43,152,
    195,135,119,84,60,195,131,128,152,192,1,204,0,124,27,192,2,164,0,249,
    52,176,195,127,129,116,36,12,9,27,152,195,118,126,29,76,27,11,27,9,29,
    52,52,39,36,60,36,10,160,195,115,109,38,36,36,52,36,52,116,176,116,9,
    25,27,27,24,27,3,195,92,144,152,195,136,122,152,195,208,108,29,6,27,168,
    85,51,46,30,30,46,30,168,94,45,43,30,36,36,195,126,128,51,43,51,195,129,
    128,54,36,36,33,38,20,36,36,52,116,33,36,20,38,27,52,50,36,136,124,43,
    51,30,29,30,36,34,33,195,128,127,36,12,33,38,38,195,127,127,43,195,129,
    128,160,195,129,128,51,44,52,12,22,54,152,195,129,128,34,34,20,11,9,27,
    51,9,30,30,25,25,9,36,33,36,11,195,128,129,3,51,11,25,33,11,30,25,29,
    11,51,136,195,128,129,25,11,27,11,12,34,27,25,30,30,30,25,9,33,17,33,
    34,20,9,195,123,153,50,195,128,129,30,160,195,81,122,13,195,129,126,52,
    136,195,177,98,152,195,129,129,144,195,99,112,27,152,195,127,127,27,195,
    130,127,27,195,131,128,33,152,195,127,126,38,195,126,129,160,195,129,
    127,160,195,125,125,11,152,195,128,129,160,195,114,111,160,195,127,128,
    11,152,195,127,127,176,195,129,128,136,195,130,129,12,195,127,128,11,
    31,195,100,135,51,195,130,129,9,195,130,123,36,36,36,9,36,195,126,128,
    27,51,195,97,115,27,27,195,158,138,27,176,195,128,129,36,136,195,151,
    121,51,27,52,52,116,33,11,195,133,124,27,27,52,36,195,125,125,30,152,
    195,129,128,176,195,129,128,136,195,142,103,27,152,195,106,120,27,30,
    36,195,124,127,52,195,129,127,152,195,127,122,152,195,74,161,36,55,36,
    32,25,152,195,124,127,27,195,127,130,30,38,36,52,12,160,195,127,128,3,
    152,195,129,132,152,195,127,128,27,52,195,123,162,27,52,44,33,195,127,
    130,29,54,17,195,127,125,30,30,30,36,195,129,128,9,195,128,126,25,30,
    195,128,127,46,43,54,54,176,195,128,127,33,160,195,128,127,25,144,195,
    129,128,136,195,123,128,51,51,58,17,195,133,126,136,195,127,129,152,195,
    126,128,31,195,133,154,30,160,195,116,120,38,38,38,27,25,136,195,79,73,
    27,152,195,170,109,43,195,128,127,27,52,195,130,128,160,195,148,152,33,
    33,136,98,27,27,51,54,63,195,123,120,27,43,27,85,27,29,29,52,36,36,12,
    115,36,18,160,195,122,128,27,195,120,114,30,27,24,9,152,195,129,128,36,
    195,127,128,11,27,27,53,54,102,54,38,51,29,30,27,46,36,160,116,36,54,
    36,160,116,36,36,12,12,10,10,34,58,36,51,152,195,130,127,194,129,132,
    36,36,52,36,36,116,36,11,11,3,3,29,30,25,12,160,195,127,128,11,98,27,
    11,24,25,27,27,3,152,195,158,111,30,160,195,147,127,24,27,43,27,27,51,
    51,53,38,38,160,116,160,116,36,36,12,12,11,9,33,195,132,130,30,52,33,
    60,36,19,25,40,152,195,121,123,38,51,195,126,128,9,160,195,135,130,103,
    194,126,123,57,195,125,127,52,136,195,117,126,36,33,27,27,176,195,129,
    128,176,195,119,126,36,20,11,27,51,195,125,129,38,30,195,128,127,25,195,
    104,126,27,152,195,113,139,30,160,195,129,128,136,195,109,123,59,27,195,
    129,128,136,195,176,126,11,152,195,221,170,84,25,25,24,27,8,24,43,11,
    25,152,83,25,27,136,195,130,129,36,60,60,160,195,129,129,9,195,128,129,
    36,60,36,38,36,36,160,195,130,129,36,33,25,25,32,36,195,127,129,38,33,
    195,127,127,33,27,136,75,136,83,1,11,30,25,27,25,1,27,27,27,24,152,195,
    129,128,36,116,33,27,3,25,36,39,36,36,195,127,128,11,25,36,36,36,38,36,
    36,20,51,52,20,34,160,195,127,128,176,195,127,128,43,195,127,128,51,195,
    129,128,36,195,127,128,51,195,129,128,160,116,195,127,128,43,195,129,
    128,36,38,60,36,36,160,66,116,195,126,128,12,160,195,127,128,12,36,38,
    33,36,116,20,36,11,27,27,3,12,195,128,129,36,160,195,127,128,9,12,36,
    195,126,128,11,195,128,129,27,27,27,152,84,20,195,130,127,136,195,127,
    129,6,29,25,160,84,27,30,27,152,115,11,195,129,128,34,160,195,127,128,
    11,11,27,41,30,176,83,10,27,176,195,128,127,27,176,195,128,127,27,25,
    27,51,26,27,152,195,128,127,27,3,195,129,128,33,152,195,129,128,33,160,
    195,127,128,27,19,25,160,125,36,36,36,11,11,84,27,27,195,126,129,84,195,
    129,128,12,12,160,195,130,128,33,33,33,24,27,29,27,27,27,20,34,58,160,
    195,127,128,152,83,27,84,27,152,84,195,129,128,20,195,127,128,27,27,195,
    130,128,12,195,127,128,27,27,176,84,27,51,84,20,20,36,195,130,128,12,
    195,127,128,3,3,40,76,27,11,152,84,25,27,11,152,84,136,194,118,125,51,
    68,27,84,29,38,36,160,195,125,128,27,27,27,195,129,128,59,27,195,129,
    128,51,27,11,195,129,128,20,11,27,25,43,27,27,46,51,27,11,195,129,128,
    33,152,195,129,128,20,17,12,195,127,128,12,160,195,127,128,12,12,11,3,
    152,84,152,84,43,27,27,27,195,129,128,117,36,36,51,195,124,127,40,30,
    152,195,129,128,38,36,36,116,160,195,121,128,152,84,30,47,160,116,38,
    38,27,24,27,27,152,195,129,129,38,160,195,127,128,63,36,160,116,54,46,
    27,24,160,116,12,195,127,128,11,27,25,27,24,25,9,12,9,17,33,34,124,116,
    12,195,127,128,27,77,194,123,128,84,152,68,27,84,27,43,29,51,27,51,51,
    45,52,51,41,195,128,129,52,39,38,36,52,38,36,36,36,160,116,60,38,27,24,
    27,30,36,184,116,52,36,52,39,36,194,138,128,195,129,128,116,195,135,129,
    3,25,27,27,26,195,134,130,36,38,36,52,136,195,127,128,8,152,195,129,128,
    36,36,160,117,36,36,36,9,24,34,38,38,36,36,52,38,195,127,129,160,195,
    128,127,36,39,27,195,133,129,36,52,51,51,195,129,128,51,195,130,128,115,
    116,195,129,128,36,12,176,118,30,160,195,127,128,52,195,127,128,52,36,
    195,128,129,36,195,128,129,38,38,116,54,84,51,51,52,36,36,52,15,36,33,
    38,36,52,36,38,36,51,195,128,127,76,30,29,41,8,11,75,195,127,128,27,27,
    27,27,51,30,29,38,36,38,36,51,27,43,84,29,27,27,27,11,25,27,27,27,30,
    39,51,27,194,130,132,160,194,133,128,60,36,12,33,152,195,129,128,34,38,
    160,115,38,36,22,20,55,36,59,195,129,128,52,38,152,195,129,128,38,33,
    38,36,160,195,127,128,51,27,195,129,128,52,36,52,36,60,36,38,36,36,36,
    160,94,36,15,116,160,116,52,36,52,36,195,127,128,60,160,195,70,65,0,12,
    195,127,128,12,195,127,128,3,27,152,68,76,84,83,84,27,43,46,110,38,36,
    36,36,160,116,36,36,36,36,36,116,195,115,130,27,195,120,127,27,152,195,
    54,132,36,12,12,160,195,127,128,11,27,11,195,129,128,34,36,36,36,36,36,
    36,12,10,152,195,129,128,34,20,36,11,27,24,27,27,29,27,3,152,84,27,152,
    84,195,129,128,59,24,27,27,29,39,27,152,195,129,128,44,51,51,52,52,51,
    195,129,128,60,62,36,195,209,113,160,116,36,12,195,127,128,27,27,152,
    195,61,130,36,38,33,38,33,36,36,36,36,36,36,36,36,36,36,160,116,36,36,
    12,52,116,36,160,116,116,34,116,36,38,36,36,39,36,20,116,36,36,160,195,
    127,127,24,160,195,130,128,20,32,25,27,24,152,84,84,84,11,176,83,41,27,
    43,27,11,27,27,152,84,27,152,77,27,27,29,11,27,27,27,27,27,152,75,27,
    27,84,24,36,36,195,124,128,136,124,36,36,36,195,127,128,11,27,27,27,27,
    3,195,129,128,36,36,160,195,126,128,11,27,27,30,24,27,30,27,27,176,195,
    129,127,19,128,85,83,27,152,84,25,152,84,152,76,59,27,52,36,52,39,36,
    60,36,23,36,36,136,195,129,128,36,36,52,36,52,44,38,176,195,129,128,43,
    52,195,127,128,52,176,195,201,121,38,36,52,176,84,27,4,4,195,134,129,
    52,195,59,122,160,195,127,128,12,195,127,128,27,27,195,130,128,52,195,
    125,125,19,13,195,126,129,160,195,92,128,52,195,140,127,11,27,195,116,
    138,36,36,52,20,36,36,43,51,44,38,36,160,195,131,128,36,39,34,36,12,9,
    27,11,27,152,83,27,27,27,152,84,27,152,84,152,195,143,125,52,195,130,
    128,29,36,160,195,111,128,176,195,129,128,136,116,160,195,123,124,52,
    195,127,128,152,195,122,126,30,160,195,123,127,27,195,124,128,27,27,27,
    29,152,195,129,128,160,116,160,195,113,126,27,84,76,195,150,136,36,59,
    152,195,130,128,38,38,160,116,36,36,116,36,36,195,127,128,12,36,195,125,
    128,12,195,127,128,11,195,129,128,33,160,195,127,128,27,195,129,128,12,
    12,11,25,36,11,27,195,126,128,27,27,27,27,27,84,184,194,132,128,39,38,
    27,27,27,25,27,25,27,195,126,127,43,195,129,128,52,36,176,84,27,24,11,
    27,195,129,128,19,27,84,11,27,152,84,27,52,52,52,33,38,160,195,127,128,
    52,36,36,160,69,195,129,128,116,38,38,36,36,116,36,160,195,129,128,12,
    36,176,195,108,128,27,51,52,39,12,36,3,136,195,98,120,43,27,195,130,128,
    51,27,29,152,195,129,128,52,36,39,160,195,127,128,27,51,195,129,128,38,
    36,39,27,152,84,27,27,6,27,25,11,84,27,195,130,128,19,27,84,25,27,27,
    27,25,27,83,27,51,6,27,51,27,29,36,44,36,36,160,195,122,128,43,30,36,
    36,160,195,124,128,84,51,60,36,160,116,38,36,33,36,36,36,33,152,195,129,
    128,33,36,38,30,38,33,36,36,36,36,36,20,52,195,127,128,30,27,27,27,84,
    27,195,126,128,51,27,30,38,160,116,36,36,36,36,116,12,36,36,32,36,36,
    36,20,160,195,129,128,20,52,36,36,12,52,36,36,36,36,33,160,195,127,128,
    9,33,33,160,195,127,128,25,27,27,27,27,29,3,24,36,11,27,25,27,27,20,160,
    195,127,128,128,195,80,133,27,27,51,29,152,84,176,116,36,36,33,36,12,
    195,128,127,32,195,107,130,30,152,195,129,128,160,195,128,127,160,195,
    117,128,36,20,36,60,12,160,195,126,128,12,36,38,152,195,129,128,36,52,
    36,36,12,195,127,128,136,195,129,129,136,195,128,129,18,36,195,127,128,
    11,152,195,130,128,36,12,36,20,51,46,36,176,195,129,128,34,25,36,36,116,
    20,160,195,126,128,12,160,83,84,20,36,36,11,27,3,27,77,176,83,27,27,27,
    43,27,27,27,51,84,29,27,43,29,160,195,127,128,84,27,51,27,27,44,38,36,
    195,127,128,176,195,181,123,152,76,3,52,195,133,126,30,195,128,126,51,
    195,119,125,152,195,130,128,12,195,127,128,152,195,137,126,43,84,84,152,
    195,129,128,52,38,36,33,36,33,27,195,131,127,11,31,195,132,126,27,54,
    36,144,116,36,39,36,36,38,27,27,27,27,51,84,27,27,195,127,128,43,52,38,
    36,36,36,36,36,36,36,116,36,12,36,160,115,4,17,152,195,129,128,20,195,
    127,128,3,27,27,27,27,152,84,27,27,68,195,180,135,27,51,195,129,128,36,
    195,122,124,84,30,37,52,38,36,160,195,129,128,8,12,195,127,128,128,195,
    145,128,27,27,27,52,36,36,160,195,154,128,36,36,36,36,39,36,36,36,34,
    152,195,129,128,160,195,126,128,83,152,84,27,152,195,126,129,83,27,152,
    195,121,126,36,36,124,36,36,36,33,0,27,24,27,11,44,43,51,29,195,84,120,
    51,52,38,36,36,36,52,12,36,195,127,128,51,195,126,128,52,38,36,36,160,
    116,36,36,52,36,12,60,12,39,36,160,195,127,128,54,36,36,12,11,27,9,9,
    11,29,27,27,4,11,27,27,29,27,176,75,27,25,76,11,27,27,27,195,166,126,
    136,84,30,160,116,195,125,128,76,52,36,39,36,36,11,25,195,187,138,27,
    152,195,130,129,144,195,143,125,12,195,127,128,11,27,51,136,195,128,129,
    27,60,116,160,195,129,128,160,195,114,120,33,160,195,127,128,20,195,127,
    128,27,29,27,195,129,128,52,160,195,114,120,27,76,27,44,36,36,36,160,
    195,189,120,27,195,130,128,160,195,160,127,152,84,27,27,27,195,115,161,
    152,195,129,128,160,195,125,128,27,52,160,195,113,133,27,195,108,121,
    25,27,184,195,116,112,27,195,124,128,168,195,128,127,27,11,152,195,129,
    128,128,84,152,84,51,25,27,84,25,24,25,27,3,27,29,30,27,52,195,127,128,
    27,59,27,27,52,36,160,195,125,128,52,195,129,127,176,195,126,128,47,116,
    39,39,36,36,184,76,195,131,128,36,52,36,195,127,128,85,27,27,27,152,195,
    129,128,52,36,195,125,128,152,195,129,128,52,38,27,52,36,116,52,36,36,
    36,160,116,36,36,160,195,127,128,11,195,129,128,36,52,36,195,127,128,
    9,36,116,36,33,27,27,11,12,39,160,195,129,129,36,34,34,152,195,129,128,
    33,36,195,131,128,12,33,3,27,27,11,30,27,27,195,129,128,51,24,33,36,36,
    12,84,195,121,149,33,27,9,36,176,195,128,129,38,36,38,33,33,12,52,52,
    38,18,12,54,152,195,129,128,38,160,116,36,36,115,25,36,176,195,128,127,
    36,52,36,9,15,62,160,116,36,36,116,116,116,34,176,195,126,128,52,36,36,
    36,36,20,33,36,36,12,195,127,128,152,194,121,125,12,36,33,152,195,129,
    128,32,36,36,36,36,36,36,33,36,36,12,12,33,160,195,127,128,27,27,12,116,
    36,116,33,27,3,27,27,51,27,27,27,195,132,128,12,160,195,126,128,84,84,
    27,43,152,195,129,128,12,195,127,128,27,152,84,152,195,142,128,11,27,
    27,27,27,84,152,195,139,128,124,195,130,129,136,195,129,129,12,116,195,
    128,129,116,11,12,84,84,27,27,27,27,27,27,195,126,129,11,27,152,195,132,
    128,160,195,129,128,11,27,195,131,128,160,195,134,129,19,27,27,24,36,
    36,36,160,195,128,129,36,36,36,195,126,128,12,195,129,129,36,36,12,36,
    36,176,195,127,127,11,195,127,129,3,27,84,195,133,128,160,195,130,128,
    36,38,36,36,36,20,36,195,127,128,136,195,126,129,27,136,116,116,36,36,
    32,76,27,195,133,128,36,36,32,27,27,152,195,129,128,115,36,195,128,129,
    36,36,36,12,36,12,36,36,33,36,116,160,194,132,127,36,34,36,33,160,195,
    127,128,27,84,27,27,29,27,27,27,84,85,27,84,27,27,29,11,152,195,134,128,
    12,36,36,36,195,132,128,144,116,116,195,124,128,27,68,27,152,195,130,
    128,20,195,143,129,20,195,127,128,27,195,130,128,116,36,36,160,123,36,
    36,36,12,36,12,52,12,36,10,27,27,27,27,27,27,27,152,195,129,128,11,27,
    195,131,128,33,160,195,127,128,27,152,76,43,27,12,160,195,126,128,27,
    52,195,127,128,25,27,27,84,27,27,27,27,27,152,84,27,128,68,27,27,27,27,
    27,27,84,27,84,27,27,43,27,84,27,27,84,84,152,84,27,195,129,128,11,27,
    27,29,3,29,27,27,195,124,128,27,27,30,36,195,126,128,27,24,43,152,195,
    130,128,51,195,127,127,27,30,160,195,127,128,27,52,160,195,126,128,27,
    84,27,152,84,27,27,27,51,29,27,195,129,128,116,124,36,160,195,126,128,
    43,27,27,195,132,128,51,27,27,11,27,152,84,27,27,27,27,43,27,27,168,195,
    126,128,52,116,160,117,195,127,128,27,195,129,128,52,36,36,36,160,195,
    127,128,194,142,129,195,127,128,20,54,36,36,36,36,34,60,160,116,36,36,
    36,36,34,116,36,36,36,160,116,36,160,115,36,36,36,36,36,36,38,27,27,76,
    27,84,84,195,126,128,44,195,127,128,27,27,194,122,128,27,43,152,84,152,
    195,129,128,44,39,36,39,36,59,27,27,152,194,122,126,83,68,194,123,127,
    152,84,27,29,36,38,76,30,36,36,36,52,54,152,195,129,128,59,152,195,129,
    128,52,36,36,36,36,116,36,36,116,36,36,43,84,27,27,152,84,27,27,152,84,
    27,27,195,123,128,43,27,43,51,195,129,128,51,194,138,128,116,11,12,195,
    128,129,39,29,38,27,195,131,129,36,33,61,36,36,36,20,8,36,52,195,127,
    128,53,152,195,127,128,52,195,127,128,27,27,27,152,195,130,128,51,195,
    127,127,27,195,127,127,27,24,11,27,27,27,27,152,84,31,152,195,129,128,
    44,36,160,117,36,36,195,124,128,60,160,195,126,128,27,152,76,27,152,84,
    43,51,30,39,160,195,130,128,152,195,210,114,36,195,126,128,136,192,2,
    48,1,106,52,33,6,195,174,23,54,53,9,9,192,1,123,1,21,60,52,195,127,128,
    110,38,195,128,127,184,115,19,8,32,27,24,152,195,199,112,17,24,34,33,
    9,9,9,1,95,52,54,30,38,30,27,51,51,30,160,195,129,127,160,117,195,124,
    111,12,195,127,128,24,51,25,8,41,27,27,52,38,62,152,195,129,128,160,116,
    160,116,195,104,125,38,30,25,27,27,27,27,43,26,144,124,36,12,60,33,192,
    2,80,1,4,45,54,94,30,84,29,84,27,27,83,152,84,27,84,9,36,33,160,116,116,
    34,57,160,115,36,36,12,33,36,195,112,138,51,30,27,176,85,84,30,27,85,
    168,85,27,27,27,43,8,27,9,33,160,117,115,194,133,125,36,116,115,116,12,
    36,39,36,195,105,131,10,38,152,195,145,114,43,27,128,84,3,54,53,94,152,
    95,30,30,1,11,8,51,168,84,9,25,34,33,136,90,19,9,27,128,83,152,84,45,
    53,94,195,128,127,27,176,94,30,46,168,110,31,176,110,54,45,94,85,24,98,
    1,8,160,90,9,10,98,105,33,106,85,94,43,9,144,114,17,34,36,33,36,116,36,
    160,116,33,36,57,57,0,84,25,27,27,24,30,27,77,27,3,11,27,25,12,114,27,
    43,176,85,84,30,152,85,30,84,27,9,27,176,84,27,25,33,34,115,20,33,36,
    20,12,12,20,34,52,12,36,10,36,116,117,36,117,38,117,52,36,57,60,54,62,
    52,38,54,38,36,39,116,36,36,116,38,36,36,36,52,63,52,62,195,128,129,194,
    110,122,195,129,128,194,132,129,116,33,27,84,152,195,146,135,30,36,136,
    195,122,118,39,36,33,152,84,195,127,128,176,195,80,109,12,11,195,129,
    128,9,152,84,51,51,55,36,195,129,128,160,195,179,132,11,176,83,29,39,
    115,195,139,121,15,36,116,51,41,30,195,128,127,41,195,148,125,33,12,136,
    115,12,33,27,43,94,30,30,160,192,1,218,0,226,12,136,98,9,1,8,1,0,1,136,
    98,9,11,43,9,33,33,9,19,195,128,129,30,30,85,44,102,38,27,27,46,51,60,
    36,168,110,39,55,52,106,38,38,102,34,54,60,195,127,128,54,94,52,195,117,
    125,39,33,160,195,127,128,128,98,0,24,13,30,36,55,59,110,195,122,122,
    12,9,152,195,129,128,98,136,84,3,24,51,30,36,36,52,59,54,52,176,195,131,
    121,11,3,136,195,128,129,27,52,38,160,192,2,78,0,187,36,160,116,20,33,
    36,36,123,84,27,77,27,27,85,152,192,1,188,0,180,51,51,6,30,54,27,63,45,
    30,46,195,128,127,36,17,36,106,32,33,25,34,33,152,195,147,132,1,25,195,
    128,129,29,46,44,36,34,160,195,82,115,136,84,27,68,27,27,27,25,84,43,
    51,43,43,53,36,20,123,136,116,160,116,160,123,116,160,116,116,160,195,
    129,128,33,160,195,134,129,27,27,52,36,195,141,130,53,45,84,136,98,36,
    36,195,77,128,116,52,16,27,152,195,100,114,39,116,38,124,36,36,36,12,
    116,36,10,10,116,36,116,160,116,12,9,11,152,195,130,128,160,116,39,36,
    34,34,176,195,128,127,32,25,160,195,128,129,116,36,32,84,83,27,152,77,
    68,51,29,27,27,59,195,129,128,37,51,27,41,152,83,25,27,3,27,3,25,25,27,
    52,184,195,129,128,60,195,129,128,52,39,36,52,54,152,84,27,27,43,27,51,
    30,24,168,85,195,159,119,36,36,160,116,36,160,195,128,127,27,84,27,27,
    195,208,117,136,84,27,27,84,176,85,24,84,27,27,84,31,36,36,124,160,195,
    131,128,160,115,116,36,160,195,129,128,160,195,107,134,176,94,51,54,27,
    25,25,25,152,195,129,128,12,20,160,115,195,148,114,27,85,152,84,3,25,
    26,36,52,52,36,160,195,121,129,27,27,152,84,27,51,11,51,25,27,13,26,23,
    36,36,34,22,36,160,195,127,128,60,36,195,58,136,184,124,36,116,17,195,
    128,129,27,24,36,195,127,128,3,176,84,168,195,148,138,136,195,128,129,
    20,10,33,18,36,19,27,83,30,27,83,27,84,76,152,76,27,27,152,84,27,54,36,
    36,115,36,160,115,184,116,160,124,36,52,36,36,176,195,128,129,152,195,
    128,129,29,195,127,129,168,195,43,115,60,36,160,117,20,18,12,36,20,117,
    51,30,27,43,30,160,115,36,160,115,34,116,3,4,20,36,39,36,116,33,4,12,
    9,30,27,27,27,27,27,27,27,12,34,160,116,19,84,3,27,27,152,85,27,168,84,
    152,85,27,84,168,84,27,176,124,116,50,36,116,36,160,116,176,116,51,152,
    83,27,27,52,37,152,85,152,195,130,128,51,152,84,195,156,141,27,27,27,
    27,24,43,30,36,117,20,176,115,39,33,36,195,99,103,60,54,33,36,9,24,77,
    192,0,161,0,147,27,30,36,160,195,128,127,160,195,232,148,36,63,63,60,
    38,33,195,127,128,11,11,136,84,0,195,119,127,54,51,84,30,195,132,127,
    38,62,52,136,98,25,1,192,1,214,0,153,51,195,129,128,60,195,127,128,43,
    25,27,9,36,160,192,2,92,0,199,116,122,11,168,85,86,194,118,120,39,36,
    8,27,152,195,150,106,27,27,84,68,152,195,129,128,60,36,160,116,195,131,
    98,46,160,195,127,128,52,51,195,129,128,52,124,116,20,17,152,83,27,11,
    27,195,127,128,152,195,175,194,160,195,127,128,11,3,136,84,195,129,128,
    44,102,36,160,192,0,151,0,165,30,27,51,29,30,34,36,144,195,129,127,160,
    192,0,138,1,147,33,33,36,12,195,127,128,11,11,11,25,27,62,30,54,38,152,
    195,129,128,176,195,125,119,36,11,11,27,52,51,52,195,125,126,33,152,195,
    130,127,27,30,195,126,126,25,25,30,30,36,184,195,116,123,60,33,11,168,
    195,126,129,30,195,42,91,160,195,126,128,160,195,129,128,160,195,123,
    128,160,192,0,174,2,101,9,24,43,55,60,160,195,76,137,6,176,195,227,122,
    10,27,176,117,195,128,125,9,30,176,195,114,121,11,6,52,195,131,130,11,
    30,160,195,104,118,11,11,54,160,195,75,29,3,52,184,195,128,127,136,195,
    232,198,9,24,30,39,176,195,120,117,11,29,36,195,185,224,30,160,195,246,
    139,30,160,192,0,126,2,51,27,52,160,192,0,13,1,95,33,27,176,195,144,131,
    3,52,195,141,138,54,17,192,0,125,2,124,6,52,195,214,96,36,11,195,116,
    133,11,30,39,192,1,246,2,6,8,8,51,62,52,51,55,33,17,195,130,127,25,30,
    195,128,129,116,192,1,214,1,109,8,9,128,97,9,12,12,12,34,33,36,20,33,
    160,115,33,9,36,60,12,33,9,39,23,36,60,36,52,12,136,195,128,129,36,52,
    52,36,20,50,58,36,20,11,195,129,128,3,24,12,36,36,20,50,52,34,12,136,
    195,128,129,54,116,36,36,23,36,38,36,52,184,123,36,136,116,52,55,55,55,
    39,102,54,54,44,195,128,127,38,195,127,128,55,52,52,52,52,54,52,55,52,
    38,36,20,106,33,9,9,11,9,25,8,8,9,1,8,11,136,98,25,9,136,90,9,17,33,33,
    20,9,9,58,36,20,12,20,20,20,12,36,136,195,128,129,17,36,12,33,36,36,9,
    27,9,27,26,36,36,160,116,9,27,27,12,34,57,1,8,51,11,25,36,160,83,33,9,
    9,9,9,9,136,116,12,54,44,54,102,38,54,34,9,33,98,25,9,4,195,128,129,38,
    36,176,195,128,127,33,17,33,18,11,9,33,36,12,34,36,34,36,39,34,12,36,
    38,33,36,33,11,31,152,195,127,129,11,9,1,9,9,20,9,34,176,195,128,127,
    38,36,9,60,10,12,36,12,36,36,36,34,11,25,192,1,71,0,233,52,54,62,30,54,
    53,9,9,30,30,27,17,136,84,76,195,126,127,27,52,55,52,54,38,52,54,38,51,
    53,54,102,53,54,54,46,54,51,54,54,52,54,54,38,54,30,38,30,52,52,54,38,
    102,160,102,52,55,62,36,20,39,55,51,3,31,54,38,60,38,54,54,38,63,39,52,
    54,52,52,36,36,39,60,36,38,60,38,39,55,52,47,195,240,161,54,52,136,195,
    132,117,29,36,195,157,122,152,195,191,139,9,195,127,128,9,195,154,82,
    38,54,195,127,128,54,144,195,128,127,33,19,136,195,125,121,160,195,151,
    105,30,160,192,1,70,0,236,11,195,145,212,3,55,160,195,128,125,52,52,36,
    3,195,127,128,136,195,137,134,27,195,129,128,176,192,7,44,2,61,27,51,
    103,54,30,94,54,53,160,195,127,128,54,54,102,54,54,94,59,54,54,51,54,
    43,54,46,29,13,24,27,1,25,25,3,27,24,25,24,11,76,25,25,0,27,1,98,12,12,
    9,9,12,12,12,17,33,32,195,128,129,25,9,195,128,129,30,30,25,25,13,29,
    27,27,83,24,27,24,11,27,24,25,27,176,194,133,132,168,69,27,25,27,54,27,
    46,30,53,51,51,46,46,38,38,54,30,1,25,11,27,25,30,30,52,51,51,54,25,136,
    98,17,128,90,25,24,43,30,27,30,46,27,30,54,27,11,176,195,129,128,54,83,
    53,53,30,25,25,43,46,36,55,54,195,128,127,25,30,48,1,9,152,84,54,30,168,
    94,54,38,53,45,51,176,85,51,51,51,43,152,85,27,27,30,27,43,27,43,43,25,
    27,30,30,43,51,51,51,30,29,45,51,1,136,195,128,130,30,46,54,55,46,46,
    54,52,55,62,52,176,102,54,25,25,30,195,129,128,54,0,11,55,52,55,38,55,
    54,52,55,55,110,54,176,102,62,103,62,55,52,55,54,51,102,102,51,27,176,
    111,36,38,39,160,116,117,116,36,36,20,12,34,39,33,106,12,36,36,116,116,
    36,57,38,34,36,60,33,36,10,18,12,34,36,20,20,36,36,115,52,36,12,34,36,
    34,160,123,36,116,36,36,36,36,36,52,60,36,39,36,36,52,63,62,52,62,39,
    38,55,46,39,23,17,160,195,127,128,9,33,34,34,33,33,33,33,12,15,54,54,
    53,46,46,54,27,30,176,194,133,127,9,106,12,55,38,38,54,30,29,36,36,20,
    38,54,62,38,38,54,31,52,52,110,38,36,52,38,36,160,117,36,36,54,36,20,
    34,36,12,1,36,36,51,51,195,129,128,52,12,38,38,36,52,57,32,36,20,12,12,
    12,12,160,116,36,36,36,34,20,12,0,9,34,9,1,12,17,33,32,33,12,17,10,176,
    195,128,127,33,12,9,26,34,12,33,144,106,136,113,9,9,17,12,9,9,33,9,9,
    11,8,11,9,38,195,128,127,9,106,98,9,9,9,8,53,54,51,11,8,11,8,8,11,25,
    24,0,25,136,97,136,195,128,129,40,3,51,136,82,8,9,11,1,25,160,82,27,3,
    9,25,195,128,129,3,25,27,3,11,8,9,1,9,9,9,30,0,9,9,11,136,98,9,25,11,
    11,27,27,24,9,1,9,12,11,11,98,9,24,9,8,192,7,56,2,231,54,55,55,55,38,
    54,160,110,52,60,52,33,20,33,36,33,12,195,127,128,10,17,17,136,90,11,
    30,27,27,30,152,84,84,3,24,13,25,192,7,216,2,195,30,62,62,63,62,60,37,
    38,62,55,62,54,102,94,53,43,51,55,117,36,60,62,94,29,116,195,127,128,
    54,36,54,36,18,33,33,12,106,20,9,32,10,115,36,51,195,129,128,20,195,127,
    128,2,33,136,106,12,8,27,29,152,77,27,3,27,4,1,12,11,8,27,62,24,27,11,
    8,9,25,33,0,25,3,51,11,128,195,128,163,11,27,51,54,152,102,51,43,53,46,
    45,51,51,29,43,43,85,168,76,51,30,30,168,85,51,59,195,129,128,51,46,30,
    52,116,36,36,52,52,36,36,60,34,20,20,12,17,160,195,127,128,30,106,10,
    12,105,34,18,160,116,34,19,25,18,33,33,10,33,20,9,8,8,43,30,25,11,128,
    195,91,184,30,176,195,128,127,160,195,128,129,30,160,195,137,103,51,53,
    36,33,136,192,0,22,2,248,38,52,160,98,3,192,7,241,2,103,36,38,34,12,10,
    25,24,27,152,94,176,102,195,141,116,29,27,51,46,36,18,144,195,54,119,
    54,54,58,9,33,24,195,130,134,55,55,33,160,195,127,128,128,90,195,133,
    126,48,111,176,195,132,142,38,33,128,195,115,141,9,19,30,54,195,130,128,
    54,116,9,152,195,113,123,48,176,195,129,128,52,55,60,55,38,38,60,38,39,
    39,8,24,195,127,128,11,0,1,25,0,24,136,195,126,128,152,195,127,130,52,
    52,55,160,90,0,11,195,136,135,30,36,195,27,233,38,52,33,11,195,128,131,
    36,195,157,54,30,38,152,195,128,129,160,195,128,126,144,195,126,127,32,
    32,195,89,54,38,60,8,195,86,144,12,19,152,195,129,132,152,195,128,129,
    34,195,106,96,55,152,195,128,129,27,17,195,111,127,26,3,52,195,116,129,
    52,52,52,36,12,9,27,27,152,195,125,131,22,33,195,128,127,25,30,176,195,
    44,180,33,13,195,114,155,55,52,8,192,7,17,2,202,27,11,51,27,27,52,58,
    60,33,36,195,162,150,30,60,136,195,86,61,15,12,36,52,55,59,54,30,54,27,
    51,10,12,8,51,1,9,195,145,133,51,51,75,9,60,184,195,132,132,25,12,176,
    195,128,129,176,195,126,130,51,53,52,33,136,195,115,135,9,1,9,1,39,52,
    52,54,94,195,119,131,88,8,3,54,62,102,52,12,176,195,124,125,11,11,30,
    2,20,184,102,195,51,129,30,30,52,17,144,195,126,114,160,82,3,11,30,176,
    117,39,195,121,123,25,195,128,129,128,85,30,29,160,116,20,195,125,134,
    50,98,106,195,127,129,128,84,51,195,129,128,38,176,195,128,127,38,195,
    128,130,160,195,116,132,9,10,33,3,27,62,54,54,195,128,111,63,57,33,24,
    152,195,127,128,11,195,145,119,36,36,160,195,127,128,136,195,128,129,
    83,84,195,128,129,152,195,147,117,9,27,31,52,195,129,128,160,195,173,
    133,25,27,27,27,195,129,128,52,38,36,36,195,65,156,12,125,12,83,27,152,
    192,2,54,1,253,54,53,51,176,94,160,195,127,128,54,102,54,52,54,60,33,
    36,54,54,30,43,46,29,27,51,54,54,55,54,38,38,29,38,38,117,60,62,62,38,
    62,39,52,102,62,54,38,52,54,52,62,55,55,38,52,54,52,117,62,52,54,38,54,
    54,38,63,63,184,117,36,63,55,38,36,38,39,36,39,39,52,39,62,38,60,52,110,
    54,52,102,176,102,54,54,102,52,51,59,102,54,30,52,46,46,62,51,54,102,
    102,176,94,54,54,54,54,46,102,30,53,30,54,51,54,38,54,54,30,30,54,176,
    103,194,128,132,38,46,160,102,53,54,46,168,94,54,53,53,45,53,54,102,43,
    54,52,54,54,54,184,94,54,30,54,53,46,52,176,102,36,52,33,36,55,54,27,
    59,46,54,54,54,52,52,38,46,29,30,38,27,52,51,30,37,53,25,25,25,24,51,
    30,62,55,38,36,54,27,195,129,128,52,38,36,52,38,152,84,25,27,52,62,51,
    25,195,128,129,30,38,54,50,34,176,195,127,128,53,29,53,38,39,36,54,27,
    54,39,48,176,195,129,128,55,33,4,195,128,129,38,195,128,127,33,57,195,
    127,128,12,38,54,54,25,27,27,54,160,195,127,128,51,62,38,20,36,51,195,
    127,127,12,9,39,36,36,195,125,128,176,84,195,127,130,30,36,36,12,12,33,
    160,116,52,195,127,128,51,30,27,30,60,36,38,33,33,10,9,33,36,36,144,116,
    12,36,36,32,0,11,11,9,9,12,12,33,33,38,33,36,9,33,9,152,195,129,128,12,
    12,144,123,20,17,17,152,195,129,128,8,27,84,11,3,136,83,1,20,12,12,18,
    34,36,36,17,17,98,10,12,136,115,19,25,25,36,136,195,128,129,39,52,33,
    33,33,11,11,51,11,176,195,129,128,43,195,127,128,11,8,9,25,8,12,22,195,
    128,127,38,38,39,36,36,184,115,12,36,144,98,17,8,33,9,12,36,60,34,116,
    12,36,160,116,116,144,116,116,115,33,33,33,33,12,10,12,9,9,11,27,1,9,
    9,3,11,25,27,9,25,9,17,12,102,51,62,62,36,36,38,36,52,38,36,33,160,116,
    36,52,36,18,33,34,20,17,33,33,16,9,30,94,54,30,25,9,12,12,10,12,176,110,
    34,12,98,25,19,195,129,128,11,195,129,128,10,12,12,12,9,12,4,60,38,30,
    54,46,30,30,152,195,129,128,34,195,128,127,33,17,160,98,33,33,9,12,9,
    36,114,10,115,9,18,98,98,136,90,9,8,12,136,195,128,129,38,20,12,18,12,
    20,12,12,20,34,36,34,17,36,12,34,36,116,36,36,9,39,52,36,33,10,36,10,
    12,9,17,17,12,10,17,18,9,9,9,105,12,12,9,98,98,9,9,9,9,9,9,9,10,9,98,
    33,17,195,128,129,22,58,10,12,33,10,10,17,33,115,12,195,127,128,12,12,
    12,144,115,9,33,136,105,33,17,9,8,17,11,9,1,9,1,3,3,40,27,27,27,3,11,
    8,0,24,3,3,3,11,3,152,76,27,27,27,27,11,27,3,27,13,43,48,0,176,98,9,25,
    24,84,11,27,11,24,27,11,48,27,43,27,51,51,53,59,45,41,16,51,152,69,27,
    24,26,160,116,160,116,160,115,36,34,10,12,9,9,27,29,27,27,84,27,54,46,
    48,9,46,30,43,40,26,17,11,195,129,128,9,33,12,34,36,12,136,115,116,9,
    9,8,30,25,17,11,44,51,1,9,11,8,11,136,98,11,8,24,24,11,8,152,83,3,27,
    3,24,29,25,27,27,84,27,84,25,24,25,24,25,27,0,9,24,25,82,0,27,27,84,27,
    195,129,128,17,33,11,3,11,152,83,27,25,25,144,115,19,195,128,129,27,27,
    27,27,27,84,30,36,43,30,27,27,27,11,11,3,24,51,27,3,83,3,128,84,3,24,
    11,8,29,54,36,38,160,84,51,27,30,30,30,54,54,54,52,54,27,41,27,11,9,9,
    12,12,9,1,1,36,34,12,9,25,27,30,27,51,51,43,43,51,29,76,51,13,27,51,51,
    46,46,54,43,53,51,51,51,54,51,9,25,25,25,83,25,24,24,152,84,6,27,51,43,
    43,51,51,27,11,0,27,9,25,84,1,24,0,25,9,17,9,98,25,12,10,9,9,9,98,10,
    90,17,27,6,27,12,8,27,136,76,51,27,152,76,27,27,27,27,27,51,27,11,9,17,
    34,9,144,98,9,1,10,12,34,12,195,127,128,11,9,160,106,12,9,20,9,9,25,27,
    27,30,152,195,129,128,39,38,27,11,27,27,27,48,30,30,84,27,46,46,54,152,
    102,45,30,152,195,129,128,52,54,84,29,25,16,29,27,30,27,43,136,195,128,
    129,30,176,195,128,127,25,43,24,25,11,25,27,43,1,160,195,127,128,11,9,
    25,8,90,25,0,11,9,25,25,36,195,127,128,8,17,9,98,9,8,17,85,17,9,10,12,
    17,195,128,126,152,192,2,54,1,253,33,195,128,129,36,20,20,160,106,12,
    136,98,17,12,33,36,10,33,9,9,11,9,17,25,9,33,9,9,8,8,8,25,1,9,8,11,11,
    27,51,29,46,46,53,51,41,195,128,129,3,8,24,25,25,27,136,84,27,27,8,30,
    1,25,11,11,0,1,27,62,27,3,1,9,16,11,11,24,8,9,0,3,3,12,33,25,27,43,11,
    27,176,83,27,27,11,9,24,84,24,83,11,27,11,24,3,3,11,136,82,0,27,11,11,
    30,29,30,30,27,30,27,27,11,3,3,27,27,24,25,27,24,27,83,25,25,27,3,0,3,
    24,25,27,25,24,25,27,11,24,25,27,8,9,97,9,12,10,11,30,195,128,127,1,9,
    1,24,25,1,25,152,90,25,0,1,24,11,11,3,3,41,24,9,12,8,24,11,152,83,11,
    9,25,25,24,1,24,8,8,8,1,1,1,25,12,195,127,128,11,27,27,3,3,195,129,128,
    46,54,55,54,54,62,63,63,62,36,52,195,127,128,62,39,62,63,184,110,33,195,
    128,129,55,55,54,38,62,62,102,38,36,52,57,195,128,129,62,38,54,29,48,
    11,8,9,24,11,11,136,84,11,136,75,9,9,9,25,3,3,3,11,30,25,25,27,11,11,
    11,12,36,36,9,25,9,25,25,3,11,3,8,9,9,27,9,1,11,90,4,195,127,128,11,195,
    128,127,152,192,2,54,2,16,36,51,54,1,192,2,91,2,237,52,39,53,54,54,30,
    51,3,12,9,9,19,195,129,128,11,136,195,132,143,36,38,43,128,195,124,129,
    37,25,195,127,131,62,25,195,125,132,102,27,51,25,12,33,160,195,128,137,
    12,38,152,195,130,126,160,195,131,129,27,152,195,122,130,12,52,53,38,
    27,9,195,130,127,38,38,152,195,131,130,54,54,46,41,9,30,51,8,15,19,12,
    10,160,195,123,132,62,27,195,129,128,136,195,129,130,36,52,195,127,128,
    51,25,195,127,129,38,48,195,136,129,27,11,136,195,129,128,184,195,124,
    129,36,61,54,27,25,11,17,195,129,133,52,46,1,195,134,128,25,160,195,125,
    129,160,195,129,128,52,38,160,195,127,128,27,195,128,127,152,195,129,
    131,36,176,195,129,128,9,27,152,195,126,128,27,195,129,131,36,36,63,160,
    195,127,128,27,3,152,195,133,131,34,38,160,195,129,127,60,38,38,36,60,
    36,37,27,27,3,27,27,83,83,195,127,127,48,195,141,135,33,25,27,52,195,
    138,130,27,152,84,30,36,36,160,195,130,129,36,36,39,124,52,33,25,195,
    128,129,3,195,130,128,11,27,27,76,27,195,127,128,34,160,124,195,124,128,
    152,195,137,128,84,195,130,129,144,195,129,129,39,15,34,11,76,152,195,
    134,128,152,195,146,126,43,6,27,184,195,131,127,36,195,153,108,51,27,
    27,51,43,195,129,128,51,43,195,129,128,36,36,36,4,20,144,195,128,127,
    160,195,128,133,12,12,195,127,128,11,30,30,52,195,130,122,54,195,129,
    130,160,116,36,9,11,29,25,152,195,249,143,27,152,195,130,128,52,195,137,
    132,25,12,3,11,25,27,27,176,195,127,128,184,116,38,36,52,176,192,2,219,
    2,4,11,48,176,195,127,130,152,195,128,129,184,195,129,128,17,136,195,
    139,124,11,24,11,152,195,127,128,176,195,127,128,53,51,52,33,12,12,60,
    36,195,120,128,27,52,192,2,111,3,50,27,152,195,128,129,36,60,11,195,128,
    127,160,195,140,123,25,25,27,27,152,195,128,127,45,27,152,195,129,128,
    46,52,54,54,36,39,36,60,36,176,116,195,126,128,27,27,3,3,27,195,127,128,
    51,195,128,127,27,43,27,195,129,128,52,39,36,116,160,116,36,195,129,129,
    160,195,136,128,144,195,130,129,36,36,36,36,18,152,195,128,129,27,25,
    24,24,27,24,25,25,27,11,1,25,192,1,246,2,1,136,195,128,129,22,62,195,
    128,129,160,195,128,130,51,195,127,125,8,195,131,128,60,33,27,195,23,
    68,52,136,195,110,20,55,9,192,2,158,1,199,33,20,9,36,54,53,27,195,16,
    114,30,160,195,90,102,12,9,195,179,75,60,34,84,152,195,125,134,52,136,
    195,135,122,39,38,54,52,9,9,11,152,195,126,134,38,152,195,128,127,136,
    195,137,132,3,6,195,129,128,184,195,129,128,176,195,118,127,52,54,38,
    30,57,195,128,129,54,1,25,11,136,98,136,195,203,87,136,195,128,129,38,
    51,25,195,68,179,46,54,52,136,195,127,126,144,195,139,129,30,60,136,195,
    85,149,25,43,176,195,129,127,52,160,195,109,111,36,36,12,36,12,12,12,
    36,116,116,51,195,129,128,60,36,38,36,52,38,160,116,52,36,36,52,52,52,
    52,52,176,116,38,45,36,176,195,128,127,160,116,36,36,36,36,36,12,33,33,
    27,3,27,27,9,27,11,3,24,25,25,27,11,27,27,11,83,0,27,3,27,27,25,30,3,
    152,84,27,29,27,43,43,51,54,27,195,163,149,39,38,39,39,36,20,33,3,25,
    27,24,152,85,195,155,120,36,60,51,54,52,52,195,127,128,51,84,27,27,27,
    30,30,39,34,36,36,36,36,36,38,36,36,33,12,36,52,36,20,36,36,116,36,8,
    128,81,27,24,84,27,11,24,27,84,30,27,27,25,84,152,195,127,129,152,195,
    129,132,55,33,128,195,171,132,11,27,27,27,46,52,36,60,12,39,9,195,134,
    126,30,51,62,52,12,136,98,195,144,133,11,176,195,128,130,54,27,10,195,
    128,133,54,33,136,195,130,132,136,195,128,129,30,36,136,195,128,131,30,
    55,36,11,136,195,127,134,33,152,195,128,131,30,50,195,137,127,52,136,
    195,114,135,44,33,195,113,135,60,19,13,195,95,120,11,30,160,195,56,75,
    30,27,52,36,34,9,27,152,192,1,130,1,148,13,195,136,129,160,195,127,128,
    11,176,195,128,124,52,136,192,2,130,2,111,9,9,25,13,30,119,176,195,118,
    110,9,19,11,13,8,27,46,39,60,38,176,192,2,29,1,191,128,73,6,54,54,38,
    36,36,192,2,103,3,8,25,84,152,85,27,62,144,195,129,127,160,116,176
};

/*  MAPDRAW  --  Decode map data, scale, and output vectors.  You call
		 this function with:

		    mapdraw(<X_pixels>, <Y_pixels>, <vectorproc>);

		 Where X_pixels and Y_pixels specify the size  of  the
		 desired image area, and vectorproc is a function that
		 receives the individual  vectors  of  the  map.   The
		 image	is  scaled to look best when X_pixels is twice
                 Y_pixels, but you're free to use any aspect ratio you
		 like.	 The  vectorproc  function  should be declared
		 like this sample:

		    void vectorproc(x1, y1, x2, y2)
		      int x1, y1, x2, y2;
		    {
                        printf("Draw from %d,%d to %d,%d.\n:,
			    x1, y1, x2, y2);
		    }

		 The  pixel at the upper left of the image is 0,0, and
		 addresses increase to	the  right  and  downward.   A
		 sample call on mapdraw would then be:

		    mapdraw(512, 256, vectorproc);
*/

void mapdraw(xsize, ysize, vector)
  int xsize, ysize;
  void (*vector)();
{
    int x1 = -32700, y1 = -32700, x2, y2;
    unsigned char *maptr = mapdata,
		  *mapend = mapdata + sizeof mapdata;

    while (maptr < mapend) {
	static int xdec[] = {-1, 0, 1, -1, 1, -1, 0, 1};
	static int ydec[] = {-1, -1, -1, 0, 0, 1, 1, 1};
	int b = *maptr++;

#define unfit(x, n) ((x) - ((1 << (n)) / 2));
#define pxy(x,y) ((int)(((x)*(long)xsize)/2048L)),((int)(((y)*(long)ysize)/1024L))

	switch (b >> 6) {
	    int d;

	    case 0:
		d = (b >> 3) & 7;
		x2 = x1 + xdec[d];
		y2 = y1 + ydec[d];
		vector(pxy(x1, y1), pxy(x2, y2));
		x1 = x2;
		y1 = y2;
		d = b & 7;
		x2 = x1 + xdec[d];
		y2 = y1 + ydec[d];
		vector(pxy(x1, y1), pxy(x2, y2));
		break;

	    case 1:
		x2 = x1 + unfit((b >> 3) & 7, 3);
		y2 = y1 + unfit(b & 7, 3);
		vector(pxy(x1, y1), pxy(x2, y2));
		break;

	    case 2:
		d = (b >> 3) & 7;
		x2 = x1 + xdec[d];
		y2 = y1 + ydec[d];
		vector(pxy(x1, y1), pxy(x2, y2));
		break;

	    case 3:
		switch (b & 077) {
		    case 0:   /* Long move */
			x2 = *maptr++;
			x2 = (x2 << 8) | *maptr++;
			y2 = *maptr++;
			y2 = (y2 << 8) | *maptr++;
			break;

		    case 1:   /* Long draw */
			x2 = *maptr++;
			x2 = (x2 << 8) | *maptr++;
			y2 = *maptr++;
			y2 = (y2 << 8) | *maptr++;
			vector(pxy(x1, y1), pxy(x2, y2));
			break;

		    case 2:   /* Medium draw */
			x2 = *maptr++;
			x2 = x1 + unfit(x2, 8);
			y2 = *maptr++;
			y2 = y1 + unfit(y2, 8);
			vector(pxy(x1, y1), pxy(x2, y2));
			break;

		    case 3:   /* Medium move */
			x2 = *maptr++;
			x2 = x1 + unfit(x2, 8);
			y2 = *maptr++;
			y2 = y1 + unfit(y2, 8);
			break;
		}
		break;
	}
	x1 = x2;
	y1 = y2;
    }
}
