.\" @(#)xsky.man	2.1 4/18/94
.TH xsky 1X "18 Apr 1994"
.SH NAME

xsky \- an interactive sky atlas for X
.SH SYNTAX

.B xsky
[-I] [-abcfgmpsLNPSZ] [-OBAFGKM] [-\fItoolkitoption\fP ...]
.SH DESCRIPTION
.PP
\fIXsky\fP is an interactive sky atlas
running under the X11 window system.
It allows interactive viewing of the sky and construction of star charts
which may be printed on any PostScript printer.
.PP
The sky is displayed with north straight up and oriented as seen by the
naked eye.  Stars are sized according to their apparent magnitude and their
colors correspond to the spectral class, as given by the relevant catalog.
.PP
Non-stellar objects are depicted as circles, boxes, and ellipses.  Objects
from the quasar catalog are circles; objects from the RNGC catalog are
elliptical if galaxies, circular if clusters, and boxes if nebulae.
.PP
.I Xsky
uses Athena widgets and the Xt toolkit exclusively, so it should run on any
X platform.
This also means that most of the familiar X command line options should
work, although \fIxsky\fP does like to pick its own fonts for object
identification text.
.PP
Environment variables control the location of the catalog data files and
the binary dump files created by \fIxsky\fP.  These binary dump
files are the in-core databases that \fIxsky\fP creates for each catalog.
If this file exists for any catalog, it will be read in place of building
the binary database for that catalog.  If the file exists with a size of
zero, the catalog will be read, and the binary database will be built and
dumped to the file for use by later invocations of \fIxsky\fP.
.SH OPTIONS
.PP
\fIXsky\fP accepts all of the standard X Toolkit command line options
as well as the following:
.TP 8
.B \-h
Print a very terse (in all actuality useless) usage message.
.TP 8
.BI \-a " font"
Set the Latin font for constellation area labelling to \fIfont\fP.
This font is used only for constellation names.
.TP 8
.B \-b
Draw the sky in black-and-white mode even if this is a color display.  The
background remains black, but stars are white instead of colored by spectral
class.
.TP 8
.BI \-c " catlist"
Set the initial list of displayed catalogs to \fIcatlist\fP.  This is a
comma-delimited list, with each catalog being specified by its menu name
in the catalog selection menu.
.TP 8
.BI \-f " font"
Set the Latin font for object labelling to \fIfont\fP.
This font is used for all object names which are not Greek letters.
.TP 8
.BI \-g " font"
Set the Greek font for object labelling to \fIfont\fP.
This font is used for Bayer
designations of stars from the Yale Bright Star Catalog.
.TP 8
.BI \-m " mag"
Set the initial limiting magnitude to \fImag\fP.  Stars dimmer than this
apparent magnitude will not be displayed.
.TP 8
.BI \-p " position"
Set the initial position of the display to \fIposition\fP.  This is a string
in the format <nnh hhm nns.nnn, +/-nnd nn' nn".nn> specifying the right
ascension and declination of the display center.  If specified, this position
defines the center points of the vertical and horizontal scrollbars.
.TP 8
.BI \-s " scale"
Set the initial display scale to \fIscale\fP pixels per degree.
.TP 8
.BI \-u
Turn the display "upside-down" for the folks in the Southern Hemisphere.
.TP 8
.B \-I " filename"
Read the file named \fIfilename\fP for initialization of xsky to a previously
saved state.
.TP 8
.B \-L
Start with a large display.  After positioning the display on the
screen, \fIxsky\fP resizes to fill the entire screen.
.TP 8
.B \-N
Operate in night mode, to preserve dark adaptation.  The xsky display uses
red stars and text.  Note that you'll need to specify "-bg black -fg red" as
well as this option, and you will probably need to diddle your window manager
colors as well.
.TP 8
.BI \-OBAFGKM " color"
Each of these option letters represents a stellar spectral class.
Specifying one of these options changes the color of the stars in that
spectral class to \fIcolor\fP.  Stars of class W are represented as O, and
stars of classes C, R, N, and S are represented as M.  Unknown or
indecipherable spectral classes are rendered as white.
.TP 8
.BI \-P " flag"
Control the appearance of the continuously-updating pointer position display.
If \fIflag\fP is "on", the display appears; if \fIflag\fP is anything
else (e. g., "off"), the display does not appear.
.TP 8
.BI \-S " flag"
Control the existence of the display vertical and horizontal scrollbars.
If \fIflag\fP is "on", the scrollbars appear; if \fIflag\fP is anything
else (e. g., "off"), the scrollbars do not appear.
.TP 8
.BI \-Z " flag"
Control the existence of the zoom (display magnification) slider.  If
\fIflag\fP is "on", the zoom slider appears with
the default maximum magnification value (the default is 100,000 unless
a different value is specified in the XSky resource file).
If \fIflag\fP is all
numeric, the zoom slider appears and the value is the zoom slider maximum
magnification in pixels per degree.
Specifying anything else for \fIflag\fP (e. g., "off") suppresses the
zoom slider.
.TP 8
.B \-bin
Terminate after reading the text catalogs and building the binary databases.
All contact with the X Window System is avoided; this option allows building
the binary databases from an ordinary terminal.  This option must be used
alone; it will not work (nor does it make sense) with any other options.
.SH CONTROL MENU
.TP 8
.B "Info"
Brings up a panel showing the size and grid spacing of the display.  There
are also two text boxes containing information which may be edited to
change the values of magnitude limit (for stars) and display scale.  Clicking
the Apply button in the panel (or pressing return in either of the text
boxes) causes the new values of magnitude limit and display scale to be
used in drawing the sky display.
.TP 8
.B "Catalogs"
Brings up a menu which allows selection of the catalogs to be displayed.
.TP 8
.B "Zoom In"
Increases the magnification of the display.  Each zoom step increases
the display scale by 20%.
.TP 8
.B "Zoom Out"
Decreases the magnification of the display.  Each zoom step decreases
the display scale by 20%.
.TP 8
.B "Grid"
Draws lines of right ascension and declination on the sky display.  The "Info"
display gives the spacing of the lines.  The lines are unlabelled, but the
spacing and display center will allow determination of the line coordinates.
.TP 8
.B "Boundaries"
Draws constellation boundary lines on the sky display.
.TP 8
.B "Hide IDs"
Removes all object identifications from the display.  They may be recalled
by toggling "Hide IDs" again.  IDs are created by clicking the center mouse
button on an object; see below.
.TP 8
.B "Erase IDs"
Erases all object identifications from the display.  Once erased,
identifications may not be recalled - even "Undo" won't bring them back.
.TP 8
.B "Find"
Brings up a panel with a text box into which the name or designation of
an object may be edited.  Clicking the Find button on the panel (or pressing
return in the text box) will then
cause the display to be moved to that object if it can be identified by the
given name or designation.  At present, only stars can be located by name.
The file "catalogs.doc" documents the object designations that can be
entered on the Find panel.
.TP 8
.B "User Label"
Brings up a panel with a text box into which a user-supplied label
may be edited.  Clicking the Label button on the panel (or pressing return
in the text box) will then
pop down the panel and arm the middle mouse button.  Pressing and holding
the middle mouse button while in the sky display draws a box which can be
positioned by mouse motion.  When the button is released, the user-supplied
label is placed at the box location.  Note that, unlike object ID labels,
user-supplied labels are not tied to any object and will therefore move if
the display scale is changed.
.TP 8
.B "Chart"
Brings up a panel with a text box into which a user-supplied filename
(defaulting to "starchart.ps") may be edited.  Clicking the Create button
on the panel (or pressing return in the text box) will then write a
PostScript representation of the display
to the given file, which may be printed on any PostScript
printer for an exact representation of the current sky display, including
identifying text and grid and boundary lines.
.TP 8
.B "Undo"
Reverses the last action taken to change the sky display.  This is intended
primarily to undo rubberbanding, but it will undo other actions.
Moving and resizing the display through the window manager is not reversible
through undo.  With those exceptions, you can undo all the way back to the
beginning of execution.
.TP 8
.B "Quit"
Leave xsky.
.SH INTERACTION
.PP
The following interactions allow manipulation of the sky display.  Note that
the mouse cursor is the original Starship Enterprise, flying toward the top
of the screen.  The forward tip of the Enterprise's "saucer section" is the
cursor hotspot.
.IP \(bu
The horizontal scrollbar at the bottom of the sky display scrolls the sky
due east/west.
.IP \(bu
The vertical scrollbar at the right of the sky display scrolls the sky
due north/south.
.IP \(bu
Clicking the left mouse button on a displayed object brings up the catalog
information for that object.
.IP \(bu
Pressing and holding the center mouse button on a displayed object brings up
an outline box which follows the mouse; releasing the center button replaces
the box with text identifying the object clicked on.
.IP \(bu
Pressing and holding the center mouse button, while
depressing the Ctrl key, brings up an outline box which follows the mouse;
releasing the center button replaces the box with text identifying the
constellation the pointer was in when the button was pressed.
.IP \(bu
Clicking the center mouse button with the Shift key depressed removes the
identifying text under the pointer.
.IP \(bu
Clicking the right mouse button on any point in the sky display recenters
the display on that point.
.IP \(bu
Pressing and holding the left mouse button with the Shift key depressed
begins a rubber-band box action.  Releasing the button causes the outlined
area to expand to fill the display.
.SH OTHER ACTIONS
.PP
The "Display center" at the top of the main display is an editable text
buffer.  To move to a known location on the sky, simply edit this buffer
to contain the desired right ascension and declination, following the
general format shown in the buffer.  Hitting the return key while in the
buffer causes the sky display to be updated.
.SH FILES
.TP 10
$YBS_PATH/ybs.dat
The Yale Catalog of Bright Stars
.TP
$YBS_BIN_PATH/ybs.bin
A dump of the binary in-core database for the YBS catalog
.TP
$RNGC_PATH/rngc.dat
The Revised New General Catalog of Non-Stellar Objects
.TP
$RNGC_PATH/rngc_desc.tab
RNGC catalog description abbreviations
.TP
$RNGC_BIN_PATH/rngc.bin
A dump of the binary in-core database for the RNGC catalog
.TP
$QSO_PATH/qso.dat
The Revised Optical Catalog of Quasi-Stellar Objects
.TP
$QSO_BIN_PATH/qso.bin
A dump of the binary in-core database for the QSO catalog
.TP
$BOUNDARY_PATH/boundaries.dat
A corrected version of the 1989 Constellation Boundary Data
.TP
$BOUNDARY_BIN_PATH/boundaries.bin
A dump of the binary in-core database for the Constellation Boundary Data
.TP
$STARNAME_PATH/starnames.dat
Common star names by HR number for use with the YBS database
.PP
The file xskyenv defines a number of other environment variables for additional
catalogs supported by, but not shipped with, xsky.
.SH BUGS
.PP
"Erase IDs" cannot be undone.
.SH AUTHOR

Terry R. Friedrichsen, Sunquest Information Systems. (terry@venus.sunquest.com)
.SH ACKNOWLEDGEMENTS
.PP
The precession algorithm and precession constants are from PRECESS.BAS,
written by PC Leyland.
.PP
Brian Wing greatly sped up the screening of objects to determine whether
they fall in the current display.
.PP
Jim Sharpe was the original beta tester, making many useful suggestions
and improving the user interface.
.PP
The supplied object databases are stripped-down versions of databases
supplied by the National Space Sciences Data Center (NSSDC) at the Goddard
Spaceflight Center in Greenbelt, Maryland, which is administered by
the National Aeronautics and Space Administration (NASA).
