.nr PO 1.25i
.DA
.nr LL 6.5i
.TL
xsky \*- An Interactive Sky Atlas for X
.AU
Terry R. Friedrichsen
.sp 2
.AB
.I
.UL xsky,
an interactive sky atlas for the X Window System environment,
is described.
The familiar graphical user interface tools of X, such as command
buttons, menus,
scrollbars, sliders, pointer action, and rubberbanding can be used to view
any portion of
the sky at any magnification and scale, with any combination of
several different astronomical object catalogs displayed on the screen.
Coordinate grid lines of right ascension and declination,
as well as constellation
boundaries, may be turned on and off at any time.  Objects can be located
by name or catalog designation and labelled on-screen, and full catalog
information is available on any object at any time.
.AE
.R

.nr PD 2v
.SH
Overview of Operation
.PP
.UL xsky
reads in a set of available catalogs, and displays an initial
view of the sky.
As distributed, this view shows a 500x500 pixel sky,
at a scale of 20 pixels per degree,
with a stellar magnitude limit of 8.0, centered on Alnilam (the middle star
in Orion's belt).  These values were chosen so the familiar constellation
of Orion appears in the display on startup.
The view will contain stars from the Yale
Catalog of Bright Stars and the Revised New General Catalog
of Non-Stellar Objects.
.PP
Stars are plotted with colors corresponding to their spectral class,
and sizes corresponding to their apparent magnitude.
(On a monochrome display, the stars can be any color you want,
as long as you want white.)
Non-stellar objects are drawn in several shapes according to the
type of object represented.
.PP
Above the sky display is a text box giving the right ascension
and declination of the center of the display.  Unless turned off
by the user, there is a vertical scrollbar to the right of the
sky display and a horizontal scrollbar below.  These scrollbars
can be used for rapid repositioning of the display anywhere on
the sky.
.PP
To the right of the vertical scrollbar is a slider which controls
the display magnification (this may be disabled under user control).
The display may be zoomed out to
view the entire sky, or zoomed in to high magnification of a
small area of the sky.
.UL xsky
is capable of infinite magnification or compression.
.PP
As you move the pointer into the sky display, the pointer
shape changes to the Starship Enterprise.  The position display
at the lower left now becomes active, showing the right ascension
and declination of the pointer position on the sky.  (The position
display may be turned off if desired.)
.PP
Down the left side of the
.UL xsky
window, there are a number of command buttons, the purposes of which
are described in detail below.  For now, note that if you click on the Info
button, a subwindow will pop up noting the current limiting magnitude
and scale of the display.  Click on the Cancel button to pop this
display back down.  The Undo button will reverse the last action you
took to alter the sky display, so you can always go back if you get
somewhere you didn't intend.
.PP
If the left pointer button is clicked while pointed at an object in the
sky display, a formatted expansion of the catalog information
for that object will pop up.
Click the Acknowledged button to remove this display
and resume normal operation.
.PP
A click of the right button will recenter the display on the position
of the pointer.  When the area of interest is centered, you can change
the magnification with the Zoom In / Zoom Out command buttons or
the magnification slider.
.PP
One interesting thing to do is to click on the Catalogs button to
bring up the catalog selection menu.  Turn off all but one catalog
by clicking on the catalog buttons until just one button is highlighted.
Then move the pointer out of the menu; it will pop down and the sky
display will change to show just that catalog's objects.  Now move the
magnification slider to the bottom to give minimum magnification.
The sky display will change again, showing the entire sky in a circle
in much the same manner as a fisheye lens.
Note the distribution of
objects; if you left the YBS catalog button highlighted, see how the YBS
objects clearly define the Milky Way, and if you selected the RNGC catalog,
notice how the RNGC objects tend to avoid areas just above and below the
plane of the Milky Way.
.PP
This should be enough to get you get started with
.UL xsky.
Have fun!

.SH
Installing
.UL xsky
.PP
See the file "BuildInstall" for complete and excruciatingly detailed
instructions for building and installing
.UL xsky.
The following is a brief overview.
.PP
The file "catdefs.h" should be edited to include definitions for all
the catalogs that are available locally.  As distributed, only the
catalogs included in the
.UL xsky
distribution are enabled.  Then build
.UL xsky
using the Imakefile or Makefile.std.
.PP
.UL xsky
requires a number of environment variables in order to locate the
various astronomical catalogs needed.  These are defined by the
executable script
"xskyenv"; you should edit this file to uncomment the lines
corresponding to any additional catalogs
you have available beyond those distributed with
.UL xsky
itself.
The xxx_PATH variables specify the locations of the text catalogs, and
the xxx_BIN_PATH variables give thelocations of the corresponding
binary databases (see below).
If the requisite environment variable is not set,
.UL xsky
will look for the needed file in the current directory.  Any "no such
file" errors are fatal to the application.
Under the C shell, "source xskyenv" will set up the
environment variables as required.
.PP
Startup takes about 11 seconds on a 20-SPECmark DECstation 5000/200;
.UL xsky
must inhale the entire YBS, RNGC, and QSO catalog texts, do some sorting,
plot a bunch of stars, and then paint all that on the screen.  This time
is lengthened if additional catalogs are available.
Startup goes a lot faster (about 4 seconds on the same machine) if
.UL xsky
has previously saved binary copies of the in-core databases it builds
from the text version of the catalogs.  Without saved binary databases,
.UL xsky
must read and process the text catalogs every time it is started.
.PP
The binary databases are located through environment
variables of the form xxx_BIN_PATH, which are set up by xskyenv, as
noted above.
.UL xsky
will automatically save the binary databases if the
corresponding ".bin" files are present and empty.
The executable file "makebin"
will create empty copies of these files in the required locations;
this is done to ensure that
.UL xsky
has access to the locations specified.
The "-bin" option (which should be used with no other options) tells
.UL xsky
to build and save the binary databases, and then exit.
Subsequent invocations of
.UL xsky,
without the "-bin" option, will read the binary files, if available,
rather than re-reading the text versions of the catalogs.
.PP
The provided X resource file "XSky" is necessary to the proper operation
of
.UL xsky.
If X is unable to locate this file, the command buttons will have generic
labels such as "panelbutton5", and the application will be useless.
Place the XSky file in the directory containing other X application default
files, or define the environment variable XAPPLRESDIR to point to the
directory in which XSky is located.
.PP
The distribution includes an icon pixmap file, "xsky_icon", which should
be placed in the icon bitmap directory or in the directory pointed to by
XAPPLRESDIR.
.PP
Due to the large size of the catalog files and the binary databases,
it is probably wise to install
.UL xsky
on a system-wide basis if a number of users will be accessing it.
Read-only access to the "*.dat" and "*.tab" files  will be required,
as will execute-only access
to the
.UL xsky
executable itself.
.PP
Additionally, the file "xsky.man" is a man page for the application,
and the "*.doc" files will also be useful to users, as will this document
itself (in either or both the ".ms" and .ps" forms).  The file
"usercat.example" should
also be available.

.SH
Catalog Availability
.PP
.UL xsky
makes use of machine-readable astronomical object catalogs made
available by the National Space Sciences Data Center (NSSDC), located at the
Goddard Spaceflight Center in Greenbelt, Maryland, which is
administrated by the National Aeronautics and Space Administration.
Thanks are due to them for providing this much-needed data
distribution service.
.PP
Supported catalogs are (abbreviations used by
.UL xsky
are in parentheses):
.nr PD 1v
.IP a) 5
the Yale Catalog of Bright Stars (YBS)
.nr PD 0v
.IP b) 5
the Revised New General Catalog of Non-Stellar Objects (RNGC)
.IP c) 5
the Revised Optical Catalog of Quasi-Stellar Objects (QSO)
.nr PD 2v
.PP
Support is included  for the following catalogs, but the catalogs themselves
are not included in this distribution:
.nr PD 1v
.IP d) 5
the Smithsonian Astrophysical Observatory Star Catalog (SAO)
.nr PD 0v
.IP e) 5
the General Catalog of Variable Stars (VAR)
.IP f) 5
the Washington Catalog of Double Stars (DBL)
.nr PD 2v
.PP
Support is included for the following catalogs on the NASA Astronomical Data
Center CD-ROM:
.nr PD 1v
.IP g) 5
the Bright Star Catalog, 5th revised edition (BSC5)
.nr PD 0v
.IP h) 5
the Smithsonian Astrophysical Observatory Star Catalog, J2000 (SAOJ000)
.IP i) 5
the Washington Catalog of Double Stars (WDS)
.IP j) 5
the General Catalog of Variable Stars (GCVS)
.IP k) 5
the New General Catalog of Nebulae and Clusters - 2000.0 (NGC2000)
.IP l) 5
the Uppsala General Catalog of Galaxies (UGC)
.nr PD 2v
.PP
Please note that catalogs (a) - (f) are supported only in the abridged
versions available as part of the
.UL xsky
distribution.  Catalogs (a) -
(c) are distributed with
.UL xsky,
and catalogs (d) - (f) are available
separately via anonymous FTP.  Catalogs (g) - (l) are handled by
.UL xsky
in precisely the form in which they are recorded on the CD-ROM distributed
by the Astronomical Data Center of the NSSDC.
.PP
You will also find the constellation boundaries file "boundaries.dat"
included in the
.UL xsky
distribution.  This file is almost, but not quite, identical to the
boundaries database on the CD-ROM.  The CD-ROM version has a couple
of bugs: the northern boundary of Cepheus goes the wrong way around
the pole, neatly including Polaris in the constellation, and a section
of boundary line between Serpens and Ophiuchus is placed incorrectly
in the Ophiuchus boundary list.  Additionally,
there is a bogus boundary point defined exactly at the South Celestial
Pole, ostensibly to aid some algorithms in processing the boundary data.
Of course, this screws up algorithms that don't require such crocks; I
suggest that the algorithms be fixed rather than fudging the data.  All
of these defects are repaired in the distributed boundaries database.
.PP
Additionally,
.UL xsky
supports a user catalog; there is an example in the
file usercat.example, and the format is documented more precisely
in usercat.doc.  The intention of the user catalog is to enable the
addition of comets, asteriods, or other transient objects such as
novae and supernovae, to create customized finder charts.

.SH
Command Button Functions
.IP Info 12
.nr PD 1v
The Info button brings up a panel containing information about
the sky display.  The size of the display in degrees is given, and if
right ascension and declination grid lines are turned on, their spacing
is given here.
.IP
The panel contains two editable text boxes, one for the current
limiting magnitude, and the other for the current display scale, in pixels
per degree.  Edit either or both of these text boxes (with the familiar
EMACS editing keystroke commands) and click the Apply button; this will cause
these values to be updated, and the sky display will change to reflect
the new values.  If these
fields are mistakenly edited, click Cancel to ignore the modifications.
If no changes are made to the fields, click either Apply or Cancel to
pop down the Info panel with no effect on the sky display.
.sp
.IP "Catalogs"
The Catalogs button brings up a menu showing the various catalogs that
are available; currently-selected catalogs (whose objects are drawn
on the sky display) will be highlighed.  Click
a catalog button to include or exclude the corresponding catalog; move
the pointer out of the menu box to pop down the menu and update the sky
display with the new set of catalogs.
.sp
.IP "Zoom In"
The Zoom In button increases the display scale (which increases the
magnification) by 20% each time it is clicked.  The display center
position remains unchanged.
.sp
.IP "Zoom Out"
The Zoom Out button decreases the display scale (which decreases the
magnification) by 20% each time it is clicked.  This means that a Zoom Out
does not precisely reverse the effect of a Zoom In.  You would not be entirely
mistaken if you considered this to be a defect.  The display center
position remains unchanged.
.sp
.IP Grid
The Grid button turns the display of coordinate lines of right ascension and
declination on or off.  If the grid is enabled (a coordinate grid
appears on the
sky display), the Grid button is highlighted.  The spacing of the coordinate
lines is adjusted to match the display scale, so a grid will always be
visible when enabled.
.sp
.IP Boundaries
The Boundaries button turns the display of constellation boundaries on or
off.  If the boundaries are enabled (the boundaries appear on the sky
display), the Boundaries button is highlighted.  Note that because of
the position and/or scale of the sky display, boundary lines will not
necessarily be visible.
.sp
.IP "Hide IDs"
The Hide IDs button temporarily removes any object labels from the display.
When the button is highlighted, IDs are removed.  A second click of the
button will restore the IDs to the sky display.
.sp
.IP "Erase IDs"
The Erase IDs button permanently removes any object labels from the display.
There is no method of recovery; even Undo will not reverse the erase action.
For safety, this function is inhibited if Hide IDs is on.
.sp
.IP Find
The Find button brings up a panel containing an editable text box into
which the name or catalog designation of an object may be entered (up to
50 characters in length), with the
usual EMACS editing.  Click the panel's Find button when the object name
is entered;
.UL xsky
will recenter the sky display on the named object; if the object is not found,
.UL xsky
will ring the bell, and the display will not change.
Refer to the file "catalogs.doc" for a description of the recognized object
name formats for each of the various catalogs.
.IP
.UL xsky
will search the enabled catalogs first, followed by the disabled catalogs,
and finally the user-supplied catalog, if any.  If the object is found in
a disabled catalog, no object will be visible at the center of the display
until the correct catalog is enabled.
.sp
.IP "User Label"
The User Label button brings up a panel containing an editable text box
into which any text, up to 20 characters in length, may be entered.  Click
the Cancel button to cancel the user label action; click the Label button
to cause the labelling action to be armed for use.
.IP
After the Label button is clicked, press and hold the middle pointer
button while in the sky display.  An empty box the size of
the specified
label appears, and will follow the pointer around the display.  Release
the button and the box disappears, with the actual text of the label taking
its place.
.sp
.IP Chart
The Chart button brings up a panel containing an editable text box into
which a filename may be entered.  Alternately, if the entry begins with the
character "!", the rest of the entry is a UNIX command to be executed.
.UL xsky
opens the file, or a pipe to the command, and writes PostScript code which
reproduces the sky display, including labels,
coordinate grid lines, and constellation
boundaries, if enabled.  An informational header is produced at the top.
.IP
The file is suitable for printing on a PostScript printer.  A useful example
of a command entry is "! lpr -Ppostscript", which causes the chart to be
printed directly rather than being written to a user file (assuming that
a "postscript" printer is defined).
.sp
.IP Undo
The Undo button provides a multi-level undo facility, reversing previous
user actions which modified the center position, size, scale, or magnitude
limit of the sky display.  This is perhaps most useful for reversing the
effects of an errant rubberband action.
The depth of Undo actions remembered by
.UL xsky
is essentially unlimited.  If no undo is available,
.UL xsky
sounds a bell.
Undo has no effect on grid or boundary lines, and no action involving
object labelling can be undone.
Window manager movement of the application
window also cannot be undone.
.sp
.IP Quit
After a demonstration of
.UL xsky,
everyone is relieved to see me click this button.
.nr PD 2v

.SH
Other Functions in the Main Window
.PP
At the top of the main window, there is a text field labelled
"Center", which shows the current right ascension and declination of
the center of the sky display.  This text field is editable in the
usual EMACS style;
if modified (according to the format given in the
description of the "-p" command line option below),
the sky display will move to the
specified location when the return key is depressed
while in the editing box.
.PP
If enabled, the vertical and horizontal scrollbars, located to the
right and below the sky display, will jump-scroll
(not smooth-scroll) the display to a new position depending on where
the scrollbar was clicked.  The size of the scrollbar thumb is
intended to give a rough indication of how much of the total sky is
visible, and the thumb's position portrays the location of the area
being viewed, relative to the initial display position.
.PP
The zoom slider at the right of the sky display, if present, will
incrementally (not smoothly) change the
magnification of the display.  The lowest magnification is one pixel
per degree; the highest magnification, settable in the resource file
or on the command line, defaults to 25000 pixels per degree if not
otherwise specified.
.PP
In the lower left of the main window are two non-editable text fields
labelled "Position" (this may be disabled under user control).  These
fields contain the right ascension and declination of the pointer position
while the pointer is within the sky display, and continuously update as
the pointer moves through the display.

.SH
Pointer Actions in the Sky Display
.PP
.UL xsky
assumes the use of a three-button pointer.  However, the third (right) button
has only one function, which is also available on the left button in
combination with control-shift, so a two-button pointer could be used
someday.  One-button pointers are totally unsupported.
.sp
.nr PD 1v
.NH 1
Catalog data for an object
.PP
The unshifted function of the left button is to bring up catalog data for
the object at the pointer hotspot.  Click the button to bring up the
information panel, which has an Acknowledged button to pop down the panel.
(If autopopdown is set to True in the resource file, the panel will also
pop down if the pointer is moved out of the panel.)
.PP
For the YBS catalog, stars have a list of common names.
For the RNGC catalog, objects include the
Messier number, if any, and galaxies have the NGC description expanded
into English text (more or less; the authors of the new NGC
descriptions quite bogusly and unashamedly used ambiguous notations,
and failed to document a number of the abbreviations they used -
.UL xsky
does the best it can).
.sp
.NH 1
Labelling an object
.PP
The unshifted function of the middle button is to label an object with a
catalog designation.  Press and hold the middle button while pointed to
an object;
the Enterprise is replaced by an empty
box which follows the pointer motion.  This box indicates the size and
location of the label text.  Move the box to the desired position of the
label and release the button; this removes the box and
places the text on the sky display in its place.
.PP
The label format and meaning is given, for each catalog, in the file
"catalogs.doc".
.PP
The middle pointer button is used in the same fashion for positioning
user labels.  After the user has entered the label text using the User Label
command button, the middle pointer button is armed.  Press and hold
the middle button anywhere in the sky display to bring up the text placement
box, which follows the pointer as described above.  Release the button
to substitute the user's label text at the position of the box.
Note that neither of these forms of labelling can be undone; however,
individual labels can be removed through pointer action.
.PP
Both user and automatic labels may be hidden or erased
.I "en masse"
by the
"Hide IDs" or "Erase IDs" command buttons.
.sp
.NH 1
Labelling a constellation
.PP
The Ctrl function of the middle button generates a constellation label for
the constellation the pointer is in.
While holding down the Ctrl key, press and hold the middle button.  The
Enterprise is replaced by an empty box which follows the pointer motion.
The box indicates the size and location of the constellation label.
Move the box to the desired position of the constellation label and release
the button; the constellation name replaces the empty box.
Note that this action cannot be undone, but a constellation label may be
removed through pointer action.
.sp
.NH 1
Moving labels
.PP
The Ctrl+Shift function of the middle button moves labels.  Place the pointer
hotspot on the desired label, hold down the ctrl+shift keys, and click the
middle button.  The indicated label is replaced by an empty box.
Note that this action cannot be undone.
.sp
.NH 1
Removing labels
.PP
The shifted function of the middle button removes labels.  Place the pointer
hotspot on the unwanted label, hold down the shift key, and click the middle
button.  The indicated label is permanently removed from the display.  Note
that this action cannot be undone.
.sp
.NH 1
Centering the display on a location
.PP
The unshifted function of the right button is to recenter the display at the
pointer hotspot.  Place the pointer on an object or at any desired position
in the sky display.  A click on the third button will recenter the display
on the chosen location.
.sp
.NH 1
Alternate recentering option
.PP
The control-shifted function of the left button is the same as the unshifted
function of the right button:  the sky display is recentered at the location
of the pointer hotspot.  Hold down the control and shift keys; then press
and hold the left button.  The sky display will shift to be recentered on
the chosen location.
.sp
.NH 1
Rubberband selection of a sky region
.PP
The shifted function of the left button is a standard rubber-banding action.
While the pointer is in the sky display,
hold down the shift key and press and hold the left button.  This defines
one corner of the rubberband box.  As you move the pointer around the screen,
the pointer position defines the diagonally-opposite corner of the rubberband
box.  Release the button, and the sky display changes to correspond to the
area enclosed by the box at the time of release.
.PP
Note that the rubberband box is not necessarily perfectly rectangular, nor
is it aligned with the window boundaries.  This is caused by the fact that
what
.UL xsky
does is project a spherical surface (the sky) onto a plane (the screen),
with the attendant unavoidable distortion.
Additionally, since the sky display is always drawn with north up (in the
Northern Hemisphere, at any rate), the box will rotate so as to be normal
to the direction of the north celestial pole.
.PP
The shape and orientation of the box changes to match exactly what will
appear in the final, updated sky display (and if you think that was easy ...).
The rule used is that the aspect ratio of the rubberband box is preserved,
and the sky display is resized to keep the total area constant, consistant
with keeping the entire display visible on the screen.
.PP
However, the "-L" option modifies this behavior, since the application
window must continue filling the entire screen.  In this case, the display
is rescaled so that either the width or height of the rubberband region
is expanded to the current display size, whichever requires the least amount
of scale expansion.
.PP
The bit about north always being toward the top of the display (or south
if the "downunder" option is enabled) means that the rubberband box changes
quite rapidly if the selected area is near the poles; getting the exact
area you want can be a bit tricky.  If you blow it, simply Undo and try
again.
.nr PD 2v

.SH
Window Manager Interactions
.PP
The window manager may be used in the usual way to move, resize, iconify,
and de-iconify the
.UL xsky
application.
.UL xsky
also understands the following window manager messages (please note that
these are not the X11R6 session manager protocol messages):
.nr PD 1v
.LP
WM_DELETE
.IP
causes a graceful exit
.LP
WM_SAVE_YOURSELF
.IP
causes
.UL xsky
to write an initialization file into "~HOME/.xskyinit", and register a restart
command with the window manager.  For convenience, and for operation with
window managers or session managers that do not support the restart command,
the command is
also written to the executable file "~HOME/.xskycmd".
.IP
The .xskycmd file can be executed to restore
.UL xsky
to the state it was in when the WM_SAVE_YOURSELF message was received.
This restart can
also be effected by using the window manager's restart action, if your
window manager or session manager supports it.
Everything is restored except the Undo action list.
.nr PD 2v

.SH
Command-Line Options
.PP
.UL xsky
has a fairly large number of command-line options; most of their functions,
however, are also available through resources which may be set in the XSky
resource file, which is described later.  Also,
.UL xsky
supports the usual X options for specifying geometry, foreground and background
colors, starting in the iconfied state, etc.
.nr PD 1v
.IP -h 13
Print a very terse (in all actuality useless) usage message.
.IP "-a font"
Set the font for constellation area labelling to
.UL font.
This font is
used only for constellation areas.  This can also
be specified in the resource file, and defaults to "helvetica12"
if not otherwise given.
.IP -b
Draw the sky in black-and-white mode even if this is a color
display.  The background remains black, but stars are white
instead of having a color determined by spectral class.
.IP "-c catlist"
Set the initial list of displayed catalogs to
.UL catlist.
This is
a comma-delimited list, with each catalog specified by its
menu name in the catalog selection menu.  This value can also
be given in the resource file, and defaults to "YBS" (the Yale
Catalog of Bright Stars) if not otherwise given.
.IP "-f font"
Set the font for object identification to
.UL font.
This font is
used for object names which are not Greek letters.  This can also
be specified in the resource file, and defaults to "helvetica10"
if not otherwise given.
.IP "-g font"
Set the font for Greek letters to
.UL font.
This font is used for
Bayer designations of stars from the Yale Bright Star Catalog.
This can also be specified in the resource file, and defaults
to "symbol12" if not otherwise given.
.IP "-m mag"
Set the initial limiting magnitude to
.UL mag.
Stars dimmer than
this apparent magnitude will not be displayed; this has no effect on
non-stellar objects.
This value can also be specified in the resource file, and defaults
to "8.0" if not otherwise given.
.IP "-p position"
Set the initial position of the display to
.UL position.
This is a
string in the format <nnh hhm nns.nnn, +/-nnd nn' nn".nn> specifying
the right ascension and declination of the display center.  (Note that
the broken brackets are used here for grouping purposes only; they
should not actually be specified as part of the value.)  Unneeded
trailing parts of either the right ascension or the declination may
be omitted.
.IP
If specified, this position also defines the center points of the
vertical and horizontal scrollbars.
This value can also be specified in the resource file, and defaults
to <05h 36m 12s.7, -01d 12' 07"> (the position of Alnilam, the center
star of the belt of Orion) if not otherwise given.
.IP "-s scale"
Set the initial display scale to
.UL scale
pixels per degree.  This value can also be specified in the resource
file, and defaults to "20" if not otherwise given.
.IP "-u"
Turn the display "upside-down" for the folks in the Southern Hemisphere.
This can also be specified in the resource file, and defaults to the
Northern Hemisphere orientation if not otherwise given.
.IP "-I filename"
Read the file named
.UL filename
for initialization of
.UL xsky
to a
previously saved state.
.IP -L
Start with a large display.  After positioning the window on
the screen,
.UL xsky
resizes to fill the entire screen.
.IP -N
Operate
.UL xsky
in "night mode", with red stars and text on a black background, to
preserve night vision.  The Xt options "-bg black -fg red" must also
be specified to get the full effect.
.IP "-OBAFGKM color"
.br
Each of these option letters represents a stellar spectral
class.  Specifying one of these options changes the color of the
stars in that spectral class to
.UL color.
Stars of class W are
represented as class O, and stars of classes C, R, N, and S are
represented as class M.  Unknown or indecipherable spectral classes
are rendered as white.
.IP "-P flag"
Control the existence of the continuously-updating pointer
position display.  If
.UL flag
is "on", the display appears; if
.UL flag
is anything else (e. g., "off"), the display does not appear.
This can also be specified in the resource file, and defaults to
"on" if not otherwise given.
.IP "-S flag"
Control the existence of the display vertical and horizontal
scrollbars.  If
.UL flag
is "on", the scrollbars appear; if
.UL flag
is anything else (e. g., "off"), the scrollbars do not appear.
This can also be specified in the resource file, and defaults to
"on" if not otherwise given.
.IP "-Z flag"
Control the existence of the zoom (display magnification)
slider.  If
.UL flag
is "on", the zoom slider appears with the
default maximum magnification value.  If
.UL flag
is all numeric,
the zoom slider appears and the value is the zoom slider maximum
magnification in pixels per degree.
Specifying anything else for
.UL flag
(e. g., "off") suppresses the zoom slider.
This can also be specified through two separate resource values
in the resource file, and defaults to "on" with a maximum of
100,000 if not otherwise given.
.IP -bin
Terminate after reading the text catalogs and dumping the
binary databases.  All contact with the X Window System is
avoided; this option allows building the binary databases from
an ordinary terminal.  This option must be used alone; it will
not work (nor does it make sense) with any other options.
.nr PD 2v

.SH
The Resource File
.PP
In addition to the vast number of resource settings available as
a simple consequence of using Athena widgets,
.UL xsky
defines a number
of resources of its own, primarily as an alternative to specifying
customizations as command-line options.
.KS
.IP
Set the initial center position of the sky display.  This corresponds
to the "-p" command-line option, and is specified as hours, minutes,
and seconds (of time) of right
ascension and degrees, minutes, and seconds (of arc) of declination,
with negative declination being
south of the celestial equator.
.sp
*displaypos:  5h 36m 12s.7, -01d 12' 07".0
.KE
.KS
.IP
Set the initial scale of the sky display.  This corresponds to the
"-s" command-line option, and is given in pixels per degree.
.sp
*displayscale:  20
.KE
.KS
.IP
Set the initial width and height of the sky display.  This is the size,
in pixels, of the box displaying the sky, not the total size of the
.UL xsky
application window.  There are no corresponding command-line options.
The normal X "-geometry" option may be used to set the size of the
application window; it should be clear that using "-geometry" will
interact badly with the use of these resources.
.sp
*displaywidth:  500
.br
*displayheight:  500
.KE
.KS
.IP
Set the initial limiting magnitude of the sky display.  This corresponds
to the "-m" command-line option.  Stars of apparent magnitude
less than this value will not be displayed.
.sp
*displaymaglim:  8.0
.KE
.KS
.IP
Control the existence of the vertical and horizontal scrollbars.  This
corresponds to the "-S" command-line option.  Setting this value to "True"
gives the scrollbars; setting it to "False" suppresses the scrollbars.
Setting it to anything else will yield an X error.
.sp
*scrollbars:  True
.KE
.KS
.IP
Control the existence of the zoom slider.  This corresponds to the "-Z"
command-line option.  Setting this value to "True" gives the slider;
setting it to "False" suppresses the slider.
Setting it to anything else will yield an X error.
.sp
*zoomslider:  True
.KE
.KS
.IP
Set the maximum magnification value of the zoom slider, in pixels per
degree.
This corresponds to the specification of a numeric value to the "-Z"
command-line option.
The value given here is
more-or-less a maximum useful value, though magnifications higher than
the specified value may still be given by editing the text field in the
Info display (see the description of the Info command button above).
.sp
*slidermax:  25000
.KE
.KS
.IP
Control the existence of the pointer position display.
This
corresponds to the "-P" command-line option.  Setting this value to "True"
gives the position display; setting it to "False" suppresses the position
display.
Setting it to anything else will yield an X error.
.sp
*posdisplay:  True
.KE
.KS
.IP
Set the Latin font for object labels.
This corresponds to the "-f" command-line option.
This font will be used for
labelling all objects in the sky display, except those that require Greek
letters (such as Bayer designations).
.sp
*displaylatinidfont:  *-helvetica-*-*-*-*-10-*
.KE
.KS
.IP
Set the Latin font for constellation labels.
This corresponds to the "-a" command-line option.
.sp
*displaylatinconfont:  *-helvetica-*-*-*-*-14-*
.KE
.KS
.IP
Set the Greek font for star Bayer designations (Greek letters).
This corresponds to the "-g" command-line option.
This font will be used for Bayer designations of stars from
the Yale Catalog of Bright Stars.
.sp
*displaygreekfont:  -adobe-symbol-medium-r-normal--12-*
.KE
.IP
Set the star colors for the various spectral classes.  These correspond to
the "-OBAFGKM" command-line options.  The chosen colors are intended to
approximate an exaggeration of the visual appearance, but may, of course,
be any desired set of colors.  Stars of spectral class W are given the
same color as O stars, and stars of C, R, N, and S are given the same
color as M stars.  If the spectral class is unknown or unintelligible,
the star is drawn in white.
.KS
.sp
*displaycolorO:  Blue
.br
*displaycolorB:  DeepSkyBlue
.br
*displaycolorA:  White
.br
*displaycolorF:  NavajoWhite2
.br
*displaycolorG:  Yellow
.br
*displaycolorK:  Orange
.br
*displaycolorM:  Red
.KE
.KS
.IP
Set automatic popdown for popups.  There
is no corresponding command-line option.
Setting this value to "True" means that popups will pop down automatically
when the pointer leaves the popup; this is useful for window managers
which automatically raise the active window to the top.
Setting it to "False" will suppress autopopdown; the popup will remain
on the screen until explicitly acknowledged with a click on an action
button.  (Note that while the popdown will remain on the screen, it may
not actually be visible due to obscuration by other windows.)
Setting it to anything else will yield an X error.
.sp
*autopopdown:  False
.KE
.KS
.IP
Configure the display for Southern Hemisphere mode.  This corresponds to the
"-u" command-line option.
Setting this value to "True" tells
.UL xsky
to invert the display and flip it in left-to-right mirror image.  This
puts south up, instead of north, and should look rather more recognizable
to users in the Southern Hemisphere.
Setting it to "False" will leave the sky display in "normal" mode, with
north up; this will be more natural for Northern Hemisphere users.
Setting it to anything else will yield an X error.
.sp
*downunder:  False
.KE
.KS
.IP
Set the initial list of catalogs to display.  This corresponds to the
"-c" command-line option.  The listed catalogs will be turned on when
.UL xsky
starts up; this does not preclude turning them off at any time, nor
does it prevent turning on other available catalogs.
.sp
*displayfirst:  YBS,RNGC
.KE

.SH
Random Hacking on
.UL xsky
.PP
There are a few interesting things you can do to alter the behavior of
.UL xsky
through changes to compilation definitions.  These definitions may be
set by adding them to the "DEFINES =" line of Makefile.std or
Imakefile and recompiling
.UL xsky.
.PP
One easy thing to do is
change the equinox at which the sky is displayed.  This value is
controlled by the manifest constant COMMON_EQUINOX and is 2000.0 in
the
.UL xsky
distribution.  For example, setting "-DCOMMON_EQUINOX=1994.75" would
change the equinox to the end of September of 1994.
.PP
Note that positions are only precessed; proper motion is not computed
(even if the necessary information is provided by the catalog), so this
feature cannot be used to see what the sky will look like, say, 50,000
years from now.  It'd be a neat hack, though (hint, hint).
.PP
Non-stellar objects can also be made larger, if desired, by changing the
value of OBJSIZE.  This is set to 4 pixels in the distribution; objects
would be drawn somewhat larger by adding, for example,
"-DOBJSIZE=6" to the defines.
.UL xsky
does not, however, alter the size of non-stellar objects based on their
actual size on the sky, even if that information is available (which it
almost never is).
.PP
Star sizes can also be controlled; "MAXSTARSIZE" sets the upper limit to
the size of a star; this value is in pixels, and is set to 11 in the
distribution.  Additionally, compiling
.UL xsky
with "BIGSTARS" defined expands the star size scale by a factor of two,
which tends to make the stars look more like the sizes seen in printed
atlases such as the
.UL "Skalnate Pleso Atlas of the Heavens."
.R
As an example,
adding "-DMAXSTARSIZE=10" to the defines, and rebuilding
.UL xsky,
would make the actual displayed maximum star size 10 pixels.  If "-DBISTARS"
is then added, the star size scale will expand to a maximum of 20 pixels.

.KS
.SH
Conclusion
.PP
.UL xsky
was originally written as a vehicle to help me learn X programming.
It has since grown to what I hope is a useful tool for the astronomical
community, both amateur and professional.  This code is free to the
net.community, as my contribution and payback for the benefits I've
received over the years from free software provided by other hackers
on the net.
.LP
Terry R. Friedrichsen
.br
terry@venus.sunquest.com
.KE
