/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-3, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

/* this routine formats and displays a variable star record */

#include <stdio.h>

#include <string.h>

#include "wds.h"

#include "skydefs.h"

#include "format.h"

/* static function prototypes */
static void display_pos PROTOTYPE((char *));
static void display_observation PROTOTYPE((char *,int));

#define MAX_WDS_ROW   70
#define NUM_WDS_ROWS  22



void format_wds_display(record,wds_num)

char *record;
int wds_num;

{
  int i;

/* start at the beginning of the display */
  idx = 0;
  row = 0;
  row_start = 0;
  max_row = MAX_WDS_ROW;

/* display the catalog number */
  sprintf(&obj_info[idx],"WDS %d",wds_num);
  idx += strlen(&obj_info[idx]);
  next_line();

/* display the Bonner Durchmusterung number */
  advance_to_tab();
  if (strncmp(&record[BD_START],"        ",8) != EQUAL) {
    if (record[BD_START + 1] == ' ')
      record[BD_START + 1] = '0';
    for (i = 0; i < 5; i++)
      if (record[BD_START + 3 + i] == ' ')
	record[BD_START + 3 + i] = '0';
    if (record[BD_START] == 'N')
      sprintf(&obj_info[idx],"BD +");
    else if (record[BD_START] == 'S')
      sprintf(&obj_info[idx],"BD -");
    else
      sprintf(&obj_info[idx],"BD %c",record[BD_START]);
    idx += strlen(&obj_info[idx]);
    sprintf(&obj_info[idx],"%.2sd %.5s",&record[BD_START + 1],
	                                               &record[BD_START + 3]);
    idx += strlen(&obj_info[idx]);
    advance_to_tab();
    advance_to_tab();
  }

/* display the ADS number */
  if (strncmp(&record[ADS_START],"     ",5) != EQUAL) {
    ljust(&record[ADS_START],5);
    sprintf(&obj_info[idx],"ADS %.5s",&record[ADS_START]);
    idx += strlen(&obj_info[idx]);
  }

/* space down some */
  blank_line();

/* display the position */
  display_pos(&record[POS_RA_START]);

/* space down a bit */
  next_line();

/* display the components, if any */
  if (strncmp(&record[COMPONENTS_START],"     ",5) != EQUAL) {
    sprintf(&obj_info[idx],"Components:  %c %c %c %c %c",
						record[COMPONENTS_START],
						record[COMPONENTS_START + 1],
						record[COMPONENTS_START + 2],
						record[COMPONENTS_START + 3],
						record[COMPONENTS_START + 4]);
    idx += strlen(&obj_info[idx]);
    blank_line();
  }

/* display the observation information, if provided */
  if (strncmp(&record[OBS_DATES_START],"   ",3) != EQUAL) {
    display_observation(record,0);
    blank_line();
  }
  if (strncmp(&record[OBS_DATES_START + 3],"   ",3) != EQUAL) {
    display_observation(record,3);
    blank_line();
  }

/* add the number of observations */
  if (strncmp(&record[NUM_MEASURES],"  ",2) != EQUAL) {
    if (strncmp(&record[NUM_MEASURES],"99",2) == EQUAL)
      sprintf(&obj_info[idx],"Number of measurements:  >= %.2s",
	                                               &record[NUM_MEASURES]);
    else
      sprintf(&obj_info[idx],"Number of measurements:  %.2s",
	                                               &record[NUM_MEASURES]);
    idx += strlen(&obj_info[idx]);
    blank_line();
  }

/* now display the magnitudes */
  if (strncmp(&record[MAG_PRIMARY_START],"      ",6) != EQUAL) {
    add_string("Magnitudes:  ");
    if (strncmp(&record[MAG_SECONDARY_START],"   ",3) == EQUAL)
      add_string("?");
    else {
      sprintf(&obj_info[idx],"%.2s.%.1s",&record[MAG_PRIMARY_START],
	                                      &record[MAG_PRIMARY_START + 2]);
      idx += strlen(&obj_info[idx]);
    }
    advance_to_tab();

    if (strncmp(&record[MAG_SECONDARY_START],"   ",3) == EQUAL)
      add_string("?");
    else {
      sprintf(&obj_info[idx],"%.2s.%.1s",&record[MAG_SECONDARY_START],
	                                    &record[MAG_SECONDARY_START + 2]);
      idx += strlen(&obj_info[idx]);
    }
    blank_line();
  }

/* add the spectral class */
  if (strncmp(&record[SPECTRUM_START],"    ",4) != EQUAL) {
    sprintf(&obj_info[idx],"Spectral classifications:  %.2s  %.2s",
	                                         &record[SPECTRUM_START],
	                                         &record[SPECTRUM_START + 2]);
    idx += strlen(&obj_info[idx]);
    blank_line();
  }

/* add in the proper motion */
  if (strncmp(&record[PROPER_MOTION_RA_START],"        ",8) != EQUAL) {
    add_string("Proper motion - RA:  ");
    if (record[PROPER_MOTION_RA_START] == 'E')
      add_string("+");
    else if (record[PROPER_MOTION_RA_START] == 'W')
      add_string("-");
    else {
      sprintf(&obj_info[idx],"%c",record[PROPER_MOTION_RA_START]);
      idx += strlen(&obj_info[idx]);
    }
    if ((strstr(&record[FLAGS_START],"P") == (char *)NULL) &&
	                    (strstr(&record[FLAGS_START],"R") == (char *)NULL))
      sprintf(&obj_info[idx],"0\".%.3s",&record[PROPER_MOTION_RA_START + 1]);
    else
      sprintf(&obj_info[idx],"%.1s\".%.2s",&record[PROPER_MOTION_RA_START + 1],
	                                  &record[PROPER_MOTION_RA_START + 2]);
    idx += strlen(&obj_info[idx]);
    add_string("/year");
    advance_to_tab();
    add_string("Dec:  ");
    if (record[PROPER_MOTION_DEC_START] == 'N')
      add_string("+");
    else if (record[PROPER_MOTION_DEC_START] == 'S')
      add_string("-");
    else {
      sprintf(&obj_info[idx],"%c",record[PROPER_MOTION_DEC_START]);
      idx += strlen(&obj_info[idx]);
    }
    if ((strstr(&record[FLAGS_START],"Q") == (char *)NULL) &&
			   (strstr(&record[FLAGS_START],"R") == (char *)NULL))
      sprintf(&obj_info[idx],"0\".%.3s",&record[PROPER_MOTION_DEC_START + 1]);
    else
      sprintf(&obj_info[idx],"%.1s\".%.2s",
	                                &record[PROPER_MOTION_DEC_START + 1],
					&record[PROPER_MOTION_DEC_START + 2]);
    idx += strlen(&obj_info[idx]);
    add_string("/year");
    blank_line();
  }

/* tell the user if notes are available */
  if (strstr(&record[FLAGS_START],"N") != (char *)NULL)
    add_string("Additional information is available in the notes");

/* fill the display out to the correct number of lines */
  while (row < NUM_WDS_ROWS)
    next_line();
  obj_info[idx] = '\0';

/* and go back */
  return;
}



static void display_pos(posptr)

char *posptr;

{
/* identify the epoch */
  add_string("Position (1900.0)");

/* display the right ascension */
  advance_to_tab();
  sprintf(&obj_info[idx]," RA:   %.2sh %.2sm.%.1s",
	                                    &posptr[0],&posptr[2],&posptr[4]);
  idx += strlen(&obj_info[idx]);
  next_line();

/* one entry has a blank in the low-order byte of declination minutes */
  if (posptr[12] == ' ')
    posptr[12] = '0';

/* and display the declination */
  advance_tabs(3);
  sprintf(&obj_info[idx],"Dec:  %c",posptr[8]);
  idx += strlen(&obj_info[idx]);

  sprintf(&obj_info[idx],"%.2sd %.2s'",&posptr[9],&posptr[11]);
  idx += strlen(&obj_info[idx]);
  next_line();

  return;
}



static void display_observation(record,offset)

char *record;
int offset;

{
  boolean minutes_flag;

/* put out a header and the year */
  sprintf(&obj_info[idx],"Observation:  1%.3s",
	                                   &record[OBS_DATES_START + offset]);
  idx += strlen(&obj_info[idx]);

/* display the position angle, if given */
  if (strncmp(&record[POSITION_ANGLES_START + offset],"   ",3) != EQUAL) {
    advance_to_tab();
    sprintf(&obj_info[idx],"Position angle:  %.3sd",
	                             &record[POSITION_ANGLES_START + offset]);
    idx += strlen(&obj_info[idx]);
  }

/* display the separation, if given */
  if (strncmp(&record[SEPARATIONS_START + offset],"   ",3) != EQUAL) {
    advance_to_tab();
    add_string("Separation:  ");
    /* assume the separation is not in minutes */
    minutes_flag = FALSE;
    if (strstr(&record[FLAGS_START],"1") != (char *)NULL)
      add_string("1");
    else if (strstr(&record[FLAGS_START],"2") != (char *)NULL)
      add_string("2");
    else if (strstr(&record[FLAGS_START],"3") != (char *)NULL)
      add_string("3");
    else if (strstr(&record[FLAGS_START],"4") != (char *)NULL)
      add_string("4");
    else if (strstr(&record[FLAGS_START],"6") != (char *)NULL)
      minutes_flag = TRUE;
    else
      ;

    if (minutes_flag)
      sprintf(&obj_info[idx],"%.2s'.%.1s",
	                              &record[SEPARATIONS_START + offset],
		                      &record[SEPARATIONS_START +offset + 2]);
    else
      sprintf(&obj_info[idx],"%.2s\".%.1s",
	                             &record[SEPARATIONS_START + offset],
	                             &record[SEPARATIONS_START + offset + 2]);
    idx += strlen(&obj_info[idx]);
  }

  return;
}
