/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-3, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

struct type_table {
	char *type_id;
	char *type_desc;
	};

static struct type_table types[] = {
		{"?","unstudied"},
		{"?L","unstudied - long-period"},
		{"?S","unstudied - short-period"},
		{"CEP","long-period Cepheid"},
		{"CST","constant - mistakenly identified as variable"},
		{"CW","long-period Cepheid in galactic halo"},
		{"C04","long-period Cepheid in galactic disk"},
		{"E","eclipsing binary"},
		{"EA","Algol eclipsing binary"},
		{"EB","beta Lyrae eclipsing binary"},
		{"ELL","ellipsiodal binary system"},
		{"EW","W Ursae Majoris eclipsing binary"},
		{"IA","irregular of early spectral class (O-A)"},
		{"IN","Orion"},
		{"INA","Orion of early spectral class (O-A)"},
		{"INAS","short-period Orion of early spectral class (O-A)"},
		{"INB","Orion of late spectral class (F-M)"},
		{"INBS","short-period Orion of late spectral class (F-M)"},
		{"INS","short-period Orion"},
		{"INSB","short-period Orion of late spectral class (F-M)"},
		{"INT","T Tauri irregular"},
		{"ISA","rapid irregular of early spectral class (O-A)"},
		{"ISB","rapid irregular of late spectral class (F-M)"},
		{"IST","not classified"},
		{"L","slow irregular"},
		{"LB","slow irregular of late spectral class (K-S)"},
		{"LC","irregular supergiant of late spectral class"},
		{"M","Mira - long-period giant"},
		{"N","nova"},
		{"NA","nova with rapid development"},
		{"NB","nova with slow development"},
		{"NC","nova with long maximum and extremely slow decline"},
		{"NL","nova-like"},
		{"NR","recurrent nova"},
		{"RCB","R Coronae Borealis"},
		{"RR","RR Lyrae"},
		{"RRAB","RR Lyrae with steep ascent"},
		{"RRC","RR Lyrae with nearly symmetrical light curve"},
		{"RRS","short-period RR Lyrae"},
		{"RV","RV Tauri"},
		{"RVA","RV Tauri with constant mean brightness"},
		{"RVB","RV Tauri with periodic mean brightness"},
		{"SN","supernova"},
		{"SR","semiregular"},
		{"SRA","late semiregular (M,C,S) with stable period"},
		{"SRB","late semiregular (M,C,S) with unstable period"},
		{"SRC","late semiregular in galactic disk"},
		{"SRD","semiregular of classes F, G, or K"},
		{"UG","U Geminorum or SS Cygni"},
		{"UV","UV Ceti - flare star"},
		{"UVN","UV Ceti - flare star connected with diffuse nebula"},
		{"ZAND","Z Andromedae (symbiotic)"},
		{"ZCAM","Z Camelopardalis variable"},
		{"01CV","alpha-2 Canum Venaticorum (magnetic)"},
		{"02C","beta Cephei or beta Canis Majoris"},
		{"04SCT","delta Scuti"},
		{NULL,NULL}
		};
