/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-5, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

/* this routine formats and displays a variable star record */

#include <stdio.h>

#include <ctype.h>
#include <string.h>

#include "var.h"

#include "skydefs.h"

#include "var_types.h"

#include "catreader.h"

#include "format.h"

/* static function prototypes */
static void display_pos PROTOTYPE((char *));
static int find_var_type PROTOTYPE((char *,struct type_table *));

/* external function prototypes */
extern int find_const_abbrev PROTOTYPE((char *));
extern char *strnstr PROTOTYPE((char *,char *,int));

#define MAX_VAR_ROW   78
#define NUM_VAR_ROWS  18

extern char *greek[];

extern char *constellations_latin[];



void format_var_display(record)

char *record;

{
  int i, j;
  char desig_buff[6];
  char const_buff[4];
  int greek_idx, superscript;
  int match_idx;
  int reclen;
  char field[6];
  int epoch_day;
  short rise_dur_flag;

/* start at the beginning of the display */
  idx = 0;
  row = 0;
  row_start = 0;
  max_row = MAX_VAR_ROW;

/* copy out the designation and nul-terminate it */
  i = 0;
  while (i < 5)
    if ((desig_buff[i] = record[NAME_START + i]) == ' ')
      break;
    else
      i++;
  desig_buff[i] = '\0';

/* if numeric, display the Bayer */
  if (isdigit(desig_buff[0])) {
    /* this is a Greek-letter index plus a possible superscript */
    greek_idx = (int)(desig_buff[0] - '0') * 10 + (int)(desig_buff[1] - '0');
    if (isdigit(desig_buff[2]))
      superscript = (int)(desig_buff[2] - '0');
    else
      superscript = 0;

    if (superscript == 0)
      sprintf(&obj_info[idx],"%s",greek[greek_idx - 1]);
    else
      sprintf(&obj_info[idx],"%s-%d",greek[greek_idx - 1],superscript);
  }
  else
    /* display the Argelander or ordinal designation */
    sprintf(&obj_info[idx],"%s",desig_buff);
  idx += strlen(&obj_info[idx]);

/* add in the genitive constellation */
  strncpy(const_buff,&record[CONSTELLATION_NAME],3);
  const_buff[3] = '\0';
  sprintf(&obj_info[idx]," %s",
	                 constellations_latin[find_const_abbrev(const_buff)]);
  idx += strlen(&obj_info[idx]);

/* advance to the next line */
  next_line();

/* display other designations if provided */
  i = 0;
/* display the Astronomische Nachrichten number */
  if (strncmp(&record[AN_START],"         ",9) != EQUAL) {
    ljust(&record[AN_START],9);
    advance_to_tab();
    sprintf(&obj_info[idx],"    AN %.9s",&record[AN_START]);
    idx += strlen(&obj_info[idx]);
    i++;
  }

/* display the Bonner Durchmusterung number */
  if (strncmp(&record[BD_START],"         ",9) != EQUAL) {
    /* add in the missing leading zeroes */
    if (record[BD_START + 1] == ' ')
      record[BD_START + 1] = '0';
    for (j = 0; j < 5; j++)
      if (record[BD_START + 4 + j] == ' ')
	record[BD_START + 4 + j] = '0';
    advance_to_tab();
    sprintf(&obj_info[idx],"BD %.3sd %.5s",&record[BD_START],
					               &record[BD_START + 4]);
    idx += strlen(&obj_info[idx]);
    i++;
  }

/* display the Cordoba Durchmusterung number */
  if (strncmp(&record[COD_START],"         ",9) != EQUAL) {
    /* fill in the missing leading zeroes */
    if (record[COD_START + 1] == ' ')
      record[COD_START + 1] = '0';
    for (j = 0; j < 5; j++)
      if (record[COD_START + 4 + j] == ' ')
	record[COD_START + 4 + j] = '0';
    advance_to_tab();
    sprintf(&obj_info[idx],"CoD %.3sd %.5s",&record[COD_START],
	                                              &record[COD_START + 4]);
    idx += strlen(&obj_info[idx]);
    i++;
  }

/* display the Cape Photographic Durchmusterung number */
  if (strncmp(&record[CPD_START],"         ",9) != EQUAL) {
    /* see if a newline is needed */
    if (i >= 4) {
      next_line();
      i = 0;
    }
    /* fill in the missing leading zeroes */
    if (record[CPD_START + 1] == ' ')
      record[CPD_START + 1] = '0';
    for (j = 0; j < 5; j++)
      if (record[CPD_START + 4 + j] == ' ')
	record[CPD_START + 4 + j] = '0';
    advance_to_tab();
    sprintf(&obj_info[idx],"CPD %.3sd %.5s",&record[CPD_START],
						      &record[CPD_START + 4]);
    idx += strlen(&obj_info[idx]);
    i++;
  }

/* display the Suspected Variable Star number */
  if (strncmp(&record[SVS_START],"    ",4) != EQUAL) {
    /* see if a newline is needed */
    if (i >= 4) {
      next_line();
      i = 0;
    }
    ljust(&record[SVS_START],4);
    advance_to_tab();
    sprintf(&obj_info[idx],"SVS %.4s",&record[SVS_START]);
    idx += strlen(&obj_info[idx]);
    i++;
  }

/* display the Boss General Catalogue number */
  if (strncmp(&record[GC_START],"     ",5) != EQUAL) {
    /* see if a newline is needed */
    if (i >= 4) {
      next_line();
      i = 0;
    }
    ljust(&record[GC_START],5);
    advance_to_tab();
    sprintf(&obj_info[idx],"GC %.5s",&record[GC_START]);
    idx += strlen(&obj_info[idx]);
    i++;
  }

/* display the Henry Draper number */
  if (strncmp(&record[HD_START],"      ",6) != EQUAL) {
    /* see if a newline is needed */
    if (i >= 4) {
      next_line();
      i = 0;
    }
    ljust(&record[HD_START],6);
    advance_to_tab();
    sprintf(&obj_info[idx],"HD %.6s",&record[HD_START]);
    idx += strlen(&obj_info[idx]);
    i++;
  }

/* display the Harvard Variable number */
  if (strncmp(&record[HV_START],"     ",5) != EQUAL) {
    /* see if a newline is needed */
    if (i >= 4) {
      next_line();
      i = 0;
    }
    ljust(&record[HV_START],5);
    advance_to_tab();
    sprintf(&obj_info[idx],"HV %.5s",&record[HV_START]);
    idx += strlen(&obj_info[idx]);
    i++;
  }

/* display the Catalogue of Suspected Variables number */
  if (strncmp(&record[CSV_START],"      ",6) != EQUAL) {
    /* see if a newline is needed */
    if (i >= 4) {
      next_line();
      i = 0;
    }
    ljust(&record[CSV_START],6);
    advance_to_tab();
    sprintf(&obj_info[idx],"CSV %.6s",&record[CSV_START]);
    i++;
  }

/* display the Ross number */
  if (strncmp(&record[ROSS_START],"   ",3) != EQUAL) {
    /* see if a newline is needed */
    if (i >= 4) {
      next_line();
      i = 0;
    }
    ljust(&record[ROSS_START],3);
    advance_to_tab();
    sprintf(&obj_info[idx],"Ross %.3s",&record[ROSS_START]);
    idx += strlen(&obj_info[idx]);
    i++;
  }

/* display the Vatican Observatory Variable number */
  if (strncmp(&record[VV_START],"   ",3) != EQUAL) {
    /* see if a newline is needed */
    if (i >= 4) {
      next_line();
      i = 0;
    }
    ljust(&record[VV_START],3);
    advance_to_tab();
    sprintf(&obj_info[idx],"VV %.3s",&record[VV_START]);
    idx += strlen(&obj_info[idx]);
    i++;
  }

/* display the nova designation */
  if (strncmp(&record[NOVA_START],"        ",8) != EQUAL) {
    /* see if a newline is needed */
    if (i >= 4) {
      next_line();
      i = 0;
    }
    ljust(&record[NOVA_START],8);
    advance_to_tab();
    sprintf(&obj_info[idx],"Nova %.8s",&record[NOVA_START]);
    idx += strlen(&obj_info[idx]);
    i++;
  }

/* display the Sonneberg Observatory number */
  if (strncmp(&record[S_START],"     ",5) != EQUAL) {
    /* see if a newline is needed */
    if (i >= 4) {
      next_line();
      i = 0;
    }
    ljust(&record[S_START],5);
    advance_to_tab();
    sprintf(&obj_info[idx],"S %.5s",&record[S_START]);
    idx += strlen(&obj_info[idx]);
  }

/* space down some */
  blank_line();

/* display the position */
  display_pos(&record[POS_RA_START]);

/* display the variable type */
  next_line();
  add_string("Variable type:  ");
  match_idx = find_var_type(&record[VAR_TYPE_START],types);
  if (match_idx == -1)
    sprintf(&obj_info[idx],"unknown variable type %.6s",
	                                          &record[VAR_TYPE_START]);
  else
    sprintf(&obj_info[idx],"%s",types[match_idx].type_desc);
  idx += strlen(&obj_info[idx]);
  next_line();

/* see if the variable is also an eclipsing type */
  advance_to_tab();
  advance_to_tab();
  if (strnstr(&record[VAR_TYPE_START],"(E)",6) != NULL)
    add_string("also an eclipsing binary");
  else if (strnstr(&record[VAR_TYPE_START],"(EA)",6) != NULL)
    add_string("also an Algol eclipsing binary");
  else
    ;
  next_line();

/* now display the magnitudes */
  if (strncmp(&record[MIN_MAG_START + 1],"8888",4) != EQUAL) {
    lzsupp(&record[MIN_MAG_START + 1],1);
    next_line();
    sprintf(&obj_info[idx],"Minimum mag:  %.3s.%.2s",
	                                          &record[MIN_MAG_START],
						  &record[MIN_MAG_START + 3]);
    idx += strlen(&obj_info[idx]);
    if (record[MIN_MAG_START + 5] == '*')
      add_string("?");
    advance_to_tab();
  }
  else if (strncmp(&record[MIN_MAG_START + 1],"9999",4) != EQUAL) {
    next_line();
    add_string("Minimum mag:  ?");
    advance_to_tab();
  }
  else
    ;
  if (strncmp(&record[MAX_MAG_START + 2],"8888",4) != EQUAL) {
    lzsupp(&record[MAX_MAG_START + 2],1);
    sprintf(&obj_info[idx],"Maximum mag:  %.4s.%.2s",
			                          &record[MAX_MAG_START],
						  &record[MAX_MAG_START + 4]);
    idx += strlen(&obj_info[idx]);
    if (record[MAX_MAG_START + 6] == '*')
      add_string("?");
    advance_to_tab();
  }

/* and the epoch */
  if (strncmp(&record[EPOCH_START],"         ",9) != EQUAL) {
    reclen = strlen(record);
    GET_FIELD(field,record,EPOCH_START,5);
    epoch_day = atoi(field) + 2400000;
    sprintf(&obj_info[idx],"Epoch:  %d.%.4s",epoch_day,
	                                            &record[EPOCH_START + 5]);
    idx += strlen(&obj_info[idx]);

    /* see if the value is in question */
    if (record[EPOCH_START + 9] == '*')
      add_string("?");
  }

/* space down some more */
  blank_line();

/* show the period and rise time or duration */
  rise_dur_flag = FALSE;
  if (strncmp(&record[PERIOD_START],"          ",10) != EQUAL) {
    lzsupp(&record[PERIOD_START + 1],4);
    sprintf(&obj_info[idx],"Period:  %.6s.%.4s",&record[PERIOD_START],
						   &record[PERIOD_START + 6]);
    idx += strlen(&obj_info[idx]);
    if (record[PERIOD_START + 10] == '*')
      add_string("?");
    add_string(" days");
    advance_to_tab();
    advance_to_tab();
    rise_dur_flag = TRUE;
  }
  if (strncmp(&record[RISE_DURATION_START],"   ",3) != EQUAL) {
    lzsupp(&record[RISE_DURATION_START],1);
    sprintf(&obj_info[idx],"Rise/duration:  %.2s.%.1s%%",
					    &record[RISE_DURATION_START],
					    &record[RISE_DURATION_START + 2]);
    idx += strlen(&obj_info[idx]);
    if (record[RISE_DURATION_START + 3] == '*')
      add_string("?");
    add_string(" of the period");
    rise_dur_flag = TRUE;
  }

/* space down more */
  if (rise_dur_flag)
    blank_line();

/* add the spectral class */
  sprintf(&obj_info[idx],"Spectral classification:  %.12s",
		                                     &record[SPECTRUM_START]);
  idx += strlen(&obj_info[idx]);
  blank_line();

/* tell the user if notes are available */
  if (record[NOTE_FLAG] == '*')
    add_string("Additional information is available in the notes");

/* fill the display out to the correct number of lines */
  while (row < NUM_VAR_ROWS)
    next_line();
  obj_info[idx] = '\0';

/* and go back */
  return;
}



static void display_pos(posptr)

char *posptr;

{
/* identify the epoch */
  add_string("Position (1900.0)");
  add_string(" [sometimes, sadly, 1950.0 - you get to guess when]");
  next_line();

/* fix up the RA minutes and seconds */
  if (posptr[2] == ' ')
    posptr[2] = '0';
  if (posptr[4] == ' ')
    posptr[4] = '0';

/* display the right ascension */
  advance_to_tab();
  sprintf(&obj_info[idx]," RA:   %.2sh %.2sm %.2ss",
		                            &posptr[0],&posptr[2],&posptr[4]);
  idx += strlen(&obj_info[idx]);
  next_line();

/* fix up the declination minutes */
  if (posptr[9] == ' ')
    posptr[9] = '0';

/* and display the declination */
  advance_to_tab();
  sprintf(&obj_info[idx],"Dec:  %.3sd %.2s'.%.1s",
	                                   &posptr[6],&posptr[9],&posptr[11]);
  idx += strlen(&obj_info[idx]);
  next_line();

  return;
}



static int find_var_type(buff,table)

char *buff;
struct type_table *table;

{
  int max_match, max_match_idx;
  char *ptr;
  int desc;
  int i;

/* make the match length impossibly small */
  max_match = -1;
  max_match_idx = -1;

/* begin at the beginning */
  desc = 0;
  while (table[desc].type_id != NULL) {
/* point to the start of the description */
    ptr = buff;

/* match characters for a while */
    i = strlen(table[desc].type_id);
    if (strncmp(ptr,table[desc].type_id,(size_t)i) == EQUAL)
      if (i > max_match) {

/* the new match is bigger; save the length and the index */
	max_match = i;
	max_match_idx = desc;
      }

/* step to the next description */
    desc++;
  }

/* return the index to the relevant description table entry */
  return(max_match_idx);
}
