/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1995, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

/* this routine formats and displays a UGC record */

#include <stdio.h>
#include <stdlib.h>

#include <string.h>

#include "ugc.h"

#include "skydefs.h"

#include "catreader.h"

#include "format.h"

/* static function prototypes */
static void display_pos PROTOTYPE((char *));

#define MAX_UGC_ROW   70
#define NUM_UGC_ROWS  16



void format_ugc_display(record)

char *record;

{
  int reclen;
  char field[5];

/* start at the beginning of the display */
  idx = 0;
  row = 0;
  row_start = 0;
  max_row = MAX_UGC_ROW;

/* get the length of the record for GET_FIELD */
  reclen = strlen(record) - 1;

/* display the catalog number */
  GET_FIELD(field,record,UGC_NUM_START,UGC_NUM_LENGTH);
  sprintf(&obj_info[idx],"UGC %d",atoi(field));
  idx += strlen(&obj_info[idx]);

/* note if this object is from the catalog addenda */
  if (record[ADDENDA_FLAG_START] == 'A')
    add_string(" (from Addenda list)");

/* add the MCG designation */
  advance_tabs(2);
  sprintf(&obj_info[idx],"%.13s",&record[MCG_DESIGNATION_START]);
  idx += strlen(&obj_info[idx]);

/* display the position */
  blank_line();
  display_pos(&record[POS_RA_START]);

/* give the Hubble classification, if any */
  if (strncmp(&record[HUBBLE_CLASS_START],"       ",HUBBLE_CLASS_LENGTH) !=
                                                                       EQUAL) {
    blank_line();
    add_string("Hubble classification (remarks):  ");
    sprintf(&obj_info[idx],"%.7s",&record[HUBBLE_CLASS_START]);
    idx += strlen(&obj_info[idx]);
  }

/* now display the photographic magnitude */
  blank_line();
  add_string("Photographic magnitude:  ");
  sprintf(&obj_info[idx],"%.4s",&record[MAGNITUDE_PG_START]);
  idx += strlen(&obj_info[idx]);

/* move over some */
  advance_tabs(2);

/* display the radial velocity, if present */
  if (strncmp(&record[RADIAL_VELOCITY_START],"     ",RADIAL_VELOCITY_LENGTH)
                                                                    != EQUAL) {
    add_string("Radial velocity:  ");
    sprintf(&obj_info[idx],"%.5s km/sec",&record[RADIAL_VELOCITY_START]);
    idx += strlen(&obj_info[idx]);
  }

/* report the lengths of the blue and red major and minor axes */
  blank_line();
  if (strncmp(&record[POSS_BLUE_MAJOR_AXIS_START],"      ",
	                                 POSS_BLUE_MAJOR_AXIS_LENGTH) == EQUAL)
    advance_tabs(3);
  else {
    add_string("POSS blue major axis:  ");
    sprintf(&obj_info[idx],"%.3s'.%.2s",&record[POSS_BLUE_MAJOR_AXIS_START],
	                              &record[POSS_BLUE_MAJOR_AXIS_START + 4]);
    idx += strlen(&obj_info[idx]);
  }

  if (strncmp(&record[POSS_RED_MAJOR_AXIS_START],"       ",
	                                POSS_RED_MAJOR_AXIS_LENGTH) != EQUAL) {
    advance_tabs(2);
    add_string("POSS red major axis:  ");
    sprintf(&obj_info[idx],"%.3s'.%.2s",&record[POSS_RED_MAJOR_AXIS_START],
	                               &record[POSS_RED_MAJOR_AXIS_START + 4]);
    idx += strlen(&obj_info[idx]);
  }

  next_line();

  if (strncmp(&record[POSS_BLUE_MINOR_AXIS_START],"      ",
	                                 POSS_BLUE_MINOR_AXIS_LENGTH) == EQUAL)
    advance_tabs(3);
  else {
    add_string("POSS blue minor axis:   ");
    sprintf(&obj_info[idx],"%.2s'.%.2s",&record[POSS_BLUE_MINOR_AXIS_START],
	                              &record[POSS_BLUE_MINOR_AXIS_START + 3]);
    idx += strlen(&obj_info[idx]);
  }

  if (strncmp(&record[POSS_RED_MINOR_AXIS_START],"      ",
	                                POSS_RED_MINOR_AXIS_LENGTH) != EQUAL) {
    advance_tabs(2);
    add_string("POSS red minor axis:   ");
    sprintf(&obj_info[idx],"%.2s'.%.2s",&record[POSS_RED_MINOR_AXIS_START],
	                               &record[POSS_RED_MINOR_AXIS_START + 3]);
    idx += strlen(&obj_info[idx]);
  }

/* report the position angle and inclination, if present */
  GET_FIELD(field,record,POSITION_ANGLE_START,POSITION_ANGLE_LENGTH);
  if (strncmp(field,"    ",POSITION_ANGLE_LENGTH) == EQUAL)
    ;
  else {
    blank_line();
    sprintf(&obj_info[idx],"Position angle:  %d degrees",atoi(field));
    idx += strlen(&obj_info[idx]);
  }
    
  if (record[INCLINATION_BIN_START] == ' ')
    ;
  else {
    blank_line();
    add_string("Inclination (1 = face-on, 7 = edge-on):  ");
    sprintf(&obj_info[idx],"%c",record[INCLINATION_BIN_START]);
    idx += strlen(&obj_info[idx]);
  }

/* report the best POSS field */
  blank_line();
  GET_FIELD(field,record,POSS_FIELD_START,POSS_FIELD_LENGTH);
  sprintf(&obj_info[idx],"Best POSS field:  %d\n",atoi(field));
  idx += strlen(&obj_info[idx]);

/* fill the display out to the correct number of lines */
  while (row < NUM_UGC_ROWS)
    next_line();
  obj_info[idx] = '\0';

/* and go back */
  return;
}



static void display_pos(posptr)

char *posptr;

{
/* identify the epoch */
  add_string("Position (1950.0)");

/* ensure that the right ascension is filled out properly */
  if (posptr[5] == ' ')
    posptr[5] = '0';

/* display the right ascension */
  advance_to_tab();
  sprintf(&obj_info[idx]," RA:   %.2sh %.2sm.%.1s",&posptr[0],&posptr[2],
						                  &posptr[5]);
  idx += strlen(&obj_info[idx]);

/* and display the declination */
  advance_to_tab();
  sprintf(&obj_info[idx],"Dec:  %.3sd %.2s'",&posptr[POS_RA_LENGTH],
	                                          &posptr[POS_RA_LENGTH + 3]);
  idx += strlen(&obj_info[idx]);

  return;
}
