/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-4, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

/* initial default size */
#define INITIAL_WIDTH   400
#define INITIAL_HEIGHT  400

/* initial default position */
#define INITIAL_POSITION  "05h 36m 12s.7, -01d 12' 07\""

/* initial default limiting magnitude */
#define INITIAL_MAGNITUDE  8.0

/* default maximum magnification on slider */
#define DEFAULT_SLIDERMAX   100000

/* initial scale:  15 degrees = 300 pixels */
#define INITIAL_DEGREES_PER_PIXEL  (15.0 / 300)
#define INITIAL_PIXELS_PER_DEGREE  (1.0 / INITIAL_DEGREES_PER_PIXEL)

/* space to allow for the title bar of the window manager */
#define WM_TITLEHEIGHT   20

/* structure for rubber-band position information (initial point is
 * at indexes 0 and 4) */
#define NUM_ENCLOSURE_POINTS   5
struct rubberband {
#if 0
  Position initial_x, initial_y;
  Position ptr_x, ptr_y;
#endif
  XPoint points[NUM_ENCLOSURE_POINTS];
  XPoint midpoint;
  int closeidx, faridx;
};

/* default PostScript chart file name */
#define DEFAULT_PS_OUTPUT_FILE   "starchart.ps"
