/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-4, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

/* this routine formats and displays an SAO record */

#include <stdio.h>

#include <string.h>

#include "saoj2000.h"

#include "skydefs.h"

#include "catreader.h"

#include "format.h"

/* static function prototypes */
static void display_pos PROTOTYPE((char *,char *));

#define MAX_SAO_ROW   75
#define NUM_SAO_ROWS  15



void format_saoj2000_display(record)

char *record;

{
  int reclen;
  char field[7];
  int sao_num;
  int i;
  int hd_num;
  int source_code, source_num;

/* start at the beginning of the display */
  idx = 0;
  row = 0;
  row_start = 0;
  max_row = MAX_SAO_ROW;

/* get the record length */
  reclen = strlen(record);

/* display the catalog number */
  GET_FIELD(field,record,CAT_START,6);
  sao_num = atoi(field);

  sprintf(&obj_info[idx],"SAO %d",sao_num);
  idx += strlen(&obj_info[idx]);
  next_line();
  advance_to_tab();

/* display the Durchmusterung number */
  if (strncmp(&record[DURCHMUSTERUNG_NUMBER],"        ",8) != EQUAL) {
    sprintf(&obj_info[idx],"%.2s ",&record[DURCHMUSTERUNG_CAT]);
    idx += strlen(&obj_info[idx]);

/* fill in the leading zero of the declination zone */
    if (record[DURCHMUSTERUNG_NUMBER + 1] == ' ')
      record[DURCHMUSTERUNG_NUMBER + 1] = '0';

/* fill in the leading zeroes of the number */
    for (i = 0; i < 5; i++)
      if (record[DURCHMUSTERUNG_NUMBER + 3 + i] == ' ')
	record[DURCHMUSTERUNG_NUMBER + 3 + i] = '0';
    sprintf(&obj_info[idx],"%.3sd %.5s",
	                         &record[DURCHMUSTERUNG_NUMBER],
	                         &record[DURCHMUSTERUNG_NUMBER + 3]);
    idx += strlen(&obj_info[idx]);
    sprintf(&obj_info[idx],"%c",record[BD_SUPP_LETTER]);
    idx += strlen(&obj_info[idx]);
    advance_to_tab();
    advance_to_tab();
  }

/* display the HD number */
  if (strncmp(&record[HD_START],"      ",6) != EQUAL) {
    GET_FIELD(field,record,HD_START,6);
    hd_num = atoi(field);

    sprintf(&obj_info[idx],"HD %d",hd_num);
    idx += strlen(&obj_info[idx]);
    if (record[HD_CODE] == '9')
      sprintf(&obj_info[idx],"/%d",hd_num + 1);
    else if (record[HD_CODE] == '1')
      sprintf(&obj_info[idx]," (brighter of pair)");
    else if (record[HD_CODE] == '2')
      sprintf(&obj_info[idx]," (fainter of pair)");
    else
      ;
    idx += strlen(&obj_info[idx]);

    advance_to_tab();
    advance_to_tab();
  }

/* display the GC number */
  if (strncmp(&record[GC_START],"     ",5) != EQUAL) {
    ljust(&record[GC_START],5);
    sprintf(&obj_info[idx],"GC %.5s",&record[GC_START]);
    idx += strlen(&obj_info[idx]);
  }

/* space down some */
  blank_line();

/* display the position */
  display_pos(&record[POS_RA_START],&record[POS_DEC_START]);

/* add the source catalog number */
  if (strncmp(&record[SOURCE_CAT_NUM_START],"     ",5) != EQUAL) {
    GET_FIELD(field,record,SOURCE_CAT_CODE_START,2);
    source_code = atoi(field);

    GET_FIELD(field,record,SOURCE_CAT_NUM_START,5);
    source_num = atoi(field);

    next_line();
    add_string("Source:  ");
    if ((source_code == 1) || (source_code == 2))
      sprintf(&obj_info[idx],"AGK2 Volume %d, #%d",source_code,source_num);
    else if ((source_code >= 3) && (source_code <= 6))
      sprintf(&obj_info[idx],"AGK2 Volume %d, #%d",source_code + 2,source_num);
    else if ((source_code >= 20) && (source_code <= 38)) {
      add_string("Yale Transactions ");
      switch (source_code) {
      case 20:
	sprintf(&obj_info[idx],"11, #%d",source_num);
	break;
      case 21:
	sprintf(&obj_info[idx],"12 - Part I, #%d",source_num);
	break;
      case 22:
	sprintf(&obj_info[idx],"12 - Part II, #%d",source_num);
	break;
      case 23:
	sprintf(&obj_info[idx],"13 - Part I, #%d",source_num);
	break;
      case 24:
	sprintf(&obj_info[idx],"12 - Part I, #%d",source_num);
	break;
      case 25:
	sprintf(&obj_info[idx],"14, #%d",source_num);
	break;
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 34:
      case 35:
	sprintf(&obj_info[idx],"%d, #%d",source_code - 10,source_num);
	break;
      case 32:
	sprintf(&obj_info[idx],"22 - Part I, #%d",source_num);
	break;
      case 33:
	sprintf(&obj_info[idx],"22 - Part II, #%d",source_num);
	break;
      case 36:
	sprintf(&obj_info[idx],"26 - Part I, #%d",source_num);
	break;
      case 37:
	sprintf(&obj_info[idx],"26 - Part II, #%d",source_num);
	break;
      case 38:
	sprintf(&obj_info[idx],"27, #%d",source_num);
	break;
      default:
	sprintf(&obj_info[idx],"???");
	break;
      }
    }
    else if ((source_code >= 40) && (source_code <= 43))
      sprintf(&obj_info[idx],"Cape Annals %d, #%d",source_code - 23,
	                                                          source_num);
    else if (source_code == 48)
      sprintf(&obj_info[idx],"Cape Zone #%d",source_num);
    else if ((source_code == 60) || (source_code == 61))
      sprintf(&obj_info[idx],"Melbourne %d, #%d",source_code - 57,source_num);
    else if (source_code == 70)
      sprintf(&obj_info[idx],"GC #%d",source_num);
    else if (source_code == 71)
      sprintf(&obj_info[idx],"FK3 #%d",source_num);
    else if (source_code == 74)
      sprintf(&obj_info[idx],"FK4 #%d",source_num);
    else
      sprintf(&obj_info[idx],"???");
    idx += strlen(&obj_info[idx]);
    blank_line();
  }

/* display double star component data */
  if (strncmp(&record[COMPONENTS_START],"  ",2) != EQUAL) {
    sprintf(&obj_info[idx],"Components:  %c %c",record[COMPONENTS_START],
						record[COMPONENTS_START + 1]);
    idx += strlen(&obj_info[idx]);
    blank_line();
  }

/* now display the magnitudes, if any */
  if (strncmp(&record[MAG_PG_START],"99.999.9",8) != EQUAL) {
    sprintf(&obj_info[idx],"Magnitude - ");
    idx += strlen(&obj_info[idx]);

    if (strncmp(&record[MAG_PG_START],"99.9",4) != EQUAL) {
      sprintf(&obj_info[idx],"photographic:  %.4s",&record[MAG_PG_START]);
      idx += strlen(&obj_info[idx]);
      advance_to_tab();
      advance_to_tab();
    }

    if (strncmp(&record[MAG_VIS_START],"99.9",4) != EQUAL) {
      sprintf(&obj_info[idx],"visual:  %.4s",&record[MAG_VIS_START]);
      idx += strlen(&obj_info[idx]);
    }

    blank_line();
  }

/* add the spectral class */
  if (strncmp(&record[SPECTRUM_START],"   ",3) != EQUAL) {
    add_string("Spectral classification:  ");
    if (strncmp(&record[SPECTRUM_START],"+++",3) == EQUAL)
      sprintf(&obj_info[idx],"composite");
    else
      sprintf(&obj_info[idx],"%.3s",&record[SPECTRUM_START]);
    idx += strlen(&obj_info[idx]);
    blank_line();
  }

/* list the proper motions */
  sprintf(&obj_info[idx],"Annual proper motion - RA:  %.2s\".%.4s",
					&record[PROPER_MOTION_RA_START],
					&record[PROPER_MOTION_RA_START + 3]);
  idx += strlen(&obj_info[idx]);
  advance_to_tab();
  advance_to_tab();
  sprintf(&obj_info[idx],"Dec:  %.2s\".%.3s",
					&record[PROPER_MOTION_DEC_START],
					&record[PROPER_MOTION_DEC_START + 3]);
  idx += strlen(&obj_info[idx]);

/* fill the display out to the correct number of lines */
  while (row < NUM_SAO_ROWS)
    next_line();
  obj_info[idx] = '\0';

/* and go back */
  return;
}



static void display_pos(ra_posptr,dec_posptr)

char *ra_posptr, *dec_posptr;

{
/* identify the epoch */
  add_string("Position (2000.0)");

/* fix up the RA minutes and seconds */
  if (ra_posptr[2] == ' ')
    ra_posptr[2] = '0';
  if (ra_posptr[4] == ' ')
    ra_posptr[4] = '0';

/* display the right ascension */
  advance_to_tab();
  sprintf(&obj_info[idx]," RA:   %.2sh %.2sm %.2ss.%.3s",
	                                        &ra_posptr[0],&ra_posptr[2],
						&ra_posptr[4],&ra_posptr[7]);
  idx += strlen(&obj_info[idx]);
  next_line();

/* fix up the declination minutes and seconds */
  if (dec_posptr[3] == ' ')
    dec_posptr[3] = '0';
  if (dec_posptr[5] == ' ')
    dec_posptr[5] = '0';

/* and display the declination */
  advance_to_tab();
  advance_to_tab();
  advance_to_tab();
  sprintf(&obj_info[idx],"Dec:  %.3sd %.2s' %.2s\".%.2s",
	                                      &dec_posptr[0],&dec_posptr[3],
	                                      &dec_posptr[5],&dec_posptr[8]);
  idx += strlen(&obj_info[idx]);
  idx += strlen(&obj_info[idx]);
  next_line();

  return;
}
