/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-3, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

/* this routine formats and displays a QSO record */

#include <stdio.h>

#include <string.h>

#include "qso.h"

#include "skydefs.h"

#include "format.h"

/* static function prototypes */
static void display_pos PROTOTYPE((char *));

#define MAX_QSO_ROW   65
#define NUM_QSO_ROWS  17



void format_qso_display(record)

char *record;

{
  char *ptr;

/* start at the beginning of the display */
  idx = 0;
  row = 0;
  row_start = 0;
  max_row = MAX_QSO_ROW;

/* display the catalog number */
  sprintf(&obj_info[idx],"QSO %.8s",&record[CAT_START]);
  idx += strlen(&obj_info[idx]);
  advance_to_tab();

/* now display the object type */
  if (record[TYPE_START] == '*')
    add_string("BL Lacertae object");

/* space down some */
  blank_line();

/* display the position */
  display_pos(&record[POS_RA_START]);

/* now display the magnitude */
  blank_line();
  add_string("Mag:");
  advance_to_tab();
  sprintf(&obj_info[idx],"%.5s",&record[MAG_START]);
  idx += strlen(&obj_info[idx]);
  if (record[VARIABLE_START] == '*') {
    advance_to_tab();
    add_string("(variable)");
  }

/* space down some more */
  blank_line();

/* display the redshift */
  add_string("Redshift:");
  advance_to_tab();
  sprintf(&obj_info[idx],"%.5s",&record[REDSHIFT_START]);
  idx += strlen(&obj_info[idx]);
  blank_line();

/* display other names, if any; wipe out the newline first  */
  record[strlen(record) - 1] = '\0';
  if (strspn(&record[OTHER_NAMES_START]," ") !=
					strlen(&record[OTHER_NAMES_START])) {
    add_string("Other names:");
    blank_line();
    ptr = strtok(&record[OTHER_NAMES_START],",");
    do {
      sprintf(&obj_info[idx],"%s, ",ptr);
      idx += strlen(&obj_info[idx]);
    } while ((ptr = strtok((char *)NULL,",")) != (char *)NULL);
  }

  /* wipe out the trailing ", " */
  idx -= 2;
  obj_info[idx] = '\0';

/* fill the display out to the correct number of lines */
  while (row < NUM_QSO_ROWS)
    next_line();
  obj_info[idx] = '\0';

/* and go back */
	return;
}



static void display_pos(posptr)

char *posptr;

{
/* identify the epoch */
  add_string("Position (1950.0)");

/* ensure that the right ascension is filled out properly */
  if (posptr[7] == ' ')
    posptr[7] = '0';
  if (posptr[8] == ' ')
    posptr[8] = '0';

/* display the right ascension */
  advance_to_tab();
  sprintf(&obj_info[idx]," RA:   %.2sh %.2sm %.2ss%.3s",&posptr[0],&posptr[2],
						        &posptr[4],&posptr[6]);
  idx += strlen(&obj_info[idx]);
  next_line();

/* ensure that the declination is filled out properly */
  if (posptr[17] == ' ')
    posptr[17] = '0';

/* and display the declination */
  advance_to_tab();
  advance_to_tab();
  advance_to_tab();
  sprintf(&obj_info[idx],"Dec:  %.3sd %.2s' %.2s\"%.2s",
	                                             &posptr[9],&posptr[12],
	                                             &posptr[14],&posptr[16]);
  idx += strlen(&obj_info[idx]);
  next_line();

  return;
}
