/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-6, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

/* some nice geometric constants */
#ifndef PI
#define PI   M_PI
#endif

#define DEGREES_PER_RAD   ((double)360 / (2 * PI))
#define RAD_PER_DEGREE    (1 / DEGREES_PER_RAD)

#define DEGREES_PER_HOUR  (360 / 24)
#define RAD_PER_HOUR      (DEGREES_PER_HOUR * RAD_PER_DEGREE)

/* some nice geometric conversions */
#define ARCSEC_TO_RAD(a)  (((double)(a) / 60 / 60) / DEGREES_PER_RAD)

#define RAD_TO_DEG(r)   ((double)(r) * DEGREES_PER_RAD)
#define DEG_TO_RAD(d)   ((double)(d) / DEGREES_PER_RAD)

#define RAD_TO_HOUR(r)  (RAD_TO_DEG(r) / DEGREES_PER_HOUR)

/* a minimum function */
#define min(a,b)   ((a) < (b) ? (a) : (b))

/* a maximum function */
#define max(a,b)   ((a) > (b) ? (a) : (b))

struct ra_pos {
  smallint hours;
  smallint minutes;
  smallint seconds;
  shortint thousandths;
};

struct dec_pos {
  short sign;
  smallint degrees;
  smallint minutes;
  smallint seconds;
  smallint hundredths;
};

#define SCALECHANGE   0x01
#define CENTERCHANGE  0x02
#define MAGCHANGE     0x04
#define SIZECHANGE    0x08

struct state {
  struct state *next;
  short changeflags;
  float scale;
  double center_ra_rad, center_dec_rad;
  float mag_limit;
  int shell_width, shell_height;
};

struct display {
  int width, height;                      /* width and height in pixels */
  double width_rad, height_rad;           /* width and height in radians */
  float scale;                            /* degrees per pixel */
  boolean downunder_flag;                 /* TRUE if southern hemisphere */
  boolean redraw_flag;                    /* TRUE if entire display redraw */
  boolean rubberband_flag;                /* TRUE if rubberbanding */
  boolean place_id_flag;                  /* TRUE if placing an object ID */
  boolean move_id_flag;                   /* TRUE if we're moving an ID */
  boolean undo_resize_flag;               /* TRUE if we're undoing a resize */
  struct ra_pos ra_pos;                   /* RA in natural units */
  struct dec_pos dec_pos;                 /* declination in natural units */
  double center_ra_rad, center_dec_rad;   /* display center in radians */
  double initial_ra_rad, initial_dec_rad; /* initial center in radians */
  double left_ra_rad, right_ra_rad;       /* limits to RA on display */
  double top_dec_rad, bottom_dec_rad;     /* limits to dec on display */
  int form_width, form_height;            /* size of shell, really */
  int ptr_x_offset, ptr_y_offset;         /* pointer offset for label moving */
  struct state *old_state;                /* old sky display state */
};
