/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1995, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

#define NGC_DESC_FILE   "ngc_desc.tab"

/* length of buffer to accumulate pieces of description */
#define	MAXDESCLEN    50

/* number of descriptions (plus fudge) in the NGC description table */
#define	MAXNUMDESCS   600

/* maximum length (plus fudge) of a recognized description */
#define	MAX_DESC_NAME     15

struct key_desc {
  char desc_name[MAX_DESC_NAME + 1];
  char *desc_string;
};

struct ambig {
  shortint cat_number;
  smallint ngc_ic_flag;
};

/* "l" ambiguity file and number of little/long ambiguity table entries */
#define NGC_L_AMBIG_FILE   "ngc_l_amb.dat"
#define NUM_L_AMBIG   20

/* "s" ambiguity file and number of south/suddenly ambiguity table entries */
#define NGC_S_AMBIG_FILE   "ngc_s_amb.dat"
#define NUM_S_AMBIG   210
