/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-3, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

/* table to translate Messier numbers into RNGC numbers */

#ifndef NUM_MESSIER_OBJS
#define NUM_MESSIER_OBJS   109
#endif

int messier_trans[NUM_MESSIER_OBJS] = {
1952,
7089,
5272,
6121,
5904,
6405,
6475,
6523,
6333,
6254,  /* 10 */
6705,
6218,
6205,
6402,
7078,
6611,
6618,
6613,
6273,
6514,  /* 20 */
6531,
6656,
6494,
6603,  /* controversial; ID from Messier's Nebulae and Star Clusters, Jones */
0,     /* 25 */
6694,
6853,
6626,
6913,
7099,  /* 30 */
224,
221,
598,
1039,
2168,
1960,
2099,
1912,
7092,
0,     /* 40 */
2287,
1976,
1982,
2632,
0,     /* 45 */
2437,
2422,
2548,
4472,
2323,  /* 50 */
5194,
7654,
5024,
6715,
6809,
6779,
6720,
4579,
4621,
4649,  /* 60 */
4303,
6266,
5055,
4826,
3623,
3627,
2682,
4590,
6637,
6681,  /* 70 */
6838,
6981,
6994,
628,
6864,
650,
1068,
2068,
1904,
6093,  /* 80 */
3031,
3034,
5236,
4374,
4382,
4406,
4486,
4501,
4552,
4569,  /* 90 */
4548,  /* 91; controversial - ID is from Dreyer's 1888 Catalog of 7840 Gal. */
6341,
2447,
4736,
3351,
3368,
3587,
4192,
4254,
4321,  /* 100 */
5457,
5866,  /* 102; controversial - ID is from Dreyer's 1888 Catalog of 7840 Gal. */
581,
4594,
3379,
4258,
6171,
3556,
3992  /* 109 */
};
