/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-5, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

/* use the heapsort algorithm to sort an array of arbitrarily-sized elements
 * by an externally-defined key.  heapsort algorithm is from Horowitz and
 * Sahni, Fundamentals of Data Structures, p. 358 */

#include <stdlib.h>

#include <sys/types.h>

#ifdef STANDALONE
#ifdef __STDC__
/* static function prototypes */
static int compare(int *,int *);

/* global function prototypes */
void hs_heapsort(char [],size_t,size_t, int (*)());
#else   /* not __STDC__ */
/* static function prototypes */
static int compare();

/* global function prototypes */
void hs_heapsort();
#endif
#endif

typedef unsigned char boolean;

#ifndef FALSE
#define FALSE  (boolean)0
#endif

#ifndef TRUE
#define TRUE   (boolean)(! FALSE)
#endif

#ifdef SYSV
/* certain bogus System V systems don't have bcopy() */
#define bcopy(src,dst,len)   (void)memmove(dst,src,len)
#endif

#define R(n)  ((char *)&array[(n - 1) * size])

#define adjust(i,n)							\
{									\
/* reset done flag */							\
  quit = FALSE;								\
									\
/* save element i */							\
  bcopy(R(i),(char *)aux,(int)size);					\
  j = 2 * i;								\
									\
/* find max of left and right child */					\
  while (j <= n) {							\
    if ((j < n) && ((*compare)(R(j),R(j + 1)) < 0))			\
      j++;								\
									\
    /* if parent is max, then done */					\
    if ((*compare)(aux,R(j)) >= 0) {					\
      bcopy((char *)aux,R(j / 2),(int)size);				\
      quit = TRUE;							\
      break;								\
    }									\
									\
    /* move element j up the tree */					\
    bcopy(R(j),R(j / 2),(int)size);					\
    j *= 2;								\
  }									\
									\
  if (! quit)								\
    bcopy((char *)aux,R(j / 2),(int)size);				\
}



#ifdef STANDALONE

#define ARRAYSIZE  10

main()

{
  int i;
  int array[ARRAYSIZE];

  for (i = 0; i < ARRAYSIZE; i++)
    array[i] = 2000 - i;

  hs_heapsort(array,ARRAYSIZE,sizeof(int),compare);

  for (i = 0; i < ARRAYSIZE; i++)
    if (array[i] != 2000 - ARRAYSIZE + 1 + i)
      printf("array element %d is %d, which is wrong\n",i,array[i]);

  exit(0);
}



static int compare(i,j)

int *i, *j;

{
  if (*i < *j)
    return(-1);
  else if (*i > *j)
    return(1);
  else
    return(0);

/* NOTREACHED */
}

#endif     /* STANDALONE */



void hs_heapsort(array,count,size,compare)

char array[];
size_t count;
size_t size;
int (*compare)();

{
  void *aux;
  void *temp;
  int k;
  int j;
  boolean quit;

/* get space for auxiliary elements */
  aux = (void *)malloc((unsigned int)size);
  temp = (void *)malloc((unsigned int)size);

/* convert into a heap */
  for (k = count / 2; k >= 1; k--)
    adjust(k,(int)count);

/* sort */
  for (k = count - 1; k >= 1; k--) {
    /* interchange element 1 and k + 1 */
    bcopy(R(k + 1),(char *)temp,(int)size);
    bcopy(R(1),R(k + 1),(int)size);
    bcopy((char *)temp,R(1),(int)size);

    /* recreate heap */
    adjust(1,k);
  }

/* return the auxiliary space */
  free(aux);
  free(temp);

  return;
}
