/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-3, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

struct type_table {
	char *type_id;
	char *type_desc;
	};

static struct type_table gcvs_types[] = {
		{"(B)","multiple pulsation modes"},
		{"(B:)","multiple pulsation modes?"},
		{"(YY)","YY Orionis - absorption on redward side of emission \
lines due to matter infall"},
		{"ACV","Alpha Canum Venaticorum - rotation"},
		{"ACVO","Alpha Canum Venaticorum - rotation with pulsation"},
		{"ACYG","ff Cygni - nonradially pulsating supergiant"},
		{"AR","AR Lacertae - both components within Roche lobes"},
		{"BCEP","beta Cephei - pulsating O8 - B6"},
		{"BCEPS","short-period beta Cephei"},
		{"BLLAC","BL Lacertae - compact QSO"},
		{"BY","BY Draconis - rotating emission-line dwarf"},
		{"CEP","Cepheid"},
		{"CST","constant - mistakenly identified as variable"},
		{"CW","W Virginis - long period, in galactic halo"},
		{"CWA","W Virginis - period > 8 days, in galactic halo"},
		{"CW","W Virginis - period < 8 days, in galactic halo"},
		{"D","detached - both components within Roche lobes"},
		{"DM","detached main sequence - both components within \
Roche lobes"},
		{"DS","detached - subgiant within Roche lobe"},
		{"DW","W Ursae Majoris, but not in contact"},
		{"DCEP","classical Cepheid"},
		{"DCEPS","small-amplitude classical Cepheid"},
		{"DSCT","delta Scuti - small amplitude, short period"},
		{"DSCTC","low-amplitude delta Scuti"},
		{"E","eclipsing binary"},
		{"EA","beta Persei (Algol) eclipsing binary"},
		{"EB","beta Lyrae eclipsing binary"},
		{"ELL","rotating ellipsiodal binary"},
		{"EW","W Ursae Majoris eclipsing binary"},
		{"FKCOM","FK Coma Berenices - rapidly rotating giant"},
		{"FU","FU Orionis"},
		{"GAL","QSO or AGN"},
		{"GCAS","Gamma Cas eruptive irregular"},
		{"GS","one or both giant or supergiant"},
		{"I","irregular with unknown features"},
		{"IA","irregular of early spectral class (O-A)"},
		{"IB","irregular of late spectral class (F-M)"},
		{"IN","Orion - irregular, eruptive"},
		{"INA","Orion of early spectral class (B-A or Ae)"},
		{"INB","Orion of intermediate to late spectral class (F-M)"},
		{"INS","Orion with rapid light variation"},
		{"INSB","Orion of intermediate to late spectral class (F-M) \
- rapid light variation"},
		{"INST","T Tauri with rapid light variation"},
		{"INT","T Tauri irregular"},
		{"IN","Orion - eruptive, connected with nebulosity"},
		{"IS","rapid irregular"},
		{"ISA","rapid irregular of early spectral class (B-A or Ae)"},
		{"ISB","rapid irregular of late spectral class (F-M)"},
		{"K","contact system"},
		{"KE","contact system - early spectral class"},
		{"KW","W Ursae Majoris - in contact"},
		{"L:","unstudied - slow light changes"},
		{"L","slow irregular"},
		{"LB","slow irregular of late spectral class"},
		{"LC","irregular supergiant of late spectral class"},
		{"M","Mira - long-period giant"},
		{"N","nova"},
		{"NA","fast nova"},
		{"NB","slow nova"},
		{"NC","nova with long maximum and extremely slow decline"},
		{"NL","nova-like"},
		{"NR","recurrent nova (T Coronae Borealis)"},
		{"PN","nuclei of planetary nebulae (UU Sagittae)"},
		{"PSR","optically-variable pulsar"},
		{"PVTEL","PV Telescopii - helium supergiant Bp"},
		{"QSO","QSO"},
		{"RCB","R Coronae Borealis - nonperiodic"},
		{"RR","RR Lyrae"},
		{"RRAB","RR Lyrae with asymmetric light curve"},
		{"RRC","RR Lyrae with nearly symmetrical light curve"},
		{"RS","RS Canum Venaticorum - eruptive"},
		{"RVA","RV Tauri with constant mean brightness"},
		{"RVB","RV Tauri with periodic mean brightness"},
		{"S:","unstudied - rapid light changes"},
		{"SD","semi-detached"},
		{"SDOR","S Doradus - high-luminosity blue eruptive"},
		{"SN","supernova (B Cassiopeiae, CM Tauri)"},
		{"SNI","type I supernova"},
		{"SNII","type II supernova"},
		{"SR","semiregular"},
		{"SRA","semiregular M, C, or S giant with stable period"},
		{"SRB","semiregular M, C, or S giant with unstable period"},
		{"SRC","semiregular M, C, or S supergiant"},
		{"SRD","semiregular giant/supergiant of class F, G, or K"},
		{"SXARI","SX Arietis - rotating main-sequence B0p - B9p"},
		{"SXPHE","SX Phoenicis - pulsating subdwarf in galactic halo"},
		{"ZZ","ZZ Ceti - nonradially-pulsating white dwarf"},
		{"ZZA","ZZ Ceti of spectral type dA"},
		{"ZZB","ZZ Ceti of spectral type dB"},
		{"UG","U Geminorum - dwarf nova"},
		{"UGSS","U Geminorum - dwarf nova of SS Cygni type"},
		{"UGSU","U Geminorum - dwarf nova of SU Ursae Majoris type"},
		{"UGZ","U Geminorum - dwarf nova of Z Camelopardalis type"},
		{"UV","UV Ceti - flare star"},
		{"UVN","flaring Orion of spectral class Ke - Me"},
		{"WD","white dwarf"},
		{"WR","eruptive Wolf-Rayet"},
		{"X","X-ray variable"},
		{"XB","X-ray burster"},
		{"XF","fluctuating X-ray variable (Cygnus X-1)"},
		{"XI","X-ray irregular"},
		{"XJ","X-ray binary"},
		{"XND","nova-like X-ray system with dwarf or subgiant"},
		{"XNG","nova-like X-ray system with early supergiant"},
		{"XP","X-ray pulsar"},
		{"XR","X-ray system with reflection effect"},
		{"XRM","magnetic X-ray system with reflection effect"},
		{"XPR","X-ray pulsar with reflection effect"},
		{"XPRM","magnetic X-ray pulsar with reflection effect"},
		{"ZAND","Z Andromedae (symbiotic)"},
		{"*","unique - unclassified"},
		{NULL,NULL}
		};
