/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-3, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

#define GCVS_CATALOG_NAME   "General Catalog of Variable Stars, 4th ed."

#define GCVS_MENU_NAME       "GCVS"

#define GCVS_EPOCH           1950.0

#define MAX_GCVS                 28484

#define GCVS_RECLEN              158

#define CONSTELLATION_NUMBER    0        /* nn */
#define	NUMBER_START		2        /* zzzz */
#define COMPONENT_ID            6        /* x */
#define NAME_START              7        /* xxxxx */
#define	CONSTELLATION_NAME	12       /* xxx */
#define REMARK_FLAG             15       /* x, * = "further info in catalog" */
#define	POS_RA_START		16       /* hhmmss, equinox 1950.0 */
#define POS_DEC_START           22       /* sddmm.m, equinox 1950.0 */
#define	VAR_TYPE_START		64       /* xxxxxxxxx */
#define	MAX_MAG_LIMIT		73       /* x, ) means lower limit */
#define	MAX_MAG                 74       /* nnn.nnn */
#define MAX_MAG_UNCERTAIN       81       /* x, : means approximate */
#define	MIN_MAG_LIMIT		82       /* x, ( means upper limit */
#define MIN_MAG                 83       /* nn.nnn */
#define MIN_MAG_SYSTEM          89       /* x, e. g. U or R */
#define MIN_MAG_UNCERTAIN       90       /* x, : means approximate */
#define MIN_MAG_DIFF            91       /* x, ) means min. is differential */
#define MAGNITUDE_CODE          92       /* x, P or V or UBVRIJHKL */
#define	EPOCH                   93       /* nnnnnnn.nnnnnn, Julian date */
#define EPOCH_UNCERTAIN         107      /* x, :/+/- means uncertain */
#define NOVA_YEAR               108      /* (yyyy) */
#define NOVA_UNCERTAIN          114      /* x, : means uncertain */
#define	PERIOD_LIMIT		115      /* x, </>/( */
#define PERIOD                  116      /* nnnn.nnnnnnnnnn, days */
#define PERIOD_UNCERTAIN        132      /* x, : means approximate */
#define PERIOD_UNKNOWN_FLAG     133      /* x, N means unknown */
#define	RISE_DURATION           135      /* nnn, 0.01 of period */
#define RISE_DURATION_UNCERTAIN 138      /* x, : if rise/duration is approx. */
#define DURATION_ZERO_FLAG      139      /* x, * if eclipse duration = 0 */
#define	SPECTRUM_START		140      /* xxxxxxxxxxxxxxxxx */
#define	NOTE_FLAG		157      /* x, = or N for nonexistent */

#define NAME_LENGTH            5
#define VAR_TYPE_LENGTH        9
#define MAX_MAG_LENGTH         7
#define MIN_MAG_LENGTH         6
#define EPOCH_LENGTH          14
#define PERIOD_LENGTH         16
#define RISE_DURATION_LENGTH   3
#define SPECTRUM_LENGTH       17
