/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-5, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

/* buffer for object display information */
extern char obj_info[];

/* variables controlling data formatter */
extern int idx;
extern int row;
extern int row_start;
extern int max_row;

/* function declarations for display-formatting routines */
#ifdef __STDC__
void ljust(char *,int);
void lzsupp(char *,int);
void add_space(int);
void add_char(char);
void add_string(char *);
void advance_to_tab();
void advance_tabs(int);
void next_line();
void blank_line();
#else   /* not __STDC__ */
void ljust();
void lzsupp();
void add_space();
void add_char();
void add_string();
void advance_to_tab();
void advance_tabs();
void next_line();
void blank_line();
#endif   /* __STDC__ */

#define FIT(s)   (((idx - row_start) + strlen(s) + 1) <= max_row)
