/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-3, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

#include <string.h>

/* buffer for object display information */
extern char obj_info[];

int idx;
int row;
int row_start;
int max_row;




void ljust(field,len)

char *field;
int len;

{
/* left-justify a field of length len */
  int i;

  while (field[0] == ' ') {
    for (i = 1; i < len; i++)
      field[i - 1] = field[i];
    field[len - 1] = ' ';
  }
  return;
}



void lzsupp(field,len)

char *field;
int len;

{
/* suppress leading zeroes in a field of length len */
	int i;

	i = -1;
	while (++i < len)
		if (field[i] == '0')
			field[i] = ' ';
		else
			break;
	return;
}



void add_space(n)

int n;

{
/* advance n spaces */
  while (n-- > 0)
    obj_info[idx++] = ' ';

  return;
}



void add_char(c)

char c;

{
/* add the given character */
  obj_info[idx++] = c;

  return;
}



void add_string(str)

char *str;

{
/* add the given string to the display */
  strcpy(&obj_info[idx],str);
  idx += strlen(str);

  return;
}



void advance_to_tab()

{
/* advance the index number to the next tab stop in this row */
  if (((idx - row_start) % 8) == 0)
    obj_info[idx++] = ' ';
  while (((idx - row_start) % 8) != 0)
    obj_info[idx++] = ' ';

  return;
}



void advance_tabs(n)

int n;

{
/* advance the given number of tab stops */
  while (n > 0) {
    advance_to_tab();
    n--;
  }

  return;
}



void next_line()

{
/* fill out the current line with spaces */
  while ((idx - row_start) < max_row)
    obj_info[idx++] = ' ';

/* advance to the next line */
  obj_info[idx++] = '\n';
  row_start = idx;
  row++;

  return;
}



void blank_line()

{
  next_line();
  next_line();

  return;
}
