/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-6, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

/* maximum length of an ID string */
#define MAX_ID_STRING  20

/* names for the identification text fonts */
#define LATIN_ID_FONT    "LatinID"
#define LATIN_CON_FONT   "LatinCon"
#define GREEK_ID_FONT    "Greek"

/* enumeration for the identification text fonts */
typedef enum { GREEK, LATIN_ID, LATIN_CON } IDfont;

struct id_node {
  struct id_node *next;
  struct cat_header *obj_catalog;
  int obj_index;
  double ra_rad, dec_rad;
  Position obj_x, obj_y;
  Position x, y;
  int ul_x, ul_y;
  int lr_x, lr_y;
  IDfont font;
  boolean show_flag;
  boolean redraw_flag;
  char id_buffer[MAX_ID_STRING + 1];
};

/* names for the colors of the standard spectral classes */
typedef enum { O, B, A, F, G, K, M } StarColor;

/* names for the shapes of object representations */
typedef enum { SQUARE, CIRCLE, ELLIPSE, XMARK } ObjShape;

/* brightest star is our friend Sirius */
#define MAXSTARMAG   -1.46

/* if the maximum size of a star is undefined, default to 11 pixels */
#ifndef MAXSTARSIZE
#define MAXSTARSIZE   11
#endif

/* function to compute pixel diameter of a star from its magnitude -
 * MAXSTARMAG = MAXSTARSIZE pixels; stars never less than 2 pixels */
#define SZ(mag)  (-(int)floor(mag) + (MAXSTARSIZE + (int)floor(MAXSTARMAG)))

#ifdef BIGSTARS
/* expand the scale by a factor of two to look more like printed atlases */
#define STARSIZE(mag)  (SZ(mag) < 2 ? 2 : 2 * SZ(mag))
#else
/* keep star sizes smaller to conserve display space */
#define STARSIZE(mag)  (SZ(mag) < 2 ? 2 : SZ(mag))
#endif

/* mean size of a non-stellar object */
#ifndef OBJSIZE
#define OBJSIZE   4
#endif
