/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-3, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

/* standard constellation abbreviations, alphabetically by abbreviation */
char *constellations_abbrev[NUM_CONSTELLATIONS] = {
  "And",         /* Andromeda */
  "Ant",         /* Antlia */
  "Aps",         /* Apus */
  "Aql",         /* Aquila */
  "Aqr",         /* Aquarius */
  "Ara",         /* Ara */
  "Ari",         /* Aries */
  "Aur",         /* Auriga */
  "Boo",         /* Bootes */
  "Cae",         /* Caelum */
  "Cam",         /* Camelopardus */
  "Cap",         /* Capricornus */
  "Car",         /* Carina */
  "Cas",         /* Cassiopeia */
  "Cen",         /* Centaurus */
  "Cep",         /* Cepheus */
  "Cet",         /* Cetus */
  "Cha",         /* Chamaeleon */
  "Cir",         /* Circinis */
  "CMa",         /* Canis Major */
  "CMi",         /* Canis Minor */
  "Cnc",         /* Cancer */
  "Col",         /* Columba */
  "Com",         /* Coma Berenices */
  "CrA",         /* Corona Australis */
  "CrB",         /* Corona Borealis */
  "Crt",         /* Crater */
  "Cru",         /* Crux */
  "Crv",         /* Corvus */
  "CVn",         /* Canes Venatici */
  "Cyg",         /* Cygnus */
  "Del",         /* Delphinus */
  "Dor",         /* Dorado */
  "Dra",         /* Draco */
  "Equ",         /* Equuleus */
  "Eri",         /* Eridanus */
  "For",         /* Fornax */
  "Gem",         /* Gemini */
  "Gru",         /* Grus */
  "Her",         /* Hercules */
  "Hor",         /* Horologium */
  "Hya",         /* Hydra */
  "Hyi",         /* Hydrus */
  "Ind",         /* Indus */
  "Lac",         /* Lacerta */
  "Leo",         /* Leo */
  "Lep",         /* Lepus */
  "Lib",         /* Libra */
  "LMi",         /* Leo Minor */
  "Lup",         /* Lupus */
  "Lyn",         /* Lynx */
  "Lyr",         /* Lyra */
  "Men",         /* Mensa */
  "Mic",         /* Microscopium */
  "Mon",         /* Monoceros */
  "Mus",         /* Musca */
  "Nor",         /* Norma */
  "Oct",         /* Octans */
  "Oph",         /* Ophiuchus */
  "Ori",         /* Orion */
  "Pav",         /* Pavo */
  "Peg",         /* Pegasus */
  "Per",         /* Perseus */
  "Phe",         /* Phoenix */
  "Pic",         /* Pictor */
  "PsA",         /* Piscis Austrinis */
  "Psc",         /* Pisces */
  "Pup",         /* Puppis */
  "Pyx",         /* Pyxis */
  "Ret",         /* Reticulum */
  "Scl",         /* Sculptor */
  "Sco",         /* Scorpius */
  "Sct",         /* Scutum */
  "Ser",         /* Serpens */
  "Sex",         /* Sextans */
  "Sge",         /* Sagitta */
  "Sgr",         /* Sagittarius */
  "Tau",         /* Taurus */
  "Tel",         /* Telescopium */
  "TrA",         /* Triangulum Australe */
  "Tri",         /* Triangulum */
  "Tuc",         /* Tucans */
  "UMa",         /* Ursa Major */
  "UMi",         /* Ursa Minor */
  "Vel",         /* Vela */
  "Vir",         /* Virgo */
  "Vol",         /* Volans */
  "Vul"          /* Vulpecula */
  };

/* this list follows the constellation order of the previous list */
char *constellations_latin[NUM_CONSTELLATIONS] = {
  "Andromedae",            /* Andromeda */
  "Antliae",               /* Antlia */
  "Apodis",                /* Apus */
  "Aquilae",               /* Aquila */
  "Aquarii",               /* Aquarius */
  "Arae",                  /* Ara */
  "Arietis",               /* Aries */
  "Aurigae",               /* Auriga */
  "Bootis",                /* Bootes */
  "Caeli",                 /* Caelum */
  "Camelopardis",          /* Camelopardus */
  "Capricorni",            /* Capricornis */
  "Carinae",               /* Carina */
  "Cassiopeiae",           /* Cassiopeia */
  "Centauri",              /* Centaurus */
  "Cephei",                /* Cepheus */
  "Ceti",                  /* Cetus */
  "Chamaeleontis",         /* Chamaeleon */
  "Circini",               /* Circinus */
  "Canis Majoris",         /* Canis Major */
  "Canis Minoris",         /* Canis Minor */
  "Cancri",                /* Cancer */
  "Columbae",              /* Columba */
  "Comae Berenices",       /* Coma Berenices */
  "Coronae Australis",     /* Corona Australis */
  "Coronae Borealis",      /* Corona Borealis */
  "Crateris",              /* Crater */
  "Crucis",                /* Crux */
  "Corvi",                 /* Corvus */
  "Canum Venaticorum",     /* Canes Venatici */
  "Cygni",                 /* Cygnus */
  "Delphini",              /* Delphinus */
  "Doradus",               /* Dorado */
  "Draconis",              /* Draco */
  "Equulei",               /* Equuleus */
  "Eridani",               /* Eridanus */
  "Fornacis",              /* Fornax */
  "Geminorum",             /* Gemini */
  "Gruis",                 /* Grus */
  "Herculis",              /* Hercules */
  "Horologii",             /* Horologium */
  "Hydrae",                /* Hydra */
  "Hydri",                 /* Hydrus */
  "Indi",                  /* Indus */
  "Lacertae",              /* Lacerta */
  "Leonis",                /* Leo */
  "Leporis",               /* Lepus */
  "Librae",                /* Libra */
  "Leonis Minoris",        /* Leo Minor */
  "Lupi",                  /* Lupus */
  "Lyncis",                /* Lynx */
  "Lyrae",                 /* Lyra */
  "Mensae",                /* Mensa */
  "Microscopii",           /* Microscopium */
  "Monocerotis",           /* Monoceros */
  "Muscae",                /* Musca */
  "Normae",                /* Norma */
  "Octantis",              /* Octans */
  "Ophiuchi",              /* Ophiuchus */
  "Orionis",               /* Orion */
  "Pavonis",               /* Pavo */
  "Pegasi",                /* Pegasus */
  "Persei",                /* Perseus */
  "Phoenicis",             /* Phoenix */
  "Pictoris",              /* Pictor */
  "Piscis Austrini",       /* Piscis Austrinis */
  "Piscium",               /* Pisces */
  "Puppis",                /* Puppis */
  "Pyxidis",               /* Pyxis */
  "Reticuli",              /* Reticulum */
  "Sculptoris",            /* Sculptor */
  "Scorpii",               /* Scorpius */
  "Scuti",                 /* Scutum */
  "Serpentis",             /* Serpens */
  "Sextantis",             /* Sextans */
  "Sagittae",              /* Sagitta */
  "Sagittarii",            /* Sagittarius */
  "Tauri",                 /* Taurus */
  "Telescopii",            /* Telescopium */
  "Trianguli Australis",   /* Triangulum Australe */
  "Trianguli",             /* Triangulum */
  "Tucanae",               /* Tucans */
  "Ursae Majoris",         /* Ursa Major */
  "Ursae Minoris",         /* Ursa Minor */
  "Velorum",               /* Vela */
  "Virginis",              /* Virgo */
  "Volantis",              /* Volans */
  "Vulpeculae"             /* Vulpecula */
  };


/* this list follows the constellation order of the first list */
char *constellations[NUM_CONSTELLATIONS] = {
  "Andromeda",
  "Antlia",
  "Apus",
  "Aquila",
  "Aquarius",
  "Ara",
  "Aries",
  "Auriga",
  "Bootes",
  "Caelum",
  "Camelopardus",
  "Capricornis",
  "Carina",
  "Cassiopeia",
  "Centaurus",
  "Cepheus",
  "Cetus",
  "Chamaeleon",
  "Circinus",
  "Canis Major",
  "Canis Minor",
  "Cancer",
  "Columba",
  "Coma Berenices",
  "Corona Australis",
  "Corona Borealis",
  "Crater",
  "Crux",
  "Corvus",
  "Canes Venatici",
  "Cygnus",
  "Delphinus",
  "Dorado",
  "Draco",
  "Equuleus",
  "Eridanus",
  "Fornax",
  "Gemini",
  "Grus",
  "Hercules",
  "Horologium",
  "Hydra",
  "Hydrus",
  "Indus",
  "Lacerta",
  "Leo",
  "Lepus",
  "Libra",
  "Leo Minor",
  "Lupus",
  "Lynx",
  "Lyra",
  "Mensa",
  "Microscopium",
  "Monoceros",
  "Musca",
  "Norma",
  "Octans",
  "Ophiuchus",
  "Orion",
  "Pavo",
  "Pegasus",
  "Perseus",
  "Phoenix",
  "Pictor",
  "Piscis Austrinis",
  "Pisces",
  "Puppis",
  "Pyxis",
  "Reticulum",
  "Sculptor",
  "Scorpius",
  "Scutum",
  "Serpens",
  "Sextans",
  "Sagitta",
  "Sagittarius",
  "Taurus",
  "Telescopium",
  "Triangulum Australe",
  "Triangulum",
  "Tucans",
  "Ursa Major",
  "Ursa Minor",
  "Vela",
  "Virgo",
  "Volans",
  "Vulpecula"
};
