/*
 * This table, a list of east-west constellation south boundary lines, is
 * due to Dr. Nancy G. Roman (1987, Publ. Astron. Soc. Pacific, 99, 695).
 * The data below is adapted from the machine-readable version provided
 * by NASA's Astronomical Data Center.
 *
 * The table has been constructed to allow easy identification of the
 * constellation in which a given position is located.
 */

static struct {
  float ral, rau, decl;
  int conidx;
} bound_list[] = {
  {  0.0000, 24.0000,  88.0000, 83 },
  {  8.0000, 14.5000,  86.5000, 83 },
  { 21.0000, 23.0000,  86.1667, 83 },
  { 18.0000, 21.0000,  86.0000, 83 },
  {  0.0000,  8.0000,  85.0000, 15 },
  {  9.1667, 10.6667,  82.0000, 10 },
  {  0.0000,  5.0000,  80.0000, 15 },
  { 10.6667, 14.5000,  80.0000, 10 },
  { 17.5000, 18.0000,  80.0000, 83 },
  { 20.1667, 21.0000,  80.0000, 33 },
  {  0.0000,  3.5083,  77.0000, 15 },
  { 11.5000, 13.5833,  77.0000, 10 },
  { 16.5333, 17.5000,  75.0000, 83 },
  { 20.1667, 20.6667,  75.0000, 15 },
  {  7.9667,  9.1667,  73.5000, 10 },
  {  9.1667, 11.3333,  73.5000, 33 },
  { 13.0000, 16.5333,  70.0000, 83 },
  {  3.1000,  3.4167,  68.0000, 13 },
  { 20.4167, 20.6667,  67.0000, 33 },
  { 11.3333, 12.0000,  66.5000, 33 },
  {  0.0000,  0.3333,  66.0000, 15 },
  { 14.0000, 15.6667,  66.0000, 83 },
  { 23.5833, 24.0000,  66.0000, 15 },
  { 12.0000, 13.5000,  64.0000, 33 },
  { 13.5000, 14.4167,  63.0000, 33 },
  { 23.1667, 23.5833,  63.0000, 15 },
  {  6.1000,  7.0000,  62.0000, 10 },
  { 20.0000, 20.4167,  61.5000, 33 },
  { 20.5367, 20.6000,  60.9167, 15 },
  {  7.0000,  7.9667,  60.0000, 10 },
  {  7.9667,  8.4167,  60.0000, 82 },
  { 19.7667, 20.0000,  59.5000, 33 },
  { 20.0000, 20.5367,  59.5000, 15 },
  { 22.8667, 23.1667,  59.0833, 15 },
  {  0.0000,  2.4333,  58.5000, 13 },
  { 19.4167, 19.7667,  58.0000, 33 },
  {  1.7000,  1.9083,  57.5000, 13 },
  {  2.4333,  3.1000,  57.0000, 13 },
  {  3.1000,  3.1667,  57.0000, 10 },
  { 22.3167, 22.8667,  56.2500, 15 },
  {  5.0000,  6.1000,  56.0000, 10 },
  { 14.0333, 14.4167,  55.5000, 82 },
  { 14.4167, 19.4167,  55.5000, 33 },
  {  3.1667,  3.3333,  55.0000, 10 },
  { 22.1333, 22.3167,  55.0000, 15 },
  { 20.6000, 21.9667,  54.8333, 15 },
  {  0.0000,  1.7000,  54.0000, 13 },
  {  6.1000,  6.5000,  54.0000, 50 },
  { 12.0833, 13.5000,  53.0000, 82 },
  { 15.2500, 15.7500,  53.0000, 33 },
  { 21.9667, 22.1333,  52.7500, 15 },
  {  3.3333,  5.0000,  52.5000, 10 },
  { 22.8667, 23.3333,  52.5000, 13 },
  { 15.7500, 17.0000,  51.5000, 33 },
  {  2.0417,  2.5167,  50.5000, 62 },
  { 17.0000, 18.2333,  50.5000, 33 },
  {  0.0000,  1.3667,  50.0000, 13 },
  {  1.3667,  1.6667,  50.0000, 62 },
  {  6.5000,  6.8000,  50.0000, 50 },
  { 23.3333, 24.0000,  50.0000, 13 },
  { 13.5000, 14.0333,  48.5000, 82 },
  {  0.0000,  1.1167,  48.0000, 13 },
  { 23.5833, 24.0000,  48.0000, 13 },
  { 18.1750, 18.2333,  47.5000, 39 },
  { 18.2333, 19.0833,  47.5000, 33 },
  { 19.0833, 19.1667,  47.5000, 30 },
  {  1.6667,  2.0417,  47.0000, 62 },
  {  8.4167,  9.1667,  47.0000, 82 },
  {  0.1667,  0.8667,  46.0000, 13 },
  { 12.0000, 12.0833,  45.0000, 82 },
  {  6.8000,  7.3667,  44.5000, 50 },
  { 21.9083, 21.9667,  44.0000, 30 },
  { 21.8750, 21.9083,  43.7500, 30 },
  { 19.1667, 19.4000,  43.5000, 30 },
  {  9.1667, 10.1667,  42.0000, 82 },
  { 10.1667, 10.7833,  40.0000, 82 },
  { 15.4333, 15.7500,  40.0000,  8 },
  { 15.7500, 16.3333,  40.0000, 39 },
  {  9.2500,  9.5833,  39.7500, 50 },
  {  0.0000,  2.5167,  36.7500,  0 },
  {  2.5167,  2.5667,  36.7500, 62 },
  { 19.3583, 19.4000,  36.5000, 51 },
  {  4.5000,  4.6917,  36.0000, 62 },
  { 21.7333, 21.8750,  36.0000, 30 },
  { 21.8750, 22.0000,  36.0000, 44 },
  {  6.5333,  7.3667,  35.5000,  7 },
  {  7.3667,  7.7500,  35.5000, 50 },
  {  0.0000,  2.0000,  35.0000,  0 },
  { 22.0000, 22.8167,  35.0000, 44 },
  { 22.8167, 22.8667,  34.5000, 44 },
  { 22.8667, 23.5000,  34.5000,  0 },
  {  2.5667,  2.7167,  34.0000, 62 },
  { 10.7833, 11.0000,  34.0000, 82 },
  { 12.0000, 12.3333,  34.0000, 29 },
  {  7.7500,  9.2500,  33.5000, 50 },
  {  9.2500,  9.8833,  33.5000, 48 },
  {  0.7167,  1.4083,  33.0000,  0 },
  { 15.1833, 15.4333,  33.0000,  8 },
  { 23.5000, 23.7500,  32.0833,  0 },
  { 12.3333, 13.2500,  32.0000, 29 },
  { 23.7500, 24.0000,  31.3333,  0 },
  { 13.9583, 14.0333,  30.7500, 29 },
  {  2.4167,  2.7167,  30.6667, 80 },
  {  2.7167,  4.5000,  30.6667, 62 },
  {  4.5000,  4.7500,  30.0000,  7 },
  { 18.1750, 19.3583,  30.0000, 51 },
  { 11.0000, 12.0000,  29.0000, 82 },
  { 19.6667, 20.9167,  29.0000, 30 },
  {  4.7500,  5.8833,  28.5000,  7 },
  {  9.8833, 10.5000,  28.5000, 48 },
  { 13.2500, 13.9583,  28.5000, 29 },
  {  0.0000,  0.0667,  28.0000,  0 },
  {  1.4083,  1.6667,  28.0000, 80 },
  {  5.8833,  6.5333,  28.0000,  7 },
  {  7.8833,  8.0000,  28.0000, 37 },
  { 20.9167, 21.7333,  28.0000, 30 },
  { 19.2583, 19.6667,  27.5000, 30 },
  {  1.9167,  2.4167,  27.2500, 80 },
  { 16.1667, 16.3333,  27.0000, 25 },
  { 15.0833, 15.1833,  26.0000,  8 },
  { 15.1833, 16.1667,  26.0000, 25 },
  { 18.3667, 18.8667,  26.0000, 51 },
  { 10.7500, 11.0000,  25.5000, 48 },
  { 18.8667, 19.2583,  25.5000, 51 },
  {  1.6667,  1.9167,  25.0000, 80 },
  {  0.7167,  0.8500,  23.7500, 66 },
  { 10.5000, 10.7500,  23.5000, 48 },
  { 21.2500, 21.4167,  23.5000, 87 },
  {  5.7000,  5.8833,  22.8333, 77 },
  {  0.0667,  0.1417,  22.0000,  0 },
  { 15.9167, 16.0333,  22.0000, 73 },  /* Caput */
  {  5.8833,  6.2167,  21.5000, 37 },
  { 19.8333, 20.2500,  21.2500, 87 },
  { 18.8667, 19.2500,  21.0833, 87 },
  {  0.1417,  0.8500,  21.0000,  0 },
  { 20.2500, 20.5667,  20.5000, 87 },
  {  7.8083,  7.8833,  20.0000, 37 },
  { 20.5667, 21.2500,  19.5000, 87 },
  { 19.2500, 19.8333,  19.1667, 87 },
  {  3.2833,  3.3667,  19.0000,  6 },
  { 18.8667, 19.0000,  18.5000, 75 },
  {  5.7000,  5.7667,  18.0000, 59 },
  {  6.2167,  6.3083,  17.5000, 37 },
  { 19.0000, 19.8333,  16.1667, 75 },
  {  4.9667,  5.3333,  16.0000, 77 },
  { 15.9167, 16.0833,  16.0000, 39 },
  { 19.8333, 20.2500,  15.7500, 75 },
  {  4.6167,  4.9667,  15.5000, 77 },
  {  5.3333,  5.6000,  15.5000, 77 },
  { 12.8333, 13.5000,  15.0000, 23 },
  { 17.2500, 18.2500,  14.3333, 39 },
  { 11.8667, 12.8333,  14.0000, 23 },
  {  7.5000,  7.8083,  13.5000, 37 },
  { 16.7500, 17.2500,  12.8333, 39 },
  {  0.0000,  0.1417,  12.5000, 61 },
  {  5.6000,  5.7667,  12.5000, 77 },
  {  7.0000,  7.5000,  12.5000, 37 },
  { 21.1167, 21.3333,  12.5000, 61 },
  {  6.3083,  6.9333,  12.0000, 37 },
  { 18.2500, 18.8667,  12.0000, 39 },
  { 20.8750, 21.0500,  11.8333, 31 },
  { 21.0500, 21.1167,  11.8333, 61 },
  { 11.5167, 11.8667,  11.0000, 45 },
  {  6.2417,  6.3083,  10.0000, 59 },
  {  6.9333,  7.0000,  10.0000, 37 },
  {  7.8083,  7.9250,  10.0000, 21 },
  { 23.8333, 24.0000,  10.0000, 61 },
  {  1.6667,  3.2833,   9.9167,  6 },
  { 20.1417, 20.3000,   8.5000, 31 },
  { 13.5000, 15.0833,   8.0000,  8 },
  { 22.7500, 23.8333,   7.5000, 61 },
  {  7.9250,  9.2500,   7.0000, 21 },
  {  9.2500, 10.7500,   7.0000, 45 },
  { 18.2500, 18.6622,   6.2500, 58 },
  { 18.6622, 18.8667,   6.2500,  3 },
  { 20.8333, 20.8750,   6.0000, 31 },
  {  7.0000,  7.0167,   5.5000, 20 },
  { 18.2500, 18.4250,   4.5000, 73 },  /* Cauda */
  { 16.0833, 16.7500,   4.0000, 39 },
  { 18.2500, 18.4250,   3.0000, 58 },
  { 21.4667, 21.6667,   2.7500, 61 },
  {  0.0000,  2.0000,   2.0000, 66 },
  { 18.5833, 18.8667,   2.0000, 73 },  /* Cauda */
  { 20.3000, 20.8333,   2.0000, 31 },
  { 20.8333, 21.3333,   2.0000, 34 },
  { 21.3333, 21.4667,   2.0000, 61 },
  { 22.0000, 22.7500,   2.0000, 61 },
  { 21.6667, 22.0000,   1.7500, 61 },
  {  7.0167,  7.2000,   1.5000, 20 },
  {  3.5833,  4.6167,   0.0000, 77 },
  {  4.6167,  4.6667,   0.0000, 59 },
  {  7.2000,  8.0833,   0.0000, 20 },
  { 14.6667, 15.0833,   0.0000, 85 },
  { 17.8333, 18.2500,   0.0000, 58 },
  {  2.6500,  3.2833,  -1.7500, 16 },
  {  3.2833,  3.5833,  -1.7500, 77 },
  { 15.0833, 16.2667,  -3.2500, 73 },  /* Caput */
  {  4.6667,  5.0833,  -4.0000, 59 },
  {  5.8333,  6.2417,  -4.0000, 59 },
  { 17.8333, 17.9667,  -4.0000, 73 },  /* Cauda */
  { 18.2500, 18.5833,  -4.0000, 73 },  /* Cauda */
  { 18.5833, 18.8667,  -4.0000,  3 },
  { 22.7500, 23.8333,  -4.0000, 66 },
  { 10.7500, 11.5167,  -6.0000, 45 },
  { 11.5167, 11.8333,  -6.0000, 85 },
  {  0.0000,  0.3333,  -7.0000, 66 },
  { 23.8333, 24.0000,  -7.0000, 66 },
  { 14.2500, 14.6667,  -8.0000, 85 },
  { 15.9167, 16.2667,  -8.0000, 58 },
  { 20.0000, 20.5333,  -9.0000,  3 },
  { 21.3333, 21.8667,  -9.0000,  4 },
  { 17.1667, 17.9667, -10.0000, 58 },
  {  5.8333,  8.0833, -11.0000, 54 },
  {  4.9167,  5.0833, -11.0000, 35 },
  {  5.0833,  5.8333, -11.0000, 59 },
  {  8.0833,  8.3667, -11.0000, 41 },
  {  9.5833, 10.7500, -11.0000, 74 },
  { 11.8333, 12.8333, -11.0000, 85 },
  { 17.5833, 17.6667, -11.6667, 58 },
  { 18.8667, 20.0000, -12.0333,  3 },
  {  4.8333,  4.9167, -14.5000, 35 },
  { 20.5333, 21.3333, -15.0000,  4 },
  { 17.1667, 18.2500, -16.0000, 73 },  /* Cauda */
  { 18.2500, 18.8667, -16.0000, 72 },
  {  8.3667,  8.5833, -17.0000, 41 },
  { 16.2667, 16.3750, -18.2500, 58 },
  {  8.5833,  9.0833, -19.0000, 41 },
  { 10.7500, 10.8333, -19.0000, 26 },
  { 16.2667, 16.3750, -19.2500, 58 },
  { 15.6667, 15.9167, -20.0000, 47 },
  { 12.5833, 12.8333, -22.0000, 28 },
  { 12.8333, 14.2500, -22.0000, 85 },
  {  9.0833,  9.7500, -24.0000, 41 },
  {  1.6667,  2.6500, -24.3833, 16 },
  {  2.6500,  3.7500, -24.3833, 35 },
  { 10.8333, 11.8333, -24.5000, 26 },
  { 11.8333, 12.5833, -24.5000, 28 },
  { 14.2500, 14.9167, -24.5000, 47 },
  { 16.2667, 16.7500, -24.5833, 58 },
  {  0.0000,  1.6667, -25.5000, 16 },
  { 21.3333, 21.8667, -25.5000, 11 },
  { 21.8667, 23.8333, -25.5000,  4 },
  { 23.8333, 24.0000, -25.5000, 16 },
  {  9.7500, 10.2500, -26.5000, 41 },
  {  4.7000,  4.8333, -27.2500, 35 },
  {  4.8333,  6.1167, -27.2500, 46 },
  { 20.0000, 21.3333, -28.0000, 11 },
  { 10.2500, 10.5833, -29.1667, 41 },
  { 12.5833, 14.9167, -29.5000, 41 },
  { 14.9167, 15.6667, -29.5000, 47 },
  { 15.6667, 16.0000, -29.5000, 71 },
  {  4.5833,  4.7000, -30.0000, 35 },
  { 16.7500, 17.6000, -30.0000, 58 },
  { 17.6000, 17.8333, -30.0000, 76 },
  { 10.5833, 10.8333, -31.1667, 41 },
  {  6.1167,  7.3667, -33.0000, 19 },
  { 12.2500, 12.5833, -33.0000, 41 },
  { 10.8333, 12.2500, -35.0000, 41 },
  {  3.5000,  3.7500, -36.0000, 36 },
  {  8.3667,  9.3667, -36.7500, 68 },
  {  4.2667,  4.5833, -37.0000, 35 },
  { 17.8333, 19.1667, -37.0000, 76 },
  { 21.3333, 23.0000, -37.0000, 65 },
  { 23.0000, 23.3333, -37.0000, 70 },
  {  3.0000,  3.5000, -39.5833, 36 },
  {  9.3667, 11.0000, -39.7500,  1 },
  {  0.0000,  1.6667, -40.0000, 70 },
  {  1.6667,  3.0000, -40.0000, 36 },
  {  3.8667,  4.2667, -40.0000, 35 },
  { 23.3333, 24.0000, -40.0000, 70 },
  { 14.1667, 14.9167, -42.0000, 14 },
  { 15.6667, 16.0000, -42.0000, 49 },
  { 16.0000, 16.4208, -42.0000, 71 },
  {  4.8333,  5.0000, -43.0000,  9 },
  {  5.0000,  6.5833, -43.0000, 22 },
  {  8.0000,  8.3667, -43.0000, 67 },
  {  3.4167,  3.8667, -44.0000, 35 },
  { 16.4208, 17.8333, -45.5000, 71 },
  { 17.8333, 19.1667, -45.5000, 24 },
  { 19.1667, 20.3333, -45.5000, 76 },
  { 20.3333, 21.3333, -45.5000, 53 },
  {  3.0000,  3.4167, -46.0000, 35 },
  {  4.5000,  4.8333, -46.5000,  9 },
  { 15.3333, 15.6667, -48.0000, 49 },
  {  0.0000,  2.3333, -48.1667, 63 },
  {  2.6667,  3.0000, -49.0000, 35 },
  {  4.0833,  4.2667, -49.0000, 40 },
  {  4.2667,  4.5000, -49.0000,  9 },
  { 21.3333, 22.0000, -50.0000, 38 },
  {  6.0000,  8.0000, -50.7500, 67 },
  {  8.0000,  8.1667, -50.7500, 84 },
  {  2.4167,  2.6667, -51.0000, 35 },
  {  3.8333,  4.0833, -51.0000, 40 },
  {  0.0000,  1.8333, -51.5000, 63 },
  {  6.0000,  6.1667, -52.5000, 12 },
  {  8.1667,  8.4500, -53.0000, 84 },
  {  3.5000,  3.8333, -53.1667, 40 },
  {  3.8333,  4.0000, -53.1667, 32 },
  {  0.0000,  1.5833, -53.5000, 63 },
  {  2.1667,  2.4167, -54.0000, 35 },
  {  4.5000,  5.0000, -54.0000, 64 },
  { 15.0500, 15.3333, -54.0000, 49 },
  {  8.4500,  8.8333, -54.5000, 84 },
  {  6.1667,  6.5000, -55.0000, 12 },
  { 11.8333, 12.8333, -55.0000, 14 },
  { 14.1667, 15.0500, -55.0000, 49 },
  { 15.0500, 15.3333, -55.0000, 56 },
  {  4.0000,  4.3333, -56.5000, 32 },
  {  8.8333, 11.0000, -56.5000, 84 },
  { 11.0000, 11.2500, -56.5000, 14 },
  { 17.5000, 18.0000, -57.0000,  5 },
  { 18.0000, 20.3333, -57.0000, 78 },
  { 22.0000, 23.3333, -57.0000, 38 },
  {  3.2000,  3.5000, -57.5000, 40 },
  {  5.0000,  5.5000, -57.5000, 64 },
  {  6.5000,  6.8333, -58.0000, 12 },
  {  0.0000,  1.3333, -58.5000, 63 },
  {  1.3333,  2.1667, -58.5000, 35 },
  { 23.3333, 24.0000, -58.5000, 63 },
  {  4.3333,  4.5833, -59.0000, 32 },
  { 15.3333, 16.4208, -60.0000, 56 },
  { 20.3333, 21.3333, -60.0000, 43 },
  {  5.5000,  6.0000, -61.0000, 64 },
  { 15.1667, 15.3333, -61.0000, 18 },
  { 16.4208, 16.5833, -61.0000,  5 },
  { 14.9167, 15.1667, -63.5833, 18 },
  { 16.5833, 16.7500, -63.5833,  5 },
  {  6.0000,  6.8333, -64.0000, 64 },
  {  6.8333,  9.0333, -64.0000, 12 },
  { 11.2500, 11.8333, -64.0000, 14 },
  { 11.8333, 12.8333, -64.0000, 27 },
  { 12.8333, 14.5333, -64.0000, 14 },
  { 13.5000, 13.6667, -65.0000, 18 },
  { 16.7500, 16.8333, -65.0000,  5 },
  {  2.1667,  3.2000, -67.5000, 40 },
  {  3.2000,  4.5833, -67.5000, 69 },
  { 14.7500, 14.9167, -67.5000, 18 },
  { 16.8333, 17.5000, -67.5000,  5 },
  { 17.5000, 18.0000, -67.5000, 60 },
  { 22.0000, 23.3333, -67.5000, 81 },
  {  4.5833,  6.5833, -70.0000, 32 },
  { 13.6667, 14.7500, -70.0000, 18 },
  { 14.7500, 17.0000, -70.0000, 79 },
  {  0.0000,  1.3333, -75.0000, 81 },
  {  3.5000,  4.5833, -75.0000, 42 },
  {  6.5833,  9.0333, -75.0000, 86 },
  {  9.0333, 11.2500, -75.0000, 12 },
  { 11.2500, 13.6667, -75.0000, 55 },
  { 18.0000, 21.3333, -75.0000, 60 },
  { 21.3333, 23.3333, -75.0000, 43 },
  { 23.3333, 24.0000, -75.0000, 81 },
  {  0.7500,  1.3333, -76.0000, 81 },
  {  0.0000,  3.5000, -82.5000, 42 },
  {  7.6667, 13.6667, -82.5000, 17 },
  { 13.6667, 18.0000, -82.5000,  2 },
  {  3.5000,  7.6667, -85.0000, 52 },
  {  0.0000, 24.0000, -90.0000, 57 }
};
