/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-5, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

struct obj_node {
  struct obj_node *next;
  int array_pos;
  Position x, y;
};

struct cat_header {
  struct cat_header *next_cat;
  struct obj_node *obj_list_head;
  struct obj_node *obj_list_rear;
  boolean show_flag;
  char *menu_name;
  char *catalog_name;
  FILE *file_fd;
  Widget datashell, datadialog, dataack;
  Widget catselect;
  FILE *(*read_data)();
  void (*calculate_field)();
  boolean (*mag_limit_check)();
  boolean (*find_object)();
  void (*get_object_pos)();
  void (*draw_object)();
  boolean (*ps_draw_object)();
  boolean (*display_data)();
  void (*format_name)();
};

/* maximum length of initial catalog list */
#define INITIAL_CATLIST_LEN   100

/* default initial active catalog */
#define INITIAL_CATALOG   "YBS"
