/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-5, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

#include <stdio.h>
#include <stdlib.h>

#include <string.h>

#include <X11/Intrinsic.h>

#include "skydefs.h"

#include "catdefs.h"
#include "catalog.h"

/* static function prototypes */
static struct cat_header *get_catalog_header PROTOTYPE((void));

/* external function prototyupes */
extern void init_user PROTOTYPE((struct cat_header *));
#ifdef HAVE_QSO
extern void init_qso PROTOTYPE((struct cat_header *));
#endif
#ifdef HAVE_DBL
extern void init_dbl PROTOTYPE((struct cat_header *));
#endif
#ifdef HAVE_WDS
extern void init_wds PROTOTYPE((struct cat_header *));
#endif
#ifdef HAVE_VAR
extern void init_var PROTOTYPE((struct cat_header *));
#endif
#ifdef HAVE_GCVS
extern void init_gcvs PROTOTYPE((struct cat_header *));
#endif
#ifdef HAVE_SAO
extern void init_sao PROTOTYPE((struct cat_header *));
#endif
#ifdef HAVE_SAOJ2000
extern void init_saoj2000 PROTOTYPE((struct cat_header *));
#endif
#ifdef HAVE_RNGC
extern void init_rngc PROTOTYPE((struct cat_header *));
#endif
#ifdef HAVE_NGC2000
extern void init_ngc2000 PROTOTYPE((struct cat_header *));
#endif
#ifdef HAVE_YBS
extern void init_ybs PROTOTYPE((struct cat_header *));
#endif
#ifdef HAVE_BSC5
extern void init_bsc5 PROTOTYPE((struct cat_header *));
#endif
#ifdef HAVE_UGC
extern void init_ugc PROTOTYPE((struct cat_header *));
#endif

extern boolean check_user_cat PROTOTYPE((void));

struct cat_header *cat_list_head = (struct cat_header *)NULL;



void catalog_init()

{
  struct cat_header *catalog;

/* build the catalog list (the catalogs will appear in the catalog selection
 * menu in the opposite order from which they are built here) */

  /* the user catalog goes first so it's last */
  if (check_user_cat())
    init_user(get_catalog_header());

#ifdef HAVE_QSO
  init_qso(get_catalog_header());
#endif

#ifdef HAVE_DBL
  init_dbl(get_catalog_header());
#endif

#ifdef HAVE_WDS
  init_wds(get_catalog_header());
#endif

#ifdef HAVE_VAR
  init_var(get_catalog_header());
#endif

#ifdef HAVE_GCVS
  init_gcvs(get_catalog_header());
#endif

#ifdef HAVE_SAO
  init_sao(get_catalog_header());
#endif

#ifdef HAVE_SAOJ2000
  init_saoj2000(get_catalog_header());
#endif

#ifdef HAVE_RNGC
  init_rngc(get_catalog_header());
#endif

#ifdef HAVE_NGC2000
  init_ngc2000(get_catalog_header());
#endif

#ifdef HAVE_YBS
  init_ybs(get_catalog_header());
#endif

#ifdef HAVE_BSC5
  init_bsc5(get_catalog_header());
#endif

#ifdef HAVE_UGC
  init_ugc(get_catalog_header());
#endif

/* read all catalogs */
  catalog = cat_list_head;
  while (catalog != (struct cat_header *)NULL) {
    catalog->file_fd = (*catalog->read_data)();
    catalog = catalog->next_cat;
  }

  return;
}



/* get a new catalog header and add it to the list */

static struct cat_header *get_catalog_header()

{
  struct cat_header *catalog;

  catalog = (struct cat_header *)malloc(sizeof(struct cat_header));
  catalog->next_cat = cat_list_head;
  cat_list_head = catalog;
  catalog->obj_list_head = catalog->obj_list_rear = (struct obj_node *)NULL;

  return(catalog);
}



struct cat_header *find_catalog_by_menu(menuname)

char *menuname;

{
  struct cat_header *catalog;

/* scan all catalogs, checking for a menu name match */
  catalog = cat_list_head;
  while (catalog != (struct cat_header *)NULL)
    if (strcmp(catalog->menu_name,menuname) == EQUAL)
      break;
    else
      catalog = catalog->next_cat;

/* return the catalog pointer */
  return(catalog);
}
