/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-3, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

#define BSC5_CATALOG_NAME   "Bright Star Catalogue, 5th Rev. Ed."

#define BSC5_MENU_NAME      "BSC5"

#define BSC5_EPOCH          2000.0

#define MAX_BSC5		9110

#define BSC5_RECLEN		197

#define	HR_NUMBER		0    /* nnnn; HR number */
#define	FLAMSTEED_NUMBER	4    /* nnn */
#define NAME_START              5    /* name for otherwise-blank records */
#define BAYER_DESIGNATION	7    /* xxx; Greek letter plus superscript */
#define BAYER_SUPERSCRIPT       10   /* n */
#define	CONSTELLATION_NAME	11   /* xxx */
#define DM_CATALOG		14   /* xx; BD, CD, or CP */
#define DM_DEGREES		16   /* snn; sign plus degrees */
#define DM_NUMBER		19   /* nnnnn */
#define DM_SUPP_ID		24   /* x; lowercase letter */
#define	HD_NUMBER		25   /* nnnnnn; Henry Draper number */
#define SA0_NUMBER		31   /* nnnnnn */
#define FK5_NUMBER		37   /* nnnn */
#define INFRARED_FLAG		41   /* x; I if infrared source */
#define INFRARED_ID		42   /* x; blank or ' or : */
#define DOUBLE_CODE		43   /* x; W, D, S, A, I, R */
#define	ADS			44   /* xxxxx; Aitken catalogue number */
#define ADS_COMPONENT_START	49   /* xx; ADS component IDs */
#define VAR_ID_START            51   /* xxxxxxxxx; pseudo-random format */
#define RA_START		75   /* hhmmss.t */
#define DEC_START		83   /* sddmmss */
#define	VISUAL_MAG		102  /* nn.nn; normally UBV system */
#define VMAG_CODE               107  /* x; blank or H or R */
#define VMAG_UNCORR_CODE	108  /* x; : if uncertain, ? if questionable */
#define COLOR_INDICES_START     109  /* start of color indices */
#define	B_V_INDEX		109  /* nn.nn; UBV system */
#define B_V_CODE		114  /* x; : if uncertain, ? if questionable */
#define	U_B_INDEX		115  /* nn.nn; UBV system */
#define U_B_CODE		120  /* x; : if uncertain, ? if questionable */
#define	R_I_INDEX		121  /* nn.nn; Johnson system */
#define R_I_CODE		126  /* x; C, E, :, ? */
#define	SPECTRUM		127  /* xxxxxxxxxxxxxxxxxxxx; MK system */
#define SPECTRUM_CODE		147  /* x; e, v, t */
#define	PROPER_MOTION_RA	148  /* nn.nnn; FK5 system */
#define	PROPER_MOTION_DEC	154  /* nn.nnn; FK5 system */
#define PARALLAX_CODE		160  /* x; D if dynamical, blank if trig. */
#define	PARALLAX		161  /* s.nnn; arcseconds */
#define	RADIAL_VELOCITY		166  /* snnn; kilometers per second */
#define	RADIAL_VELOCITY_COMM	166  /* xxxx; variable, SB, etc. */
#define ROTATIONAL_VEL_LIMIT	174  /* x; = if limit */
#define ROTATIONAL_VEL_CODE	175  /* x; < or > */
#define ROTATIONAL_VELOCITY	176  /* nnn; Slettebak system */
#define ROT_VEL_UNCERTAIN	179  /* x; : if uncertain */
#define	DELTA_MAG		180  /* nn.n; if multiple */
#define	SEPARATION		184  /* nnnn.n; arcseconds */
#define COMPONENTS_START	190  /* xxxx */
#define TOTAL_COMPONENTS	194  /* nn */
#define REMARKS_FLAG		196  /* x; * if remarks */

#define HR_NUMBER_LENGTH         4
#define NAME_LENGTH              9
#define FLAMSTEED_LENGTH         3
#define BAYER_LENGTH             3
#define BAYER_SUPER_LENGTH       1
#define CONSTELLATION_LENGTH     3
#define DM_DEGREES_LENGTH        3
#define DM_NUMBER_LENGTH         5
#define HD_NUMBER_LENGTH         6
#define ADS_LENGTH               5
#define ADS_COMPONENT_LENGTH     2
#define VAR_ID_LENGTH            9
#define VISUAL_MAG_LENGTH        5
#define COLOR_INDICES_LENGTH    18
#define B_V_LENGTH               5
#define U_B_LENGTH               5
#define R_I_LENGTH               5
#define SPECTRUM_LENGTH         20
#define PARALLAX_LENGTH          5
#define RADIAL_VEL_LENGTH        4
#define ROTATIONAL_VEL_LENGTH    3
#define DELTA_MAG_LENGTH         4
#define SEPARATION_LENGTH        6
