/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-5, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

/* this is a generalized binary search routine, based on the binary search
 * algorithm in Sedgewick's "Algorithms", p. 198.  It differs from bsearch(3)
 * in that it works with array indices rather than pointers to table members,
 * and it returns the matching array index (or -1 on failure).
 *
 * table is a pointer to the array to be searched; the comparison routine is
 * responsible for knowing the element size
 *
 * tablemax is the maximum index into the table
 *
 * key is a pointer to the key value
 *
 * compar is a comparison routine which takes three arguments:  the table
 * address, a pointer to the key being searched for,  and a table index.
 * it returns an integer less than, equal to, or greater than, 0, depending
 * on whether the key is less than, equal to, or greater than, the value at
 * the given index
 */

#include "skydefs.h"

#ifndef NULL
#define NULL   0
#endif

/* static function prototypes */
static int int_compar PROTOTYPE((void *,void *,int));



/* binary-search a table of integers, returning the index of the match or
 * -1 if no match is found */

int binsearch(table,tablemax,key,compar)

void *table;
int tablemax;
void *key;
int (*compar)();

{
  int l, r;
  int x;
  int comparval;

/* if no comparison routine is given, use the default */
  if (compar == NULLINTFUNCTION)
    compar = int_compar;

/* binary-search looking for the key */
  l = 1;
  r = tablemax + 1;

  do {
    x = (l + r) / 2;
    comparval = (*compar)(table,key,x - 1);
    if (comparval < 0)
      r = x - 1;
    else
      l = x + 1;
  } while (! ((comparval == 0) || (l > r)));

/* return the 0-relative table index */
  if (comparval == 0)
    return(x - 1);
  else 
/* return -1 if we didn't find it */
   return(-1);

/* NOTREACHED */
}



/* comparison routine for the default array-of-integers case */

static int int_compar(table,key,idx)

void *table;
void *key;
int idx;

{
  return(*(int *)key - ((int *)table)[idx]);
}
