/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-3, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

#include <stdio.h>
#include <string.h>

#include <stdlib.h>

typedef unsigned char boolean;

#ifndef FALSE
#define FALSE  (boolean)0
#endif

#ifndef TRUE
#define TRUE   (boolean)(! FALSE)
#endif



boolean write_binary_database(file,base,itemsize,itemcount)

char *file;
void *base;
size_t itemsize;
size_t itemcount;

{
  FILE *bin_fd;
  boolean retval;

/* open the binary output file */
  if ((bin_fd = fopen(file,"w")) == (FILE *)NULL) {
    printf("sky:  error opening file %s as output\n",file);
    perror("sky");
    return(FALSE);
  }

/* write the database to the file */

  /* first, write the size and number of items in the database */
  (void)putw((int)itemsize,bin_fd);
  (void)putw((int)itemcount,bin_fd);

  /* next, write out the database itself */
  retval = (boolean)(fwrite(base,itemsize,itemcount,bin_fd) == itemcount);

/* be neat and close the file */
  if (fclose(bin_fd) == EOF)
    retval = FALSE;

/* return success/failure indicator to the caller */
  return(retval);
}



boolean read_binary_database(file,base,max)

char *file;
void *base;
int *max;

{
  FILE *bin_fd;
  size_t itemsize;
  size_t itemcount;
  boolean retval;

/* reopen the YBS database */
  if ((bin_fd = fopen(file,"r")) == (FILE *)NULL) {
    printf("sky:  error opening file %s as input\n",file);
    perror("sky");
    return(FALSE);
  }

/* read the database item size and count */
  itemsize = getw(bin_fd);
  itemcount = getw(bin_fd);

/* read the database back in */
  retval = (boolean)(fread(base,itemsize,itemcount,bin_fd) == itemcount);

/* be neat and close the file */
  (void)fclose(bin_fd);

/* return the maximum array index */
  *max = itemcount - 1;

/* return success/failure indicator to the caller */
  return(retval);
}



/* build a file path from the path environment variable and file name */

char *build_filespec(path_var,filename)

char *path_var;
char *filename;

{
  char *path;
  int pathlen;
  char *filebuff;

/* get the path from the environment */
  path = getenv(path_var);
  if (path == (char *)NULL)
    pathlen = 0;
  else
    pathlen = strlen(path);

/* get a buffer big enough to hold the filename */
  filebuff = (char *)malloc(pathlen + 1 + strlen(filename) + 1);

/* build the path */
  if (path == (char *)NULL)
    filebuff[0] = '\0';
  else {
    strcpy(filebuff,path);
    strcat(filebuff,"/");
  }

/* build the data filename */
  strcat(filebuff,filename);

/* return a pointer to the constructed file path */
  return(filebuff);
}
