/*
 * xsky - an interactive sky atlas
 *
 * Copyright 1992-3, Terry R. Friedrichsen
 *
 * This program may be copied and redistributed, in whole or in part,
 * as long as you don't try to make any money from the sale or redis-
 * tribution of the program or any part of the program, or pretend
 * that you wrote the program or any of its parts unless specifically
 * credited by the original author.
 *
 * You are free to make use of this software in your own programs, as
 * long as you credit the original author where it is due.
 */

/*
 * WARRANTY:
 * xsky was written as a learning project and as a demonstration of
 * X Window System programming.  xsky doesn't do anything; it is not
 * merchantable, and it is not fit for any purpose whatsoever.  In
 * fact, don't use xsky at all; it's free, and you're getting what
 * you paid for.
 */

#include <stdio.h>

#include <ctype.h>

#include <string.h>

#include "skydefs.h"

/* global function prototypes */
void build_argelander_table PROTOTYPE((void));
int argelander_to_ordinal PROTOTYPE((char *));
void ordinal_to_argelander PROTOTYPE((int,char *));

char argelander[NUM_ARGELANDER][3];

static boolean argelander_build_flag = FALSE;



/* convert an Argelander designation to an ordinal */

#define sum(k)  ((k) * ((k) + 1) / 2)


int argelander_to_ordinal(buff)

char *buff;

{
  int idx;

/*
 * the algorithm for valid Argelander designations is:
 *     1) if a single letter, must be >= 'R'
 *     2) if a double letter, second letter >= first
 *     3) the letter J is never used
 *
 * the Argelander designations start with 'R' through 'Z', and then 'RR'
 * through 'ZZ' (following the above rules), and then 'AA' through 'QZ'
 * (again under the above rules), for a total of 334 designations
 */

  if (strlen(buff) == 1)
    if ((! isupper(buff[0])) || (buff[0] < 'R') || (buff[0] > 'Z'))
      return(-1);
    else
      return(buff[0] - 'R' + 1);
  else if (strlen(buff) == 2) {
    if (isupper(buff[0]) && isupper(buff[1]))
      ;
    else
      return(-1);
    if ((buff[0] == 'J') || (buff[1] == 'J') || (buff[0] > buff[1]))
      return(-1);
    else {
      idx = 0;
      if (buff[0] > 'Q') {
	idx = sum('Z' - 'R' + 1) - sum(('Z' - 'R' + 1) - (buff[0] - 'R'));
	idx += buff[1] - buff[0] + 1;
	idx += argelander_to_ordinal("Z");
	return(idx);
      }
      else {
	if (buff[0] < 'J')
	  idx = sum(26 - 1) - sum((26 - 1) - (buff[0] - 'A'));
	else
	  idx = sum('Z' - 'K' + 1) - sum(('Z' - 'K' + 1) - (buff[0] - 'K')) +
	                             sum(26 - 1) - sum((26 - 1) - ('J' - 'A'));
	idx += buff[1] - buff[0] + 1;
	/* compensate for no Js */
	if ((buff[0] < 'J') && (buff[1] > 'J'))
	  idx--;
	idx += argelander_to_ordinal("ZZ");
	return(idx);
      }
    }
  }
  else
    return(-1);

/* NOTREACHED */
}



/* convert an ordinal to an Argelander designation by table lookup */

void ordinal_to_argelander(i,buff)

int i;
char *buff;

{
  strcpy(buff,argelander[i - 1]);

  return;
}



/* build the ordinal-to-Argelander lookup table */

void build_argelander_table()

{
  int i;
  char c1, c2;

/* don't bother if it's already built */
  if (argelander_build_flag)
    return;

/* start with 'R' through 'Z' */
  for (c1 = 'R', i = 0; c1 <= 'Z'; c1++, i++)
    sprintf(argelander[i],"%c",c1);

/* now do 'RR' through 'ZZ' */
  c1 = c2 = 'R';
  do {
    do {
      sprintf(argelander[i++],"%c%c",c1,c2++);
    } while (c2 <= 'Z');
    c1++;
    c2 = c1;
  } while (c1 <= 'Z');

/* apply that same technique to 'AA' through 'QZ', remembering to skip 'J' */
  c1 = c2 = 'A';
  do {
    do {
      sprintf(argelander[i++],"%c%c",c1,c2);
      if (++c2 == 'J')
	c2++;
    } while (c2 <= 'Z');
    if (++c1 == 'J')
      c1++;
    c2 = c1;
  } while (c1 < 'R');

/* flag that we've now built the Argelander table */
  argelander_build_flag = TRUE;

  return;
}
