.\"
.\" Copyright 1992 by David A. Curry
.\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that copyright
.\" notice and this permission notice appear in supporting documentation.  The
.\" author makes no representations about the suitability of this software for
.\" any purpose.  It is provided "as is" without express or implied warranty.
.\"
.TH XSAT 1.4 "February 1996" X11R5
.SH NAME
xsat \- X window system satellite tracker
.SH SYNOPSIS
.B xsat
[
.I \-toolkitoptions ...
] [
.I \-options ...
]
.SH DESCRIPTION
.PP
.I Xsat
simulates the orbits of satellites around the Earth and displays the
results of the simulation both textually and (optionally) graphically.
Facilities are provided to select the satellite,
city that visibility information is calculated for,
and maps to display ground tracks with.
.PP
When
.I xsat
is started,
it creates a window with several parts.
At the top of the window are four menu buttons,
labeled
.BR Commands ,
.BR Cities ,
.BR Satellites ,
and
.BR Maps .
Underneath the menu buttons,
the current orbit simulation parameters are displayed.
Beneath the orbit parameters is a large area for displaying maps and
satellite ground tracks.
Next is a label describing the contents of the following area,
a text window with a scrollbar.
This area is used to display orbit information,
or information about the cities and satellites in the program.
.PP
To use
.IR xsat ,
you must first select a satellite.
This is done using the
.B "Select satellite"
option from the
.B Satellites
menu,
or you can specify the satellite name as a resource or on the command line.
After selecting a satellite,
choose a city using the
.B "Select city"
option from the
.B Cities
menu,
or you can specify the city name as a resource or on the command line.
Orbit information about the satellite,
such as azimuth,
elevation,
and range,
will be calculated with regard to this city.
Now select the
.B Predict
option from the
.B Commands
menu,
wait a moment,
and the orbit information will be displayed in the text window,
where you can use the scroll bar to move through it.
This same information may be printed in PostScript or saved to a file (also
as PostScript) using the
.B Print
and
.B Save
options from the
.B Commands
menu.
.PP
To display satellite ground track information,
first select a map from the
.B Maps
menu.
It may take a few minutes to draw some of the larger maps;
fortunately,
you only need to select a map once,
and then you can run as many different orbit simulations (even with different
cities and satellites) as you want.
After selecting the map,
select
.B Predict
from the
.B Commands
menu again.
Lines will be drawn on the map,
and labeled with the time of day,
showing the path of the satellite over the particular land masses on the map.
This same information,
along with the textual information,
may be printed or saved to a file.
.PP
Printing of ground track information and maps is controlled by whether or not
a map has been selected.
Initially,
there is no map selected,
and so only textual information will be displayed on the screen,
sent to the printer,
or saved to a file.
Once a map has been selected,
the line segments for drawing the map and the ground track information,
as well as the textual information,
will be sent to the printer or saved to the file.
.SH MENUS
.PP
.I Xsat
provides four menus.
The first menu,
.BR Commands ,
provides the following options:
.TP 8
.B "Set start time"
Set the starting time of the orbit simulation.
Almost any legal format of date and time specification may be used.
The time is taken to be in the local time zone unless a different time zone
is specified.
The time of day defaults to midnight if not specified,
the year defaults to the current year.
Relative time may also be specified using words such as ``today'' and
``tomorrow.''
Note that ``4/3/92'' will always be interpreted as April 3, 1992 and never
as March 4, 1992.
The default is ``Today 00:00:00''.
.TP 8
.B "Set stop time"
Set the ending time for the orbit simulation.
The default is ``Tomorrow 00:00:00''.
.TP 8
.B "Set step time"
When performing an orbit simulation,
time is incremented from the start time to the stop time in units of the
step time.
A line is printed (providing the satellite is visible from the current city)
for each step.
The step time is given in seconds.
Note that because ground tracks are drawn as a series of straight lines,
large step times will give very poor ground tracks.
The default is 60 seconds.
.TP 8
.B "Set elevation"
Set the minimum elevation,
in degrees above the horizon,
for the satellite to be considered visible from the current city.
The default is 0 degrees.
.TP 8
.B "Time labels"
When printing ground tracks,
.I xsat
labels the tracks every so often with the current time.
When producing large tracks,
sometimes these labels get in the way of each other,
making the whole thing illegible.
This option allows you to set how often,
in minutes,
labels are printed.
The default is 2 minutes,
a value of 0 will disable the labels.
.TP 8
.B "Predict"
Run an orbit simulation using the current parameters,
and display the results on the screen.
The textual information is always printed.
If a map is selected,
ground tracks will be displayed as well.
.TP 8
.B "Print"
Run an orbit simulation and send the results in PostScript to a print
command (and command which reads from standard input).
If a map is selected,
the map and ground tracks will be sent first,
followed by the textual information.
The default print command is ``lpr''.
.TP 8
.B "Save"
Run an orbit simulation and send the results in PostScript to a file.
The default file name is ``xsatout.ps''.
.TP 8
.B "Quit"
Exit the program.
.PP
The
.B Cities
menu provides the following options:
.TP 8
.B "Show current city"
Display information about the currently selected city.
.TP 8
.B "Select a city"
Prompts for a new city.
Cities are specified as
.IR cityname ,
.I stateorcountry
with provinces such as those in Canada being considered part of the city
name.
Examples:
``Lafayette, Indiana'',
``Paris, France'',
``Toronto Ontario, Canada''.
.TP 8
.B "List cities"
List the names of all known cities in the text window.
The mouse may be used to select a city in the text window and paste it
into the city selection dialog box.
.PP
The
.B Satellites
menu provides the following options:
.TP 8
.B "Show current satellite"
Display orbital element information for the currently selected satellite.
.TP 8
.B "Select a satellite"
Prompts for a new satellite name.
.TP 8
.B "Add a satellite"
Prompts for a satellite element set, in either two-line or AMSAT format.  The
intent of this is to allow pasting in an element set from an external source.
The on-disk satellite data file is not updated.
.TP 8
.B "List satellites"
List all known satellites and their catalog numbers in the text window.
The mouse may be used to select a satellite in the text window and paste it
into the satellite selection dialog box.
.PP
The
.B Maps
menu provides the following options:
.TP 8
.B "World"
Display a map of the entire world.
.TP 8
.B "Antarctica"
Display a map of the Antarctica continent.
.TP 8
.B "Asia"
Display a map of Asia and the surrounding islands.
.TP 8
.B "Australia"
Display a map of Australia and the surrounding islands.
.TP 8
.B "Europe"
Display a map of Europe.
.TP 8
.B "Greenland"
Display a map of Greenland and the surrounding islands.
.TP 8
.B "North America"
Display a map of the North American continent.
.TP 8
.B "Pacific"
Display a map of several Pacific islands.
.TP 8
.B "South America"
Display a map of the South American continent.
.TP 8
.B "United States"
Display a map of the 48 Continental United States.
.SH OPTIONS AND RESOURCES
.PP
Most of the parameters selectable from the menus can also be specified on
the command line or via resources.
The following options and resources are understood.
In addition,
any standard X toolkit options may be specified on the command line.
.TP 8
.BI \-city " city,stateorcountry"
(.cityName)
[String]
The name of the city and state or country.
Default:
.IR none .
.TP 8
.BI \-elev " minimum elevation"
(.minElev)
[Int]
The minimum satellite elevation,
in degrees.
Default:
.IR 0 .
.TP 8
.BI \-map " mapname"
(.mapName)
[String]
The name of the map to use.
Default:
.IR none .
.TP 8
.BI \-sat " satellite name"
(.satName)
[String]
The name of the satellite to track.
Default:
.IR none .
.TP 8
.BI \-start " start time"
(.startTime)
[String]
The time to start the simulation.
Default:
.IR "Today 00:00:00" .
.TP 8
.BI \-step " step"
(.stepTime)
[Int]
The step time,
in seconds.
Default:
.IR 60 .
.TP 8
.BI \-stop " stop time"
(.stopTime)
[String]
The time to stop the simulation.
Default:
.IR "Tomorrow 00:00:00" .
.TP 8
.BI \-time " label frequency"
(.timeLabels)
[Int]
The time label frequency,
in minutes.
Default:
.IR 2 .
.TP 8
.B \-utc
(.utc)
[Boolean]
Print all times in Coordinated Universal Time (UTC),
rather than the local time zone.
Default:
.IR False .
.SH WIDGET HIERARCHY
.PP
In order to specify resources,
it is useful to know the hierarchy of widgets that compose
.IR xsat .
In the notation below,
indentation indicates hierarchical structure.
The widget class name is given first,
followed by the widget instance name.
The application class name is XSat.
.sp
.nf
.ta .5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i 6.5i 7.0i
XSat xsat
	Form form
		MenuButton Commands
			SimpleMenu menu
				SmeBSB Set start time
				SmeBSB Set stop time
				SmeBSB Set step time
				SmeBSB Set elevation
				SmeBSB Time labels
				SmeBSB Predict
				SmeBSB Print
				SmeBSB Save
				SmeBSB Quit
		MenuButton Cities
			SimpleMenu menu
				SmeBSB Show current city
				SmeBSB Select a city
				SmeBSB List cities
		MenuButton Satellites
			SimpleMenu menu
				SmeBSB Show current satellite
				SmeBSB Select a satellite
				SmeBSB List satellites
		MenuButton Maps
			SimpleMenu menu
				SmeBSB World
				SmeBSB Antarctica
				SmeBSB Asia
				SmeBSB Australia
				SmeBSB Europe
				SmeBSB Greenland
				SmeBSB North America
				SmeBSB Pacific
				SmeBSB South America
				SmeBSB United States
		Label topLabel
		Canvas canvas
		Label botLabel
		Text orbitText
		Label versLabel
	TransientShell prompt
		Dialog prompt
			Label label
			Text value
			Command command
.fi
.sp
.PP
All widgets with the exception of the Canvas widget are standard Athena
widgets,
and accept all the resources normally associated with those widgets.
See the Athena Widget Set documentation for additional information.
The Canvas widget understands the following resources:
.TP 8
.B foreground
[Pixel]
The foreground color.
Default:
.IR black .
.TP 8
.B background
[Pixel]
The background color.
Default:
.IR white .
.TP 8
.B idle_cursor
[Cursor]
The cursor to display when the window is idle.
Default:
.IR left_ptr .
.TP 8
.B busy_cursor
[Cursor]
The cursor to display when the window is busy.
Default:
.IR watch .
.TP 8
.B font
[FontStruct]
The font to use when writing text in the window.
Default:
.IR XtDefaultFont .
.SH AUTHOR
David A. Curry, N9MSW
.br
Purdue University
.br
Engineering Computer Network
.br
1285 Electrical Engineering Building
.br
West Lafayette, IN 47907
.br
davy@ecn.purdue.edu
.PP
Patched to work on color displays, with some bug fixes and enhancements by:
.sp
Terry R. Friedrichsen, N7XJO
.br
terry@venus.sunquest.com
.SH BUGS
.PP
Drawing the maps on the screen takes a long time,
especially for the world map.
It would be nice to have a more efficient way of doing this.
.PP
Due to slight variations in the maps,
the ground tracks sometimes do not go all the way to the edges of the maps.
.PP
Ground tracks are drawn using line segments,
making tracks with a large step time look real ugly.
.PP
The input checking on the cities file,
as well as for most of the dialog boxes,
is not as robust as it could be.
