/*
 * $Header: /home/orchestra5/davy/stuff/misc/xsat/RCS/xsat.h,v 1.1 92/04/10 14:08:17 davy Exp $
 *
 * Copyright 1992 by David A. Curry
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The
 * author makes no representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or implied warranty.
 *
 * Include file for xsat, defining default values, structure types, and
 * function returns.
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * 1285 Electrical Engineering Building
 * West Lafayette, IN 47907
 * davy@ecn.purdue.edu
 *
 * $Log:	xsat.h,v $
 * Revision 1.1  92/04/10  14:08:17  davy
 * Initial revision
 *
 * Revision 1.2  94/05/24  11:22:33  trf
 * 
 */

/*
 * Data files are located here.
 */
#ifndef XSATLIBDIR
#define XSATLIBDIR		"lib"
#endif

/*
 * SATFILE	- location of two-line orbital element data, in XSATLIBDIR
 * CITYFILE	- location of city information, in XSATLIBDIR
 */
#define SATFILE			"satellites.info"
#define CITYFILE		"cities.info"

/* size of buffer for two-line element lines from SATFILE (with some fudge) */
#define MAX_TLE_LINE   100

/*
 * DEFAULT_ELEV		- default satellite minimum elevation
 * DEFAULT_FILE		- default file name to save PostScript output to
 * DEFAULT_PRINT	- default command to pipe PostScript output to
 * DEFAULT_STEPTIME	- default simulation step in seconds
 * DEFAULT_STOPTIME	- default time to stop the orbital simulation
 * DEFAULT_STARTIME	- default time to start the orbital simulation
 * DEFAULT_TIMELABEL	- default time to label ground tracks in minutes
 * DEFAULT_MARGIN	- default PostScript printer margin
 */
#define DEFAULT_ELEV		0
#define DEFAULT_FILE		"xsatout.ps"
#define DEFAULT_PRINT		"lpr"
#define DEFAULT_STEPTIME	60
#define DEFAULT_STOPTIME	"tomorrow 00:00:00"
#define DEFAULT_STARTTIME	"today 00:00:00"
#define DEFAULT_TIMELABEL	2
#define DEFAULT_MARGIN		0.0

/*
 * Width and height of map window, in pixels.
 */
#define MAPWIN_HEIGHT		370
#define MAPWIN_WIDTH		730

/*
 * Send this many segments at a time to XDrawSegments.
 */
#define MAP_NSEGMENTS		8192

/*
 * Absolute value.
 */
#define abs(x)			((x) < 0 ? -(x) : (x))

/*
 * Sign.
 */
#define sgn(x)			((x) < 0 ? -1 : 1)

/*
 * Millimeters to PostScript points.
 */
#define mmtopt(x)		((x) / 25.4 * 72)

/*
 * XSAT resources.
 */
typedef struct {
	Boolean		utc;		/* display time in utc, if true	*/

	String		mapName;	/* name of initial map		*/
	String		satName;	/* name of initial satellite	*/
	String		cityName;	/* name of initial city		*/
	String		saveFile;	/* name of output save file	*/
	String		printCmd;	/* name of output print command	*/

	int		minElev;	/* initial minimum elevation	*/
	int		stepTime;	/* initial step time		*/
	int		timeLabelFreq;	/* initial time label frequency	*/

	String		stopTime;	/* initial stop time		*/
	String		startTime;	/* initial start time		*/

	float		mapLeftMargin;	/* PostScript map margins	*/
	float		mapRightMargin;
	float		mapTopMargin;
	float		mapBottomMargin;
} AppRes, *AppResPtr;

typedef struct {
	char		 *m_string;		/* string in menu	*/
	void		(*m_callback)();	/* callback function	*/
} MenuItem;

typedef struct {
	char		*m_name;	/* name of map in menu		*/
	char		*m_file;	/* file map is stored in	*/

	float		 m_minx;	/* lowest x coordinate		*/
	float		 m_miny;	/* lowest y coordinate		*/
	float		 m_maxx;	/* highest x coordinate		*/
	float		 m_maxy;	/* highest y coordinate		*/

	char		 m_partofworld;	/* true if part of world map	*/
} MapInfo;

typedef struct _c {
	char		*c_city;		/* city name		*/
	char		*c_statecountry;	/* state or country name*/

	double		 c_longitude;	/* longitude, -180..180 degrees	*/
	double		 c_latitude;	/* latitude, -90..90 degrees	*/

	double		 c_elevation;	/* elevation, meters		*/

	struct _c	*c_next;
} CityInfo;

typedef struct _s {
	char		*s_name;	/* satellite name		*/

	unsigned long	 s_satnum;	/* NORAD catalog number		*/
	double		 s_epochyear;	/* epoch year			*/
	double		 s_epochday;	/* epoch time			*/
	double		 s_decayrate;	/* orbit decay rate		*/
	char		*s_elementset;	/* element set			*/
	double		 s_inclination;	/* orbital inclination		*/
	double		 s_raan;	/* right ascension		*/
	double		 s_eccentricity; /* orbit eccentricity		*/
	double		 s_argperigee;	/* arg of perigee		*/
	double		 s_meananomaly;	/* mean anomaly			*/
	double		 s_meanmotion;	/* mean motion			*/
	unsigned long	 s_epochrev;	/* epoch revolution		*/

	struct _s	*s_next;
} SatInfo;

/*
 * Global variables.  All are declared in xsat.c.
 */
extern AppRes		appResources;

extern Widget		formWidget;
extern Widget		mapCanvas;
extern Widget		orbitText;
extern Widget		topLevel;
extern Widget		topLabel;
extern Widget		botLabel;

extern char		startTimeStr[];
extern char		stopTimeStr[];
extern char		saveFile[];
extern char		printCmd[];
extern char		tmpFile[];

extern time_t		startTime;
extern time_t		stopTime;

extern int		timeLabelFreq;
extern int		minElevation;
extern int		stepTime;

extern CityInfo		*currentCity;
extern SatInfo		*currentSat;
extern MapInfo		*currentMap;

extern FILE		*tmpFP;
extern FILE		*psFP;

/*
 * Function return values.
 */
time_t			parsedate();

CityInfo		*findCity();
SatInfo			*findSatByName();
SatInfo			*findSatByNumber();
MapInfo			*findMap();

char			*topLabelStr();
char			*saveString();
char			*safeAlloc();
void			prompt();
Widget			changeTextSource();
Boolean			verify_tle_checksum();

void			setInitialValues();
void			readCityList();
void			readSatList();
void			stripSpace();

SatInfo			*handle_twoline_format();
Boolean			handle_line_1();
Boolean			handle_line_2();
SatInfo			*handle_amsat_format();

void			commandsSetTimeLabels();
void			commandsSetStartTime();
void			commandsSetStopTime();
void			commandsSetStepTime();
void			commandsSetMinElev();
void			commandsPredict();
void			commandsPrint();
void			commandsSave();
void			commandsQuit();

void			citiesSelectCity();
void			citiesListCities();
void			citiesShowCity();

void			satellitesShowSatellite();
void			satellitesSelectSatellite();
void			satellitesAddSatellite();
void			satellitesListSatellites();

void			mapsSelectMap();
void			mapsDrawMapPS();
void			mapsDrawLineX();
void			mapsDrawTextX();
void			mapsDrawLinePS();
void			mapsDrawTextPS();

void			canvasBusy();
void			canvasIdle();
void			canvasClearPaper();
void			canvasClearScratch();
void			canvasUpdateWindow();
void			canvasDrawLinePaper();
void			canvasDrawLineScratch();
void			canvasDrawTextPaper();
void			canvasDrawTextScratch();
void			canvasDrawSegmentsPaper();
void			canvasDrawSegmentsScratch();

void			promptOkay();
