/*
 * $Header: /home/orchestra5/davy/stuff/misc/xsat/RCS/util.c,v 1.1 92/04/10 14:08:15 davy Exp $
 *
 * Copyright 1992 by David A. Curry
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The
 * author makes no representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or implied warranty.
 *
 * Utility routines.
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * 1285 Electrical Engineering Building
 * West Lafayette, IN 47907
 * davy@ecn.purdue.edu
 *
 * $Log:	util.c,v $
 * Revision 1.1  92/04/10  14:08:15  davy
 * Initial revision
 *
 * Revision 1.2  94/05/24  11:22:33  trf
 * 
 */
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/AsciiSrc.h>
#include <stdio.h>
#include <time.h>
#include <string.h>

#include "xsat.h"

static Widget	dialog;

/* set up <return> keypresses to invoke the text_return action, and modify
 * the cut-and-paste action */
static String text_trans =
   "<Key>Return:  text_return()  \n\
    <Btn2Down>:   beginning-of-line() kill-to-end-of-line()  \n\
    <Btn2Up>:     insert-selection(PRIMARY, CUT_BUFFER0) text_cut_and_paste()";

/* "the only way to pass application data into an action function is through
 * global variables" - sigh */
static XtCallbackProc dialog_callback;
static XtPointer dialog_data;

/*
 * Set up initial values for variables.
 */
void
setInitialValues()
{
	char *mktemp();

	stepTime = appResources.stepTime;
	minElevation = appResources.minElev;
	timeLabelFreq = appResources.timeLabelFreq;

	stopTime = parsedate(appResources.stopTime);
	startTime = parsedate(appResources.startTime);

	strcpy(printCmd, appResources.printCmd);
	strcpy(saveFile, appResources.saveFile);

	if (appResources.mapName != NULL) {
		if ((currentMap = findMap(appResources.mapName)) == NULL) {
			fprintf(stderr, "unknown map name: %s\n",
				appResources.mapName);
			exit(1);
		}
	}

	if (appResources.satName != NULL) {
		if ((currentSat = findSatByName(appResources.satName)) ==
		                                                       NULL) {
			fprintf(stderr, "unknown satellite name: %s\n",
				appResources.satName);
			exit(1);
		}
	}

	if (appResources.cityName != NULL) {
		if ((currentCity = findCity(appResources.cityName)) == NULL) {
			fprintf(stderr, "unknown city name: %s\n",
				appResources.cityName);
			exit(1);
		}
	}

	(void) mktemp(tmpFile);
	tmpFP = fopen(tmpFile, "w+");

#if !defined(STRUCT_TM_HAS_GMTOFF) || !defined(STRUCT_TM_HAS_ZONE)
	tzset();
#endif
}

/*
 * Prompt a user for some input.
 */
void
prompt(str, val, func)
char *str, *val;
void (*func)();
{
	Position x, y;
	Cardinal nargs;
	Arg argList[8];
	Widget w, popup;

	XtTranslateCoords(topLevel, 50, 50, &x, &y);

	nargs = 0;
	XtSetArg(argList[nargs], XtNx, x); nargs++;
	XtSetArg(argList[nargs], XtNy, y); nargs++;
	XtSetArg(argList[nargs], XtNinput, True); nargs++;
	XtSetArg(argList[nargs], XtNallowShellResize, True); nargs++;
	XtSetArg(argList[nargs], XtNtransientFor, topLevel); nargs++;
	popup = XtCreatePopupShell("prompt", transientShellWidgetClass,
				   topLevel, argList, nargs);

	nargs = 0;
	XtSetArg(argList[nargs], XtNlabel, str); nargs++;

	if (val != NULL) {
		XtSetArg(argList[nargs], XtNvalue, val);
		nargs++;
	}

	dialog = XtCreateManagedWidget("prompt", dialogWidgetClass, popup,
				       argList, nargs);

	XawDialogAddButton(dialog, "command", func, popup);

	if (val != NULL) {
		XtSetArg(argList[0], XtNresizable, True);
		XtSetArg(argList[1], XtNresize, XawtextResizeBoth);
		w = XtNameToWidget(dialog, "value");
		XtSetValues(w, argList, TWO);

		XtOverrideTranslations(w,XtParseTranslationTable(text_trans));
	}

	/* save the callback function and client data */
	dialog_callback = (XtCallbackProc)func;
	dialog_data = (XtPointer)popup;

	XtPopup(popup, XtGrabNone);
}

/*
 * Make the top label string.
 */
char *
topLabelStr(start, stop, step, elev)
time_t start, stop;
int step, elev;
{
	char *ap;
	char *tzn;
	struct tm *tp;
	char tmp[BUFSIZ];
	static char str[BUFSIZ];

	tp = appResources.utc ? gmtime(&start) : localtime(&start);
	ap = asctime(tp);

	if (appResources.utc)
		tzn = "UTC";
	else
#ifdef STRUCT_TM_HAS_ZONE
		tzn = tp->tm_zone;
#else
		if (tp->tm_isdst)
			tzn = tzname[1];
		else
			tzn = tzname[0];
#endif

	ap[strlen(ap)-1] = '\0';

	sprintf(startTimeStr, "%.20s", ap);
	if (tzn != NULL)
		strcat(startTimeStr, tzn);
	strcat(startTimeStr, ap+19);

	sprintf(str, "Start: %s  Stop: ", startTimeStr);

	tp = appResources.utc ? gmtime(&stop) : localtime(&stop);
	ap = asctime(tp);

	if (appResources.utc)
		tzn = "UTC";
	else
#ifdef STRUCT_TM_HAS_ZONE
		tzn = tp->tm_zone;
#else
		if (tp->tm_isdst)
			tzn = tzname[1];
		else
			tzn = tzname[0];
#endif
	ap[strlen(ap)-1] = '\0';

	sprintf(stopTimeStr, "%.20s", ap);
	if (tzn != NULL)
		strcat(stopTimeStr, tzn);
	strcat(stopTimeStr, ap+19);

	strcat(str, stopTimeStr);

	sprintf(tmp, "  Step: %d sec  MinElev: %d deg", step, elev);
	strcat(str, tmp);

	return(str);
}

/*
 * Callback for prompt().
 */
void
promptOkay(w, clientData, callData)
XtPointer clientData, callData;
Widget w;
{
	XtDestroyWidget(clientData);
}

/*
 * Strip trailing spaces from a string.
 */
void
stripSpace(s)
char *s;
{
	char *t;

	t = &s[strlen(s)-1];

	while (((*t == ' ') || (*t == '\t')) && (t > s))
		t--;

	*++t = '\0';
}

/*
 * Save a string in alloc'd memmory.
 */
char *
saveString(s)
char *s;
{
	char *t;
	char *malloc();

	if ((t = malloc(strlen(s)+1)) == NULL) {
		fprintf(stderr, "out of memory.\n");
		exit(1);
	}

	strcpy(t, s);

	return(t);
}

/*
 * Allocate memory with error checking.
 */
char *
safeAlloc(size)
int size;
{
	char *p;
	char *malloc();

	if ((p = malloc(size)) == NULL) {
		fprintf(stderr, "out of memory.\n");
		exit(1);
	}

	return(p);
}

/*
 * Change the disk file source for a Text widget
 */
Widget changeTextSource(w,file)
Widget w;
String file;
{
  Widget newsrc;
  Arg argList[2];

/* remove the old text source widget */
  XtDestroyWidget(XawTextGetSource(w));

/* create a new text source and attach it to the text widget */
  newsrc = XtCreateWidget("src",asciiSrcObjectClass,w,(Arg *)NULL,0);
  XawTextSetSource(w,newsrc,(XawTextPosition)0);

/* point the text source widget at the file */
  XtVaSetValues(w,XtNstring,file,XtNtype,XawAsciiFile,(String *)NULL);

  return(newsrc);
}


/* this is the action code for <return> in a dialog text widget */

/* ARGSUSED */

XtActionProc text_return(w,event,params,num_params)

Widget w;
XEvent *event;
String *params;
Cardinal *num_params;

{
/* simply call the button callback function */
  (*dialog_callback)(w, dialog_data, (XtPointer)NULL);

/* zap the function and data */
  dialog_callback = (XtCallbackProc)NULL;
  dialog_data = (XtPointer)NULL;

  return;
}


/* this is the action code for cut-and-paste in a dialog text widget */

/* ARGSUSED */

XtActionProc text_cut_and_paste(w,event,params,num_params)

Widget w;
XEvent *event;
String *params;
Cardinal *num_params;

{
#if 0
  Dimension width, height;
  Widget src, sink;

  XtVaGetValues(w,XtNtextSource,&src,XtNtextSink,&sink,(String)NULL);

  XtVaGetValues(w,XtNwidth,&width,XtNheight,&height,(String)NULL);
  width += 40;
  height += 30;
  XtVaSetValues(w,XtNwidth,width,XtNheight,height,(String)NULL);
#endif

  return;
}


/* verify the checksum of the given element set line */

Boolean verify_tle_checksum(line)

char *line;

{
  int cksum;
  int i;
  int plus;

/* compute the checksum of the digits and minus signs, keeping plus signs
 * separate because they aren't always handled consistently */
  for (cksum = 0, plus = 0, i = 0; i < strlen(line) - 1; i++)
    if (isdigit(line[i]))
      cksum += line[i] - '0';
    else if (line[i] == '-')
      cksum++;
    else if (line[i] == '+')
      plus += 2;
    else
      ;

/* does the checksum match ignoring plus signs? */
  if ((cksum % 10) == (line[i] - '0'))
    return True;
  else if (((cksum + plus) % 10) == (line[i] - '0'))
/* does the checksum match including plus signs? */
    return True;
  else
    return False;

/* NOTREACHED */
}
