/*
 * $Header: /home/orchestra5/davy/stuff/misc/xsat/RCS/xsat.h,v 1.1 92/04/10 14:08:17 davy Exp $
 *
 * Copyright 1992 by David A. Curry
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The
 * author makes no representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or implied warranty.
 *
 * Include file for xsat, defining default values, structure types, and
 * function returns.
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * 1285 Electrical Engineering Building
 * West Lafayette, IN 47907
 * davy@ecn.purdue.edu
 *
 * $Log:	xsat.h,v $
 * Revision 1.1  92/04/10  14:08:17  davy
 * Initial revision
 *
 * Revision 1.2  94/05/24  11:22:33  trf
 * 
 *     Module(s)   Description
 *
 * 1)  orbit.c	   satellites with inclinations > 90 degrees would not get
 *		   plotted properly (reported by Scott Gennari)
 *
 * 2)  orbit.c	   visibility predictions were for the wrong longitude if
 *		   the site was east of Greenwich (reported by Thomas
 *		   Stingl)
 *
 * 3)  xsat.c/xsat.h/util.c
 *		   On some systems, under intelligent compilers such as gcc,
 *		   mktemp() can seg fault if given a string literal argument
 *		   (fix due to James Gallagher)
 *
 * 4)  orbit.c/util.c
 *		   Day was always UTC in prediction text; also use localtime()
 *		   instead of the deprecated ftime() + timezone()
 *
 * 5)  satellites.c
 *		   Orbit number was mostly wrong; scanf() does not always do
 *		   what one might wish (reported by Thomas Stingl)
 *
 * 6)  orbit.c/xsat.h
 *		   Patch 1 only partially solved the problem; the real
 *		   solution required a different tactic
 *
 * 7)  xsat.h/getdate.y
 *		   Finish the job patch 4 started, so that OSF/1 (reported
 *		   by Paul Scowen) and Linux (reported by Cameron Newham)
 *		   are happy
 *
 * 8)  commands.c
 *		   Missing parameter in topLabelStr() call
 *
 * 9)  orbit.c
 *		   Orbit timestamps missing on some systems due to unini-
 *		   tialized variable
 *
 * 10) satellites.c
 *		   Ignore records beginning with '-' in satellite info file
 *		   so the header line doesn't need to be removed from the
 *		   TLE file retrieved from archive.afit.af.mil
 *
 * Revision 1.3  94/10/28  07:47:07  trf
 *
 * 1)  getdate.y/util.c/orbit.c
 *		   More mods to make patch 1.2.7 work right for POSIX/Linux
 *		   daylight savings time, and to understand time zones such
 *		   as "MET DST" (fixes by Uwe Bonnes and trf)
 *
 * 2)  commands.c
 *                 Identify the satellite and site in the hard-copy pre-
 *                 diction output
 *
 * 3)  getdate.y/commands.c/util.c
 *		   Remove unused second argument to getdate()
 *
 * 4)  xsat.h/commands.c/maps.c/xsat.c
 *		   Modifications to PostScript map output to allow user-
 *		   defineable margins; also improved the map generation
 *		   code and the generated PostScript code somewhat
 *
 * Revision 1.4  96/02/28  03:24:27  trf
 *
 * 1)  xsat.h/commands.c/elements.c/satellites.c/util.c
 *		   Added a new item to the "Satellites" menu to allow cut-
 *		   and-paste of two-line or AMSAT element sets
 *
 * 2)  xsat.h/getdate.y/commands.c/util.c/Imakefile
 *		   Changed getdate() to parsedate() to keep C++ compilers
 *		   happy; changed getdate.y to parsedate.y
 *
 * 3)  xsat.c
 *		   Fixed up some definitions in the resources array
 *
 * 4)  elements.c/satellites.c
 *		   Change include of sys/ctypes.h to drop the "sys/"
 */

/*
 * Version and patch level.
 */
#define VERSION			"1.4"
#define PATCHLEVEL		4
