#!/bin/sh
#
#  install script for Xplns 3.2
#
prefix=/usr/local

if [ X"$1" = "X-n" ]; then
  doit=""
elif [ X"$1" = "X-x" ]; then
  if [ `whoami` != 'root' ]; then
    echo '** You must be root to install xplns.'
    exit 1
  fi
  doit="1"
else
  echo "Usage:  $0 -n   show what this script will do"
  echo "        $0 -x   do install"
  echo "        $0 -h   show this message"
  exit 1
fi

# show message
if [ -n "$doit" ]; then
  echo -n "Installing Xplns..."
fi

# find X11 directory
if [ -d /usr/X11R6 ]; then
  XROOT=/usr/X11R6
elif [ -d /usr/X11 ]; then
  XROOT=/usr/X11
elif [ -d /usr/lib/X11R6 ]; then
  XROOT=/usr/lib/X11R6
elif [ -d /usr/lib/X11 ]; then
  XROOT=/usr/lib/X11
elif [ -d /usr/local/X11R6 ]; then
  XROOT=/usr/local/X11
elif [ -d /usr/local/X11 ]; then
  XROOT=/usr/local/X11
else
  XROOT=/usr/X11
fi

# make directories
for d in \
    $prefix/bin \
    $prefix/share \
    $prefix/share/xplns \
    $prefix/share/xplns/adf \
    $prefix/share/xplns/image/solar \
    $prefix/share/xplns/image/nebula \
    $XROOT/lib/X11/app-defaults \
    $XROOT/lib/X11/fr/app-defaults \
    $XROOT/lib/X11/ja/app-defaults
do
  if [ ! -d $d ]; then
    if [ -n "$doit" ]; then
      mkdir -p $d
    else
      echo "mkdir -p $d"
    fi
  fi
done

# install executable
if [ -n "$doit" ]; then
  install -c -m 755 -o root xplns $prefix/bin/xplns
else
  echo "install $prefix/bin/xplns"
fi
if [ -n "$doit" ]; then
  install -c -m 755 -o root uninst-xplns $prefix/bin/uninst-xplns
else
  echo "install $prefix/bin/uninst-xplns"
fi

# install default resource
if [ -n "$doit" ]; then
  install -c -m 644 -o root XPlns.ad    $XROOT/lib/X11/app-defaults/XPlns
  install -c -m 644 -o root XPlns.ad.fr $XROOT/lib/X11/fr/app-defaults/XPlns
  install -c -m 644 -o root XPlns.ad.ja $XROOT/lib/X11/ja/app-defaults/XPlns
else
  echo "install $XROOT/lib/X11/app-defaults/XPlns"
  echo "install $XROOT/lib/X11/fr/app-defaults/XPlns"
  echo "install $XROOT/lib/X11/ja/app-defaults/XPlns"
fi

# install data files
for i in \
  README \
  README.ja \
  xplns.obs \
  starname.dat \
  starname.dat.ja \
  consname.dat \
  consname.dat.ja \
  skymark.adf \
  skymark.adf.ja \
  adf/nickname.adf \
  adf/nova.adf \
  adf/pulsar.adf \
  adf/quasar.adf \
  adf/snova.adf
do
  if [ -n "$doit" ]; then
    install -c -m 644 -o root $i $prefix/share/xplns/$i
  else
    echo "install $prefix/share/xplns/$i"
  fi
done

# install orbital element files
if [ -f xplns.sao ]; then
  for i in \
    comet.elm \
    mp.elm
  do
    if [ -n "$doit" ]; then
      install -c -m 644 -o root $i $prefix/share/xplns/$i
    else
      echo "install $prefix/share/xplns/$i"
    fi
  done
fi

# install star data files
if [ -f xplns.sao ]; then
  for i in \
    xplns.sao \
    xplns.gsc
  do
    if [ -n "$doit" ]; then
      install -c -m 644 -o root $i $prefix/share/xplns/$i
    else
      echo "install $prefix/share/xplns/$i"
    fi
  done
fi

# install image files
if [ -f xplns.cdf ]; then
  for i in \
    xplns.cdf \
    xplns.cdf.ja \
    image/solar/callist.jpg \
    image/solar/europa.jpg \
    image/solar/ganymede.jpg \
    image/solar/io.jpg \
    image/solar/jupiter.jpg \
    image/solar/mars.jpg \
    image/solar/mercury.jpg \
    image/solar/moon.jpg \
    image/solar/neptune.jpg \
    image/solar/pluto.jpg \
    image/solar/saturn.jpg \
    image/solar/sun.jpg \
    image/solar/uranus.jpg \
    image/solar/venus.jpg \
    image/nebula/I434.jpg \
    image/nebula/M1.jpg \
    image/nebula/M101.jpg \
    image/nebula/M104.jpg \
    image/nebula/M13.jpg \
    image/nebula/M15.jpg \
    image/nebula/M16.jpg \
    image/nebula/M17.jpg \
    image/nebula/M2.jpg \
    image/nebula/M20.jpg \
    image/nebula/M22.jpg \
    image/nebula/M27.jpg \
    image/nebula/M3.jpg \
    image/nebula/M31.jpg \
    image/nebula/M33.jpg \
    image/nebula/M4.jpg \
    image/nebula/M42.jpg \
    image/nebula/M45.jpg \
    image/nebula/M5.jpg \
    image/nebula/M51.jpg \
    image/nebula/M53.jpg \
    image/nebula/M55.jpg \
    image/nebula/M56.jpg \
    image/nebula/M57.jpg \
    image/nebula/M63.jpg \
    image/nebula/M64.jpg \
    image/nebula/M65M66.jpg \
    image/nebula/M74.jpg \
    image/nebula/M8.jpg \
    image/nebula/M80.jpg \
    image/nebula/M81M82.jpg \
    image/nebula/M83.jpg \
    image/nebula/N1499.jpg \
    image/nebula/N2174.jpg \
    image/nebula/N2237.jpg \
    image/nebula/N253.jpg \
    image/nebula/N3372.jpg \
    image/nebula/N5128.jpg \
    image/nebula/N7000.jpg \
    image/nebula/N7293.jpg \
    image/nebula/N869.jpg
  do
    if [ -n "$doit" ]; then
      install -c -m 644 -o root $i $prefix/share/xplns/$i
    else
      echo "install $prefix/share/xplns/$i"
    fi
  done
fi

# message
if [ -n "$doit" ]; then
  echo "Completed."
  echo "To uninstall Xplns, run 'uninst-xplns'."
fi

exit 0
