!
! XPlns.ad.fr - default resource French file.
!   Version: 3.2.0.1-e
!   Last updated: 14/02/2001
!
!   Thanks: Dominique VOILLEMOT <domi13@infonie.fr>
!           Francois Massonneau <fmas@celtes.com>
!

!
! date format
!
!XPlns*DateStyle:	English
XPlns*DateStyle:	European
!XPlns*DateStyle:	Japanese

!
! location (Site is a name listed in file SiteFile)
!
XPlns*SiteFile:		/usr/local/share/xplns/xplns.obs
XPlns*Site:		Paris (France)

!
! orbital element of comet and minor planet
!
XPlns*CometFile:	/usr/local/share/xplns/comet.elm
XPlns*MPlanetFile:	/usr/local/share/xplns/mp.elm

!
! star and constellation name data file
!
XPlns*ConstDataFile:	/usr/local/share/xplns/consname.dat
XPlns*StarNameDataFile:	/usr/local/share/xplns/starname.dat

!
! SAO star catalog
!
XPlns*SaoFile:		/usr/local/share/xplns/xplns.sao

!
! GSC
!
XPlns*GscPath:		/cdrom
XPlns*GscIndexFile:	/usr/local/share/xplns/xplns.gsc

!
! Sky Mark
!
XPlns*SkyMarkFile:	/usr/local/share/xplns/skymark.adf

!
! File I/O default path
!
XPlns*StlFileIoPath:	~
XPlns*SaveImagePath:	~
XPlns*UserObjectPath:	/usr/local/share/xplns/adf

!
! Object Information Image
!
XPlns*ClickDataFile:	/usr/local/share/xplns/xplns.cdf
XPlns*ClickImagePath:	/usr/local/share/xplns/image/

!
! Image Viewer
!
XPlns*ClickImageViewer1:	xli -quiet -title '%s'
XPlns*ClickImageViewer2:	xloadimage -quiet -title '%s'
XPlns*ClickImageViewer3:	xv -name '%s'
XPlns*ClickImageViewer4:	display -title '%s'

!
! How many command lines saved into history file
!
XPlns*SaveHistory:	10

!
! Time for blink in unit of 1/10 second.
!
XPlns*BlinkTime:	5

!
! Colors
!
XPlns*ColorStarNameFont:	#FFFFFF
XPlns*ColorStarMagFont:		#FFFFFF
XPlns*ColorStarFlamsteedFont:	#FFFFFF
XPlns*ColorStarBayerFont:	#FFFFFF
XPlns*ColorStarBayerNumFont:	#FFFFFF
XPlns*ColorMilkyWayLine:	#2C8A92
XPlns*ColorCometIonTail:	#2C6CA6
XPlns*ColorCometDulstTail:	#544878
XPlns*ColorConstLine:		#244382
XPlns*ColorConstBorder:		#23305D
XPlns*ColorConstPict:		#292951
XPlns*ColorConstNameFont:	#00FFFF
XPlns*ColorNebulaMark:		#4DC07E
XPlns*ColorNabulaNameFont:	#FFFFFF
XPlns*ColorNebulaMagFont:	#FFFFFF
XPlns*ColorEarth:		#8080FF
XPlns*ColorMoonEclipse:		#B45B21
XPlns*ColorPlanet:		#FFFFFF
XPlns*ColorMinorPlanet:		#FFFFFF
XPlns*ColorMarsDisk:		#FF8000
XPlns*ColorJupiterDisk:		#FAE6B4
XPlns*ColorSaturnDisk:		#FFE5B7
XPlns*ColorSaturnRingA:		#C2AF85
XPlns*ColorSaturnRingB:		#DCD2BB
XPlns*ColorOuterPlanetsDisk:	#02C7AE
XPlns*ColorSolarNameFont:	#FFFF00
XPlns*ColorSolarDateFont:	#FFFFFF
XPlns*ColorSolarMagFont:	#FFFFFF
XPlns*ColorSatelliteNameFont:	#00CC00
XPlns*ColorPlanisphereBack:	#000058
XPlns*ColorLandscape:		#202020
XPlns*ColorDirection1Font:	#FF0000
XPlns*ColorDirection2Font:	#C0C0C0
XPlns*ColorGlobeBack:		#00006A
XPlns*ColorUserObjectFont:	#FFFFFF
XPlns*ColorHorizontalGrid:	#40407F
XPlns*ColorEquatorialGrid:	#40407F
XPlns*ColorEclipticGrid:	#40407F
XPlns*ColorGalacticGrid:	#40407F
XPlns*ColorMeridianLine:	#40407F
XPlns*ColorEquatorialLine:	#9F3535
XPlns*ColorEclipticLine:	#B6B63D
XPlns*ColorGalacticLine:	#C0C0C0
XPlns*ColorGridNumFont:		#808080
XPlns*ColorStatusFont:		#000000
XPlns*ColorStatusBackground:	#C0C0C0
XPlns*ColorOrbit:		#404080
XPlns*ColorOrbitMinorPlanet:	#5E2080
XPlns*ColorOrbitComet:		#205E80
XPlns*ColorSolarAxis:		#408080

!
! Font Set
!
XPlns*StarNameFontset:		-*-medium-r-normal-*-14-*
XPlns*StarMagFontset:		-*-medium-r-normal-*-12-*
XPlns*StarFlamsteedFontset:	-*-medium-r-normal-*-12-*
XPlns*StarBayerNumFontset:	-*-medium-r-normal-*-12-*
XPlns*ConstNameFontset:		-*-medium-*-normal-*-14-*
XPlns*SolarNameFontset:		-*-medium-*-normal-*-14-*
XPlns*SolarDateFontset:		-*-medium-r-normal-*-12-*
XPlns*SolarMagFontset:		-*-medium-r-normal-*-12-*
XPlns*SatelliteNameFontset:	-*-medium-*-normal-*-14-*
XPlns*UserObjectNameFontset:	-*-medium-*-normal-*-14-*
XPlns*DirNameFontset:		-*-medium-r-normal-*-14-*
XPlns*StatusFontset:		-*-medium-r-normal-*-14-*
XPlns*MoonAgeFontset:		-*-medium-r-normal-*-12-*
XPlns*NebulaNameFontset:	-*-medium-r-normal-*-14-*
XPlns*NebulaMagFontset:		-*-medium-r-normal-*-12-*
XPlns*GridNumFontset:		-*-medium-r-normal-*-12-*
XPlns*ClickDataFontset:		-*-medium-r-normal-*-14-*-c-*

!
! Symbol Font
!
XPlns*StarBayerFont:		-*-symbol-medium-r-normal-*-14-*

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!  Following resources are required for Xplns
!!    Be careful, if you change them
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

XPlns.title:				Xplns

XPlns.Main.DrawingArea*translations: #override \
	!Ctrl<Key>space      : OpenCommandDialog()        \n\
	None<Key>osfPageUp   : StkDoit("ZOOM UP;DRIVE")   \n\
	None<Key>osfPageDown : StkDoit("ZOOM DOWN;DRIVE")

!XPlns*inputMethod:	none

XPlns*FontList:		-*-medium-r-normal-*-14-*:
XPlns*background:	gray77
XPlns*TipHelp.fontSet:	-*-medium-r-normal-*-14-*

!
! Main Window
!
XPlns*Main.width:	640
XPlns*Main.height:	480
XPlns*Main.spacing:	1

!
! Menu
!
XPlns*MenuFile.labelString:			Fichier
XPlns*MenuFile.mnemonic:			F

XPlns*MenuSettings.labelString:			Rglages
XPlns*MenuSettings.mnemonic:			R

XPlns*MenuView.labelString:			Voir
XPlns*MenuView.mnemonic:			V

XPlns*MenuObject.labelString:			Objets
XPlns*MenuObject.mnemonic:			j

XPlns*MenuCenter.labelString:			Centrer
XPlns*MenuCenter.mnemonic:			C

XPlns*MenuOption.labelString:			Options
XPlns*MenuOption.mnemonic:			O

XPlns*MenuHelp.labelString:			Aide
XPlns*MenuHelp.mnemonic:			A

!
! Cascade Menu
!
XPlns*MenuFileOpen.labelString:			Ouvrir...
XPlns*MenuFileOpen.mnemonic:			O
XPlns*MenuFileOpen.accelerator:			Ctrl<Key>o
XPlns*MenuFileOpen.acceleratorText:		Ctrl+O

XPlns*MenuFileSave.labelString:			Sauver
XPlns*MenuFileSave.mnemonic:			S
XPlns*MenuFileSave.accelerator:			Ctrl<Key>s
XPlns*MenuFileSave.acceleratorText:		Ctrl+S

XPlns*MenuFileSaveAs.labelString:		Sauver sous...
XPlns*MenuFileSaveAs.mnemonic:			a

XPlns*MenuFileSaveImage.labelString:		Sauvegarder l'image...
XPlns*MenuFileSaveImage.mnemonic:		i

XPlns*MenuFileQuit.labelString:			Sortir de Xplns
XPlns*MenuFileQuit.mnemonic:			X
XPlns*MenuFileQuit.accelerator:			Ctrl<Key>q
XPlns*MenuFileQuit.acceleratorText:		Ctrl+Q

XPlns*MenuSettingsDate.labelString:		Date/heure...
XPlns*MenuSettingsDate.mnemonic:		D
XPlns*MenuSettingsDate.accelerator:		Ctrl<Key>d
XPlns*MenuSettingsDate.acceleratorText:		Ctrl+D

XPlns*MenuSettingsObs.labelString:		Lieu...
XPlns*MenuSettingsObs.mnemonic:			L
XPlns*MenuSettingsObs.accelerator:		Ctrl<Key>p
XPlns*MenuSettingsObs.acceleratorText:		Ctrl+P

XPlns*MenuSettingsContinue.labelString:		Mise en mouvement
XPlns*MenuSettingsContinue.mnemonic:		M
XPlns*MenuSettingsContinue.accelerator:		Ctrl<Key>l
XPlns*MenuSettingsContinue.acceleratorText:	Ctrl+L

XPlns*MenuSettingsTimeStep.labelString:		Avance dans le temps...
XPlns*MenuSettingsTimeStep.mnemonic:		A

XPlns*MenuSettingsTrace.labelString:		Trace
XPlns*MenuSettingsTrace.mnemonic:		T
XPlns*MenuSettingsTrace.accelerator:		Ctrl<Key>t
XPlns*MenuSettingsTrace.acceleratorText:	Ctrl+T

XPlns*MenuSettingsInitialize.labelString:	Initialiser
XPlns*MenuSettingsInitialize.mnemonic:		I
XPlns*MenuSettingsInitialize.accelerator:	Ctrl<Key>i
XPlns*MenuSettingsInitialize.acceleratorText:	Ctrl+I

XPlns*MenuSettingsSaveAsDefault.labelString:	Sauvegarder par dfaut
XPlns*MenuSettingsSaveAsDefault.mnemonic:	S

XPlns*MenuSettingsSetEnv.labelString:		Environnement...
XPlns*MenuSettingsSetEnv.mnemonic:		E

XPlns*MenuViewProjection.labelString:		Projection...
XPlns*MenuViewProjection.mnemonic:		P

XPlns*MenuViewWidth.labelString:		Largeur d'angle de vue
XPlns*MenuViewWidth.mnemonic:			a

XPlns*MenuViewDir.labelString:			Direction
XPlns*MenuViewDir.mnemonic:			D

XPlns*MenuViewRotate.labelString:		Faire pivoter
XPlns*MenuViewRotate.mnemonic:			T

XPlns*MenuViewGrid.labelString:			Grille...
XPlns*MenuViewGrid.mnemonic:			G

XPlns*MenuViewDaylight.labelString:		Lumire du jour
XPlns*MenuViewDaylight.mnemonic:		L

XPlns*MenuViewStatusbar.labelString:		Barre de Status
XPlns*MenuViewStatusbar.mnemonic:		S
XPlns*MenuViewStatusbar.accelerator:		Ctrl<Key>a
XPlns*MenuViewStatusbar.acceleratorText:	Ctrl+A

XPlns*MenuViewLookHrz.labelString:		Horizon
XPlns*MenuViewLookHrz.mnemonic:			H
XPlns*MenuViewLookHrz.accelerator:		Ctrl<Key>h
XPlns*MenuViewLookHrz.acceleratorText:		Ctrl+H

XPlns*MenuViewWidth120.labelString:		120\260
XPlns*MenuViewWidth120.mnemonic:		1

XPlns*MenuViewWidth90.labelString:		90\260
XPlns*MenuViewWidth90.mnemonic:			9

XPlns*MenuViewWidth60.labelString:		60\260
XPlns*MenuViewWidth60.mnemonic:			6

XPlns*MenuViewWidth30.labelString:		30\260
XPlns*MenuViewWidth30.mnemonic:			3

XPlns*MenuViewWidth10.labelString:		10\260
XPlns*MenuViewWidth10.mnemonic:			0

XPlns*MenuViewDirSouth.labelString:		Sud
XPlns*MenuViewDirSouth.mnemonic:		S

XPlns*MenuViewDirWest.labelString:		Ouest
XPlns*MenuViewDirWest.mnemonic:			O

XPlns*MenuViewDirNorth.labelString:		Nord
XPlns*MenuViewDirNorth.mnemonic:		N

XPlns*MenuViewDirEast.labelString:		Est
XPlns*MenuViewDirEast.mnemonic:			E

XPlns*MenuViewRotateNormal.labelString:		Normal
XPlns*MenuViewRotateNormal.mnemonic:		N
XPlns*MenuViewRotateNormal.indicatorType:	ONE_OF_MANY

XPlns*MenuViewRotate180.labelString:		180\260
XPlns*MenuViewRotate180.mnemonic:		1
XPlns*MenuViewRotate180.indicatorType:		ONE_OF_MANY

XPlns*MenuViewRotateMirror.labelString:		Inverser
XPlns*MenuViewRotateMirror.mnemonic:		I
XPlns*MenuViewRotateMirror.indicatorType:	ONE_OF_MANY

XPlns*MenuObjectSun.labelString:		Soleil...
XPlns*MenuObjectSun.mnemonic:			S

XPlns*MenuObjectMoon.labelString:		Lune...
XPlns*MenuObjectMoon.mnemonic:			u

XPlns*MenuObjectPlanet.labelString:		Plantes...
XPlns*MenuObjectPlanet.mnemonic:		P

XPlns*MenuObjectComet.labelString:		Comtes...
XPlns*MenuObjectComet.mnemonic:			C

XPlns*MenuObjectMPlanet.labelString:		Plantes Mineures...
XPlns*MenuObjectMPlanet.mnemonic:		a

XPlns*MenuObjectJoviSat.labelString:		Satellites joviens...
XPlns*MenuObjectJoviSat.mnemonic:		j

XPlns*MenuObjectStar.labelString:		Etoiles...
XPlns*MenuObjectStar.mnemonic:			t

XPlns*MenuObjectConst.labelString:		Constellations...
XPlns*MenuObjectConst.mnemonic:			l

XPlns*MenuObjectNebula.labelString:		Nbuleuses/Galaxies...
XPlns*MenuObjectNebula.mnemonic:		N

XPlns*MenuObjectSkyMark.labelString:		Ligne guide
XPlns*MenuObjectSkyMark.mnemonic:		k

XPlns*MenuObjectUserObject.labelString:		Objet utilisateur...
XPlns*MenuObjectUserObject.mnemonic:		e

XPlns*MenuObjectMilkyway.labelString:		Voie lacte
XPlns*MenuObjectMilkyway.mnemonic:		V

XPlns*MenuCenterSun.labelString:		Soleil
XPlns*MenuCenterSun.mnemonic:			S

XPlns*MenuCenterMoon.labelString:		Lune
XPlns*MenuCenterMoon.mnemonic:			u

XPlns*MenuCenterPlanet.labelString:		Plantes...
XPlns*MenuCenterPlanet.mnemonic:		P

XPlns*MenuCenterComet.labelString:		Comtes...
XPlns*MenuCenterComet.mnemonic:			C

XPlns*MenuCenterMPlanet.labelString:		Plantes Mineures...
XPlns*MenuCenterMPlanet.mnemonic:		a

XPlns*MenuCenterJoviSat.labelString:		Satellites joviens...
XPlns*MenuCenterJoviSat.mnemonic:		j

XPlns*MenuCenterStar.labelString:		Etoiles...
XPlns*MenuCenterStar.mnemonic:			t

XPlns*MenuCenterConst.labelString:		Constellations...
XPlns*MenuCenterConst.mnemonic:			l

XPlns*MenuCenterNebula.labelString:		Nbuleuses/Galaxies...
XPlns*MenuCenterNebula.mnemonic:		N

XPlns*MenuCenterSkyMark.labelString:		Ligne guide...
XPlns*MenuCenterSkyMark.mnemonic:		k

XPlns*MenuCenterUserObject.labelString:		Objet utilisateur...
XPlns*MenuCenterUserObject.mnemonic:		e

XPlns*MenuOptionWhatsToday.labelString:		Qui a t'il Aujourd'hui ?
XPlns*MenuOptionWhatsToday.mnemonic:		A
XPlns*MenuOptionWhatsToday.accelerator:		Ctrl<Key>w
XPlns*MenuOptionWhatsToday.acceleratorText:	Ctrl+W

XPlns*MenuOptionStepBox.labelString:		Fentre d'avancement dans le temps
XPlns*MenuOptionStepBox.mnemonic:		F
XPlns*MenuOptionStepBox.accelerator:		Ctrl<Key>b
XPlns*MenuOptionStepBox.acceleratorText:	Ctrl+B

XPlns*MenuOptionCommandBox.labelString:		Fentre de Commandes
XPlns*MenuOptionCommandBox.mnemonic:		C
XPlns*MenuOptionCommandBox.accelerator:		Ctrl<Key>Space
XPlns*MenuOptionCommandBox.acceleratorText:	Ctrl+Space

XPlns*MenuHelpAbout.labelString:		A propos de Xplns...
XPlns*MenuHelpAbout.mnemonic:			A

XPlns*MenuHelpCopyright.labelString:		Copyright...
XPlns*MenuHelpCopyright.mnemonic:		C

!
! File dialog (common)
!
XPlns*XmFileSelectionBox*filterLabelString:	Filtre:
XPlns*XmFileSelectionBox*dirListLabelString:	Directories:
XPlns*XmFileSelectionBox*fileListLabelString:	Fichiers:
XPlns*XmFileSelectionBox*selectionLabelString:	Slection:
XPlns*XmFileSelectionBox*applyLabelString:	Filtre
XPlns*XmFileSelectionBox*cancelLabelString:	Annuler

!
! File Open Dialog
!
XPlns*OpenFile.dialogTitle:		Ouvrir
XPlns*OpenFile.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL
XPlns*OpenFile.width:			320
XPlns*OpenFile.resizePolicy:		RESIZE_NONE
XPlns*OPenFile.ButtonCancel.labelString: Annuler

!
! File SaveAs Dialog
!
XPlns*SaveFile.dialogTitle:		Sauvegarder sous
XPlns*SaveFile.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL
XPlns*SaveFile.width:			320
XPlns*SaveFile.resizePolicy:		RESIZE_NONE

!
! File Save Image Dialog
!
XPlns*SaveImage.dialogTitle:		Sauvegarder une Prise de Vue
XPlns*SaveImage.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL
XPlns*SaveImage.width:			320
XPlns*SaveImage.resizePolicy:		RESIZE_NONE

!
! Environment Dialog
!
XPlns*SetEnvDialog.dialogTitle:		Environnement
XPlns*SetEnvDialog.resizePolicy:	RESIZE_ANY
XPlns*SetEnvDialog.autoUnmanage:	False
XPlns*SetEnvDialog.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL
XPlns*SetEnvDialog.noResize:		True

XPlns*SetEnvDialog*ToggleToolbar.labelString:		Voir la barre d'outils
XPlns*SetEnvDialog*ToggleTipHelp.labelString:		Voir les messages d'aide
XPlns*SetEnvDialog*ToggleConfirmQuit.labelString:	Confirmer avant de quitter
XPlns*SetEnvDialog*ToggleConfirmInit.labelString:	Confirmer avant d'initialiser

XPlns*SetEnvDialog*LabelAffect.labelString:		\
Les options suivantes ne prendront effet\n\
que la prochaine fois o vous lancerez Xplns.
XPlns*SetEnvDialog*LabelAffect.marginTop:		2
XPlns*SetEnvDialog*LabelAffect.marginBottom:		6

XPlns*SetEnvDialog*Separator1.height:			10

XPlns*SetEnvDialog*LabelGeometry.labelString:		Gomtrie (cran):
XPlns*SetEnvDialog*TextGeometryWidth.width:		52
XPlns*SetEnvDialog*TextGeometryWidth.maxLength:		5
XPlns*SetEnvDialog*LabelGeometryX.labelString:		X
XPlns*SetEnvDialog*TextGeometryHeight.width:		52
XPlns*SetEnvDialog*TextGeometryHeight.maxLength:	5
XPlns*SetEnvDialog*ButtonGeometryNow.labelString:	Actuel

XPlns*SetEnvDialog*LabelLocale.labelString:		Env. langage:
XPlns*SetEnvDialog*TextLocale.width:			180
XPlns*SetEnvDialog*TextLocale.maxLength:		20
XPlns*SetEnvDialog*LabelLocaleDesc.labelString:		Voir locale(7)
XPlns*SetEnvDialog*LabelLocaleDesc.marginBottom:	6

XPlns*SetEnvDialog*LabelTZ.labelString:			TZ:
XPlns*SetEnvDialog*TextTZ.width:			210
XPlns*SetEnvDialog*TextTZ.maxLength:			60
XPlns*SetEnvDialog*LabelTZDesc.labelString:		Voir tzset(5)
XPlns*SetEnvDialog*LabelTZDesc.marginBottom:		6

XPlns*SetEnvDialog*ButtonOK.labelString:		OK
XPlns*SetEnvDialog*ButtonCancel.labelString:		Annuler

!
! Date Dialog
!
XPlns*DateDialog.dialogTitle:		Date / Heure
XPlns*DateDialog.resizePolicy:		RESIZE_ANY
XPlns*DateDialog.autoUnmanage:		False
XPlns*DateDialog.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL
XPlns*DateDialog.noResize:		True

XPlns*DateDialog*LabelYear.labelString:		An
XPlns*DateDialog*LabelMonth.labelString:	Mois
XPlns*DateDialog*LabelDay.labelString:		Jour
XPlns*DateDialog*LabelHour.labelString:		Heure
XPlns*DateDialog*LabelMin.labelString:		Min

XPlns*DateDialog*Month01.labelString:		Jan.
XPlns*DateDialog*Month02.labelString:		Fv.
XPlns*DateDialog*Month03.labelString:		Mar.
XPlns*DateDialog*Month04.labelString:		Avr.
XPlns*DateDialog*Month05.labelString:		Mai
XPlns*DateDialog*Month06.labelString:		Juin
XPlns*DateDialog*Month07.labelString:		Juil.
XPlns*DateDialog*Month08.labelString:		Aot
XPlns*DateDialog*Month09.labelString:		Sep.
XPlns*DateDialog*Month10.labelString:		Oct.
XPlns*DateDialog*Month11.labelString:		Nov.
XPlns*DateDialog*Month12.labelString:		Dc.

XPlns*DateDialog*ToggleStime.labelString:	Verrouiller l'heure du jour
XPlns*DateDialog*LabelStimeMin.labelString:	Min.
XPlns*DateDialog*ToggleBefore.labelString:	Avant
XPlns*DateDialog*ToggleAfter.labelString:	Aprs
XPlns*DateDialog*ToggleRise.labelString:	Lever de Soleil
XPlns*DateDialog*ToggleSet.labelString:		Coucher de Soleil

XPlns*DateDialog*ButtonOK.labelString:		OK
XPlns*DateDialog*ButtonCancel.labelString:	Annuler
XPlns*DateDialog*ButtonNow.labelString:		Actuellement

!
! Site Dialog
!
XPlns*SiteDialog.dialogTitle:		Lieu
XPlns*SiteDialog.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL
XPlns*SiteDialog.autoUnmanage:		False

XPlns*SiteDialog*ButtonOK.labelString:		OK
XPlns*SiteDialog*ButtonCancel.labelString:	Annuler
XPlns*SiteDialog*ButtonSearch.labelString:	Chercher...
XPlns*SiteDialog*ButtonEditSite.labelString:	Editer...
XPlns*SiteDialog*ButtonAddSite.labelString:	Nouveau...
XPlns*SiteDialog*ButtonDelSite.labelString:	Effacer...
XPlns*SiteDialog*ToggleMakeDefault.labelString:	En faire le site par dfaut

!
! Site Search Dialog
!
XPlns*SiteSearchDialog.dialogTitle:		Chercher
XPlns*SiteSearchDialog.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL
XPlns*SiteSearchDialog.textColumns:		40
XPlns*SiteSearchDialog.autoUnmanage:		False
XPlns*SiteSearchDialog.autoUnmanage:		Annuler

!
! Site Edit Dialog
!
XPlns*SiteEditDialog.dialogTitle:	Edition d'un Site
XPlns*SiteEditDialog.dialogStyle:	DIALOG_FULL_APPLICATION_MODAL
XPlns*SiteEditDialog.autoUnmanage:	False

XPlns*SiteEditDialog*NameLabel.labelString:	Nom
XPlns*SiteEditDialog*LongLabel.labelString:	Longitude
XPlns*SiteEditDialog*LongE.labelString:		E
XPlns*SiteEditDialog*LongW.labelString:		W
XPlns*SiteEditDialog*LongDegLabel.labelString:	\260
XPlns*SiteEditDialog*LongMinLabel.labelString:	'
XPlns*SiteEditDialog*LatiLabel.labelString:	Latitude\040
XPlns*SiteEditDialog*LatiN.labelString:		N
XPlns*SiteEditDialog*LatiS.labelString:		S
XPlns*SiteEditDialog*LatiDegLabel.labelString:	\260
XPlns*SiteEditDialog*LatiMinLabel.labelString:	'
XPlns*SiteEditDialog*AltiLabel.labelString:	Altitude
XPlns*SiteEditDialog*AltiUnitLabel.labelString:	m

XPlns*SiteEditDialog*TZLabel.labelString:	Zone Horaire
XPlns*SiteEditDialog*TZPlus.labelString:	+
XPlns*SiteEditDialog*TZMinus.labelString:	-
XPlns*SiteEditDialog*TZHourLabel.labelString:	h

XPlns*SiteEditDialog*ButtonOK.labelString:	OK
XPlns*SiteEditDialog*ButtonCancel.labelString:	Annuler

!
! Time Step Dialog
!
XPlns*TimeStepDialog.dialogTitle:	Avance dans le temps
XPlns*TimeStepDialog.resizePolicy:	RESIZE_NONE
XPlns*TimeStepDialog.autoUnmanage:	False
XPlns*TimeStepDialog.dialogStyle:	DIALOG_FULL_APPLICATION_MODAL
XPlns*TimeStepDialog.noResize:		True

XPlns*TimeStepDialog*LabelYear.labelString:	An
XPlns*TimeStepDialog*LabelMonth.labelString:	Mois
XPlns*TimeStepDialog*LabelDay.labelString:	Jour
XPlns*TimeStepDialog*LabelHour.labelString:	Heure
XPlns*TimeStepDialog*LabelMin.labelString:	Min

XPlns*TimeStepDialog*ToggleRealTime.labelString:	Temps rel
XPlns*TimeStepDialog*ToggleRTSysTime.labelString:	Heure systme
XPlns*TimeStepDialog*ToggleRTSetting.labelString:	Option courante

XPlns*TimeStepDialog*ButtonOK.labelString:		OK
XPlns*TimeStepDialog*ButtonCancel.labelString:		Annuler

!
! Projection Dialog
!
XPlns*ProjectionDialog.dialogTitle:	Projection
XPlns*ProjectionDialog.resizePolicy:	RESIZE_NONE
XPlns*ProjectionDialog.autoUnmanage:	False
XPlns*ProjectionDialog.dialogStyle:	DIALOG_FULL_APPLICATION_MODAL
XPlns*ProjectionDialog.noResize:	True

XPlns*ProjectionDialog*ToggleModeHrz.labelString:	Horizontale
XPlns*ProjectionDialog*ToggleModeEqt.labelString:	Equatoriale
XPlns*ProjectionDialog*ToggleModeEcl.labelString:	Ecliptique
XPlns*ProjectionDialog*ToggleModeGal.labelString:	Galactique
XPlns*ProjectionDialog*ToggleModeSol.labelString:	Systme Solaire
XPlns*ProjectionDialog*ToggleModePlns.labelString:	Planisphre

XPlns*ProjectionDialog*ButtonOK.labelString:		OK
XPlns*ProjectionDialog*ButtonCancel.labelString:	Annuler

!
! Grid Dialog
!
XPlns*GridDialog.dialogTitle:		Grille
XPlns*GridDialog.resizePolicy:		RESIZE_ANY
XPlns*GridDialog.autoUnmanage:		False
XPlns*GridDialog.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL
XPlns*GridDialog.noResize:		True

XPlns*GridDialog*LabelEqt2000.labelString:		Equ.(2000)
XPlns*GridDialog*ToggleEqt2000.labelString:		Ligne
XPlns*GridDialog*ToggleEqt2000Grid.labelString:		Grille
XPlns*GridDialog*ToggleEqt2000GridNum.labelString:	Echelle
XPlns*GridDialog*LabelEqt1950.labelString:		Equ.(1950)
XPlns*GridDialog*ToggleEqt1950.labelString:		Ligne
XPlns*GridDialog*ToggleEqt1950Grid.labelString:		Grille
XPlns*GridDialog*ToggleEqt1950GridNum.labelString:	Echelle
XPlns*GridDialog*LabelEqtDate.labelString:		Equ.(Date)
XPlns*GridDialog*ToggleEqtDate.labelString:		Ligne
XPlns*GridDialog*ToggleEqtDateGrid.labelString:		Grille
XPlns*GridDialog*ToggleEqtDateGridNum.labelString:	Echelle
XPlns*GridDialog*LabelEcl.labelString:			Ecliptique
XPlns*GridDialog*ToggleEcl.labelString:			Ligne
XPlns*GridDialog*ToggleEclGrid.labelString:		Grille
XPlns*GridDialog*ToggleEclGridNum.labelString:		Echelle
XPlns*GridDialog*LabelGal.labelString:			Galactique
XPlns*GridDialog*ToggleGal.labelString:			Ligne
XPlns*GridDialog*ToggleGalGrid.labelString:		Grille
XPlns*GridDialog*ToggleGalGridNum.labelString:		Echelle
XPlns*GridDialog*LabelHrz.labelString:			Horizontale
XPlns*GridDialog*ToggleHrz.labelString:			Ligne
XPlns*GridDialog*ToggleHrzGrid.labelString:		Grille
XPlns*GridDialog*ToggleHrzGridNum.labelString:		Echelle

XPlns*GridDialog*GridModeLabel.labelString:		Mode
XPlns*GridDialog*RadioMode10.labelString:		10\260
XPlns*GridDialog*RadioMode05.labelString:		5\260
XPlns*GridDialog*RadioMode02.labelString:		2\260
XPlns*GridDialog*RadioMode01.labelString:		1\260

XPlns*GridDialog*ToggleSolGrid.labelString:		Axe Systme Solaire

XPlns*GridDialog*ButtonOK.labelString:			OK
XPlns*GridDialog*ButtonCancel.labelString:		Annuler

!
! Sun Dialog
!
XPlns*SunDialog.dialogTitle:		Soleil
XPlns*SunDialog.resizePolicy:		RESIZE_ANY
XPlns*SunDialog.autoUnmanage:		False
XPlns*SunDialog.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL
XPlns*SunDialog.noResize:		True

XPlns*SunDialog*RCSun.spacing:			0

XPlns*SunDialog*ToggleSun.labelString:		Montrer
XPlns*SunDialog*ToggleSunName.labelString:	Nom
XPlns*SunDialog*ToggleSunDate.labelString:	Date
XPlns*SunDialog*ToggleSunOutline.labelString:	Contours

XPlns*SunDialog*ButtonOK.labelString:		OK
XPlns*SunDialog*ButtonCancel.labelString:	Annuler

!
! Moon Dialog
!
XPlns*MoonDialog.dialogTitle:		Lune
XPlns*MoonDialog.resizePolicy:		RESIZE_ANY
XPlns*MoonDialog.autoUnmanage:		False
XPlns*MoonDialog.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL
XPlns*MoonDialog.noResize:		True

XPlns*MoonDialog*RCMoon.spacing:		0

XPlns*MoonDialog*ToggleMoon.labelString:	Montrer
XPlns*MoonDialog*ToggleMoonName.labelString:	Nom
XPlns*MoonDialog*ToggleMoonDate.labelString:	Date
XPlns*MoonDialog*ToggleMoonOutline.labelString:	Contours

XPlns*MoonDialog*ButtonOK.labelString:		OK
XPlns*MoonDialog*ButtonCancel.labelString:	Annuler

!
! Planet Dialog
!
XPlns*PlanetDialog.dialogTitle:		Plantes
XPlns*PlanetDialog.resizePolicy:	RESIZE_ANY
XPlns*PlanetDialog.autoUnmanage:	False
XPlns*PlanetDialog.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL
XPlns*PlanetDialog.noResize:		True

XPlns*PlanetDialog*RCPlanet.spacing:	0

XPlns*PlanetDialog*ToggleShow.labelString:	Montrer
XPlns*PlanetDialog*ToggleName.labelString:	Nom
XPlns*PlanetDialog*ToggleDate.labelString:	Date
XPlns*PlanetDialog*ToggleOrbit.labelString:	Orbite
XPlns*PlanetDialog*ToggleMag.labelString:	Mag
XPlns*PlanetDialog*ToggleDisk.labelString:	Disque

XPlns*PlanetDialog*RCDiskMagCtrl.marginHeight:	0
XPlns*PlanetDialog*RCDiskMagCtrl.spacing:	0

XPlns*PlanetDialog*LabelDiskMag.labelString:	Disque:
XPlns*PlanetDialog*EditDiskMag.width:		36
XPlns*PlanetDialog*EditDiskMag.maxLength:	3

XPlns*PlanetDialog*ButtonOK.labelString:	OK
XPlns*PlanetDialog*ButtonCancel.labelString:	Annuler

!
! Comet Dialog
!
XPlns*CometDialog.dialogTitle:		Comte
XPlns*CometDialog.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL
XPlns*CometDialog.autoUnmanage:		False

XPlns*CometDialog*CometList.visibleItemCount:	12

XPlns*CometDialog*ToggleShow.labelString:	Montrer
XPlns*CometDialog*ToggleName.labelString:	Nom
XPlns*CometDialog*ToggleDate.labelString:	Date
XPlns*CometDialog*ToggleOrbit.labelString:	Orbite
XPlns*CometDialog*ToggleMag.labelString:	Mag
XPlns*CometDialog*ToggleIonTail.labelString:	Queue Ion
XPlns*CometDialog*ToggleDustTail.labelString:	Queue de Poussires

XPlns*CometDialog*ButtonOK.labelString:		OK
XPlns*CometDialog*ButtonCancel.labelString:	Annuler
XPlns*CometDialog*ButtonClear.labelString:	Mise  Zro
XPlns*CometDialog*ButtonSearch.labelString:	Chercher...

!
! Minor Planet Dialog
!
XPlns*MPlanetDialog.dialogTitle:	Plantes Mineures
XPlns*MPlanetDialog.dialogStyle:	DIALOG_FULL_APPLICATION_MODAL
XPlns*MPlanetDialog.autoUnmanage:	False

XPlns*MPlanetDialog*MPlanetList.visibleItemCount:	12

XPlns*MPlanetDialog*ToggleShow.labelString:	Montrer
XPlns*MPlanetDialog*ToggleName.labelString:	Nom
XPlns*MPlanetDialog*ToggleDate.labelString:	Date
XPlns*MPlanetDialog*ToggleOrbit.labelString:	Orbite
XPlns*MPlanetDialog*ToggleMag.labelString:	Mag

XPlns*MPlanetDialog*ButtonOK.labelString:	OK
XPlns*MPlanetDialog*ButtonCancel.labelString:	Annuler
XPlns*MPlanetDialog*ButtonClear.labelString:	Mise  Zro
XPlns*MPlanetDialog*ButtonSearch.labelString:	Chercher...

!
! Comet Search Dialog
!
XPlns*CometSearchDialog.dialogTitle:		Chercher
XPlns*CometSearchDialog.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL
XPlns*CometSearchDialog.textColumns:		40
XPlns*CometSearchDialog.autoUnmanage:		False
XPlns*CometSearchDialog.cancelLabelString:	Annuler

!
! Jovian Satellite Dialog
!
XPlns*JoviSatDialog.dialogTitle:	Satellites Joviens
XPlns*JoviSatDialog.resizePolicy:	RESIZE_ANY
XPlns*JoviSatDialog.autoUnmanage:	False
XPlns*JoviSatDialog.dialogStyle:	DIALOG_FULL_APPLICATION_MODAL
XPlns*JoviSatDialog.noResize:		True

XPlns*JoviSatDialog*RCJoviSat.spacing:	0

XPlns*JoviSatDialog*ToggleShow.labelString:	Voir
XPlns*JoviSatDialog*ToggleName.labelString:	Dnomination
XPlns*JoviSatDialog*ToggleNumber.labelString:	Numro.
XPlns*JoviSatDialog*ButtonOK.labelString:	OK
XPlns*JoviSatDialog*ButtonCancel.labelString:	Annuler

!
! Star Dialog
!
XPlns*StarDialog.dialogTitle:		Etoile
XPlns*StarDialog.resizePolicy:		RESIZE_ANY
XPlns*StarDialog.autoUnmanage:		False
XPlns*StarDialog.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL
XPlns*StarDialog.noResize:		True

XPlns*StarDialog*FormStar.width:	220
XPlns*StarDialog*FormStar.height:	34

XPlns*StarDialog*ToggleStar.x:				12
XPlns*StarDialog*ToggleStar.y:				4
XPlns*StarDialog*ToggleStar.width:			80
XPlns*StarDialog*ToggleStar.height:			22
XPlns*StarDialog*ToggleStar.labelString:		Etoile
XPlns*StarDialog*ToggleStar.alignment:			ALIGNMENT_BEGINNING

XPlns*StarDialog*LabelMagLimit.x:			138
XPlns*StarDialog*LabelMagLimit.y:			0
XPlns*StarDialog*LabelMagLimit.width:			46
XPlns*StarDialog*LabelMagLimit.height:			30
XPlns*StarDialog*LabelMagLimit.labelString:		Limite:
XPlns*StarDialog*LabelMagLimit.alignment:		ALIGNMENT_CENTER

XPlns*StarDialog*EditMagLimit.x:			182
XPlns*StarDialog*EditMagLimit.y:			0
XPlns*StarDialog*EditMagLimit.width:			50
XPlns*StarDialog*EditMagLimit.height:			30
XPlns*StarDialog*EditMagLimit.maxLength:		3

XPlns*StarDialog*ArrowMagLimitUp.x:			232
XPlns*StarDialog*ArrowMagLimitUp.y:			0
XPlns*StarDialog*ArrowMagLimitUp.width:			20
XPlns*StarDialog*ArrowMagLimitUp.height:		14
XPlns*StarDialog*ArrowMagLimitUp.arrowDirection:	ARROW_UP
XPlns*StarDialog*ArrowMagLimitUp.borderWidth:		0
XPlns*StarDialog*ArrowMagLimitUp.highlightThickness:	0
XPlns*StarDialog*ArrowMagLimitUp.traversalOn:		False

XPlns*StarDialog*ArrowMagLimitDown.x:			232
XPlns*StarDialog*ArrowMagLimitDown.y:			14
XPlns*StarDialog*ArrowMagLimitDown.width:		20
XPlns*StarDialog*ArrowMagLimitDown.height:		15
XPlns*StarDialog*ArrowMagLimitDown.arrowDirection:	ARROW_DOWN
XPlns*StarDialog*ArrowMagLimitDown.borderWidth:		0
XPlns*StarDialog*ArrowMagLimitDown.highlightThickness:	0
XPlns*StarDialog*ArrowMagLimitDown.traversalOn:		False

XPlns*StarDialog*FormStarName.width:	220
XPlns*StarDialog*FormStarName.height:	98

XPlns*StarDialog*ToggleStarName.x:			12
XPlns*StarDialog*ToggleStarName.y:			4
XPlns*StarDialog*ToggleStarName.width:			116
XPlns*StarDialog*ToggleStarName.height:			22
XPlns*StarDialog*ToggleStarName.labelString:		Nom de l'Etoile
XPlns*StarDialog*ToggleStarName.alignment:		ALIGNMENT_BEGINNING

XPlns*StarDialog*ToggleStarMag.x:			12
XPlns*StarDialog*ToggleStarMag.y:			26
XPlns*StarDialog*ToggleStarMag.width:			116
XPlns*StarDialog*ToggleStarMag.height:			22
XPlns*StarDialog*ToggleStarMag.labelString:		Mag.
XPlns*StarDialog*ToggleStarMag.alignment:		ALIGNMENT_BEGINNING

XPlns*StarDialog*ToggleStarBayer.x:			12
XPlns*StarDialog*ToggleStarBayer.y:			48
XPlns*StarDialog*ToggleStarBayer.width:			116
XPlns*StarDialog*ToggleStarBayer.height:		22
XPlns*StarDialog*ToggleStarBayer.labelString:		Bayer
XPlns*StarDialog*ToggleStarBayer.alignment:		ALIGNMENT_BEGINNING

XPlns*StarDialog*ToggleStarFlamsteed.x:			12
XPlns*StarDialog*ToggleStarFlamsteed.y:			70
XPlns*StarDialog*ToggleStarFlamsteed.width:		116
XPlns*StarDialog*ToggleStarFlamsteed.height:		22
XPlns*StarDialog*ToggleStarFlamsteed.labelString:	Flamsteed
XPlns*StarDialog*ToggleStarFlamsteed.alignment:		ALIGNMENT_BEGINNING

XPlns*StarDialog*LabelNameMagLimit.x:			138
XPlns*StarDialog*LabelNameMagLimit.y:			35
XPlns*StarDialog*LabelNameMagLimit.width:		46
XPlns*StarDialog*LabelNameMagLimit.height:		30
XPlns*StarDialog*LabelNameMagLimit.labelString:		Limite:
XPlns*StarDialog*LabelNameMagLimit.alignment:		ALIGNMENT_CENTER

XPlns*StarDialog*EditNameMagLimit.x:			182
XPlns*StarDialog*EditNameMagLimit.y:			35
XPlns*StarDialog*EditNameMagLimit.width:		50
XPlns*StarDialog*EditNameMagLimit.height:		30
XPlns*StarDialog*EditNameMagLimit.maxLength:		3

XPlns*StarDialog*ArrowNameMagLimitUp.x:			232
XPlns*StarDialog*ArrowNameMagLimitUp.y:			35
XPlns*StarDialog*ArrowNameMagLimitUp.width:		20
XPlns*StarDialog*ArrowNameMagLimitUp.height:		14
XPlns*StarDialog*ArrowNameMagLimitUp.arrowDirection:	ARROW_UP
XPlns*StarDialog*ArrowNameMagLimitUp.borderWidth:	0
XPlns*StarDialog*ArrowNameMagLimitUp.highlightThickness:0
XPlns*StarDialog*ArrowNameMagLimitUp.traversalOn:	False

XPlns*StarDialog*ArrowNameMagLimitDown.x:		232
XPlns*StarDialog*ArrowNameMagLimitDown.y:		49
XPlns*StarDialog*ArrowNameMagLimitDown.width:		20
XPlns*StarDialog*ArrowNameMagLimitDown.height:		15
XPlns*StarDialog*ArrowNameMagLimitDown.arrowDirection:	ARROW_DOWN
XPlns*StarDialog*ArrowNameMagLimitDown.borderWidth:	0
XPlns*StarDialog*ArrowNameMagLimitDown.highlightThickness:	0
XPlns*StarDialog*ArrowNameMagLimitDown.traversalOn:	False

XPlns*StarDialog*LabelCatalog.labelString:		Catalogue:
XPlns*StarDialog*CatalogStd.labelString:		Xplns
XPlns*StarDialog*CatalogSao.labelString:		SAO
XPlns*StarDialog*CatalogGsc.labelString:		GSC

XPlns*StarDialog*LabelGscPath.labelString:		Voie d'accs de GSC-CD:
XPlns*StarDialog*TextGscPath.width:			180
XPlns*StarDialog*TextGscPath.maxLength:			255

XPlns*StarDialog*ButtonOK.labelString:			OK
XPlns*StarDialog*ButtonCancel.labelString:		Annuler

!
! Constellation Dialog
!
XPlns*ConstDialog.dialogTitle:		Constellation
XPlns*ConstDialog.resizePolicy:		RESIZE_ANY
XPlns*ConstDialog.autoUnmanage:		False
XPlns*ConstDialog.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL
XPlns*ConstDialog.noResize:		True

XPlns*ConstDialog*ToggleConstLine.labelString:		Ligne
XPlns*ConstDialog*ToggleConstAbbr.labelString:		Abbr.
XPlns*ConstDialog*ToggleConstName.labelString:		Nom
XPlns*ConstDialog*ToggleConstBoundary.labelString:	Limites
XPlns*ConstDialog*ButtonOK.labelString:			OK
XPlns*ConstDialog*ButtonCancel.labelString:		Annuler

!
! Nebula/Galaxy Dialog
!
XPlns*NebulaDialog.dialogTitle:		Nbuleuses/Galaxies
XPlns*NebulaDialog.resizePolicy:	RESIZE_ANY
XPlns*NebulaDialog.autoUnmanage:	False
XPlns*NebulaDialog.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL
XPlns*NebulaDialog.noResize:		True

XPlns*NebulaDialog*FormNebula.width:			290
XPlns*NebulaDialog*FormNebula.height:			200

XPlns*NebulaDialog*ToggleNebula.x:			12
XPlns*NebulaDialog*ToggleNebula.y:			6
XPlns*NebulaDialog*ToggleNebula.width:			90
XPlns*NebulaDialog*ToggleNebula.height:			26
XPlns*NebulaDialog*ToggleNebula.labelString:		Nbuleuses
XPlns*NebulaDialog*ToggleNebula.alignment:		ALIGNMENT_BEGINNING

XPlns*NebulaDialog*ToggleNebulaLabel.x:			102
XPlns*NebulaDialog*ToggleNebulaLabel.y:			6
XPlns*NebulaDialog*ToggleNebulaLabel.width:		90
XPlns*NebulaDialog*ToggleNebulaLabel.height:		26
XPlns*NebulaDialog*ToggleNebulaLabel.labelString:	Nom
XPlns*NebulaDialog*ToggleNebulaLabel.alignment:		ALIGNMENT_BEGINNING

XPlns*NebulaDialog*ToggleNebulaMag.x:			192
XPlns*NebulaDialog*ToggleNebulaMag.y:			6
XPlns*NebulaDialog*ToggleNebulaMag.width:		90
XPlns*NebulaDialog*ToggleNebulaMag.height:		26
XPlns*NebulaDialog*ToggleNebulaMag.labelString:		Magnitude
XPlns*NebulaDialog*ToggleNebulaMag.alignment:		ALIGNMENT_BEGINNING

XPlns*NebulaDialog*Separator1.x:			12
XPlns*NebulaDialog*Separator1.y:			35
XPlns*NebulaDialog*Separator1.width:			270
XPlns*NebulaDialog*Separator1.orientation:		HORIZONTAL
XPlns*NebulaDialog*Separator1.separatorType:		SHADOW_ETCHED_IN
XPlns*NebulaDialog*Separator1.shadowThickness:		3

XPlns*NebulaDialog*ToggleNebulaMessier.x:		12
XPlns*NebulaDialog*ToggleNebulaMessier.y:		40
XPlns*NebulaDialog*ToggleNebulaMessier.width:		90
XPlns*NebulaDialog*ToggleNebulaMessier.height:		26
XPlns*NebulaDialog*ToggleNebulaMessier.labelString:	Messier
XPlns*NebulaDialog*ToggleNebulaMessier.alignment:	ALIGNMENT_BEGINNING

XPlns*NebulaDialog*ToggleNebulaNGC.x:			102
XPlns*NebulaDialog*ToggleNebulaNGC.y:			40
XPlns*NebulaDialog*ToggleNebulaNGC.width:		90
XPlns*NebulaDialog*ToggleNebulaNGC.height:		26
XPlns*NebulaDialog*ToggleNebulaNGC.labelString:		NGC
XPlns*NebulaDialog*ToggleNebulaNGC.alignment:		ALIGNMENT_BEGINNING

XPlns*NebulaDialog*ToggleNebulaIC.x:			192
XPlns*NebulaDialog*ToggleNebulaIC.y:			40
XPlns*NebulaDialog*ToggleNebulaIC.width:		90
XPlns*NebulaDialog*ToggleNebulaIC.height:		26
XPlns*NebulaDialog*ToggleNebulaIC.labelString:		IC
XPlns*NebulaDialog*ToggleNebulaIC.alignment:		ALIGNMENT_BEGINNING

XPlns*NebulaDialog*Separator2.x:			12
XPlns*NebulaDialog*Separator2.y:			69
XPlns*NebulaDialog*Separator2.width:			270
XPlns*NebulaDialog*Separator2.orientation:		HORIZONTAL
XPlns*NebulaDialog*Separator2.separatorType:		SHADOW_ETCHED_IN
XPlns*NebulaDialog*Separator2.shadowThickness:		3

XPlns*NebulaDialog*ToggleNebulaGlobular.x:		12
XPlns*NebulaDialog*ToggleNebulaGlobular.y:		74
XPlns*NebulaDialog*ToggleNebulaGlobular.width:		90
XPlns*NebulaDialog*ToggleNebulaGlobular.height:		26
XPlns*NebulaDialog*ToggleNebulaGlobular.labelString:	Amas Glob.
XPlns*NebulaDialog*ToggleNebulaGlobular.alignment:	ALIGNMENT_BEGINNING

XPlns*NebulaDialog*ToggleNebulaPlanetary.x:		102
XPlns*NebulaDialog*ToggleNebulaPlanetary.y:		74
XPlns*NebulaDialog*ToggleNebulaPlanetary.width:		90
XPlns*NebulaDialog*ToggleNebulaPlanetary.height:	26
XPlns*NebulaDialog*ToggleNebulaPlanetary.labelString:	Plantaires
XPlns*NebulaDialog*ToggleNebulaPlanetary.alignment:	ALIGNMENT_BEGINNING

XPlns*NebulaDialog*ToggleNebulaOpenCluster.x:		192
XPlns*NebulaDialog*ToggleNebulaOpenCluster.y:		74
XPlns*NebulaDialog*ToggleNebulaOpenCluster.width:	90
XPlns*NebulaDialog*ToggleNebulaOpenCluster.height:	26
XPlns*NebulaDialog*ToggleNebulaOpenCluster.labelString:	Amas
XPlns*NebulaDialog*ToggleNebulaOpenCluster.alignment:	ALIGNMENT_BEGINNING

XPlns*NebulaDialog*ToggleNebulaDiffuse.x:		12
XPlns*NebulaDialog*ToggleNebulaDiffuse.y:		100
XPlns*NebulaDialog*ToggleNebulaDiffuse.width:		90
XPlns*NebulaDialog*ToggleNebulaDiffuse.height:		26
XPlns*NebulaDialog*ToggleNebulaDiffuse.labelString:	Diffuse
XPlns*NebulaDialog*ToggleNebulaDiffuse.alignment:	ALIGNMENT_BEGINNING

XPlns*NebulaDialog*ToggleNebulaGalaxy.x:		102
XPlns*NebulaDialog*ToggleNebulaGalaxy.y:		100
XPlns*NebulaDialog*ToggleNebulaGalaxy.width:		90
XPlns*NebulaDialog*ToggleNebulaGalaxy.height:		26
XPlns*NebulaDialog*ToggleNebulaGalaxy.labelString:	Galaxie
XPlns*NebulaDialog*ToggleNebulaGalaxy.alignment:	ALIGNMENT_BEGINNING

XPlns*NebulaDialog*ToggleNebulaCompound.x:		192
XPlns*NebulaDialog*ToggleNebulaCompound.y:		100
XPlns*NebulaDialog*ToggleNebulaCompound.width:		90
XPlns*NebulaDialog*ToggleNebulaCompound.height:		26
XPlns*NebulaDialog*ToggleNebulaCompound.labelString:	Compose
XPlns*NebulaDialog*ToggleNebulaCompound.alignment:	ALIGNMENT_BEGINNING

XPlns*NebulaDialog*Separator3.x:			12
XPlns*NebulaDialog*Separator3.y:			129
XPlns*NebulaDialog*Separator3.width:			270
XPlns*NebulaDialog*Separator3.orientation:		HORIZONTAL
XPlns*NebulaDialog*Separator3.separatorType:		SHADOW_ETCHED_IN
XPlns*NebulaDialog*Separator3.shadowThickness:		3

XPlns*NebulaDialog*ToggleNebulaLimit.x:			12
XPlns*NebulaDialog*ToggleNebulaLimit.y:			134
XPlns*NebulaDialog*ToggleNebulaLimit.width:		160
XPlns*NebulaDialog*ToggleNebulaLimit.height:		26
XPlns*NebulaDialog*ToggleNebulaLimit.labelString:	Limite par Magnitude

XPlns*NebulaDialog*LabelMagMinLimit.x:			16
XPlns*NebulaDialog*LabelMagMinLimit.y:			166
XPlns*NebulaDialog*LabelMagMinLimit.width:		36
XPlns*NebulaDialog*LabelMagMinLimit.height:		30
XPlns*NebulaDialog*LabelMagMinLimit.labelString:	Min.
XPlns*NebulaDialog*LabelMagMinLimit.alignment:		ALIGNMENT_BEGINNING

XPlns*NebulaDialog*EditMagMinLimit.x:			52
XPlns*NebulaDialog*EditMagMinLimit.y:			166
XPlns*NebulaDialog*EditMagMinLimit.width:		50
XPlns*NebulaDialog*EditMagMinLimit.height:		30
XPlns*NebulaDialog*EditMagMinLimit.maxLength:		4

XPlns*NebulaDialog*ArrowMagMinLimitUp.x:		102
XPlns*NebulaDialog*ArrowMagMinLimitUp.y:		166
XPlns*NebulaDialog*ArrowMagMinLimitUp.width:		20
XPlns*NebulaDialog*ArrowMagMinLimitUp.height:		14
XPlns*NebulaDialog*ArrowMagMinLimitUp.arrowDirection:	ARROW_UP
XPlns*NebulaDialog*ArrowMagMinLimitUp.borderWidth:	0
XPlns*NebulaDialog*ArrowMagMinLimitUp.highlightThickness:	0
XPlns*NebulaDialog*ArrowMagMinLimitUp.traversalOn:	False

XPlns*NebulaDialog*ArrowMagMinLimitDown.x:		102
XPlns*NebulaDialog*ArrowMagMinLimitDown.y:		180
XPlns*NebulaDialog*ArrowMagMinLimitDown.width:		20
XPlns*NebulaDialog*ArrowMagMinLimitDown.height:		15
XPlns*NebulaDialog*ArrowMagMinLimitDown.arrowDirection:	ARROW_DOWN
XPlns*NebulaDialog*ArrowMagMinLimitDown.borderWidth:	0
XPlns*NebulaDialog*ArrowMagMinLimitDown.highlightThickness:	0
XPlns*NebulaDialog*ArrowMagMinLimitDown.traversalOn:	False

XPlns*NebulaDialog*LabelMagMaxLimit.x:			146
XPlns*NebulaDialog*LabelMagMaxLimit.y:			166
XPlns*NebulaDialog*LabelMagMaxLimit.width:		36
XPlns*NebulaDialog*LabelMagMaxLimit.height:		30
XPlns*NebulaDialog*LabelMagMaxLimit.labelString:	Max.
XPlns*NebulaDialog*LabelMagMaxLimit.alignment:		ALIGNMENT_BEGINNING

XPlns*NebulaDialog*EditMagMaxLimit.x:			182
XPlns*NebulaDialog*EditMagMaxLimit.y:			166
XPlns*NebulaDialog*EditMagMaxLimit.width:		50
XPlns*NebulaDialog*EditMagMaxLimit.height:		30
XPlns*NebulaDialog*EditMagMaxLimit.maxLength:		4

XPlns*NebulaDialog*ArrowMagMaxLimitUp.x:		232
XPlns*NebulaDialog*ArrowMagMaxLimitUp.y:		166
XPlns*NebulaDialog*ArrowMagMaxLimitUp.width:		20
XPlns*NebulaDialog*ArrowMagMaxLimitUp.height:		14
XPlns*NebulaDialog*ArrowMagMaxLimitUp.arrowDirection:	ARROW_UP
XPlns*NebulaDialog*ArrowMagMaxLimitUp.borderWidth:	0
XPlns*NebulaDialog*ArrowMagMaxLimitUp.highlightThickness:	0
XPlns*NebulaDialog*ArrowMagMaxLimitUp.traversalOn:	False

XPlns*NebulaDialog*ArrowMagMaxLimitDown.x:		232
XPlns*NebulaDialog*ArrowMagMaxLimitDown.y:		180
XPlns*NebulaDialog*ArrowMagMaxLimitDown.width:		20
XPlns*NebulaDialog*ArrowMagMaxLimitDown.height:		15
XPlns*NebulaDialog*ArrowMagMaxLimitDown.arrowDirection:	ARROW_DOWN
XPlns*NebulaDialog*ArrowMagMaxLimitDown.borderWidth:	0
XPlns*NebulaDialog*ArrowMagMaxLimitDown.highlightThickness:	0
XPlns*NebulaDialog*ArrowMagMaxLimitDown.traversalOn:	False

XPlns*NebulaDialog*ButtonOK.labelString:		OK
XPlns*NebulaDialog*ButtonCancel.labelString:		Annuler

!
! User Object Dialog
!
XPlns*UserObjectDialog.dialogTitle:		Objet utilisateur
XPlns*UserObjectDialog.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL
XPlns*UserObjectDialog.autoUnmanage:		False

XPlns*UserObjectDialog*ButtonOK.labelString:		OK
XPlns*UserObjectDialog*ButtonCancel.labelString:	Annuler
XPlns*UserObjectDialog*ButtonAddFile.labelString:	Ajouter...
XPlns*UserObjectDialog*ButtonDelFile.labelString:	Effacer

!
! Add User Object Dialog
!
XPlns*AddUserObjectDialog.dialogTitle:	Ajouter des donnes pour des objets utilisateurs
XPlns*AddUserObjectDialog.dialogStyle:	DIALOG_FULL_APPLICATION_MODAL
XPlns*AddUserObjectDialog.width:	320
XPlns*AddUserObjectDialog.resizePolicy:	RESIZE_NONE

!
! Center Planet Dialog
!
XPlns*CenterPlanetDialog.dialogTitle:	Centrer une Plante
XPlns*CenterPlanetDialog.resizePolicy:	RESIZE_ANY
XPlns*CenterPlanetDialog.autoUnmanage:	False
XPlns*CenterPlanetDialog.dialogStyle:	DIALOG_FULL_APPLICATION_MODAL
XPlns*CenterPlanetDialog.noResize:	True

XPlns*CenterPlanetDialog*RCPlanet.spacing:		0
XPlns*CenterPlanetDialog*PlanetList.visibleItemCount:	9

XPlns*CenterPlanetDialog*ButtonOK.labelString:		OK
XPlns*CenterPlanetDialog*ButtonCancel.labelString:	Annuler

!
! Center Comet Dialog
!
XPlns*CenterCometDialog.dialogTitle:	Centrer une Comte
XPlns*CenterCometDialog.dialogStyle:	DIALOG_FULL_APPLICATION_MODAL
XPlns*CenterCometDialog.autoUnmanage:	False

XPlns*CenterCometDialog*CometList.visibleItemCount:	12

XPlns*CenterCometDialog*ButtonOK.labelString:		OK
XPlns*CenterCometDialog*ButtonCancel.labelString:	Annuler

!
! Center Minor Planet Dialog
!
XPlns*CenterMPlanetDialog.dialogTitle:		Centrer une petite Plante
XPlns*CenterMPlanetDialog.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL
XPlns*CenterMPlanetDialog.autoUnmanage:		False

XPlns*CenterMPlanetDialog*MPlanetList.visibleItemCount:	12

XPlns*CenterMPlanetDialog*ButtonOK.labelString:		OK
XPlns*CenterMPlanetDialog*ButtonCancel.labelString:	Annuler

!
! Center Jovian Satellite
!
XPlns*CenterJoviSatDialog.dialogTitle:	Centrer un Satellite Jovien
XPlns*CenterJoviSatDialog.resizePolicy:	RESIZE_ANY
XPlns*CenterJoviSatDialog.autoUnmanage:	False
XPlns*CenterJoviSatDialog.dialogStyle:	DIALOG_FULL_APPLICATION_MODAL
XPlns*CenterJoviSatDialog.noResize:	True

XPlns*CenterJoviSatDialog*RCJoviSat.spacing:		0
XPlns*CenterJoviSatDialog*JoviSatList.visibleItemCount:	4

XPlns*CenterJoviSatDialog*ButtonOK.labelString:		OK
XPlns*CenterJoviSatDialog*ButtonCancel.labelString:	Annuler

!
! Center Star Dialog
!
XPlns*CenterStarDialog.dialogTitle:	Centrer une Etoile
XPlns*CenterStarDialog.resizePolicy:	RESIZE_ANY
XPlns*CenterStarDialog.autoUnmanage:	False
XPlns*CenterStarDialog.dialogStyle:	DIALOG_FULL_APPLICATION_MODAL
XPlns*CenterStarDialog.noResize:	True

XPlns*CenterStarDialog*RCStar.spacing:			0
XPlns*CenterStarDialog*StarList.visibleItemCount:	12

XPlns*CenterStarDialog*ButtonOK.labelString:		OK
XPlns*CenterStarDialog*ButtonCancel.labelString:	Annuler

!
! Center Const Dialog
!
XPlns*CenterConstDialog.dialogTitle:	Centrer une Constellation
XPlns*CenterConstDialog.resizePolicy:	RESIZE_ANY
XPlns*CenterConstDialog.autoUnmanage:	False
XPlns*CenterConstDialog.dialogStyle:	DIALOG_FULL_APPLICATION_MODAL
XPlns*CenterConstDialog.noResize:	True

XPlns*CenterConstDialog*RCConst.spacing:		0
XPlns*CenterConstDialog*ConstList.visibleItemCount:	12

XPlns*CenterConstDialog*ButtonOK.labelString:		OK
XPlns*CenterConstDialog*ButtonCancel.labelString:	Annuler

!
! Center Nebula Dialog
!
XPlns*CenterNebulaDialog.dialogTitle:	Centrer une Nbuleuse/Galaxie
XPlns*CenterNebulaDialog.resizePolicy:	RESIZE_ANY
XPlns*CenterNebulaDialog.autoUnmanage:	False
XPlns*CenterNebulaDialog.dialogStyle:	DIALOG_FULL_APPLICATION_MODAL
XPlns*CenterNebulaDialog.noResize:	True

XPlns*CenterNebulaDialog*RCNebula.spacing:		0

XPlns*CenterNebulaDialog*ToggleTypeM.labelString:	M
XPlns*CenterNebulaDialog*ToggleTypeNGC.labelString:	NGC
XPlns*CenterNebulaDialog*ToggleTypeIC.labelString:	IC

XPlns*CenterNebulaDialog*LabelNumber.labelString:	No.
XPlns*CenterNebulaDialog*EditNumber.width:		50
XPlns*CenterNebulaDialog*EditNumber.maxLength:		5

XPlns*CenterNebulaDialog*ButtonOK.labelString:		OK
XPlns*CenterNebulaDialog*ButtonCancel.labelString:	Annuler

!
! Center Sky Mark Dialog
!
XPlns*CenterSkyMarkDialog.dialogTitle:	Centrer un lment de ligne guide
XPlns*CenterSkyMarkDialog.resizePolicy:	RESIZE_ANY
XPlns*CenterSkyMarkDialog.autoUnmanage:	False
XPlns*CenterSkyMarkDialog.dialogStyle:	DIALOG_FULL_APPLICATION_MODAL
XPlns*CenterSkyMarkDialog.noResize:	True
XPlns*CenterSkyMarkDialog*ObjectList.visibleItemCount:	12
XPlns*CenterSkyMarkDialog*ButtonOK.labelString:		OK
XPlns*CenterSkyMarkDialog*ButtonCancel.labelString:	Annuler

!
! Center User Object Dialog
!
XPlns*CenterUserObjectDialog.dialogTitle:	Centrer un objet utilisateur
XPlns*CenterUserObjectDialog.resizePolicy:	RESIZE_ANY
XPlns*CenterUserObjectDialog.autoUnmanage:	False
XPlns*CenterUserObjectDialog.dialogStyle:	DIALOG_FULL_APPLICATION_MODAL
XPlns*CenterUserObjectDialog.noResize:				True
XPlns*CenterUserObjectDialog*ObjectList.visibleItemCount:	12
XPlns*CenterUserObjectDialog*ButtonOK.labelString:		OK
XPlns*CenterUserObjectDialog*ButtonCancel.labelString:		Annuler

!
! What's Today Dialog
!
XPlns*TodayDialog.dialogTitle:			Que se passe t'il aujourd'hui ?
XPlns*TodayDialog.resizePolicy:			RESIZE_ANY
XPlns*TodayDialog.autoUnmanage:			False
XPlns*TodayDialog.dialogStyle:			DIALOG_MODELESS
XPlns*TodayDialog.noResize:			True
XPlns*TodayDialog*ButtonClose.labelString:	Fermer
XPlns*TodayDialog*ButtonUpdate.labelString:	Mettre  jour

XPlns*TodayDialog*LabelDate.labelString:		Date
XPlns*TodayDialog*LabelDateX.labelString:		AJC aaaaaa/mm/jj
XPlns*TodayDialog*LabelJD.labelString:			JD
XPlns*TodayDialog*LabelJDX.labelString:			2449000.5
XPlns*TodayDialog*LabelMJD.labelString:			MJD
XPlns*TodayDialog*LabelMJDX.labelString:		49000.0
XPlns*TodayDialog*LabelObs.labelString:			Site
XPlns*TodayDialog*LabelObsX.labelString:		139.70E 35.70N

XPlns*TodayDialog*LabelTwS.labelString:			Dbut Aurore
XPlns*TodayDialog*LabelTwSX.labelString:		--:--
XPlns*TodayDialog*LabelSR.labelString:			Lever de Soleil
XPlns*TodayDialog*LabelSRX.labelString:			--:--
XPlns*TodayDialog*LabelSM.labelString:			Mrid.Soleil
XPlns*TodayDialog*LabelSMX.labelString:			--:--
XPlns*TodayDialog*LabelSS.labelString:			Coucher de Soleil
XPlns*TodayDialog*LabelSSX.labelString:			--:--
XPlns*TodayDialog*LabelTwE.labelString:			Fin de Crpuscule
XPlns*TodayDialog*LabelTwEX.labelString:		--:--

XPlns*TodayDialog*LabelMAge.labelString:		Age Lunaire
XPlns*TodayDialog*LabelMAgeX.labelString:		00.0
XPlns*TodayDialog*LabelMR.labelString:			Lever de Lune
XPlns*TodayDialog*LabelMRX.labelString:			--:--
XPlns*TodayDialog*LabelMM.labelString:			Mrid. Lune
XPlns*TodayDialog*LabelMMX.labelString:			--:--
XPlns*TodayDialog*LabelMS.labelString:			Coucher de Lune
XPlns*TodayDialog*LabelMSX.labelString:			--:--

XPlns*TodayDialog*LabelCornerPlanet.labelString:	\ 
XPlns*TodayDialog*LabelRisePlanet.labelString:		Lever
XPlns*TodayDialog*LabelMeriPlanet.labelString:		Mrid.
XPlns*TodayDialog*LabelSetPlanet.labelString:		Coucher
XPlns*TodayDialog*LabelMercuryName.labelString:		Mercure
XPlns*TodayDialog*LabelMercuryRise.labelString:		--:--
XPlns*TodayDialog*LabelMercuryMeri.labelString:		--:--
XPlns*TodayDialog*LabelMercurySet.labelString:		--:--
XPlns*TodayDialog*LabelVenusName.labelString:		Vnus
XPlns*TodayDialog*LabelVenusRise.labelString:		--:--
XPlns*TodayDialog*LabelVenusMeri.labelString:		--:--
XPlns*TodayDialog*LabelVenusSet.labelString:		--:--
XPlns*TodayDialog*LabelMarsName.labelString:		Mars
XPlns*TodayDialog*LabelMarsRise.labelString:		--:--
XPlns*TodayDialog*LabelMarsMeri.labelString:		--:--
XPlns*TodayDialog*LabelMarsSet.labelString:		--:--
XPlns*TodayDialog*LabelJupiterName.labelString:		Jupiter
XPlns*TodayDialog*LabelJupiterRise.labelString:		--:--
XPlns*TodayDialog*LabelJupiterMeri.labelString:		--:--
XPlns*TodayDialog*LabelJupiterSet.labelString:		--:--
XPlns*TodayDialog*LabelSaturnName.labelString:		Saturne
XPlns*TodayDialog*LabelSaturnRise.labelString:		--:--
XPlns*TodayDialog*LabelSaturnMeri.labelString:		--:--
XPlns*TodayDialog*LabelSaturnSet.labelString:		--:--
XPlns*TodayDialog*LabelUranusName.labelString:		Uranus
XPlns*TodayDialog*LabelUranusRise.labelString:		--:--
XPlns*TodayDialog*LabelUranusMeri.labelString:		--:--
XPlns*TodayDialog*LabelUranusSet.labelString:		--:--
XPlns*TodayDialog*LabelNeptuneName.labelString:		Neptune
XPlns*TodayDialog*LabelNeptuneRise.labelString:		--:--
XPlns*TodayDialog*LabelNeptuneMeri.labelString:		--:--
XPlns*TodayDialog*LabelNeptuneSet.labelString:		--:--
XPlns*TodayDialog*LabelPlutoName.labelString:		Pluton
XPlns*TodayDialog*LabelPlutoRise.labelString:		--:--
XPlns*TodayDialog*LabelPlutoMeri.labelString:		--:--
XPlns*TodayDialog*LabelPlutoSet.labelString:		--:--

XPlns*TodayDialog*LabelCornerCometMp.labelString:	\ 
XPlns*TodayDialog*LabelRiseCometMp.labelString:		Lever
XPlns*TodayDialog*LabelMeriCometMp.labelString:		Mrid.
XPlns*TodayDialog*LabelSetCometMp.labelString:		Coucher
XPlns*TodayDialog*LabelCometMp1Name.labelString:	CometMp1
XPlns*TodayDialog*LabelCometMp1Rise.labelString:	--:--
XPlns*TodayDialog*LabelCometMp1Meri.labelString:	--:--
XPlns*TodayDialog*LabelCometMp1Set.labelString:		--:--
XPlns*TodayDialog*LabelCometMp2Name.labelString:	CometMp2
XPlns*TodayDialog*LabelCometMp2Rise.labelString:	--:--
XPlns*TodayDialog*LabelCometMp2Meri.labelString:	--:--
XPlns*TodayDialog*LabelCometMp2Set.labelString:		--:--
XPlns*TodayDialog*LabelCometMp3Name.labelString:	CometMp3
XPlns*TodayDialog*LabelCometMp3Rise.labelString:	--:--
XPlns*TodayDialog*LabelCometMp3Meri.labelString:	--:--
XPlns*TodayDialog*LabelCometMp3Set.labelString:		--:--
XPlns*TodayDialog*LabelCometMp4Name.labelString:	CometMp4
XPlns*TodayDialog*LabelCometMp4Rise.labelString:	--:--
XPlns*TodayDialog*LabelCometMp4Meri.labelString:	--:--
XPlns*TodayDialog*LabelCometMp4Set.labelString:		--:--
XPlns*TodayDialog*LabelCometMp5Name.labelString:	CometMp5
XPlns*TodayDialog*LabelCometMp5Rise.labelString:	--:--
XPlns*TodayDialog*LabelCometMp5Meri.labelString:	--:--
XPlns*TodayDialog*LabelCometMp5Set.labelString:		--:--
XPlns*TodayDialog*LabelCometMp6Name.labelString:	CometMp6
XPlns*TodayDialog*LabelCometMp6Rise.labelString:	--:--
XPlns*TodayDialog*LabelCometMp6Meri.labelString:	--:--
XPlns*TodayDialog*LabelCometMp6Set.labelString:		--:--
XPlns*TodayDialog*LabelCometMp7Name.labelString:	CometMp7
XPlns*TodayDialog*LabelCometMp7Rise.labelString:	--:--
XPlns*TodayDialog*LabelCometMp7Meri.labelString:	--:--
XPlns*TodayDialog*LabelCometMp7Set.labelString:		--:--
XPlns*TodayDialog*LabelCometMp8Name.labelString:	CometMp8
XPlns*TodayDialog*LabelCometMp8Rise.labelString:	--:--
XPlns*TodayDialog*LabelCometMp8Meri.labelString:	--:--
XPlns*TodayDialog*LabelCometMp8Set.labelString:		--:--

!
! About Dialog
!
XPlns*AboutDialog.dialogTitle:		A propos de Xplns
XPlns*AboutDialog.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL
XPlns*AboutDialog.noResize:		True

XPlns*AboutDialog.LabelName.labelString:	Xplns
XPlns*AboutDialog.LabelName.fontList:		-*-utopia-bold-r-*-*-26-*-*-*-p-*-iso8859-1
XPlns*AboutDialog.LabelVersion.labelString:	Version 3.2.0
XPlns*AboutDialog.LabelCopyright.labelString:	Copyright(C) 1995-2001 by AstroArts/osam-a
XPlns*AboutDialog.LabelURL.labelString:		http://www.astroarts.com/
XPlns*AboutDialog.LabelAuthor.labelString:	E-Mail: osam-a@astroarts.co.jp
XPlns*AboutDialog.ButtonOK.labelString:		\040\040OK\040\040

!
! Copyright Dialog
!
XPlns*CopyrightDialog.dialogTitle:		COPYRIGHT
XPlns*CopyrightDialog.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL
XPlns*CopyrightDialog.noResize:			True
XPlns*CopyrightDialog.ButtonOK.labelString:	\040\040OK\040\040

!
! Command Dialog
!
XPlns*CommandDialog.dialogTitle:	Commande
XPlns*CommandDialog.dialogStyle:	DIALOG_MODELESS
XPlns*CommandDialog.autoUnmanage:	False
XPlns*CommandDialog.width:		320
XPlns*CommandDialog.resizePolicy:	RESIZE_NONE
XPlns*CommandDialog.cancelLabelString:	Fermer

!
! Step Box Dialog
!
XPlns*StepBox.dialogTitle:		Dplacement dans le temps
XPlns*StepBox.resizePolicy:		RESIZE_NONE
XPlns*StepBox.autoUnmanage:		False
XPlns*StepBox.noResize:			True

XPlns*StepBox*Label1Min.labelString:			1 Min
XPlns*StepBox*Label5Min.labelString:			5 Mins
XPlns*StepBox*Label10Min.labelString:			10 Mins
XPlns*StepBox*Label30Min.labelString:			30 Mins
XPlns*StepBox*Label1Hour.labelString:			1 Heure
XPlns*StepBox*Label3Hour.labelString:			3 Heures
XPlns*StepBox*Label1Day.labelString:			1 Jour
XPlns*StepBox*Label10Day.labelString:			10 Jours
XPlns*StepBox*Label1Mon.labelString:			1 Mois
XPlns*StepBox*Label1Year.labelString:			1 An

!
! Click Data Dialog
!
XPlns*ClickDataDialog.dialogTitle:	Informations sur cet Objet
XPlns*ClickDataDialog.width:		320
XPlns*ClickDataDialog.height:		94
XPlns*ClickDataDialog.autoUnmanage:	False

!
! Message Box Dialog
!
XPlns*MessageBox.dialogTitle:		Xplns
XPlns*MessageBox.dialogStyle:		DIALOG_FULL_APPLICATION_MODAL

!
! Question Dialog
!
XPlns*QuestionDialog.dialogTitle:	Xplns
XPlns*QuestionDialog.cancelLabelString:	Annuler

!
! Messages
!
XPlns*messageConfirmQuit:	Quitter Xplns
XPlns*messageConfirmSaveEnv:	Sauvegarder les rglages actuels comme paramtres par dfaut.
XPlns*messageInvalidGeometry:	Valeur de gomtrie d'cran non valide
XPlns*messageInputValidDate:	Veuillez entrer une date correcte.
XPlns*messageLockTimeMinimum:	Le chiffre pour le vrouillage du temps doit tre entre 0 et 90.
XPlns*messageNoPlaceFileFound:	Fichier de donnes sur les Sites non trouv.
XPlns*messageSystemOutOfMemory:	Mmoire insuffisante.
XPlns*messageCannotCreateFile:	Impossible de crer le fichier: %s
XPlns*messageCannotOpenFile:	Impossible d'ouvrir le fichier: %s
XPlns*messageCannotWriteFile:	Impossible d'crire le fichier: %s
XPlns*messageCannotDeleteFile:	Impossible d'effacer le fichier: %s
XPlns*messageSelectSiteToEdit:	Slectionner le site  diter.
XPlns*messageSelectSiteToDel:	Slectionner le site  effacer.
XPlns*messageSiteAlreadyExist:	Le Site existe dj.
XPlns*messageConfirmDeleteSite:	Effacer ce site %s
XPlns*messageInvalidTimeStep:	Veuillez entrer un saut dans le temps correcte.
XPlns*messageContinueOutOfDate:	Limite de date atteinte, arrt du dfilement dans le temps.
XPlns*messageNebulaLimitMinMax:	La magniture maximun doit tre moindre que la magniture mininum.
XPlns*messageNebulaLimitRange:	La limite de magnitude doit tre entre %.1f et %.1f
XPlns*messageNoElementFile:	Fichier d'lments orbitaux non trouv.
XPlns*messageObjectAlreadySelected:	Dj slectionn: %s
XPlns*messageSunNotRise:	Le soleil ne se lvera pas ici, verrouillage du temps non activ.
XPlns*messageSunNotSet:		Le soleil ne se couchera pas ici, verrouillage du temps non activ.
XPlns*messageMustSpecSiteName:	Nom de Site non spcifi.
XPlns*messageInvalidSiteLong:	Longitude non valable.
XPlns*messageInvalidSiteLongDeg:	Longitude non valable (degr part).
XPlns*messageInvalidSiteLongMin:	Longitude non valable (minute part).
XPlns*messageInvalidSiteLati:	Latitude non valable.
XPlns*messageInvalidSiteLatiDeg:	Latitude non valable (degr part).
XPlns*messageInvalidSiteLatiMin:	Latitude non valable (minute part).
XPlns*messageInvalidSiteAlti:	Altitude incorrecte.
XPlns*messageInvalidSiteTz:	Zone horaire incorrecte.
XPlns*messageNoSuchANebula:	Il n'existe pas une telle nbuleuse ou galaxie.
XPlns*messageCenterEarthOnNonSol:	Impossible de centrer la terre, sauf en mode solaire
XPlns*messageErrorInUserObjectFile:	Erreure de syntaxe  la ligne %d
XPlns*messageNoDataInUserObjectFile:	Aucune donne n'est contenue dans le fichier d'objets utilisateur.
XPlns*messageSiteNotInit:	\
Xplns ne peut pas dterminer o vous vivez, et vous n'avez pas\n\
dj une localisation par dfaut. Si vous voulez avoir une \n\
localisation par dfaut (site), slectionnez dans le menu le\n\
paramtre "Rglages" -> "Site...", et choisissez votre site\n\
favori dans la liste fournie, ou faites vous-mme votre propre\n\
site en cliquant sur le bouton "Nouveau..." dans la boite de\n\
dialogue.
XPlns*messageConfirmReInitAll:	\
Attention, cela rinitialise l'affichage par rapport\n\
 votre fichier de ressources local ou par rapport\n\
aux paramtres gnraux si aucune fichier local de\n\
ressources n'est disponible.

!
! Command Error
!
XPlns*stkErrorSyntax:		%s: Erreur de syntaxe: %s
XPlns*stkErrorIllegalParam:	%s: Paramtre illgal: %s
XPlns*stkErrorOutOfMemory:	%s: Mmoire insuffisante.
XPlns*stkErrorFileNotFound:	%s: Fichier non trouv: %s
XPlns*stkErrorFileWriteFailed:	%s: Impossible de crer le fichier: %s
XPlns*stkErrorInvalidComet:	%s: Elment non valable: %s
XPlns*stkErrorCometNotFound:	%s: Comte ou Plante mineure non trouve: %s
XPlns*stkErrorCalcCometPos:	%s: Impossible d'obtenir la position de la comte %s, cache.
XPlns*stkErrorCalcCometTail:	%s: Impossible d'obtenir la position de la queue de la comte %s, cache.
XPlns*stkErrorCalcMpPos:	%s: Impossible d'obtenir la position de la plante mineure %s, cache.

!
! Nebula/Galaxy type
!
XPlns*messageNebulaPlanetary:	Nbuleuse Plantaire
XPlns*messageNebulaDiffuse:	Nbuleuse Diffuse
XPlns*messageNebulaOpen:	Amas ouvert
XPlns*messageNebulaGlobular:	Globulaire
XPlns*messageNebulaGalaxy:	Galaxie
XPlns*messageNebulaCompound:	Amas+Nbuleuse
XPlns*messageNebulaLMC:		LMC
XPlns*messageNebulaSMC:		SMC

!
! Direction
!
XPlns*messageDirection00:	S
XPlns*messageDirection01:	SSE
XPlns*messageDirection02:	SE
XPlns*messageDirection03:	ESE
XPlns*messageDirection04:	E
XPlns*messageDirection05:	ENE
XPlns*messageDirection06:	NE
XPlns*messageDirection07:	NNE
XPlns*messageDirection08:	N
XPlns*messageDirection09:	NNW
XPlns*messageDirection10:	NW
XPlns*messageDirection11:	WNW
XPlns*messageDirection12:	W
XPlns*messageDirection13:	WSW
XPlns*messageDirection14:	SW
XPlns*messageDirection15:	SSW

!
! Month
!
XPlns*messageMonth01:		Jan
XPlns*messageMonth02:		Fv
XPlns*messageMonth03:		Mar
XPlns*messageMonth04:		Avr
XPlns*messageMonth05:		Mai
XPlns*messageMonth06:		Jun
XPlns*messageMonth07:		Jul
XPlns*messageMonth08:		Ao
XPlns*messageMonth09:		Sep
XPlns*messageMonth10:		Oct
XPlns*messageMonth11:		Nov
XPlns*messageMonth12:		Dc

!
! Solar objects
!
XPlns*messagePlanetEarth:	Terre
XPlns*messagePlanetSun:		Soleil
XPlns*messagePlanetMoon:	Lune
XPlns*messagePlanetMercury:	Mercure
XPlns*messagePlanetVenus:	Vnus
XPlns*messagePlanetMars:	Mars
XPlns*messagePlanetJupiter:	Jupiter
XPlns*messagePlanetSaturn:	Saturne
XPlns*messagePlanetUranus:	Uranus
XPlns*messagePlanetNeptune:	Neptune
XPlns*messagePlanetPluto:	Pluton
XPlns*messagePlanetJsIo:	Io
XPlns*messagePlanetJsEuropa:	Europe
XPlns*messagePlanetJsGanymede:	Ganymde
XPlns*messagePlanetJsCallist:	Callisto

!
! Tool help
!
XPlns*messageToolOpenFile:	Ouvrir un fichier.
XPlns*messageToolSaveFile:	Sauvegarder un fichier.
XPlns*messageToolModeHrz:	Mode Horizontal.
XPlns*messageToolModeEqt:	Mode Equatorial.
XPlns*messageToolModeSol:	Mode Systme Solaire.
XPlns*messageToolModePlns:	Mode Planisphre.
XPlns*messageToolSetDateTime:	Date et heure.
XPlns*messageToolSetTimeStep:	Avancement dans le temps.
XPlns*messageToolSetSite:	Site.
XPlns*messageToolHorizon:	Horizon.
XPlns*messageToolDaylight:	Lumire du Jour.
XPlns*messageToolZoomUp:	Augmenter le Zoom.
XPlns*messageToolZoomDown:	Diminuer le Zoom.
XPlns*messageToolConstLine:	Dessiner les Constellations.
XPlns*messageToolConstName:	Afficher les noms des Constellations.
XPlns*messageToolPlanetName:	Afficher les noms des Plantes.
XPlns*messageToolNebula:	Nbuleuses et Galaxies.
XPlns*messageToolMilkyway:	Voie lacte.
XPlns*messageToolHrzGrid:	Quadrillage Horizontal.
XPlns*messageToolEqtGrid:	Quadrillage Equatorial.
XPlns*messageToolToggleTrace:	Afficher la Trace des objets clestes.
XPlns*messageToolTogglePlay:	Faire fonctionner le programme avec le temps.

!
! Tool help on Object Information Dialog
!
XPlns*messageToolObjClose:	Fermer
XPlns*messageToolObjBlink:	Clignoter
XPlns*messageToolObjCenter:	Centrer
XPlns*messageToolObjTrack:	Suivre
XPlns*messageToolObjImage:	Image

!
! Mouse right click data
!
XPlns*messageMousePosEqt2000:	Eqt.2000
XPlns*messageMousePosEqtDate:	Eqt.Date
XPlns*messageMousePosEcl:	Ecliptic
XPlns*messageMousePosHrz:	Horizon.
XPlns*messageMousePosEqtFormat:	%-10.10sR.A. %2dh%04.1fm Decl %c%02d\260%02d'
XPlns*messageMousePosEclFormat:	%-10.10sLong %3d\260%02d'  Lati %c%02d\260%02d'
XPlns*messageMousePosHrzFormat:	%-10.10sAzm. %5.1f\260   Alt. %5.1f\260

!
! Grid tics
!
XPlns*messageGridEqtRaFormat1:	%dh+%02d\260
XPlns*messageGridEqtRaFormat2:	%dh%02d\260
XPlns*messageGridEqtRaFormat3:	%dh
XPlns*messageGridEqtDcFormat1:	%d\260+%02d\260
XPlns*messageGridEqtDcFormat2:	%d\260%02d\260
XPlns*messageGridEqtDcFormat3:	%d\260
XPlns*messageGridDegFormat:	%d\260

!
! Statusbar
!
XPlns*messageStatusDateTime1:	%4d/%2d/%2d(%s) %2d:%02d
XPlns*messageStatusDateTime2:	%2d/%2d/%4d(%s) %2d:%02d
XPlns*messageStatusDateTime3:	%3.3s %3.3s %2d, %4d %02d:%02d
XPlns*messageStatusSite:	%.2f\260%c %.2f\260%c (%c%.1fh)  %s
XPlns*messageStatusWidth:	W:%.1f\260
XPlns*messageStatusDayOfWeek00:	Dim
XPlns*messageStatusDayOfWeek01:	Lun
XPlns*messageStatusDayOfWeek02:	Mar
XPlns*messageStatusDayOfWeek03:	Mer
XPlns*messageStatusDayOfWeek04:	Jeu
XPlns*messageStatusDayOfWeek05:	Ven
XPlns*messageStatusDayOfWeek06:	Sam

!
! Information Box
!
XPlns*messageInfoBoxHrzInvalid:	Azm ---.--\260  Alt ---.--\260
XPlns*messageInfoBoxHrz:	Azm %6.2f\260  Alt %6.2f\260
XPlns*messageInfoBoxEqtInvalie:	R.A. --h--.-m  Decl. --\260--'
XPlns*messageInfoBoxEqt:	R.A.%2dh%4.1fm Decl.%c%2d\260%2d'
XPlns*messageInfoBoxSolInvalid:	Delta  -.---AU  r  -.---AU
XPlns*messageInfoBoxDelta:	Delta %6.3fAU
XPlns*messageInfoBoxRadius:	r %6.3fAU
XPlns*messageInfoBoxMSInvalid:	--.-- --.--
XPlns*messageInfoBoxMag:	mag%4.1f
XPlns*messageInfoBoxSize0:	taille %.0f'
XPlns*messageInfoBoxSize1:	taille %.1f'

!
! Mouse right button click menu
!
XPlns*messageMousePosComets:	Comtes
XPlns*messageMousePosMPlanets:	Plantes Mineures
XPlns*messageMousePosSun:	Soleil
XPlns*messageMousePosMoon:	Lune
XPlns*messageMousePosPlanets:	Plantes
XPlns*messageMousePosStar:	Etoiles
XPlns*messageMousePosNebula:	Nbuleuses/Galaxies
XPlns*messageMousePosJoviSat:	Satellites Joviens
