/********************************************************/
/* mjd.c						*/
/*							*/
/* convert gregorian date to julian day number		*/
/* 							*/
/* algorithm from the Explanatory supplement to the	*/
/* Astronomical Almanac					*/
/********************************************************/

/***** description
 *
 *	$Id: mjd.c,v 1.2 1993/04/22 21:15:34 craig Exp $
 *
 */

/***** modification history
 *
 *	$Log: mjd.c,v $
 * Revision 1.2  1993/04/22  21:15:34  craig
 * changed the output from the modified Julian date to the Julian date.
 *
 * Revision 1.1  1993/04/01  18:18:42  craig
 * Initial revision
 *
 *
 */

/***** include files *****/

#include "satproto.h"

/*******/
/* mjd */
/*******/

double mjd (int year, int month, double day)
{
    long    terma, termb, termc;
    double  jday;

    terma = (1461 * (year + 4800 + ((month - 14) / 12))) / 4;

    termb = (367 * (month - 2 - (12 * ((month - 14) / 12)))) / 12;

    termc = (3 * ((year + 4900 + ((month - 14) / 12)) / 100)) / 4;

    jday = terma + termb - termc + day - 32075.5;

    /* jday = jday - 2400000.5; */
    
    return (jday);
}	
