/************************************************/
/* satellite.h					*/
/*						*/
/* definitions for satellite tracking routines	*/
/************************************************/

/***** description
 *
 *	$Id: satellite.h,v 1.4 1993/05/18 16:35:10 craig Exp $
 *
 */

/***** modification history
 *
 *	$Log: satellite.h,v $
 * Revision 1.4  1993/05/18  16:35:10  craig
 * added a name field to the satellite element structure.
 *
 * Revision 1.3  1993/04/23  18:50:58  craig
 * added a speed of light in au/day to PCONSTANTS.
 *
 * Revision 1.2  1993/04/22  21:09:15  craig
 * various additions to the MCONSTANTS and PCONSTANTS structures.
 *
 * Revision 1.1  1993/04/02  18:07:42  craig
 * Initial revision
 *
 *
 */

struct ELEMENT
{
    char name[32];
    double xmo;
    double xnodeo;
    double omegao;
    double eo;
    double xincl;
    double xno;
    double xndt2o;
    double xndd6o;
    double bstar;
    double x;
    double y;
    double z;
    double xdot;
    double ydot;
    double zdot;
    double epoch;
    double ds50;
};


struct PCONSTANTS
{
    double c;			/* speed of light (m/s)			*/
    double caupda;		/* speed of light (au/day)		*/
    double k;			/* gaussian gravitation constant	*/
    double ck2;			/* xj2 * ae**2 / 2			*/
    double ck4;			/* -3/8 xj4 * ae**4			*/
    double qoms2t;		/* (qo - so)**4 * (ae / xkmper)**4	*/
    double s;			/* ae * ((so / xkmper) + 1)		*/
    double xj3;			/* third gravitational zonal harmonic	*/
    double xke;
    double xkmper;		/* earth radius in km			*/
    double xauper;		/* earth radius in au			*/
    double rapau;		/* earth radii per au			*/
    double xmnpda;		/* minutes per day			*/
    double secpda;		/* seconds per day			*/
    double dapcen;		/* days per julian century		*/
    double J2000;		/* 2000 January 1.5			*/
    double B1950;		/* 1950 January 0.923 Besselian epoch	*/
    double J1900;		/* 1900 January 0, 12h UT		*/
    double ae;			/* distance units in earth radii	*/
    double kmpau;		/* km per au 				*/
};

struct MCONSTANTS
{
    double de2ra;		/* degrees to radians	*/
    double ra2de;		/* radians to degrees	*/
    double ra2sec;		/* radians to arc-sec	*/
    double sec2ra;		/* arc-sec to radians	*/
    double pi;			/* pi			*/
    double pio2;		/* pi / 2		*/
    double twopi;		/* 2 pi			*/
    double x3pio2;		/* 3 pi / 2		*/
    double tothrd;		/* 2 / 3		*/
    double e6a;			/* 1 e -6		*/
};
